/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.extras.EditNodeHandler;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.Layerer;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlNodeHighlighter;
import org.jetbrains.idea.maven.ext.uml.actions.MavenExcludeDependency;

public class MavenUmlExtras
extends CommonDiagramExtras<MavenElement> {
    private static final MavenUmlNodeHighlighter NODE_HIGHLIGHTER = new MavenUmlNodeHighlighter();
    private static final EditNodeHandler<MavenElement> EDIT_HANDLER = new EditNodeHandler<MavenElement>(){

        public void doEdit(DiagramNode<MavenElement> node, DiagramPresentationModel presentationModel) {
            ((MavenElement)node.getIdentifyingElement()).navigate(true);
        }
    };

    public boolean isDeleteActionImplemented() {
        return false;
    }

    public Object getData(@NotNull String dataId, List<DiagramNode<MavenElement>> umlNodes, DiagramBuilder builder) {
        if (dataId == null) {
            MavenUmlExtras.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.uml.maven.dependencies.diagram";
        }
        if (umlNodes.isEmpty()) {
            return null;
        }
        MavenElement mavenElement = (MavenElement)umlNodes.get(0).getIdentifyingElement();
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return mavenElement.getNavigatable();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return mavenElement.getVirtualFile();
        }
        return null;
    }

    public EditNodeHandler<MavenElement> getEditNodeHandler() {
        return EDIT_HANDLER;
    }

    public Layouter getCustomLayouter(GraphSettings settings, Project project) {
        HierarchicGroupLayouter layouter = GraphManager.getGraphManager().createHierarchicGroupLayouter();
        layouter.setOrientationLayouter((LayoutStage)GraphManager.getGraphManager().createOrientationLayouter(LayoutOrientation.LEFT_TO_RIGHT));
        layouter.setMinimalNodeDistance(20.0);
        layouter.setMinimalLayerDistance(20.0);
        layouter.setLayerer((Layerer)GraphManager.getGraphManager().createBFSLayerer());
        return layouter;
    }

    public MavenUmlNodeHighlighter getNodeHighlighter() {
        return NODE_HIGHLIGHTER;
    }

    @NotNull
    public List<AnAction> getExtraActions() {
        List<MavenExcludeDependency> list = Collections.singletonList(new MavenExcludeDependency());
        if (list == null) {
            MavenUmlExtras.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/ext/uml/MavenUmlExtras";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/ext/uml/MavenUmlExtras";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

