/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class MavenUmlElementManager
extends AbstractDiagramElementManager<MavenElement> {
    @Nullable
    public MavenElement findInDataContext(@NotNull DataContext context) {
        MavenProject mavenProject;
        Project project;
        if (context == null) {
            MavenUmlElementManager.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return null;
        }
        if (MavenDataKeys.MAVEN_PROJECTS_TREE.getData(context) == null) {
            FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
            if (editor == null) {
                return null;
            }
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            if (psiFile == null || !"pom.xml".equalsIgnoreCase(psiFile.getName())) {
                return null;
            }
        }
        return (mavenProject = MavenActionUtil.getMavenProject((DataContext)context)) == null ? null : new MavenElement(project, mavenProject, null);
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof MavenElement;
    }

    public String getElementTitle(MavenElement element) {
        String classifier = MavenUmlElementManager.getElementClassifier(element);
        return element.getName() + (String)(StringUtil.isNotEmpty((String)classifier) ? " :" + classifier : "");
    }

    @Nullable
    @NlsSafe
    private static String getElementClassifier(MavenElement element) {
        MavenArtifactNode artifactNode = element.getArtifact();
        if (artifactNode == null) {
            return null;
        }
        MavenArtifact artifact = artifactNode.getArtifact();
        if (artifact == null) {
            return null;
        }
        return artifact.getClassifier();
    }

    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            MavenUmlElementManager.$$$reportNull$$$0(1);
        }
        if (element instanceof MavenElement) {
            MavenElement mavenElement = (MavenElement)element;
            int style = 1;
            if (mavenElement.getState() == MavenArtifactState.EXCLUDED) {
                style = 4;
            }
            SimpleTextAttributes attr = new SimpleTextAttributes(style, mavenElement.getTitleColor());
            return new SimpleColoredText(mavenElement.getName(), attr);
        }
        return null;
    }

    @Nullable
    @Nls
    public String getNodeTooltip(MavenElement element) {
        return element.getDescription();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/ext/uml/MavenUmlElementManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

