/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.remoteRun;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfiguration;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.execution.target.TargetConfigurationMavenExtension;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/ext/remoteRun/MavenOnSshTargetConfigurationExtension;", "Lorg/jetbrains/idea/maven/execution/target/TargetConfigurationMavenExtension;", "()V", "createUploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "mavenRuntimeConfiguration", "Lorg/jetbrains/idea/maven/execution/target/MavenRuntimeTargetConfiguration;", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "volumeDescriptor", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "localRootPath", "Ljava/nio/file/Path;", "sha256", "", "intellij.maven.remoteRun"})
public final class MavenOnSshTargetConfigurationExtension
implements TargetConfigurationMavenExtension {
    @Nullable
    public TargetEnvironment.UploadRoot createUploadRoot(@Nullable MavenRuntimeTargetConfiguration mavenRuntimeConfiguration, @NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor, @NotNull Path localRootPath) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironmentRequest, (String)"targetEnvironmentRequest");
        Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
        Intrinsics.checkNotNullParameter((Object)localRootPath, (String)"localRootPath");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = targetEnvironmentRequest.getConfiguration();
        if (!(targetEnvironmentConfiguration instanceof SshTargetEnvironmentConfiguration)) {
            return null;
        }
        if (!((SshTargetEnvironmentConfiguration)targetEnvironmentConfiguration).getUseRsync()) {
            return null;
        }
        String applicationDir = targetEnvironmentConfiguration.getProjectRootOnTarget();
        if (StringsKt.isBlank((CharSequence)applicationDir)) {
            return null;
        }
        char fileSeparator = targetEnvironmentRequest.getTargetPlatform().getPlatform().fileSeparator;
        String targetRootParentDirName = StringsKt.take((String)this.sha256(localRootPath), (int)16);
        String targetRootParentDir = applicationDir + fileSeparator + targetRootParentDirName;
        TargetEnvironment.TargetPath.Temporary targetRootPath = new TargetEnvironment.TargetPath.Temporary(volumeDescriptor.getType().getId(), targetRootParentDir);
        TargetEnvironment.UploadRoot uploadRoot = new TargetEnvironment.UploadRoot(localRootPath, (TargetEnvironment.TargetPath)targetRootPath, false, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        TargetEnvironment.UploadRoot it = uploadRoot;
        boolean bl3 = false;
        MavenRuntimeTargetConfiguration mavenRuntimeTargetConfiguration = mavenRuntimeConfiguration;
        it.setVolumeData((TargetEnvironmentType.TargetSpecificVolumeData)(mavenRuntimeTargetConfiguration != null ? mavenRuntimeTargetConfiguration.getTargetSpecificData(volumeDescriptor) : null));
        return uploadRoot;
    }

    private final String sha256(Path $this$sha256) {
        MessageDigest digest = DigestUtil.sha256();
        String string = ((Object)$this$sha256).toString();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        digest.update(byArray);
        String string3 = StringUtil.toHexString((byte[])digest.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtil.toHexString(digest.digest())");
        return string3;
    }
}

