/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.spark;

import com.intellij.database.Dbms;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.hive.HiveDialectBase;
import com.intellij.sql.dialects.spark.SparkReservedKeywords;
import com.intellij.sql.dialects.spark.SparkTokens;
import com.intellij.sql.dialects.spark.SparkTypeSystem;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SparkDialect
extends HiveDialectBase {
    public static final SparkDialect INSTANCE = new SparkDialect();

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            SparkDialect.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            SparkDialect.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            SparkDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        SparkTypeSystem sparkTypeSystem = SparkTypeSystem.INSTANCE;
        if (sparkTypeSystem == null) {
            SparkDialect.$$$reportNull$$$0(3);
        }
        return sparkTypeSystem;
    }

    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"set", (String)"set", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            SparkDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    public SparkDialect() {
        super("SparkSQL");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SPARK;
        if (dbms == null) {
            SparkDialect.$$$reportNull$$$0(5);
        }
        return dbms;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/dialects/spark/SparkDialect";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(SparkTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens(SparkTokens.class);
            ourReservedKeywords = SqlTokenRegistry.getTokens(SparkReservedKeywords.class);
        }
    }
}

