/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake;

import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.snowflake.SFlakeDialect;
import com.intellij.sql.dialects.snowflake.psi.SFlakeCreateStreamStatement;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SFlakeTypeSystem
extends SqlTypeSystemBase {
    public static final SFlakeTypeSystem INSTANCE = new SFlakeTypeSystem();

    private SFlakeTypeSystem() {
        super((SqlLanguageDialectEx)SFlakeDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(0);
        }
        if (name2.equalsIgnoreCase("GEOGRAPHY")) {
            String string = super.getNormalizedTypeName(name2);
            if (string == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = super.getNormalizedTypeName(this.getDefaultTypeName(this.getTypeCategoryByName(name2)));
        if (string == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(3);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case REAL: {
                return "float";
            }
            case STRING: {
                return "varchar";
            }
            case BYTES: {
                return "binary";
            }
            case ARRAY: {
                return "array";
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                return "timestamp";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case RECORD: {
                return "object";
            }
        }
        return "variant";
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(4);
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"string")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"bit")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"dec")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(7);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"numeric")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(8);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"timestamp")) {
            SqlType.Category category = SqlType.Category.TIMESTAMP;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(9);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"array")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(10);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"object")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(11);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(12);
        }
        return category;
    }

    @NotNull
    public SqlType getSqlType(@Nullable SqlReferenceImpl ref2, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        if (ref2 != null && resolved instanceof SFlakeCreateStreamStatement) {
            SqlPrimitiveType baseType;
            SqlReferenceExpression tableRef = ((SFlakeCreateStreamStatement)resolved).getTargetTableReference();
            Object object = baseType = tableRef != null ? tableRef.getSqlType() : SqlType.UNKNOWN;
            if (!(baseType instanceof SqlTableType)) {
                SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)ref2);
                if (sqlTableType == null) {
                    SFlakeTypeSystem.$$$reportNull$$$0(13);
                }
                return sqlTableType;
            }
            PsiElement refElement = ref2.getElement();
            DasTypeService typeService = this.getTypeService();
            SqlTableType extraType = SqlImplUtil.createType((List)ContainerUtil.newArrayList((Object[])new SqlImplUtil.Column[]{SqlDialectImplUtilCore.col((PsiElement)refElement, (PsiElement)resolved, (String)"METADATA$ACTION", (SqlType)this.stringType(), (DasType)typeService.getStringType(), (boolean)false), SqlDialectImplUtilCore.col((PsiElement)refElement, (PsiElement)resolved, (String)"METADATA$ISUPDATE", (SqlType)this.booleanType(), (DasType)typeService.getBooleanType(), (boolean)false), SqlDialectImplUtilCore.col((PsiElement)refElement, (PsiElement)resolved, (String)"METADATA$ROW_ID", (SqlType)this.stringType(), (DasType)typeService.getStringType(), (boolean)false)}), (PsiElement)refElement);
            SqlTableType sqlTableType = ((SqlTableType)baseType).add(extraType);
            if (sqlTableType == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(14);
            }
            return sqlTableType;
        }
        SqlType sqlType = super.getSqlType(ref2, resolved, symbol);
        if (sqlType == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(15);
        }
        return sqlType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/snowflake/SFlakeTypeSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/snowflake/SFlakeTypeSystem";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

