/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dataFlow.SqlErrorSpecInfo;
import com.intellij.sql.dataFlow.SqlStateInfo;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.psi.PgRaiseStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlErrorSpec;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSpecialErrorSpec;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0004*\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/dialects/postgres/dataFlow/PgErrorSpecHelper;", "Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper;", "()V", "DEFAULT_ERROR_CODE", "", "getDefaultErrorCode", "", "sqlState", "Lcom/intellij/sql/dataFlow/SqlStateInfo;", "context", "Lcom/intellij/psi/PsiElement;", "getNotFoundErrorSpec", "Lcom/intellij/sql/dataFlow/SqlErrorSpecInfo;", "getSqlStateByErrorCode", "errorCode", "resolveSpec", "errorSpec", "Lcom/intellij/sql/psi/SqlErrorSpec;", "getExplicitErrorCode", "Lcom/intellij/sql/dialects/postgres/psi/PgRaiseStatement;", "intellij.database.dialects.postgresbase"})
public final class PgErrorSpecHelper
extends SqlErrorSpecHelper {
    private static final String DEFAULT_ERROR_CODE = "RAISE_EXCEPTION";
    @NotNull
    public static final PgErrorSpecHelper INSTANCE;

    private final String getExplicitErrorCode(PgRaiseStatement $this$getExplicitErrorCode) {
        Iterator iterator = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)$this$getExplicitErrorCode.getOptionsClause())).filter(SqlSetAssignment.class).iterator();
        while (iterator.hasNext()) {
            SqlSetAssignment infoItem;
            SqlSetAssignment sqlSetAssignment = infoItem = (SqlSetAssignment)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)sqlSetAssignment, (String)"infoItem");
            PsiElement psiElement = sqlSetAssignment.getFirstChild();
            if (!Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)PgTypes.PG_ERRCODE)) continue;
            SqlElement sqlElement = infoItem.getRValue();
            if (!(sqlElement instanceof SqlStringLiteralExpression)) {
                sqlElement = null;
            }
            SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)sqlElement;
            return sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
        }
        return null;
    }

    @Nullable
    public SqlErrorSpecInfo resolveSpec(@Nullable SqlErrorSpec errorSpec, @Nullable PsiElement context) {
        if (errorSpec == null && context instanceof PgRaiseStatement && ((PgRaiseStatement)context).isException() && !((PgRaiseStatement)context).isReraise()) {
            String string = this.getExplicitErrorCode((PgRaiseStatement)context);
            if (string == null) {
                string = DEFAULT_ERROR_CODE;
            }
            String errorCode = string;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)context);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(context)");
            boolean isErrorId = sqlLanguageDialectEx.getExceptionNames().contains(errorCode);
            if (isErrorId) {
                return new SqlErrorSpecInfo((SqlStateInfo)new SqlStateInfo.Wildcard(SqlSpecialErrorSpec.Kind.OTHERS), (Object)errorCode);
            }
            return new SqlErrorSpecInfo((SqlStateInfo)new SqlStateInfo.Specific(errorCode), null);
        }
        return super.resolveSpec(errorSpec, context);
    }

    @Nullable
    public Object getDefaultErrorCode(@NotNull SqlStateInfo sqlState, @Nullable PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)sqlState, (String)"sqlState");
        return null;
    }

    @Nullable
    public SqlStateInfo getSqlStateByErrorCode(@NotNull Object errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        if (Intrinsics.areEqual((Object)errorCode, (Object)DEFAULT_ERROR_CODE)) {
            return (SqlStateInfo)new SqlStateInfo.Specific("P0001");
        }
        return (SqlStateInfo)new SqlStateInfo.Wildcard(SqlSpecialErrorSpec.Kind.OTHERS);
    }

    @NotNull
    public SqlErrorSpecInfo getNotFoundErrorSpec() {
        return new SqlErrorSpecInfo((SqlStateInfo)new SqlStateInfo.Specific("02000"), (Object)"NO_DATA_FOUND");
    }

    private PgErrorSpecHelper() {
    }

    static {
        PgErrorSpecHelper pgErrorSpecHelper;
        INSTANCE = pgErrorSpecHelper = new PgErrorSpecHelper();
    }
}

