/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.oracle.types.OraRecordType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObjectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.oracle.OraDateTimeLanguageHelper;
import com.intellij.sql.dialects.oracle.OraElementFactory;
import com.intellij.sql.dialects.oracle.OraElementTypes;
import com.intellij.sql.dialects.oracle.OraOptionalKeywords;
import com.intellij.sql.dialects.oracle.OraPlReservedKeywords;
import com.intellij.sql.dialects.oracle.OraReservedKeywords;
import com.intellij.sql.dialects.oracle.OraTokens;
import com.intellij.sql.dialects.oracle.OraTypeSystem;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.dataFlow.OraDFABuildingVisitor;
import com.intellij.sql.dialects.oracle.dataFlow.OraErrorSpecHelper;
import com.intellij.sql.dialects.oracle.psi.OraModelClauseImpl;
import com.intellij.sql.dialects.oracle.psi.OraReferenceTypeElementImpl;
import com.intellij.sql.dialects.oracle.refactoring.OraExtractFunctionHelper;
import com.intellij.sql.dialects.oracle.refactoring.OraExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraDialect
extends SqlLanguageDialectEx {
    public static final OraDialect INSTANCE = new OraDialect();

    public OraDialect() {
        super("Oracle");
    }

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        OraTypeSystem oraTypeSystem = OraTypeSystem.INSTANCE;
        if (oraTypeSystem == null) {
            OraDialect.$$$reportNull$$$0(0);
        }
        return oraTypeSystem;
    }

    protected OraDialect(@NonNls @NotNull String id) {
        if (id == null) {
            OraDialect.$$$reportNull$$$0(1);
        }
        super((SqlLanguageDialect)INSTANCE, id);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.ORACLE;
        if (dbms == null) {
            OraDialect.$$$reportNull$$$0(2);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    public boolean isReservedKeywordPL(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokensPL.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            OraDialect.$$$reportNull$$$0(3);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    public boolean processConnectByPseudoColumns(@NotNull PsiElement element, @NotNull SqlScopeProcessorBase processor) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            OraDialect.$$$reportNull$$$0(5);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (ReservedEntity entity : LazyData.CONNECT_BY_PSEUDO_COLUMNS.values()) {
                if (processor.executeTarget((DasSymbol)entity, this.getTypeSystem().integerType(), null, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        ObjectKind kind;
        if (place == null) {
            OraDialect.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            OraDialect.$$$reportNull$$$0(7);
        }
        if (!this.processReservedEntitiesWithTypeDual(name2, place, resolve2, processor)) {
            return false;
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve2, processor)) {
            return false;
        }
        SqlTypeSystemBase typeSystem = this.getTypeSystem();
        if (processor.isExpected(ObjectKind.COLUMN) && DbImplUtilCore.isDataTable((ObjectKind)(kind = SqlImplUtil.getQualifierKind((PsiElement)place)))) {
            for (ReservedEntity entity : LazyData.PSEUDO_COLUMNS.values()) {
                if (OraDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)entity, (SqlType)typeSystem.integerType(), (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, null)) continue;
                return false;
            }
        }
        if ((processor.isExpected(ObjectKind.COLUMN) || processor.isExpected(ObjectKind.ROUTINE)) && (SqlType.Category.ARRAY.is(SqlImplUtil.getQualifierType((PsiElement)place)) || OraDialect.isBulkUpdateAttribute(place))) {
            for (ReservedEntity entity : LazyData.PL_TABLE_ATTRIBUTES.values()) {
                if (OraDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)entity, (SqlType)(entity.getKind() == ObjectKind.COLUMN ? typeSystem.integerType() : null), (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, null)) continue;
                return false;
            }
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)LazyData.RE_EXTEND.name, (String)name2, (boolean)resolve2) && SqlType.Category.ARRAY.is(SqlImplUtil.getQualifierType((PsiElement)place)) && !processor.executeTarget((DasSymbol)LazyData.RE_EXTEND, SqlTypeFactory.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        if (!OraDialect.processReservedEntitiesWithTypeSimple((ReservedEntity)LazyData.RE_PROFILE_DEFAULT, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)place, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, null)) {
            return false;
        }
        if (place instanceof SqlReferenceExpression && resolve2 && ((SqlReferenceExpression)place).getQualifierExpression() == null) {
            for (ReservedEntity object : LazyData.ourObjects) {
                if (processor.executeTarget((DasSymbol)object, null, Boolean.valueOf(false), ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull SqlReference ref2, @NotNull SqlExpression qualifier) {
        DasType dasType;
        if (processor == null) {
            OraDialect.$$$reportNull$$$0(8);
        }
        if (state2 == null) {
            OraDialect.$$$reportNull$$$0(9);
        }
        if (ref2 == null) {
            OraDialect.$$$reportNull$$$0(10);
        }
        if (qualifier == null) {
            OraDialect.$$$reportNull$$$0(11);
        }
        if (processor.mayAccept(ObjectKind.COLUMN) && (dasType = DasTypeUtilsKt.unwrapAlias((DasType)qualifier.getDasType())) instanceof OraRecordType) {
            Project project = qualifier.getProject();
            for (DasTypedObjectEx column2 : ((OraRecordType)dasType).getColumnScope().getAllElements()) {
                ResolveState qualifiedState = SqlImplUtil.setQualifier((ResolveState)state2, (PsiElement)qualifier);
                DasSymbol columnSymbol = DasSymbolUtil.wrapObjectToSymbol((DasObject)column2, (Project)project);
                if (processor.execute(columnSymbol, qualifiedState)) continue;
                return false;
            }
        }
        return super.processQualifiedResolve(processor, state2, ref2, qualifier);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            OraDialect.$$$reportNull$$$0(16);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath((TreePattern)pattern, (ObjectName[])dsNames, Collections.singletonList(ObjectName.quoted((String)"PUBLIC")), (boolean)false, (ObjectKind[])new ObjectKind[]{SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA});
        if (treePattern == null) {
            OraDialect.$$$reportNull$$$0(17);
        }
        return treePattern;
    }

    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target2) {
        if (target2 == null) {
            OraDialect.$$$reportNull$$$0(18);
        }
        Set set = target2 == ObjectKind.ROUTINE && SqlPsiMiscUtil.isDropTarget((PsiElement)context) ? LazyData.IGNORED_ROUTINE_DROP_TARGETS : super.getIgnoredParentKinds(context, target2);
        if (set == null) {
            OraDialect.$$$reportNull$$$0(19);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        PsiElement parent2;
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(20);
        }
        if (strict) {
            return false;
        }
        if (SqlDialectImplUtilCore.isLabelOrRoutineQualification((PsiElement)(symbol instanceof PsiElement ? (PsiElement)symbol : null), (ObjectKind)type, (PsiElement)place, (boolean)isCompletion)) {
            return true;
        }
        if (type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.VARIABLE)) {
            return true;
        }
        if (type == ObjectKind.ROUTINE && expectedTypes.contains(ObjectKind.COLUMN)) {
            DasRoutine routine2;
            DasRoutine dasRoutine = routine2 = symbol != null ? (DasRoutine)ObjectUtils.tryCast((Object)symbol.getDasObject(), DasRoutine.class) : null;
            if (routine2 == null) {
                return false;
            }
            DasArgument arg = (DasArgument)SqlFunctionsUtil.getAcceptedArguments((DasObject)routine2).find(a -> !a.getName().equalsIgnoreCase("self") && a.getDefault() == null);
            return arg == null;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return symbol == null || symbol instanceof PsiElement && ((PsiElement)symbol).getParent() instanceof OraModelClauseImpl;
        }
        if ((type == ObjectKind.VARIABLE || type == ObjectKind.ARGUMENT) && expectedTypes.contains(OraElementTypes.Kinds.COLLECTION)) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        PsiElement psiElement = parent2 = place != null ? place.getParent() : null;
        if (isCompletion && parent2 instanceof OraReferenceTypeElementImpl && parent2.getParent() instanceof SqlVariableDefinition) {
            return OraDialect.isTableTypeLookupCandidate(type, expectedTypes) || OraDialect.isColumnTypeLookupCandidate(type, expectedTypes);
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    private static boolean isTableTypeLookupCandidate(ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(21);
        }
        return (type == ObjectKind.TABLE || type == ObjectKind.VIEW) && expectedTypes.contains(ObjectKind.OBJECT_TYPE);
    }

    private static boolean isColumnTypeLookupCandidate(ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(22);
        }
        return type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.OBJECT_TYPE);
    }

    @Nullable
    public String adjustReferenceLookupString(@NotNull LookupElement element, @NotNull ObjectKind kind, @NotNull Set<ObjectKind> expectedTypes) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(23);
        }
        if (kind == null) {
            OraDialect.$$$reportNull$$$0(24);
        }
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(25);
        }
        if (OraDialect.isTableTypeLookupCandidate(kind, expectedTypes)) {
            return element.getLookupString() + "%rowtype";
        }
        if (OraDialect.isColumnTypeLookupCandidate(kind, expectedTypes)) {
            return element.getLookupString() + "%type";
        }
        return null;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            OraDialect.$$$reportNull$$$0(26);
        }
        ObjectKind kind = SqlImplUtil.getIdentifierKind((SqlIdentifier)identifier);
        if (Registry.is((String)"database.oracle.names.long") || version == null || version.isOrGreater(new int[]{12, 2})) {
            if (kind == ObjectKind.DATABASE) {
                SqlCreateStatement createDb = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlCreateStatement.class);
                return createDb != null && PsiUtilCore.getElementType((PsiElement)createDb) == OraTypes.ORA_CREATE_DATABASE_STATEMENT && PsiTreeUtil.findSiblingForward((PsiElement)createDb.getFirstChild(), (IElementType)OraTypes.ORA_PLUGGABLE, (boolean)true, null) != null ? 30 : 8;
            }
            return kind == OraElementTypes.Kinds.DISKGROUP || kind == OraElementTypes.Kinds.ROLLBACK_SEGMENT || kind == ObjectKind.TABLESPACE ? 30 : 128;
        }
        return kind == ObjectKind.DATABASE ? 8 : (kind == ObjectKind.DB_LINK ? 128 : 30);
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.PACKAGE);
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.OPERATOR) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.BODY);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            OraDialect.$$$reportNull$$$0(27);
        }
        return kind == ObjectKind.CLUSTER || super.shouldSkipFromQualification(kind);
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type) {
        return type != OraElementTypes.Extra.CONDITIONAL_FLAG && (type != ObjectKind.EXCEPTION || o2 != null && !this.getExceptionNames().contains(o2.getName())) && super.shallResolve(o2, type);
    }

    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        if (name2 == null) {
            OraDialect.$$$reportNull$$$0(28);
        }
        if (name2.equals("JSON_PASSING_CLAUSE")) {
            return OraElementTypes.Misc.ORA_JSON_PASSING_CLAUSE;
        }
        if (name2.equals("JSON_EXISTS_ON_ERROR_CLAUSE")) {
            return OraElementTypes.Misc.ORA_JSON_EXISTS_ON_ERROR_CLAUSE;
        }
        IElementType res2 = OraElementFactory.findComposite(name2);
        return res2 == null ? super.getFunctionParserExtension(name2) : res2;
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    public boolean isMultiIdReference(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            OraDialect.$$$reportNull$$$0(29);
        }
        return expression.getReferenceElementType() == OraElementTypes.Extra.ORA_DATABASE_LINK_REFERENCE;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            OraDialect.$$$reportNull$$$0(30);
        }
        if (super.isTableAliasAllowedAt(element)) {
            return true;
        }
        SqlOnTargetClauseImpl onTargetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlOnTargetClauseImpl.class});
        return PsiTreeUtil.getContextOfType((PsiElement)onTargetClause, (Class[])new Class[]{SqlCreateIndexStatement.class}) != null;
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o2, InspectionManager manager, boolean onTheFly) {
        ProblemDescriptor result2 = this.checkIdentifierStartsWithLetter(o2, manager, onTheFly);
        if (result2 != null) {
            return result2;
        }
        SqlDefinition def = (SqlDefinition)ObjectUtils.tryCast((Object)PsiTreeUtil.getTopmostParentOfType((PsiElement)o2, SqlStatement.class), SqlDefinition.class);
        boolean isPl = false;
        if (def != null && !PsiTreeUtil.isContextAncestor((PsiElement)def.getNameElement(), (PsiElement)o2, (boolean)false)) {
            ObjectKind kind = def.getKind();
            isPl = kind == ObjectKind.ROUTINE || kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY;
        }
        return this.checkIdentifierIsKeyword(o2, manager, onTheFly, isPl);
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new OraExtractVariableHelper();
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return OraExtractFunctionHelper.INSTANCE;
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        OraErrorSpecHelper oraErrorSpecHelper = OraErrorSpecHelper.INSTANCE;
        if (oraErrorSpecHelper == null) {
            OraDialect.$$$reportNull$$$0(31);
        }
        return oraErrorSpecHelper;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new OraDFABuildingVisitor(this);
    }

    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        OraDateTimeLanguageHelper oraDateTimeLanguageHelper = OraDateTimeLanguageHelper.INSTANCE;
        if (oraDateTimeLanguageHelper == null) {
            OraDialect.$$$reportNull$$$0(32);
        }
        return oraDateTimeLanguageHelper;
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})})});
    }

    private static boolean isBulkUpdateAttribute(PsiElement element) {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof SqlBinaryExpression)) {
            return false;
        }
        SqlUnaryExpression prev = (SqlUnaryExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, SqlUnaryExpression.class);
        ASTNode node = prev == null ? null : prev.getNode();
        ASTNode bulkException = node == null ? null : node.findChildByType(OraTypes.ORA_BULK_EXCEPTIONS);
        return bulkException != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/OraDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/OraDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processConnectByPseudoColumns";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isTableTypeLookupCandidate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isColumnTypeLookupCandidate";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "adjustReferenceLookupString";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isMultiIdReference";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final Set<ObjectKind> IGNORED_ROUTINE_DROP_TARGETS = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.PACKAGE, ObjectKind.OBJECT_TYPE});
        static final TokenClasses ourClasses = new TokenClasses(OraTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final Set<String> ourSystemVars;
        static final Set<String> ourExceptionNames;
        static final List<ReservedEntity> ourObjects;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static final NullableFunction<String, IElementType> ourReservedTokensPL;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final TokenSet ourClosingTokens;
        static final Set<IElementType> ourSupportedOperators;
        static final Map<String, ReservedEntity> PSEUDO_COLUMNS;
        static final Map<String, ReservedEntity> CONNECT_BY_PSEUDO_COLUMNS;
        static final Map<String, ReservedEntity> PL_TABLE_ATTRIBUTES;
        static final ReservedEntity RE_EXTEND;
        static final ReservedEntity RE_PROFILE_DEFAULT;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            SqlTokenRegistry.initTypeMap(OraPlReservedKeywords.class, null);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadTokens((SqlLanguageDialect)INSTANCE, (String)"exceptions.txt"));
            ourObjects = SqlDialectImplUtilCore.loadObjects((SqlLanguageDialect)INSTANCE, (String)"fallback.txt");
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourReservedTokensPL = SqlTokenRegistry.getTokenProvider(OraPlReservedKeywords.class);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV, SqlTokens.ORAP_SLASH_DELIMITER_TOKEN, SqlTokens.ORAP_DELIMITER_TOKEN, SqlTokens.ORAP_BIG_DELIMITER_TOKEN})});
            ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.ORA_POWER, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.ORA_OP_JOIN, OraReservedKeywords.ORA_PRIOR, OraOptionalKeywords.ORA_LIKEC, OraOptionalKeywords.ORA_LIKE2, OraOptionalKeywords.ORA_LIKE4, OraTypes.ORA_AT, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_NEQ_WS, SqlTokens.SQL_OP_NEQ2_WS, SqlTokens.SQL_OP_NEQ3_WS, SqlTokens.SQL_YEAR, SqlTokens.SQL_DAY, SqlTokens.SQL_OP_ASSIGN, OraTypes.ORA_MEMBER, OraTypes.ORA_SUBMULTISET, OraTypes.ORA_CURSOR, OraOptionalKeywords.ORA_MULTISET);
            PSEUDO_COLUMNS = SqlDialectImplUtilCore.buildEntities((Dbms)Dbms.ORACLE, (ObjectKind)ObjectKind.COLUMN, (String[])new String[]{"BINARY_DOUBLE_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_FLOAT_INFINITY", "BINARY_FLOAT_NAN", "COLUMN_VALUE", "OBJECT_ID", "OBJECT_VALUE", "ORA_ROWSCN", "VERSIONS_STARTTIME", "VERSIONS_STARTSCN", "VERSIONS_ENDTIME", "VERSIONS_ENDSCN", "VERSIONS_XID", "VERSIONS_OPERATION", "XMLDATA", "ROWID", "ROWNUM"});
            CONNECT_BY_PSEUDO_COLUMNS = SqlDialectImplUtilCore.buildEntities((Dbms)Dbms.ORACLE, (ObjectKind)ObjectKind.COLUMN, (String[])new String[]{"CONNECT_BY_ISCYCLE", "CONNECT_BY_ISLEAF", "LEVEL"});
            PL_TABLE_ATTRIBUTES = SqlDialectImplUtilCore.buildEntities((Dbms)Dbms.ORACLE, (ObjectKind)ObjectKind.COLUMN, (String[])new String[]{"COUNT", "FIRST", "LAST"});
            RE_EXTEND = new ReservedEntity(Dbms.ORACLE, "extend", ObjectKind.OBJECT_TYPE);
            RE_PROFILE_DEFAULT = new ReservedEntity(Dbms.ORACLE, "DEFAULT", SqlDbElementType.PROFILE);
            PL_TABLE_ATTRIBUTES.putAll(SqlDialectImplUtilCore.buildEntities((Dbms)Dbms.ORACLE, (ObjectKind)ObjectKind.ROUTINE, (String[])new String[]{"EXISTS", "PRIOR", "NEXT", "DELETE"}));
        }
    }
}

