/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql.dataFlow.MsDFABuildingVisitor;
import com.intellij.sql.dialects.mssql.refactoring.MsExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MsDialectBase
extends SqlLanguageDialectEx {
    private final NotNullLazyValue<LazyInstanceData> myInstanceData;

    protected MsDialectBase(@NotNull String id) {
        if (id == null) {
            MsDialectBase.$$$reportNull$$$0(0);
        }
        super(id);
        this.myInstanceData = NotNullLazyValue.atomicLazy(() -> new LazyInstanceData());
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"hierarchyid", (String)"hierarchyid", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"xml", (String)"xml", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"geometry", (String)"geometry", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"geography", (String)"geography", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MsDialectBase.$$$reportNull$$$0(1);
        }
        if ((type == ObjectKind.ALIAS_TYPE || type == ObjectKind.TABLE_TYPE) && expectedTypes.contains(ObjectKind.OBJECT_TYPE)) {
            return true;
        }
        if (type == ObjectKind.INDEX && expectedTypes.contains(SqlDbElementType.STATISTICS) && place instanceof SqlReferenceExpression && PsiUtilCore.getElementType((PsiElement)place.getParent()) == MsTypes.MSSQL_UPDATE_STATISTICS_STATEMENT) {
            return true;
        }
        if ((type == ObjectKind.LOGIN || type == ObjectKind.ROLE) && expectedTypes.contains(ObjectKind.USER)) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            MsDialectBase.$$$reportNull$$$0(2);
        }
        for (PsiElement parent2 : SqlImplUtil.sqlParents((PsiElement)place)) {
            if (PsiUtilCore.getElementType((PsiElement)parent2) != SqlElementTypes.SQL_COLUMN_GENERATED_CLAUSE) continue;
            return true;
        }
        return super.allowGlobalTableResolve(place);
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            MsDialectBase.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            MsDialectBase.$$$reportNull$$$0(4);
        }
        SqlTypeSystemBase typeSystem = this.getTypeSystem();
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_ACTION.name, (boolean)resolve2)) {
            if (!processor.executeTarget((DasSymbol)LazyData.RE_ACTION, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_IDENTITY.name, (boolean)resolve2)) {
            if (!processor.executeTarget((DasSymbol)LazyData.RE_IDENTITY, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_ROWGUID.name, (boolean)resolve2)) {
            if (!processor.executeTarget((DasSymbol)LazyData.RE_ROWGUID, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_XML.name, (boolean)resolve2)) {
            if (!processor.executeTarget((DasSymbol)LazyData.RE_XML, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_ROWVERSION.name, (boolean)resolve2)) {
            if (!processor.executeTarget((DasSymbol)LazyData.RE_ROWVERSION, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_GEOMETRY.name, (boolean)resolve2)) {
            if (!processor.executeTarget((DasSymbol)LazyData.RE_GEOMETRY, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_GEOGRAPHY.name, (boolean)resolve2)) {
            if (!processor.executeTarget((DasSymbol)LazyData.RE_GEOGRAPHY, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else {
            String referenceName;
            String string = referenceName = place instanceof SqlReferenceExpression ? ((SqlReferenceExpression)place).getName() : null;
            if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.VARIABLE})) {
                SqlType scopingType = SqlImplUtil.getScopingType((PsiElement)place);
                if (scopingType != null) {
                    String typeName = scopingType.getDisplayName();
                    if ((typeName.equalsIgnoreCase("geometry") || typeName.equalsIgnoreCase("geography")) && !processor.executeTarget((DasSymbol)LazyData.RE_GEO_NULL, scopingType, null, ResolveState.initial())) {
                        return false;
                    }
                } else {
                    Map<String, ReservedEntity.Typed> fieldMap2;
                    String typeName = SqlImplUtil.getQualifierType((PsiElement)place).getDisplayName();
                    LazyInstanceData instanceData = (LazyInstanceData)this.myInstanceData.getValue();
                    Map<String, Object> map2 = typeName.equalsIgnoreCase("geometry") ? instanceData.GEOMETRY_FIELDS : (fieldMap2 = typeName.equalsIgnoreCase("geography") ? instanceData.GEOGRAPHY_FIELDS : null);
                    if (fieldMap2 != null) {
                        ReservedEntity.Typed target2 = instanceData.COMMON_GEO_FIELDS.get(referenceName);
                        if (target2 == null) {
                            target2 = fieldMap2.get(referenceName);
                        }
                        if (target2 != null && !processor.executeTarget((DasSymbol)target2, target2.type, null, ResolveState.initial())) {
                            return false;
                        }
                    }
                }
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor);
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull SqlReference ref2, @NotNull SqlExpression qualifier) {
        DasSymbol qualifierSymbol;
        if (processor == null) {
            MsDialectBase.$$$reportNull$$$0(5);
        }
        if (state2 == null) {
            MsDialectBase.$$$reportNull$$$0(6);
        }
        if (ref2 == null) {
            MsDialectBase.$$$reportNull$$$0(7);
        }
        if (qualifier == null) {
            MsDialectBase.$$$reportNull$$$0(8);
        }
        if (qualifier instanceof SqlReferenceExpression && (qualifierSymbol = ((SqlReferenceExpression)qualifier).resolveSymbol()) != null && qualifierSymbol.getKind() == ObjectKind.LINKED_SERVER) {
            processor.executeTarget(DasSymbolUtil.getInlineSymbol((SqlReference)ref2, (boolean)true), null, Boolean.valueOf(false), state2);
        }
        return super.processQualifiedResolve(processor, state2, ref2, qualifier);
    }

    @Nullable
    public Condition<DasObject> getAdditionalExpandCondition(@NotNull SqlScopeProcessor processor, @NotNull PsiElement place) {
        if (processor == null) {
            MsDialectBase.$$$reportNull$$$0(9);
        }
        if (place == null) {
            MsDialectBase.$$$reportNull$$$0(10);
        }
        if (processor instanceof SqlCompletionScopeProcessor) {
            return o2 -> o2.getKind() == ObjectKind.SCHEMA;
        }
        PsiElement parent2 = place.getParent();
        if (processor.mayAccept(ObjectKind.ROUTINE) && parent2 instanceof SqlFunctionCallExpression && parent2.getParent() instanceof SqlCallStatement) {
            return o2 -> o2.getKind() == ObjectKind.SCHEMA && o2.getName().equals("sys");
        }
        return null;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            MsDialectBase.$$$reportNull$$$0(11);
        }
        return 128;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName, @Nullable ObjectKind kind) {
        if (identifier == null) {
            MsDialectBase.$$$reportNull$$$0(12);
        }
        if (newElementName == null) {
            MsDialectBase.$$$reportNull$$$0(13);
        }
        if (kind == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName, kind);
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type) {
        if (type == SqlDbElementType.ANY && MsDialectBase.isExecArg(o2)) {
            return false;
        }
        return MsElementTypes.Kinds.FILEGROUP != type && MsElementTypes.Kinds.FILE != type && super.shallResolve(o2, type);
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.INDEX) {
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        if (type == ObjectKind.DATABASE) {
            result2.add((ObjectKind)ObjectKind.LINKED_SERVER);
        }
        return result2;
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref2) {
        if (ref2 == null) {
            MsDialectBase.$$$reportNull$$$0(14);
        }
        return !this.getKeywords().contains(ref2);
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            MsDialectBase.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        List<ObjectName> schemas2 = MsDialectBase.getSchemaNames(dataSource);
        ObjectName dbname = MsDialectBase.getDatabaseName(dataSource);
        DasNamespace namespace = MsDialectBase.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[]{namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(schemas2, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                MsDialectBase.$$$reportNull$$$0(16);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)SqlImportUtil.createPositiveDatabase((dataSource == null ? 1 : 0) != 0, (ObjectName)dbname, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create(schemas2, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}))));
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        TreePatternNode.Group[] schemas2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MsDialectBase.getSchemaNames(dataSource), (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)MsDialectBase.getDatabaseName(dataSource), (ObjectKind)ObjectKind.DATABASE, (TreePatternNode.Group[])schemas2)});
        TreePattern treePattern = SqlDialectImplUtilCore.forcedContextExpandedToSchemas((DbDataSource)dataSource, (Dbms)this.getDbms(), (SearchPath)searchPath, (TreePatternNode.Group[])schemas2, (TreePatternNode.Group[])databases2);
        if (treePattern == null) {
            MsDialectBase.$$$reportNull$$$0(17);
        }
        return treePattern;
    }

    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref2) {
        if (prev == null) {
            MsDialectBase.$$$reportNull$$$0(18);
        }
        if (ref2 == null) {
            MsDialectBase.$$$reportNull$$$0(19);
        }
        return SqlDialectImplUtilCore.refPatternExpandedToSchema((TreePattern)prev, (SqlReferenceExpression)ref2, (SqlLanguageDialectEx)this);
    }

    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath searchPath) {
        if (searchPath == null) {
            MsDialectBase.$$$reportNull$$$0(20);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, searchPath);
        if (treePattern == null) {
            MsDialectBase.$$$reportNull$$$0(21);
        }
        return treePattern;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            MsDialectBase.$$$reportNull$$$0(22);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlMergeStatement.class}) != null;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return MsExtractFunctionHelper.INSTANCE;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new MsDFABuildingVisitor(this);
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, false})}), new SubstitutionDescriptorImpl(new IElementType[]{MsTypes.MSSQL_TRY, MsElementTypes.Misc.MSSQL_TRY_CATCH_STATEMENT}, "", "end try\nbegin catch\nend catch", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{MsTypes.MSSQL_TRY}).opt(new IElementType[]{MsElementTypes.Misc.MSSQL_CATCH_CLAUSE, SqlElementTypes.SQL_SEMICOLON}).build()}), new SubstitutionDescriptorImpl(new IElementType[]{MsTypes.MSSQL_CATCH, MsElementTypes.Misc.MSSQL_CATCH_CLAUSE}, "", "end catch", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, MsTypes.MSSQL_CATCH, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})})});
    }

    public static boolean isExecArg(@Nullable SqlReferenceExpression o2) {
        if (o2 == null) {
            return false;
        }
        PsiElement top = (PsiElement)SqlImplUtil.sqlParents((PsiElement)o2).skipWhile(x -> x == o2 || x instanceof SqlNamedParameterValueExpression || x instanceof SqlExpressionList || x instanceof SqlFunctionCallExpression).first();
        return top instanceof SqlStatement;
    }

    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtilCore.getDatabaseName((RawConnectionConfig)SqlImportUtil.getConnectionConfig((DbDataSource)dataSource)), (Object)"master")));
    }

    @NotNull
    private static List<ObjectName> getSchemaNames(@Nullable DbDataSource dataSource) {
        SmartList schemas2 = new SmartList((Object)ObjectName.quoted((String)"dbo"));
        String username = SqlDialectImplUtilCore.getUserName((RawConnectionConfig)SqlImportUtil.getConnectionConfig((DbDataSource)dataSource));
        if (username != null) {
            schemas2.add(ObjectName.plain((String)username));
        }
        SmartList smartList = schemas2;
        if (smartList == null) {
            MsDialectBase.$$$reportNull$$$0(23);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mssql/MsDialectBase";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mssql/MsDialectBase";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalExpandCondition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LazyInstanceData {
        private final ReservedEntity.Typed RE_GEO_STSRID;
        private final ReservedEntity.Typed RE_GEO_STX;
        private final ReservedEntity.Typed RE_GEO_STY;
        private final ReservedEntity.Typed RE_GEO_HASM;
        private final ReservedEntity.Typed RE_GEO_HASZ;
        private final ReservedEntity.Typed RE_GEO_M;
        private final ReservedEntity.Typed RE_GEO_Z;
        private final ReservedEntity.Typed RE_GEO_LAT;
        private final ReservedEntity.Typed RE_GEO_LONG;
        private final Map<String, ReservedEntity.Typed> COMMON_GEO_FIELDS;
        private final Map<String, ReservedEntity.Typed> GEOMETRY_FIELDS;
        private final Map<String, ReservedEntity.Typed> GEOGRAPHY_FIELDS;

        private LazyInstanceData() {
            this.RE_GEO_STSRID = new ReservedEntity.Typed(Dbms.MSSQL, "STSrid", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().integerType());
            this.RE_GEO_STX = new ReservedEntity.Typed(Dbms.MSSQL, "STX", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().realType());
            this.RE_GEO_STY = new ReservedEntity.Typed(Dbms.MSSQL, "STY", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().realType());
            this.RE_GEO_HASM = new ReservedEntity.Typed(Dbms.MSSQL, "HasM", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().booleanType());
            this.RE_GEO_HASZ = new ReservedEntity.Typed(Dbms.MSSQL, "HasZ", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().booleanType());
            this.RE_GEO_M = new ReservedEntity.Typed(Dbms.MSSQL, "M", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().realType());
            this.RE_GEO_Z = new ReservedEntity.Typed(Dbms.MSSQL, "Z", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().realType());
            this.RE_GEO_LAT = new ReservedEntity.Typed(Dbms.MSSQL, "Lat", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().realType());
            this.RE_GEO_LONG = new ReservedEntity.Typed(Dbms.MSSQL, "Long", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().realType());
            this.COMMON_GEO_FIELDS = new ContainerUtil.ImmutableMapBuilder().put((Object)this.RE_GEO_STSRID.name, (Object)this.RE_GEO_STSRID).put((Object)this.RE_GEO_HASM.name, (Object)this.RE_GEO_HASM).put((Object)this.RE_GEO_HASZ.name, (Object)this.RE_GEO_HASZ).put((Object)this.RE_GEO_M.name, (Object)this.RE_GEO_M).put((Object)this.RE_GEO_Z.name, (Object)this.RE_GEO_Z).build();
            this.GEOMETRY_FIELDS = new ContainerUtil.ImmutableMapBuilder().put((Object)this.RE_GEO_STX.name, (Object)this.RE_GEO_STX).put((Object)this.RE_GEO_STY.name, (Object)this.RE_GEO_STY).build();
            this.GEOGRAPHY_FIELDS = new ContainerUtil.ImmutableMapBuilder().put((Object)this.RE_GEO_LAT.name, (Object)this.RE_GEO_LAT).put((Object)this.RE_GEO_LONG.name, (Object)this.RE_GEO_LONG).build();
        }
    }

    static final class LazyData {
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{MsTypes.MSSQL_GO})});
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ);
        static final ReservedEntity RE_ACTION = new ReservedEntity(Dbms.MSSQL, "$action", ObjectKind.COLUMN);
        static final ReservedEntity RE_IDENTITY = new ReservedEntity(Dbms.MSSQL, "$IDENTITY", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWGUID = new ReservedEntity(Dbms.MSSQL, "$ROWGUID", ObjectKind.COLUMN);
        static final ReservedEntity RE_XML = new ReservedEntity(Dbms.MSSQL, "XML", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_ROWVERSION = new ReservedEntity(Dbms.MSSQL, "rowversion", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_GEOMETRY = new ReservedEntity(Dbms.MSSQL, "geometry", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_GEOGRAPHY = new ReservedEntity(Dbms.MSSQL, "geography", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_GEO_NULL = new ReservedEntity(Dbms.MSSQL, "Null", ObjectKind.VARIABLE);
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Collections.singletonList(ObjectKind.TRIGGER);

        LazyData() {
        }
    }
}

