/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.database.Dbms;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSHighlightInfoFilter;", "Lcom/intellij/codeInsight/highlighting/HighlightErrorFilter;", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoFilter;", "()V", "suppressedWarnings", "", "", "accept", "", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "file", "Lcom/intellij/psi/PsiFile;", "shouldHighlightErrorElement", "element", "Lcom/intellij/psi/PsiErrorElement;", "intellij.database.dialects.mongo"})
public final class MongoJSHighlightInfoFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    private final Set<String> suppressedWarnings = SetsKt.setOf((Object[])new String[]{"JSUnresolvedVariable", "JSUnresolvedFunction", "UnterminatedStatementJS"});

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)highlightInfo, (String)"highlightInfo");
        PsiFile psiFile = file;
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return true;
        }
        PsiFile vFile = psiFile;
        DbDataSource dbDataSource = DbVFSUtils.getDataSource((Project)file.getProject(), (VirtualFile)vFile);
        if (dbDataSource == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"DbVFSUtils.getDataSource\u2026ct, vFile) ?: return true");
        DbDataSource dataSource = dbDataSource;
        DbDataSource dbDataSource2 = dataSource.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource2, (String)"dataSource.dataSource");
        Dbms dbms = dbDataSource2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dataSource.dataSource.dbms");
        if (!dbms.isMongo()) {
            return true;
        }
        return !CollectionsKt.contains((Iterable)this.suppressedWarnings, (Object)highlightInfo.getInspectionToolId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        Object object;
        boolean bl;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) return true;
        PsiFile file = psiFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) return true;
        VirtualFile virtualFile2 = virtualFile;
        DbDataSource dataSource = DbVFSUtils.getDataSource((Project)element.getProject(), (VirtualFile)virtualFile2);
        if (dataSource == null) return true;
        Dbms dbms = dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dataSource.dbms");
        if (!dbms.isMongo()) return true;
        Object object3 = element.getPrevSibling();
        if (object3 != null && (object3 = object3.getText()) != null) {
            object2 = object3;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            bl = false;
            Object object4 = object2;
            boolean bl2 = false;
            Object object5 = object4;
            if (object5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object5).toLowerCase(locale2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
        } else {
            object = null;
        }
        object2 = object;
        boolean bl3 = false;
        bl = false;
        Object prev = object2;
        boolean bl4 = false;
        if (!(Intrinsics.areEqual((Object)prev, (Object)"show") ^ true)) return false;
        if (!(Intrinsics.areEqual((Object)prev, (Object)"use") ^ true)) return false;
        return true;
    }
}

