/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.lang.DependentLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mongo.MongoSqlTokens;
import com.intellij.sql.dialects.mongo.MongoSqlTypeSystem;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MongoSqlDialect
extends SqlLanguageDialectEx
implements DependentLanguage {
    public static final MongoSqlDialect INSTANCE = new MongoSqlDialect();

    public MongoSqlDialect() {
        super("MongoDB");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MONGO;
        if (dbms == null) {
            MongoSqlDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            MongoSqlDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            MongoSqlDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            MongoSqlDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MongoSqlDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MongoSqlDialect.$$$reportNull$$$0(5);
        }
        if (place instanceof SqlReferenceExpression && type == SqlDbElementType.ANY && expectedTypes.contains(ObjectKind.COLUMN)) {
            PsiElement parent2 = place.getParent();
            while (parent2 instanceof SqlReferenceExpression) {
                ObjectKind parentKind = ((SqlReferenceExpression)parent2).getReferenceElementType().getTargetKind();
                if (parentKind == ObjectKind.COLUMN) {
                    return true;
                }
                parent2 = parent2.getParent();
            }
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        MongoSqlTypeSystem mongoSqlTypeSystem = MongoSqlTypeSystem.INSTANCE;
        if (mongoSqlTypeSystem == null) {
            MongoSqlDialect.$$$reportNull$$$0(6);
        }
        return mongoSqlTypeSystem;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        Collection res2 = super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            res2.add(ObjectKind.COLUMN);
        }
        return (T)res2;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"double", (String)"double", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"string", (String)"string", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"object", (String)"object", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"array", (String)"array", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"binData", (String)"binData", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"objectId", (String)"objectId", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"bool", (String)"bool", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"date", (String)"date", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"regex", (String)"regex", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"code", (String)"code", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"int", (String)"int", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"timestamp", (String)"timestamp", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"long", (String)"long", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"decimal", (String)"decimal", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"minKey", (String)"minKey", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"maxKey", (String)"maxKey", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"number", (String)"number", (SqlLanguageDialectEx)this);
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false})})});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mongo/MongoSqlDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mongo/MongoSqlDialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(MongoSqlTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final TokenSet ourClosingTokens;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ);
            ourClosingTokens = SqlTokens.STATEMENT_SEPARATORS;
        }
    }
}

