/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cockroach.psi;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiTable;
import com.intellij.database.symbols.DasColumnSymbol;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.cockroach.CRoachDialect;
import com.intellij.sql.dialects.cockroach.CRoachTypes;
import com.intellij.sql.dialects.cockroach.psi.CRoachAnalyzeKeyword;
import com.intellij.sql.dialects.cockroach.psi.CRoachExplainOption;
import com.intellij.sql.dialects.cockroach.psi.CRoachExplicitTableExpressionWithOrdinalityImpl;
import com.intellij.sql.dialects.cockroach.psi.CRoachShowStatementImpl;
import com.intellij.sql.dialects.cockroach.psi.CRoachWithCommentOption;
import com.intellij.sql.dialects.cockroach.psi.resolve.CRoachColumn;
import com.intellij.sql.dialects.cockroach.psi.resolve.StatementTypeUtilKt;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlExplainStatement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionWithOrdinalityImpl;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRoachStatementTableExpressionImpl
extends CRoachExplicitTableExpressionWithOrdinalityImpl {
    public CRoachStatementTableExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            CRoachStatementTableExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    protected SqlType getSqlTypeWithoutOrdinality() {
        SqlQueryExpression queryExpression;
        SqlStatement statement = (SqlStatement)this.findChildByClass(SqlStatement.class);
        if (statement instanceof SqlExplainStatement) {
            ArrayList<FakeColumn> resultColumns = new ArrayList<FakeColumn>();
            Set explainOptionTypes = PsiTreeUtil.findChildrenOfType((PsiElement)statement, CRoachExplainOption.class).stream().map(o2 -> o2.getOptionType()).collect(Collectors.toSet());
            boolean containStrongOption = false;
            if (explainOptionTypes.contains(CRoachTypes.CROACH_OPT) || explainOptionTypes.contains(CRoachTypes.CROACH_DEBUG) || explainOptionTypes.contains(CRoachTypes.CROACH_VEC)) {
                this.addColumns(resultColumns, LazyData.EXPLAIN_OPT_DEBUG_VEC_TYPE);
                containStrongOption = true;
            }
            if (explainOptionTypes.contains(CRoachTypes.CROACH_DISTSQL)) {
                this.addColumns(resultColumns, LazyData.EXPLAIN_DISTSQ_TYPE);
                containStrongOption = true;
            }
            if (!containStrongOption) {
                boolean isExplainAnalyze;
                boolean bl = isExplainAnalyze = PsiTreeUtil.findChildOfType((PsiElement)statement, CRoachAnalyzeKeyword.class) != null;
                if (isExplainAnalyze) {
                    this.addColumns(resultColumns, LazyData.EXPLAIN_ANALYZE_TYPE);
                } else {
                    this.addColumns(resultColumns, LazyData.EXPLAIN_TYPE);
                    if (explainOptionTypes.contains(CRoachTypes.CROACH_VERBOSE) || explainOptionTypes.contains(CRoachTypes.CROACH_TYPES)) {
                        this.addColumns(resultColumns, LazyData.EXPLAIN_VERBOSE_TYPES_TYPE);
                    }
                }
            }
            return new TableBasedSqlTableTypeImpl(resultColumns, (PsiElement)this.getTable());
        }
        if (statement instanceof CRoachShowStatementImpl) {
            boolean withComment;
            ArrayList<FakeColumn> resultColumns = new ArrayList<FakeColumn>();
            IElementType showElementType = ((CRoachShowStatementImpl)statement).getElementType();
            if (showElementType == CRoachTypes.CROACH_SHOW_SYSTEM_REFERENCE_STATEMENT) {
                return new TableBasedSqlTableTypeImpl(Collections.singletonList(new FakeSystemReferenceColumn(this.getTable())), (PsiElement)this.getTable());
            }
            List<CRoachColumn> columns = LazyData.SHOW_TYPE_MAP.get(showElementType.toString());
            this.addColumns(resultColumns, columns);
            boolean bl = withComment = PsiTreeUtil.findChildOfType((PsiElement)statement, CRoachWithCommentOption.class) != null;
            if (withComment) {
                this.addColumns(resultColumns, LazyData.SHOW_WITH_COMMENT_TYPE);
            }
            return new TableBasedSqlTableTypeImpl(resultColumns, (PsiElement)this.getTable());
        }
        if (statement instanceof SqlSelectStatement && (queryExpression = ((SqlSelectStatement)statement).getQueryExpression()) != null) {
            SqlType sqlType = queryExpression.getSqlType();
            if (sqlType == null) {
                CRoachStatementTableExpressionImpl.$$$reportNull$$$0(1);
            }
            return sqlType;
        }
        if (statement instanceof SqlDmlStatement) {
            SqlTableType type;
            SqlDmlInstruction instruction = (SqlDmlInstruction)PsiTreeUtil.findChildOfType((PsiElement)statement, SqlDmlInstruction.class);
            SqlReturningClause returningClause = (SqlReturningClause)PsiTreeUtil.findChildOfType((PsiElement)instruction, SqlReturningClause.class);
            SqlTableType sqlTableType = type = returningClause != null ? returningClause.getSqlType() : null;
            if (type != null) {
                SqlTableType sqlTableType2 = type;
                if (sqlTableType2 == null) {
                    CRoachStatementTableExpressionImpl.$$$reportNull$$$0(2);
                }
                return sqlTableType2;
            }
        }
        SqlType sqlType = super.getSqlTypeWithoutOrdinality();
        if (sqlType == null) {
            CRoachStatementTableExpressionImpl.$$$reportNull$$$0(3);
        }
        return sqlType;
    }

    private void addColumns(@NotNull List<FakeColumn> resultColumns, @Nullable List<CRoachColumn> newColumns) {
        if (resultColumns == null) {
            CRoachStatementTableExpressionImpl.$$$reportNull$$$0(4);
        }
        if (newColumns == null) {
            return;
        }
        resultColumns.addAll(ContainerUtil.map(newColumns, c -> new FakeColumn(this.getTable(), c.getName(), c.getType())));
    }

    @Nullable
    private SqlStatement getTableStatement() {
        return (SqlStatement)PsiTreeUtil.getChildOfType((PsiElement)this, SqlStatement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cockroach/psi/CRoachStatementTableExpressionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cockroach/psi/CRoachStatementTableExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTypeWithoutOrdinality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addColumns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FakeSystemReferenceColumn
    extends SqlExplicitTableExpressionWithOrdinalityImpl.FakeDefinition
    implements PsiColumn,
    DasColumnSymbol {
        protected FakeSystemReferenceColumn(PsiTable table) {
            super((SqlExplicitTableExpressionWithOrdinalityImpl)CRoachStatementTableExpressionImpl.this, (PsiElement)table);
        }

        @NotNull
        public DasColumn getDasObject() {
            FakeSystemReferenceColumn fakeSystemReferenceColumn = this;
            if (fakeSystemReferenceColumn == null) {
                FakeSystemReferenceColumn.$$$reportNull$$$0(0);
            }
            return fakeSystemReferenceColumn;
        }

        public short getPosition() {
            return 0;
        }

        public SqlNameElement getNameElement() {
            CRoachShowStatementImpl showStatement = (CRoachShowStatementImpl)((Object)ObjectUtils.tryCast((Object)CRoachStatementTableExpressionImpl.this.getTableStatement(), CRoachShowStatementImpl.class));
            if (showStatement == null) {
                return null;
            }
            SqlReferenceExpression systemReference = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)showStatement, SqlReferenceExpression.class);
            return systemReference != null ? systemReference : super.getNameElement();
        }

        public DasTable getTable() {
            return (PsiTable)this.getParent();
        }

        @Nullable
        public DasObject getDasParent() {
            return this.getTable();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                FakeSystemReferenceColumn.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                FakeSystemReferenceColumn.$$$reportNull$$$0(2);
            }
            return dataType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/dialects/cockroach/psi/CRoachStatementTableExpressionImpl$FakeSystemReferenceColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class FakeColumn
    extends SqlExplicitTableExpressionWithOrdinalityImpl.FakeDefinition
    implements SqlTypedDefinition {
        @NotNull
        private final String name;
        @NotNull
        private final DataType dataType;

        protected FakeColumn(@NotNull PsiTable table, @NotNull String name2, DataType dataType) {
            if (name2 == null) {
                FakeColumn.$$$reportNull$$$0(0);
            }
            if (dataType == null) {
                FakeColumn.$$$reportNull$$$0(1);
            }
            super((SqlExplicitTableExpressionWithOrdinalityImpl)CRoachStatementTableExpressionImpl.this, (PsiElement)table);
            this.name = name2;
            this.dataType = dataType;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                FakeColumn.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        public DasObject getDasParent() {
            return (PsiTable)this.getParent();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                FakeColumn.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.dataType;
            if (dataType == null) {
                FakeColumn.$$$reportNull$$$0(4);
            }
            return dataType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = SqlTypeFactory.of((DataType)this.dataType, (SqlLanguageDialect)CRoachDialect.INSTANCE);
            if (sqlType == null) {
                FakeColumn.$$$reportNull$$$0(5);
            }
            return sqlType;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = DasType.UNKNOWN;
            if (dasType == null) {
                FakeColumn.$$$reportNull$$$0(6);
            }
            return dasType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/cockroach/psi/CRoachStatementTableExpressionImpl$FakeColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/cockroach/psi/CRoachStatementTableExpressionImpl$FakeColumn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class LazyData {
        static final Map<String, List<CRoachColumn>> SHOW_TYPE_MAP = StatementTypeUtilKt.loadStatementType("psi/resolve/showStatementType.txt");
        static final List<CRoachColumn> SHOW_WITH_COMMENT_TYPE = Collections.singletonList(new CRoachColumn("comment", "text"));
        static final List<CRoachColumn> EXPLAIN_OPT_DEBUG_VEC_TYPE = Collections.singletonList(new CRoachColumn("text", "text"));
        static final List<CRoachColumn> EXPLAIN_DISTSQ_TYPE = Arrays.asList(new CRoachColumn("automatic", "boolean"), new CRoachColumn("url", "text"));
        static final List<CRoachColumn> EXPLAIN_VERBOSE_TYPES_TYPE = Arrays.asList(new CRoachColumn("columns", "text"), new CRoachColumn("ordering", "text"));
        static final List<CRoachColumn> EXPLAIN_ANALYZE_TYPE = EXPLAIN_DISTSQ_TYPE;
        static final List<CRoachColumn> EXPLAIN_TYPE = Arrays.asList(new CRoachColumn("tree", "text"), new CRoachColumn("field", "text"), new CRoachColumn("description", "text"));

        LazyData() {
        }
    }
}

