/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.dialects.postgresbase.model.PgBaseDescriptionService;
import com.intellij.database.dialects.redshift.model.RsExternalSchema;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.RsExternalTableColumn;
import com.intellij.database.dialects.redshift.model.RsModelFunKt;
import com.intellij.database.dialects.redshift.model.RsTable;
import com.intellij.database.dialects.redshift.model.RsTableColumn;
import com.intellij.database.dialects.redshift.model.RsUser;
import com.intellij.database.dialects.redshift.model.properties.RsExternalTableStorageType;
import com.intellij.database.dialects.redshift.model.properties.RsTableBackupMode;
import com.intellij.database.dialects.redshift.model.properties.RsTableDistStyle;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicDistTableColumn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/redshift/model/RsDescriptionService;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeRedshiftColumn", "column", "Lcom/intellij/database/dialects/redshift/model/RsTableColumn;", "describeRedshiftExternalSchema", "schema", "Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;", "describeRedshiftExternalTable", "table", "Lcom/intellij/database/dialects/redshift/model/RsExternalTable;", "describeRedshiftExternalTableColumn", "Lcom/intellij/database/dialects/redshift/model/RsExternalTableColumn;", "describeRedshiftTable", "Lcom/intellij/database/dialects/redshift/model/RsTable;", "describeRedshiftUser", "user", "Lcom/intellij/database/dialects/redshift/model/RsUser;", "intellij.database.dialects.redshift"})
public final class RsDescriptionService
extends PgBaseDescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof RsTable ? this.describeRedshiftTable((RsTable)e2, context) : (basicElement instanceof RsTableColumn ? this.describeRedshiftColumn((RsTableColumn)e2, context) : (basicElement instanceof RsExternalSchema ? this.describeRedshiftExternalSchema((RsExternalSchema)e2, context) : (basicElement instanceof RsExternalTable ? this.describeRedshiftExternalTable((RsExternalTable)e2, context) : (basicElement instanceof RsExternalTableColumn ? this.describeRedshiftExternalTableColumn((RsExternalTableColumn)e2, context) : (basicElement instanceof RsUser ? this.describeRedshiftUser((RsUser)e2, context) : super.content(e2, context))))));
    }

    private final String describeRedshiftColumn(RsTableColumn column2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId basicMetaPropertyId = RsTableColumn.ENCODING;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = RsTableColumn.SORT_KEY_ORDER;
        bl = false;
        collection.add(basicMetaPropertyId);
        String d = this.describeDistColumn((BasicDistTableColumn)column2, context);
        if (column2.getEncoding() != null && !RsModelFunKt.isDefaultEncoding(column2)) {
            d = d + " encode(" + column2.getEncoding() + ')';
        }
        return d;
    }

    private final String describeRedshiftExternalSchema(RsExternalSchema schema, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = RsExternalSchema.DATABASE_NAME;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalSchema.IAM_ROLE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalSchema.URI;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalSchema.PORT;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalSchema.REGION;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalSchema.SCHEMA_KIND;
        bl = false;
        collection.add(object);
        ArrayList<String> attributes2 = new ArrayList<String>();
        if (schema.getDatabaseName() != null) {
            attributes2.add("database name: " + schema.getDatabaseName());
        }
        if (schema.getIamRole() != null) {
            attributes2.add("iam role: " + schema.getIamRole());
        }
        if (schema.getUri() != null) {
            attributes2.add("uri: " + schema.getUri());
        }
        if (schema.getPort() != null) {
            attributes2.add("port: " + schema.getPort());
        }
        if (schema.getRegion() != null) {
            attributes2.add("region: " + schema.getRegion());
        }
        if (schema.getSchemaKind() != -1) {
            attributes2.add("kind: " + (schema.getSchemaKind() == 2 ? "hive metastore" : "data catalog"));
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String describeRedshiftExternalTable(RsExternalTable table, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = RsExternalTable.SERIALIZATION_LIB;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalTable.INPUT_FORMAT;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalTable.OUTPUT_FORMAT;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalTable.LOCATION;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalTable.SERDE_PROPERTIES;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalTable.PROPS;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsExternalTable.STORAGE_TYPE;
        bl = false;
        collection.add(object);
        ArrayList<String> attributes2 = new ArrayList<String>();
        if (table.getSerializationLib() != null) {
            attributes2.add("serialization lib: " + table.getSerializationLib());
        }
        if (table.getInputFormat() != null) {
            attributes2.add("input format: " + table.getInputFormat());
        }
        if (table.getOutputFormat() != null) {
            attributes2.add("output fotmat: " + table.getOutputFormat());
        }
        if (table.getLocation() != null) {
            attributes2.add("location: " + table.getLocation());
        }
        List<String> list = table.getSerdeProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"table.serdeProperties");
        object = list;
        bl = false;
        if (!object.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("serde properties: ");
            List<String> list2 = table.getSerdeProperties();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"table.serdeProperties");
            attributes2.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null)).toString());
        }
        List<String> list3 = table.getProps();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"table.props");
        object = list3;
        bl = false;
        if (!object.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("properties: ");
            List<String> list4 = table.getProps();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"table.props");
            attributes2.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null)).toString());
        }
        if (table.getStorageType() != RsExternalTableStorageType.UNKNOWN) {
            attributes2.add("stored as: " + table.getStorageType().getSqlDefinition());
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String describeRedshiftExternalTableColumn(RsExternalTableColumn column2, DescriptionService.Context context) {
        String string;
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<Integer> basicMetaPropertyId = RsExternalTableColumn.PARTITION_KEY_ORDER;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        StringBuilder stringBuilder = new StringBuilder().append(this.describeColumn((BasicLikeColumn)column2, context)).append(" ");
        switch (column2.getPartitionKeyOrder()) {
            case 0: {
                string = "";
                break;
            }
            default: {
                string = "partition key order: " + column2.getPartitionKeyOrder();
            }
        }
        return stringBuilder.append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String describeRedshiftTable(RsTable table, DescriptionService.Context context) {
        void $this$sortedBy$iv;
        RsTableColumn it;
        void $this$filterTo$iv$iv2;
        Collection collection = context.getDescribed();
        Object object = RsTable.DIST_STYLE;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = RsTable.BACKUP_MODE;
        bl = false;
        collection.add(object);
        String d = this.describeTable((BasicTable)table, context);
        if (table.getDistStyle() != RsTableDistStyle.EVEN) {
            d = d + " diststyle(" + table.getDistStyle().name() + ')';
        }
        if (table.getBackupMode() != RsTableBackupMode.ON) {
            d = d + " backup(no)";
        }
        ModPositioningNamingFamily<? extends RsTableColumn> modPositioningNamingFamily = table.getColumns();
        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"table.columns");
        Iterable $this$filter$iv = (Iterable)modPositioningNamingFamily;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (RsTableColumn)element$iv$iv;
            boolean bl2 = false;
            RsTableColumn rsTableColumn = it;
            Intrinsics.checkNotNullExpressionValue((Object)rsTableColumn, (String)"it");
            if (!(rsTableColumn.getSortKeyOrder() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean $this$filterTo$iv$iv2 = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                RsTableColumn it = (RsTableColumn)a;
                boolean bl2 = false;
                RsTableColumn rsTableColumn = it;
                Intrinsics.checkNotNullExpressionValue((Object)rsTableColumn, (String)"it");
                int n = rsTableColumn.getSortKeyOrder();
                boolean bl3 = false;
                it = (RsTableColumn)b;
                Comparable comparable = Integer.valueOf(Math.abs(n));
                bl2 = false;
                RsTableColumn rsTableColumn2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)rsTableColumn2, (String)"it");
                n = rsTableColumn2.getSortKeyOrder();
                bl3 = false;
                Integer n2 = Math.abs(n);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
            }
        });
        if (sorted.isEmpty()) {
            return d;
        }
        if (RsModelFunKt.hasInterleavedSortKey(table)) {
            d = d + " interleaved";
        }
        d = d + " sortkey(";
        Iterable $this$forEachIndexed$iv = sorted;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void col;
            int n = index$iv++;
            boolean bl3 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (RsTableColumn)item$iv;
            int idx = n;
            boolean bl4 = false;
            if (idx != 0) {
                d = d + ", ";
            }
            StringBuilder stringBuilder = new StringBuilder().append(d);
            void v3 = col;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"col");
            d = stringBuilder.append(v3.getName()).toString();
        }
        d = d + ")";
        return d;
    }

    private final String describeRedshiftUser(RsUser user, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId basicMetaPropertyId = RsUser.SUPER_ROLE;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = RsUser.CREATE_DB;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = RsUser.CONNECTION_LIMIT;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = RsUser.VALID_UNTIL;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = RsUser.CONFIG;
        bl = false;
        collection.add(basicMetaPropertyId);
        ArrayList<String> props = new ArrayList<String>();
        if (user.isSuperRole()) {
            props.add("superuser");
        }
        if (user.isCreateDb()) {
            props.add("create db");
        }
        if (user.getConnectionLimit() != -1L) {
            props.add("connection limit: " + user.getConnectionLimit());
        }
        if (user.getValidUntil() != null) {
            props.add("valid until: " + user.getValidUntil());
        }
        props.addAll((Collection)user.getConfig());
        return CollectionsKt.joinToString$default((Iterable)props, null, null, null, (int)0, null, null, (int)63, null);
    }
}

