/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgresbase.PgBaseObjectBuilder;
import com.intellij.database.dialects.redshift.RsObjectBuilder;
import com.intellij.database.dialects.redshift.model.RsExternalSchema;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.RsExternalTableColumn;
import com.intellij.database.dialects.redshift.model.properties.RsExternalTableStorageType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.redshift.RsElementTypes;
import com.intellij.sql.dialects.redshift.RsTypes;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateSchemaStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.stubs.SqlColumnDefinitionElementType;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0017H\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/redshift/RsObjectBuilder;", "Lcom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder;", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildExternalSchema", "Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;", "buildExternalTable", "Lcom/intellij/database/dialects/redshift/model/RsExternalTable;", "findOptions", "", "", "element", "Lcom/intellij/psi/PsiElement;", "findTerminator", "setColumnsOrder", "table", "by", "intellij.database.dialects.redshift"})
public final class RsObjectBuilder
extends PgBaseObjectBuilder {
    @Nullable
    private final IElementType lazyCodeBlock = RsElementTypes.Misc.RS_LAZY_CODE_BLOCK;

    @Override
    @Nullable
    protected IElementType getLazyCodeBlock() {
        return this.lazyCodeBlock;
    }

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof RsExternalSchema) {
            this.buildExternalSchema((RsExternalSchema)obj2, source);
        } else if (basicModElement instanceof RsExternalTable) {
            this.buildExternalTable((RsExternalTable)obj2, source);
        } else {
            super.build(obj2, source, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildExternalTable(RsExternalTable obj2, DasObject source) {
        BasicElement basicElement;
        void $this$stubbed$iv$iv;
        void $this$stubbedOrBuild$iv;
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbedOrBuild = false;
        void var7_6 = $this$stubbedOrBuild$iv;
        SqlObjectBuilderImpl this_$iv$iv = this_$iv;
        boolean $i$f$stubbed = false;
        void var10_10 = $this$stubbed$iv$iv;
        if (var10_10 instanceof RsExternalTable) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var10_10 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof RsExternalTable)) {
                object = null;
            }
            basicElement = (BasicElement)((RsExternalTable)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement2 = basicElement;
        if (basicElement == null) {
            void this_$iv2;
            BasicElement basicElement3 = ((BasicElement)obj2).getMetaObject().newDataObject();
            if (basicElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.redshift.model.RsExternalTable");
            }
            BasicElement basicElement4 = (BasicElement)((RsExternalTable)basicElement3);
            boolean bl = false;
            boolean bl2 = false;
            RsExternalTable $this$stubbedOrBuild = (RsExternalTable)basicElement4;
            boolean bl3 = false;
            ArrayList<String> serdeProperties = new ArrayList<String>();
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var17_17 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                String terminator;
                ArrayList<String> $this$apply;
                boolean bl4;
                boolean bl5;
                ArrayList<String> arrayList;
                PsiElement it = tmp$iv$iv;
                boolean bl6 = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SERDE)) {
                    $this$stubbedOrBuild.setSerializationLib(this.findString(it));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_FIELDS)) {
                    arrayList = serdeProperties;
                    bl5 = false;
                    bl4 = false;
                    $this$apply = arrayList;
                    boolean bl7 = false;
                    terminator = this.findTerminator(it);
                    if (terminator != null) {
                        $this$apply.add("'field.delim'='" + terminator + '\'');
                        $this$apply.add("'serialization.format'='" + terminator + '\'');
                    }
                    $this$stubbedOrBuild.setSerializationLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_LINES)) {
                    arrayList = serdeProperties;
                    bl5 = false;
                    bl4 = false;
                    $this$apply = arrayList;
                    boolean bl8 = false;
                    terminator = this.findTerminator(it);
                    if (terminator == null) continue;
                    $this$apply.add("'line.delim'='" + terminator + '\'');
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_LOCATION)) {
                    $this$stubbedOrBuild.setLocation(this.findString(it));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_INPUTFORMAT)) {
                    $this$stubbedOrBuild.setInputFormat(this.findString(it));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_OUTPUTFORMAT)) {
                    $this$stubbedOrBuild.setOutputFormat(this.findString(it));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PARQUET)) {
                    $this$stubbedOrBuild.setStorageType(RsExternalTableStorageType.PARQUET);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_RCFILE)) {
                    $this$stubbedOrBuild.setStorageType(RsExternalTableStorageType.RCFILE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SEQUENCEFILE)) {
                    $this$stubbedOrBuild.setStorageType(RsExternalTableStorageType.SEQUENCEFILE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_TEXTFILE)) {
                    $this$stubbedOrBuild.setStorageType(RsExternalTableStorageType.TEXTFILE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_ORC)) {
                    $this$stubbedOrBuild.setStorageType(RsExternalTableStorageType.ORC);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_AVRO)) {
                    $this$stubbedOrBuild.setStorageType(RsExternalTableStorageType.AVRO);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SERDEPROPERTIES)) {
                    serdeProperties.addAll((Collection)this.findOptions(it));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_TABLE)) {
                    IElementType iElementType2 = RsTypes.RS_PROPERTIES;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"RsTypes.RS_PROPERTIES");
                    PsiElement p = this.findSibling(it, iElementType2);
                    if (p == null) continue;
                    $this$stubbedOrBuild.setProps(this.findOptions(p));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PARTITIONED)) continue;
                IElementType iElementType3 = RsTypes.RS_BY;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"RsTypes.RS_BY");
                PsiElement by = this.findSibling(it, iElementType3);
                if (by == null) continue;
                this.setColumnsOrder(obj2, by);
            }
            $this$stubbedOrBuild.setSerdeProperties((List<String>)serdeProperties);
            basicElement2 = basicElement4;
        }
        RsExternalTable stubbed = (RsExternalTable)basicElement2;
        obj2.setSerializationLib(stubbed.getSerializationLib());
        obj2.setInputFormat(stubbed.getInputFormat());
        obj2.setOutputFormat(stubbed.getOutputFormat());
        obj2.setLocation(stubbed.getLocation());
        obj2.setStorageType(stubbed.getStorageType());
        obj2.setSerdeProperties(stubbed.getSerdeProperties());
        obj2.setProps(stubbed.getProps());
    }

    /*
     * WARNING - void declaration
     */
    private final void buildExternalSchema(RsExternalSchema obj2, DasObject source) {
        BasicElement basicElement;
        void $this$stubbed$iv$iv;
        void $this$stubbedOrBuild$iv;
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbedOrBuild = false;
        void var7_6 = $this$stubbedOrBuild$iv;
        SqlObjectBuilderImpl this_$iv$iv = this_$iv;
        boolean $i$f$stubbed = false;
        void var10_10 = $this$stubbed$iv$iv;
        if (var10_10 instanceof RsExternalSchema) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var10_10 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof RsExternalSchema)) {
                object = null;
            }
            basicElement = (BasicElement)((RsExternalSchema)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement2 = basicElement;
        if (basicElement == null) {
            void this_$iv2;
            BasicElement basicElement3 = ((BasicElement)obj2).getMetaObject().newDataObject();
            if (basicElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.redshift.model.RsExternalSchema");
            }
            BasicElement basicElement4 = (BasicElement)((RsExternalSchema)basicElement3);
            boolean bl = false;
            boolean bl2 = false;
            RsExternalSchema $this$stubbedOrBuild = (RsExternalSchema)basicElement4;
            boolean bl3 = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateSchemaStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateSchemaStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var16_16 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl4 = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_DATABASE)) {
                    $this$stubbedOrBuild.setDatabaseName(this.findString(it));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_IAM_ROLE)) {
                    $this$stubbedOrBuild.setIamRole(this.findString(it));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_URI)) {
                    $this$stubbedOrBuild.setUri(this.findString(it));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PORT)) {
                    Float f = this.findNumberInSiblings(it);
                    $this$stubbedOrBuild.setPort(f != null ? String.valueOf((int)f.floatValue()) : null);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_REGION)) {
                    $this$stubbedOrBuild.setRegion(this.findString(it));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_HIVE)) continue;
                IElementType iElementType2 = RsTypes.RS_METASTORE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"RsTypes.RS_METASTORE");
                if (this.findSibling(it, iElementType2) == null) continue;
                $this$stubbedOrBuild.setSchemaKind(2);
            }
            basicElement2 = basicElement4;
        }
        RsExternalSchema stubbed = (RsExternalSchema)basicElement2;
        obj2.setDatabaseName(stubbed.getDatabaseName());
        obj2.setIamRole(stubbed.getIamRole());
        obj2.setUri(stubbed.getUri());
        obj2.setPort(stubbed.getPort());
        obj2.setRegion(stubbed.getRegion());
        obj2.setSchemaKind(stubbed.getSchemaKind());
    }

    private final String findTerminator(PsiElement element) {
        IElementType iElementType = RsTypes.RS_TERMINATED;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"RsTypes.RS_TERMINATED");
        PsiElement psiElement = this.findSibling(element, iElementType);
        if (psiElement == null) {
            return null;
        }
        PsiElement terminated = psiElement;
        IElementType iElementType2 = RsTypes.RS_BY;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"RsTypes.RS_BY");
        PsiElement psiElement2 = this.findSibling(terminated, iElementType2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement by = psiElement2;
        return this.findString(by);
    }

    private final void setColumnsOrder(RsExternalTable table, PsiElement by) {
        SqlColumnDefinitionElementType sqlColumnDefinitionElementType = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
        Intrinsics.checkNotNullExpressionValue((Object)sqlColumnDefinitionElementType, (String)"SqlCompositeElementTypes.SQL_COLUMN_DEFINITION");
        PsiElement psiElement = this.findSibling(by, (IElementType)sqlColumnDefinitionElementType);
        if (!(psiElement instanceof SqlColumnDefinition)) {
            psiElement = null;
        }
        SqlColumnDefinition def = (SqlColumnDefinition)psiElement;
        int order = 1;
        while (def != null) {
            RsExternalTableColumn column2;
            String name2;
            SqlNameElement sqlNameElement = def.getNameElement();
            String string = name2 = sqlNameElement != null ? sqlNameElement.getName() : null;
            if (name2 != null && (column2 = (RsExternalTableColumn)table.getColumns().find(new Predicate(name2){
                final /* synthetic */ String $name;

                public final boolean test(RsExternalTableColumn it) {
                    RsExternalTableColumn rsExternalTableColumn = it;
                    Intrinsics.checkNotNullExpressionValue((Object)rsExternalTableColumn, (String)"it");
                    return Intrinsics.areEqual((Object)rsExternalTableColumn.getName(), (Object)this.$name);
                }
                {
                    this.$name = string;
                }
            })) != null) {
                column2.setPartitionKeyOrder(order++);
            }
            PsiElement psiElement2 = def.getNextSibling();
            SqlColumnDefinitionElementType sqlColumnDefinitionElementType2 = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
            Intrinsics.checkNotNullExpressionValue((Object)sqlColumnDefinitionElementType2, (String)"SqlCompositeElementTypes.SQL_COLUMN_DEFINITION");
            PsiElement psiElement3 = this.findSibling(psiElement2, (IElementType)sqlColumnDefinitionElementType2);
            if (!(psiElement3 instanceof SqlColumnDefinition)) {
                psiElement3 = null;
            }
            def = (SqlColumnDefinition)psiElement3;
        }
    }

    private final List<String> findOptions(PsiElement element) {
        return this.findOptions(element, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>(this){
            final /* synthetic */ RsObjectBuilder this$0;

            @Nullable
            public final PsiElement invoke(@NotNull PsiElement current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_STRING_LITERAL");
                return RsObjectBuilder.access$findSibling(this.this$0, current, (IElementType)sqlCompositeElementType);
            }
            {
                this.this$0 = rsObjectBuilder;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)findOptions.2.INSTANCE));
    }

    public static final /* synthetic */ PsiElement access$findSibling(RsObjectBuilder $this, PsiElement element, IElementType type) {
        return $this.findSibling(element, type);
    }
}

