/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Operation;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeTable;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseDmlHelperKt;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBasePredicatesHelper;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBasePredicatesHelperKt;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTableColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J>\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0014J.\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J$\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J&\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002JP\u0010%\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010'\u001a\u00020\nH\u0014J\"\u0010(\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010)\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBasePredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "cannotCastToTextTypes", "", "", "needsCastWhenValueIsPassedAsParameter", "canCastToText", "", "typeName", "version", "Lcom/intellij/database/util/Version;", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "alias", "ftsPredicate", "columnRef", "getDomain", "Lcom/intellij/database/data/types/domain/Domain;", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "domain", "getInnerDomain", "defType", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDefType;", "registry", "Lcom/intellij/database/data/types/DomainRegistry;", "Lcom/intellij/database/model/DasColumn;", "likePredicate", "Lcom/intellij/database/data/types/LikePredicateOperation;", "inUpdate", "parameterNeedsCast", "supportsFts", "intellij.database.dialects.postgresgreenplumbase"})
public class PgGPlumBasePredicatesHelper
extends BasePredicatesHelper {
    private final Set<String> cannotCastToTextTypes;
    private final Set<String> needsCastWhenValueIsPassedAsParameter;

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        ComparePredicateOperation operator2;
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Domain domain = this.getDomain(column2, value, version);
        ComparePredicateOperation comparePredicateOperation = operator2 = op instanceof EqualsPredicateOperation && domain != null && PgBaseJdbcHelper.isCustomOperatorType((String)domain.simpleName()) ? (ComparePredicateOperation)new EqualsPredicateOperation("~=") : op;
        if (value instanceof Placeholder && this.parameterNeedsCast(column2, value, version)) {
            return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column2), value, (Function1)new Function1<DdlBuilder, Unit>(this, column2, value, quote, alias, operator2){
                final /* synthetic */ PgGPlumBasePredicatesHelper this$0;
                final /* synthetic */ ColumnRef $column;
                final /* synthetic */ PredicateValue $value;
                final /* synthetic */ boolean $quote;
                final /* synthetic */ String $alias;
                final /* synthetic */ ComparePredicateOperation $operator;

                public final void invoke(@NotNull DdlBuilder builder) {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    PredicatesUtilKt.defaultEqualsPredicate((ColumnRef)this.$column, (PredicateValue)this.$value, (boolean)this.$quote, (Dbms)this.this$0.getDbms(), (String)this.$alias, (ComparePredicateOperation)this.$operator).getProduce().invoke((Object)builder);
                    DasColumn dasColumn = PredicatesUtilKt.toDasColumn((ColumnRef)this.$column);
                    if (dasColumn != null) {
                        builder.symbol("::").type(dasColumn.getDataType());
                    }
                }
                {
                    this.this$0 = pgGPlumBasePredicatesHelper;
                    this.$column = columnRef;
                    this.$value = predicateValue;
                    this.$quote = bl;
                    this.$alias = string;
                    this.$operator = comparePredicateOperation;
                    super(1);
                }
            });
        }
        return PredicatesUtilKt.defaultEqualsPredicate((ColumnRef)column2, (PredicateValue)value, (boolean)quote, (Dbms)this.getDbms(), (String)alias, (ComparePredicateOperation)operator2);
    }

    private final boolean parameterNeedsCast(ColumnRef column2, PredicateValue value, Version version) {
        BasicTableOrViewColumn dasColumn = PredicatesUtilKt.toBasicColumn((ColumnRef)column2);
        if (dasColumn instanceof PgGPlumBaseTableColumn && PgGPlumBaseDmlHelperKt.isNonBasicType((PgGPlumBaseTableColumn)dasColumn)) {
            return true;
        }
        Domain domain = this.getDomain(column2, value, version);
        Domain domain2 = domain;
        return CollectionsKt.contains((Iterable)this.needsCastWhenValueIsPassedAsParameter, (Object)(domain2 != null ? domain2.simpleName() : null));
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable String alias, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        if (!this.supportsFts(columnRef, value, version)) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (Function1)new Function1<DdlBuilder, Unit>(this, alias, columnRef, value){
            final /* synthetic */ PgGPlumBasePredicatesHelper this$0;
            final /* synthetic */ String $alias;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ PredicateValue $value;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                DdlBuilder ddlBuilder = PredicatesUtilKt.identifier((DdlBuilder)builder, (String)this.$alias, (ColumnRef)this.$columnRef).space().symbol("@@").space().plain("plainto_tsquery(");
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.identifier(alias\u2026plain(\"plainto_tsquery(\")");
                PredicatesUtilKt.value((DdlBuilder)ddlBuilder, (PredicateValue)this.$value, (ColumnRef)this.$columnRef, (Dbms)this.this$0.getDbms(), (DbImplUtilCore.StringLiteralDecorator)DbImplUtilCore.StringLiteralDecorator.PLAIN).plain(")");
            }
            {
                this.this$0 = pgGPlumBasePredicatesHelper;
                this.$alias = string;
                this.$columnRef = columnRef;
                this.$value = predicateValue;
                super(1);
            }
        });
    }

    private final boolean supportsFts(ColumnRef columnRef, PredicateValue value, Version version) {
        boolean bl;
        block11: {
            Domain domain;
            Domain domain2 = domain = this.getDomain(columnRef, value, version);
            if (domain2 == null || !domain2.supports(OperationKt.FULL_TEXT_SEARCH_OPERATION)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)domain.name(), (Object)"tsvector")) {
                return true;
            }
            BasicTableOrViewColumn basicTableOrViewColumn = PredicatesUtilKt.toBasicColumn((ColumnRef)columnRef);
            if (!(basicTableOrViewColumn instanceof PgBaseLikeColumn)) {
                basicTableOrViewColumn = null;
            }
            PgBaseLikeColumn pgBaseLikeColumn = (PgBaseLikeColumn)basicTableOrViewColumn;
            if (pgBaseLikeColumn == null) {
                return false;
            }
            PgBaseLikeColumn column2 = pgBaseLikeColumn;
            BasicLikeTable basicLikeTable = column2.getLikeTable();
            if (!(basicLikeTable instanceof PgBaseLikeTable)) {
                basicLikeTable = null;
            }
            PgBaseLikeTable pgBaseLikeTable = (PgBaseLikeTable)basicLikeTable;
            if (pgBaseLikeTable == null) {
                return false;
            }
            PgBaseLikeTable table = pgBaseLikeTable;
            ModFamily modFamily = table.getIndices();
            Intrinsics.checkNotNullExpressionValue((Object)modFamily, (String)"table.indices");
            Iterable $this$any$iv = (Iterable)modFamily;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    BasicModIndex i2 = (BasicModIndex)element$iv;
                    boolean bl3 = false;
                    BasicModIndex basicModIndex = i2;
                    Intrinsics.checkNotNullExpressionValue((Object)basicModIndex, (String)"i");
                    if (basicModIndex.getColNames().size() != 1) {
                        bl2 = false;
                    } else {
                        String expression;
                        String string = expression = StringUtil.trim((String)((String)i2.getColNames().get(0)));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression");
                        bl2 = StringsKt.startsWith$default((String)string, (String)"to_tsvector(", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)expression, (String)(column2.getName() + "::text)"), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)expression, (String)("\"" + column2.getName() + "\"::text)"), (boolean)false, (int)2, null));
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        boolean canCast;
        Domain domain2;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        Domain domain3 = domain2 = this.getDomain(columnRef, value, version);
        boolean typeSupportsOperation = domain3 != null && domain3.supports(OperationKt.LIKE_OPERATION);
        boolean bl = canCast = canCastToText && domain2 != null && this.canCastToText(StringUtil.toLowerCase((String)domain2.simpleName()), version) && !domain2.supports((Operation)OperationKt.EQUALS_TO_NUMBER_OPERATION);
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        String string = PredicatesUtilKt.getLikeKeyword((boolean)op.getMatchCase(), (boolean)op.isNotLike(), (Dbms)this.getDbms(), (Version)version, (boolean)inUpdate);
        if (string == null) {
            return null;
        }
        String likeWord = string;
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (Function1)new Function1<DdlBuilder, Unit>(this, alias, columnRef, typeSupportsOperation, likeWord, value, op){
            final /* synthetic */ PgGPlumBasePredicatesHelper this$0;
            final /* synthetic */ String $alias;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ boolean $typeSupportsOperation;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ LikePredicateOperation $op;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.identifier((DdlBuilder)builder, (String)this.$alias, (ColumnRef)this.$columnRef);
                if (!this.$typeSupportsOperation) {
                    builder.symbol("::").type("text");
                }
                DdlBuilder ddlBuilder = builder.space().keyword(this.$likeWord).space();
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.space().keyword(likeWord).space()");
                PredicatesUtilKt.value((DdlBuilder)ddlBuilder, (PredicateValue)this.$value, (ColumnRef)this.$columnRef, (Dbms)this.this$0.getDbms(), (DbImplUtilCore.StringLiteralDecorator)this.$op.getLikeType().getDecorator());
            }
            {
                this.this$0 = pgGPlumBasePredicatesHelper;
                this.$alias = string;
                this.$columnRef = columnRef;
                this.$typeSupportsOperation = bl;
                this.$likeWord = string2;
                this.$value = predicateValue;
                this.$op = likePredicateOperation;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    protected Domain getDomain(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Version version) {
        BasicTableOrViewColumn basicTableOrViewColumn;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                basicTableOrViewColumn = PredicatesUtilKt.toBasicColumn((ColumnRef)columnRef);
                if (basicTableOrViewColumn == null) break block2;
                BasicTableOrViewColumn basicTableOrViewColumn2 = basicTableOrViewColumn;
                boolean bl = false;
                boolean bl2 = false;
                BasicTableOrViewColumn col = basicTableOrViewColumn2;
                boolean bl3 = false;
                basicTableOrViewColumn = this.getInnerDomain((DasColumn)col, this.getDbms(), version);
                if (basicTableOrViewColumn != null) break block3;
            }
            basicTableOrViewColumn = super.getDomain(columnRef, value, version);
        }
        return basicTableOrViewColumn;
    }

    protected boolean canCastToText(@Nullable String typeName, @Nullable Version version) {
        return typeName != null && !this.cannotCastToTextTypes.contains(typeName);
    }

    private final Domain getInnerDomain(DasColumn column2, Dbms dbms, Version version) {
        DomainRegistry domainRegistry = BaseDomainRegistry.get((Dbms)dbms, (Version)version);
        if (domainRegistry == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"BaseDomainRegistry.get(d\u2026, version) ?: return null");
        DomainRegistry registry = domainRegistry;
        if (!(column2 instanceof PgGPlumBaseTableColumn)) {
            return null;
        }
        PgGPlumBaseDefType defType = ((PgGPlumBaseTableColumn)column2).getType();
        if (defType != null) {
            return this.getInnerDomain(defType, registry);
        }
        String string = ((PgGPlumBaseTableColumn)column2).getDataType().typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"column.dataType.typeName");
        String typeName = string;
        return registry.getDomain((ColumnDescriptor)new TypeNameColumnDescriptor(typeName));
    }

    private final Domain getInnerDomain(PgGPlumBaseDefType defType, DomainRegistry registry) {
        Domain domain = registry.getDomain((ColumnDescriptor)new TypeNameColumnDescriptor(defType.getName()));
        if (domain != null) {
            return domain;
        }
        PgGPlumBaseDefType innerDefType = defType.getBaseType();
        if (innerDefType != null) {
            return this.getInnerDomain(innerDefType, registry);
        }
        String definition2 = defType.getDefinition();
        return definition2 == null || Intrinsics.areEqual((Object)definition2, (Object)"-") ? null : registry.getDomain((ColumnDescriptor)new TypeNameColumnDescriptor(definition2));
    }

    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        if (domain == null) {
            BasicTableOrViewColumn basicTableOrViewColumn = PredicatesUtilKt.toBasicColumn((ColumnRef)columnRef);
            if (!(basicTableOrViewColumn instanceof PgGPlumBaseTableColumn)) {
                basicTableOrViewColumn = null;
            }
            PgGPlumBaseTableColumn pgGPlumBaseTableColumn = (PgGPlumBaseTableColumn)basicTableOrViewColumn;
            PgGPlumBaseDefType defType = pgGPlumBaseTableColumn != null ? pgGPlumBaseTableColumn.getType() : null;
            PgGPlumBaseDefType pgGPlumBaseDefType = PgGPlumBasePredicatesHelperKt.findType(defType, PgDataTypeSubKind.ENUM);
            object = pgGPlumBaseDefType == null ? null : PredicatesUtilKt.simpleFormat((Function1)((Function1)new Function1<String, Boolean>(pgGPlumBaseDefType){
                final /* synthetic */ PgGPlumBaseDefType $enum;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$enum.getLabels().contains(it);
                }
                {
                    this.$enum = pgGPlumBaseDefType;
                    super(1);
                }
            }));
        } else if (Intrinsics.areEqual((Object)domain.simpleName(), (Object)"bytea")) {
            object = new FormatTester(true, false, (Function1)getFormatTester.2.INSTANCE, 2, null);
        } else if (Intrinsics.areEqual((Object)domain.simpleName(), (Object)"oid")) {
            object = PredicatesUtilKt.simpleFormat((Function1)getFormatTester.3.INSTANCE);
        } else {
            Dbms dbms = this.getDbms();
            LogicalType logicalType = domain.getLogicType();
            Intrinsics.checkNotNullExpressionValue((Object)logicalType, (String)"domain.logicType");
            object = PredicatesUtilKt.getFormatTester((ColumnRef)columnRef, (Dbms)dbms, (LogicalType)logicalType);
        }
        return object;
    }

    public PgGPlumBasePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        this.cannotCastToTextTypes = SetsKt.setOf((Object[])new String[]{"abstime", "aclitem", "bit", "bool", "boolean", "box", "bytea", "cid", "circle", "line", "lseg", "money", "path", "point", "polygon", "refcursor", "regclass", "regoper", "regoperator", "regproc", "regprocedure", "regtype", "reltime", "smgr", "tid", "tinterval", "varbit", "bit varying", "xid", "xml"});
        this.needsCastWhenValueIsPassedAsParameter = SetsKt.setOf((Object[])new String[]{"box", "cidr", "circle", "inet", "line", "lseg", "macaddr", "path", "pg_lsn", "point", "polygon", "tsquery", "tsvector"});
    }
}

