/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql;

import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.DbmsOutputHelper;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHandler;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessagesParser;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001>B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001dH\u0002J\u001e\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!H\u0002J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020$H\u0014J4\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020$0/H\u0002J\b\u00101\u001a\u00020\bH\u0002J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\"\u00104\u001a\u00020$2\f\u00105\u001a\b\u0012\u0004\u0012\u00020$0\u001f2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u00020\bH\u0002J\u0010\u00108\u001a\u00020$2\u0006\u00107\u001a\u00020\bH\u0002J\u0016\u00109\u001a\u00020\b2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020!0\u001dH\u0002J\u0006\u0010;\u001a\u00020$J \u0010<\u001a\b\u0012\u0004\u0012\u00020$0\u001f2\u0006\u0010=\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010!H\u0002R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006?"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "paths", "", "", "tags", "coveragePath", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "expected", "Lkotlin/text/Regex;", "p", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "getP", "()Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "getPaths", "()Ljava/util/List;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTags", "allSchemas", "", "attachReporter", "Ljava/util/concurrent/CompletionStage;", "testsReporter", "Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;", "coverageReporter", "destroyProcessImpl", "", "detachIsDefault", "", "detachProcessImpl", "fetchReporter", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "reporter", "fetchSize", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "genUuid", "getProcessInput", "Ljava/io/OutputStream;", "hookReporterTermination", "tests", "preprocessOutput", "input", "reportOutput", "runScript", "reporters", "start", "startTests", "testReporter", "Reporter", "intellij.database.dialects.oracle.ex"})
public final class UtPlSqlHandler
extends ProcessHandler {
    private final Logger LOG;
    @NotNull
    private final EmptyProgressIndicator p;
    private final Regex expected;
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;
    @NotNull
    private final List<String> paths;
    @NotNull
    private final List<String> tags;
    private final String coveragePath;

    @NotNull
    public final EmptyProgressIndicator getP() {
        return this.p;
    }

    public final void start() {
        Reporter reporter;
        Reporter testReporter = new Reporter("tests_reporter", "ut_teamcity_reporter", this.genUuid());
        String string = this.coveragePath;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            reporter = new Reporter("coverage_reporter", "ut_coveralls_reporter", this.genUuid());
        } else {
            reporter = null;
        }
        Reporter coverageReporter = reporter;
        CompletionStage<Unit> tests = this.startTests(testReporter, coverageReporter);
        CompletionStage<?> reporter2 = this.attachReporter(testReporter, coverageReporter);
        this.startNotify();
        this.notifyTextAvailable(ServiceMessageBuilder.testsStarted().toString(), ProcessOutputTypes.STDOUT);
        this.hookReporterTermination(tests, reporter2);
    }

    private final String genUuid() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    private final void hookReporterTermination(CompletionStage<Unit> tests, CompletionStage<?> reporter) {
        tests.exceptionally(new Function(reporter){
            final /* synthetic */ CompletionStage $reporter;

            public final void apply(Throwable it) {
                this.$reporter.toCompletableFuture().cancel(true);
            }
            {
                this.$reporter = completionStage;
            }
        });
        reporter.handle(new BiFunction(this){
            final /* synthetic */ UtPlSqlHandler this$0;

            public final void apply(Object $noName_0, Throwable e2) {
                if (!this.this$0.isProcessTerminated()) {
                    if (e2 != null) {
                        if (!AsyncUtil.isCancellation((Throwable)e2)) {
                            String string = e2.getMessage();
                            if (string == null) {
                                string = "";
                            }
                            this.this$0.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
                        }
                        UtPlSqlHandler.access$notifyProcessTerminated(this.this$0, 1);
                    } else {
                        UtPlSqlHandler.access$notifyProcessTerminated(this.this$0, 0);
                    }
                }
            }
            {
                this.this$0 = utPlSqlHandler;
            }
        });
    }

    private final CompletionStage<?> attachReporter(Reporter testsReporter, Reporter coverageReporter) {
        CompletionStage completionStage = AsyncUtil.supplyAsync((Supplier)new Supplier(this, testsReporter, coverageReporter){
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Reporter $testsReporter;
            final /* synthetic */ Reporter $coverageReporter;

            public final CompletionStage<Unit> get() {
                return DatabaseSessionManager.facade((Project)this.this$0.getProject(), (LocalDataSource)this.this$0.getDs(), null, null, (boolean)false, null, (DatabaseDepartment)((DatabaseDepartment)DGDepartment.TEST_RUNNER)).runAsync((Function1)new Function1<DatabaseConnection, Unit>(this){
                    final /* synthetic */ attachReporter.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull DatabaseConnection connection) {
                        block8: {
                            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                            try {
                                UtPlSqlHandler.access$fetchReporter(this.this$0.this$0, connection, this.this$0.$testsReporter, 1, (Function1)new Function1<RemoteResultSet, Unit>(this){
                                    final /* synthetic */ attachReporter.1 this$0;

                                    public final void invoke(@NotNull RemoteResultSet rs) {
                                        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                                        UtPlSqlHandler utPlSqlHandler = this.this$0.this$0.this$0;
                                        String string = rs.getString(1);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rs.getString(1)");
                                        UtPlSqlHandler.access$reportOutput(utPlSqlHandler, string);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                                if (this.this$0.$coverageReporter == null) break block8;
                                String string = UtPlSqlHandler.access$getCoveragePath$p(this.this$0.this$0);
                                Intrinsics.checkNotNull((Object)string);
                                Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(string), StandardCharsets.UTF_8);
                                boolean bl = false;
                                boolean bl2 = false;
                                Throwable throwable = null;
                                try {
                                    OutputStreamWriter writer = (OutputStreamWriter)closeable;
                                    boolean bl3 = false;
                                    UtPlSqlHandler.access$fetchReporter(this.this$0.this$0, connection, this.this$0.$coverageReporter, 10000, (Function1)new Function1<RemoteResultSet, Unit>(writer){
                                        final /* synthetic */ OutputStreamWriter $writer;

                                        public final void invoke(@NotNull RemoteResultSet rs) {
                                            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                                            this.$writer.write(rs.getString(1));
                                        }
                                        {
                                            this.$writer = outputStreamWriter;
                                            super(1);
                                        }
                                    });
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                            }
                            catch (Throwable th) {
                                UtPlSqlHandler.access$getLOG$p(this.this$0.this$0).warn(th);
                                UtPlSqlHandler utPlSqlHandler = this.this$0.this$0;
                                String string = th.getMessage();
                                if (string == null) {
                                    string = th.toString();
                                }
                                utPlSqlHandler.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = utPlSqlHandler;
                this.$testsReporter = reporter;
                this.$coverageReporter = reporter2;
            }
        }, (Executor)attachReporter.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"AsyncUtil.supplyAsync({ \u2026 TimeUnit.MILLISECONDS)})");
        return completionStage;
    }

    private final void fetchReporter(DatabaseConnection connection, Reporter reporter, int fetchSize, Function1<? super RemoteResultSet, Unit> consumer) {
        SmartStatements.Companion.poweredBy(connection).call(new Configuration(false, null, null, Integer.valueOf(fetchSize), null, null, 55, null)).noisy().execute((Object)new StatementParameters().parameter((OutParameter)new CallableStatementData.SimpleOutParameter(1, -10, 0, null, null, 28, null)).asCallData(StringsKt.trimIndent((String)("\n        declare\n          l_reporter " + reporter.getType() + " := " + reporter.getType() + "();\n        begin\n          l_reporter.set_reporter_id('" + reporter.getUuid() + "');\n          ? := l_reporter.get_lines_cursor();\n        end;"))), (ExecutionMode)StandardExecutionMode.GENERIC, StandardResultsProcessors.process$default((ThrowableConsumer)new ThrowableConsumer(this, consumer){
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Function1 $consumer;

            public final void consume(RemoteResultSet it) {
                this.this$0.getP().checkCanceled();
                RemoteResultSet remoteResultSet = it;
                Intrinsics.checkNotNullExpressionValue((Object)remoteResultSet, (String)"it");
                this.$consumer.invoke((Object)remoteResultSet);
            }
            {
                this.this$0 = utPlSqlHandler;
                this.$consumer = function1;
            }
        }, (int)0, (int)2, null));
    }

    private final void reportOutput(String input) {
        block0: {
            String string = this.preprocessOutput(input);
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.notifyTextAvailable(it + "\n", ProcessOutputTypes.STDOUT);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String preprocessOutput(String input) {
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        new ServiceMessagesParser().parse(input, new ServiceMessageParserCallback(this, (Ref.ObjectRef)result2){
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Ref.ObjectRef $result;

            public void parseException(@NotNull ParseException parseException, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)parseException, (String)"parseException");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                UtPlSqlHandler.access$getLOG$p(this.this$0).warn((Throwable)parseException);
                this.$result.element = text;
            }

            /*
             * WARNING - void declaration
             */
            public void serviceMessage(@NotNull ServiceMessage message2) {
                String string;
                boolean bl7;
                boolean bl2;
                Object object;
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Map map2 = message2.getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"message.attributes");
                Map attrs = MapsKt.toMutableMap((Map)map2);
                String string2 = (String)attrs.get("name");
                if (string2 != null && (string2 = this.fixName(string2)) != null) {
                    object = string2;
                    boolean bl3 = false;
                    bl2 = false;
                    Object it = object;
                    bl7 = false;
                    attrs.put("name", it);
                }
                Ref.ObjectRef objectRef = this.$result;
                object = message2;
                if (object instanceof TestStarted) {
                    String testName = ((TestStarted)message2).getTestName();
                    if (((TestStarted)message2).getLocationHint() == null) {
                        String string3;
                        Map map3 = attrs;
                        String string4 = "locationHint";
                        String string5 = testName;
                        if (string5 != null) {
                            void it;
                            String string6 = string5;
                            boolean bl4 = false;
                            bl7 = false;
                            String string7 = string6;
                            String string8 = string4;
                            Map map4 = map3;
                            Ref.ObjectRef objectRef2 = objectRef;
                            boolean bl5 = false;
                            String string9 = "db://" + (String)it;
                            objectRef = objectRef2;
                            map3 = map4;
                            string4 = string8;
                            string3 = string9;
                        } else {
                            string3 = null;
                        }
                        map3.put(string4, string3);
                    }
                    string = ServiceMessage.asString((String)((TestStarted)message2).getMessageName(), (Map)attrs);
                } else if (object instanceof TestStdErr) {
                    void it;
                    String string10 = ((TestStdErr)message2).getStdErr();
                    bl2 = false;
                    boolean bl6 = false;
                    String bl7 = string10;
                    Ref.ObjectRef objectRef3 = objectRef;
                    boolean bl8 = false;
                    boolean bl9 = it == null || StringsKt.startsWith$default((String)it, (String)"Test exception:", (boolean)false, (int)2, null);
                    objectRef = objectRef3;
                    string = bl9 ? null : ServiceMessage.asString((String)((TestStdErr)message2).getMessageName(), (Map)attrs);
                } else if (object instanceof TestFailed) {
                    if (((TestFailed)message2).getFailureMessage() == null) {
                        String string11 = (String)attrs.remove("details");
                        if (string11 != null) {
                            MatchResult matchResult;
                            void details;
                            String string12 = string11;
                            bl2 = false;
                            boolean bl10 = false;
                            String it = string12;
                            Ref.ObjectRef objectRef4 = objectRef;
                            boolean bl11 = false;
                            attrs.put("message", details);
                            MatchResult matchResult2 = UtPlSqlHandler.access$getExpected$p(this.this$0).matchEntire((CharSequence)details);
                            if (matchResult2 != null) {
                                MatchResult matchResult3 = matchResult2;
                                boolean bl12 = false;
                                boolean bl13 = false;
                                MatchResult $this$apply = matchResult3;
                                boolean bl14 = false;
                                MatchGroup matchGroup = $this$apply.getGroups().get(1);
                                attrs.put("actual", matchGroup != null ? matchGroup.getValue() : null);
                                MatchGroup matchGroup2 = $this$apply.getGroups().get(2);
                                attrs.put("expected", matchGroup2 != null ? matchGroup2.getValue() : null);
                                attrs.put("type", "comparisonFailure");
                                matchResult = matchResult3;
                            } else {
                                matchResult = null;
                            }
                            MatchResult matchResult4 = matchResult;
                            objectRef = objectRef4;
                        }
                    }
                    string = ServiceMessage.asString((String)((TestFailed)message2).getMessageName(), (Map)attrs);
                } else {
                    string = object instanceof TestIgnored ? ServiceMessage.asString((String)((TestIgnored)message2).getMessageName(), (Map)attrs) + "\n" + ServiceMessage.asString((String)"testFinished", (Map)attrs) : ServiceMessage.asString((String)message2.getMessageName(), (Map)attrs);
                }
                objectRef.element = string;
            }

            private final String fixName(String $this$fixName) {
                String string = $this$fixName;
                return string != null ? StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) : null;
            }

            public void regularText(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$result.element = text;
            }
            {
                this.this$0 = this$0;
                this.$result = $captured_local_variable$1;
            }
        });
        return (String)result2.element;
    }

    private final CompletionStage<Unit> startTests(Reporter testReporter, Reporter coverageReporter) {
        return DatabaseSessionManager.facade((Project)this.project, (LocalDataSource)this.ds, null, null, (boolean)false, null, (DatabaseDepartment)((DatabaseDepartment)DGDepartment.TEST_RUNNER)).runAsync((Function1)new Function1<DatabaseConnection, Unit>(this, testReporter, coverageReporter){
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Reporter $testReporter;
            final /* synthetic */ Reporter $coverageReporter;

            public final void invoke(@NotNull DatabaseConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Dbms dbms = Dbms.ORACLE;
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.ORACLE");
                new DbmsOutputHelper(dbms).enable(connection, 10000000);
                SmartStatements.Companion.poweredBy(connection).simple().noisy().execute((Object)UtPlSqlHandler.access$runScript(this.this$0, CollectionsKt.listOfNotNull((Object[])new Reporter[]{this.$testReporter, this.$coverageReporter})), (Function1)startTests.1.INSTANCE);
            }
            {
                this.this$0 = utPlSqlHandler;
                this.$testReporter = reporter;
                this.$coverageReporter = reporter2;
                super(1);
            }
        });
    }

    private final Iterable<String> allSchemas() {
        TreePattern treePattern = this.ds.getIntrospectionScope();
        boolean bl = false;
        boolean bl2 = false;
        TreePattern sc2 = treePattern;
        boolean bl3 = false;
        JBTreeTraverser jBTreeTraverser = ((JBTreeTraverser)((JBTreeTraverser)this.ds.getModel().traverser().expand((Condition)allSchemas.1.1.INSTANCE)).filter(new Condition(sc2){
            final /* synthetic */ TreePattern $sc;

            public final boolean value(DasObject it) {
                DasObject dasObject = it;
                Intrinsics.checkNotNullExpressionValue((Object)dasObject, (String)"it");
                return Intrinsics.areEqual((Object)dasObject.getKind(), (Object)ObjectKind.SCHEMA) && DataSourceSchemaMapping.isIntrospected((TreePattern)this.$sc, (DasObject)it);
            }
            {
                this.$sc = treePattern;
            }
        })).map((com.intellij.util.Function)allSchemas.1.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"ds.introspectionScope.le\u2026       .map { it.name } }");
        return (Iterable)jBTreeTraverser;
    }

    private final String runScript(Iterable<Reporter> reporters) {
        return "\n    declare" + CollectionsKt.joinToString$default(reporters, (CharSequence)"", null, null, (int)0, null, (Function1)runScript.1.INSTANCE, (int)30, null) + "\n    begin " + CollectionsKt.joinToString$default(reporters, (CharSequence)"", null, null, (int)0, null, (Function1)runScript.2.INSTANCE, (int)30, null) + "\n      ut_runner.run(\n        ut_varchar2_list (" + CollectionsKt.joinToString$default((Iterable)this.paths, null, null, null, (int)0, null, (Function1)runScript.3.INSTANCE, (int)31, null) + "),\n        ut_reporters(" + CollectionsKt.joinToString$default(reporters, null, null, null, (int)0, null, (Function1)runScript.4.INSTANCE, (int)31, null) + "),\n        false,\n        ut_varchar2_list(" + CollectionsKt.joinToString$default(this.allSchemas(), null, null, null, (int)0, null, (Function1)runScript.5.INSTANCE, (int)31, null) + "),\n        a_tags => " + (this.tags.isEmpty() ? "null" : ScriptGeneratorHelperKt.getSqlString(CollectionsKt.joinToString$default((Iterable)this.tags, (CharSequence)",", null, null, (int)0, null, (Function1)runScript.6.INSTANCE, (int)30, null))) + "\n      );\n    end;";
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public boolean detachIsDefault() {
        return false;
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
    }

    protected void destroyProcessImpl() {
        this.p.cancel();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LocalDataSource getDs() {
        return this.ds;
    }

    @NotNull
    public final List<String> getPaths() {
        return this.paths;
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    public UtPlSqlHandler(@NotNull Project project, @NotNull LocalDataSource ds, @NotNull List<String> paths2, @NotNull List<String> tags2, @Nullable String coveragePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        Intrinsics.checkNotNullParameter(tags2, (String)"tags");
        this.project = project;
        this.ds = ds;
        this.paths = paths2;
        this.tags = tags2;
        this.coveragePath = coveragePath;
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
        this.p = new EmptyProgressIndicator();
        this.expected = new Regex("Actual: (.*?)(?: \\(.*\\))? was expected to equal: (.*?)(?: \\(.*\\))?");
    }

    public static final /* synthetic */ void access$notifyProcessTerminated(UtPlSqlHandler $this, int p0) {
        $this.notifyProcessTerminated(p0);
    }

    public static final /* synthetic */ void access$fetchReporter(UtPlSqlHandler $this, DatabaseConnection connection, Reporter reporter, int fetchSize, Function1 consumer) {
        $this.fetchReporter(connection, reporter, fetchSize, (Function1<? super RemoteResultSet, Unit>)consumer);
    }

    public static final /* synthetic */ void access$reportOutput(UtPlSqlHandler $this, String input) {
        $this.reportOutput(input);
    }

    public static final /* synthetic */ String access$getCoveragePath$p(UtPlSqlHandler $this) {
        return $this.coveragePath;
    }

    public static final /* synthetic */ Logger access$getLOG$p(UtPlSqlHandler $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ Regex access$getExpected$p(UtPlSqlHandler $this) {
        return $this.expected;
    }

    public static final /* synthetic */ String access$runScript(UtPlSqlHandler $this, Iterable reporters) {
        return $this.runScript(reporters);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;", "", "name", "", "type", "uuid", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "getUuid", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.oracle.ex"})
    private static final class Reporter {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        @NotNull
        private final String uuid;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        public Reporter(@NotNull String name2, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.name = name2;
            this.type = type;
            this.uuid = uuid;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.uuid;
        }

        @NotNull
        public final Reporter copy(@NotNull String name2, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new Reporter(name2, type, uuid);
        }

        public static /* synthetic */ Reporter copy$default(Reporter reporter, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reporter.name;
            }
            if ((n & 2) != 0) {
                string2 = reporter.type;
            }
            if ((n & 4) != 0) {
                string3 = reporter.uuid;
            }
            return reporter.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Reporter(name=" + this.name + ", type=" + this.type + ", uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.type;
            String string3 = this.uuid;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Reporter)) break block3;
                    Reporter reporter = (Reporter)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)reporter.name) || !Intrinsics.areEqual((Object)this.type, (Object)reporter.type) || !Intrinsics.areEqual((Object)this.uuid, (Object)reporter.uuid)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

