/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.base.GeneratedModelUtil;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraForeignKey;
import com.intellij.database.dialects.oracle.model.OraInnerRoutine;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.properties.OraTableType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraGeneratedModelUtil
extends GeneratedModelUtil {
    public static void setSubstituted(@NotNull OraSchema nsp) {
        if (nsp == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(0);
        }
        OraGeneratedModelUtil.setSubstituted(nsp);
        nsp.setIntrospectionTimestamp(null);
        nsp.setDbLinksHash(0L);
        nsp.setCommentsHash(0L);
    }

    public static List<String> getRefColNames(OraForeignKey fk) {
        return OraGeneratedModelUtil.getRefColNamesByKey((BasicForeignKey)fk);
    }

    public static void setRefColNames(OraForeignKey fk, List<String> names2) {
    }

    public static void handleRename(@NotNull OraModule m, @NotNull String oldName) {
        if (m == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(1);
        }
        if (oldName == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(2);
        }
        GeneratedModelUtil.handleRename((BasicModElement)m, oldName);
        for (OraBody body2 : m.getBodies()) {
            GeneratedModelUtil.handleRename((BasicModElement)body2, oldName);
        }
    }

    public static SequenceIdentity getSequenceIdentity(OraTableColumn column2) {
        if (!column2.isAutoInc()) {
            return null;
        }
        OraTable table = column2.getTable();
        if (table == null) {
            return null;
        }
        OraSchema schema = table.getSchema();
        if (schema == null) {
            return null;
        }
        long tableId = table.getObjectId();
        if (tableId <= 0L) {
            return null;
        }
        String sequenceName = "ISEQ$$_" + tableId;
        BasicSequence sequence = (BasicSequence)schema.getSequences().get(sequenceName);
        if (sequence == null) {
            return null;
        }
        return sequence.getSequenceIdentity();
    }

    public static void setSequenceIdentity(OraTableColumn column2, SequenceIdentity identity) {
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull OraSourceAware element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(3);
        }
        BasicDatabase database = (BasicDatabase)BasicMixinElement.parent((BasicElement)element, BasicDatabase.class);
        JBIterable jBIterable = JBIterable.from(element.getDependsOnIds()).map(objectId -> database.findIdentifiedElement(objectId.longValue())).filter(e2 -> e2 != null);
        if (jBIterable == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull OraTrigger element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.from(OraGeneratedModelUtil.getPredecessors((OraSourceAware)element)).append(OraGeneratedModelUtil.getPredecessors((BasicColumniation)element));
        if (jBIterable == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    public static boolean isElementSurrogate(@NotNull OraTableColumn element) {
        OraTable table;
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(7);
        }
        return (table = element.getTable()) != null && table.getTableType() == OraTableType.MAT_LOG && element.getName().endsWith("$$");
    }

    public static boolean isElementSurrogate(@NotNull OraSequence sequence) {
        if (sequence == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(8);
        }
        return sequence.isBelongsToColumn();
    }

    public static int getDisplayOrder(@NotNull OraBody e1, @NotNull OraBody e2) {
        if (e1 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(9);
        }
        if (e2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(10);
        }
        return 0;
    }

    public static int getDisplayOrder(@NotNull OraTable e1, @NotNull OraBody e2) {
        if (e1 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(11);
        }
        if (e2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(12);
        }
        String id1 = e1.identity(false);
        String id2 = e2.identity(false);
        return Comparing.compare((Comparable)((Object)id1), (Comparable)((Object)id2));
    }

    public static boolean getAutoCreated(@NotNull OraTable element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(13);
        }
        switch (element.getTableType()) {
            case MAT_LOG: 
            case MAT_LOG_TEMP: {
                return true;
            }
            case MAT_VIEW: {
                OraSchema schema = element.getSchema();
                if (schema == null) {
                    return false;
                }
                OraMatView mv = (OraMatView)schema.getMatViews().get(element.getName());
                if (mv == null) {
                    return false;
                }
                return !mv.isPrebuilt();
            }
            case BASIC: {
                return element.isSecondary();
            }
        }
        return false;
    }

    @NotNull
    public static String identity(@NotNull OraBody element, boolean includingSurrogate) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(14);
        }
        return "#BODY";
    }

    @NotNull
    public static String identity(@NotNull OraMatLog element, boolean includingSurrogate) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(15);
        }
        return includingSurrogate ? OraGeneratedModelUtil.identity((BasicElement)element, true) : "#ML";
    }

    @NotNull
    public static String identity(@NotNull OraTable element, boolean includingSurrogate) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(16);
        }
        if (element.getTableType() == OraTableType.MAT_LOG) {
            if (includingSurrogate) {
                String string = element.getName();
                if (string == null) {
                    OraGeneratedModelUtil.$$$reportNull$$$0(17);
                }
                return string;
            }
            String masterTableName = StringUtil.notNullize((String)element.getMasterTableName(), (String)"???");
            String string = masterTableName + "'ML";
            if (string == null) {
                OraGeneratedModelUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = OraGeneratedModelUtil.identity((BasicElement)element, includingSurrogate);
        if (string == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String identity(@NotNull OraInnerRoutine routine2, boolean includingSurrogate) {
        short ovr;
        if (routine2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(20);
        }
        if ((ovr = routine2.getOverloadNr()) > 0) {
            String string = routine2.getName() + "[" + ovr + "]";
            if (string == null) {
                OraGeneratedModelUtil.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = routine2.getName();
        if (string == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static int getDisplayOrder(@NotNull OraInnerRoutine e1, @NotNull OraInnerRoutine e2) {
        int res2;
        if (e1 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(23);
        }
        if (e2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(24);
        }
        return (res2 = OraGeneratedModelUtil.getDisplayOrder((BasicElement)e1, (BasicElement)e2)) == 0 ? Comparing.compare((int)e1.getOverloadNr(), (int)e2.getOverloadNr()) : res2;
    }

    @Nullable
    public static BasicSchema getTargetSchema(@NotNull OraSynonym s) {
        if (s == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(25);
        }
        if (s.getTargetDbLinkName() != null) {
            return null;
        }
        BasicMetaObject ms = s.getMetaObject().getParent();
        return ms == null ? null : OraGeneratedModelUtil.findInRoot((BasicElement)s, s.getTargetSchemaName(), ms, BasicSchema.class);
    }

    @Nullable
    public static BasicMajorObject getTargetObject(@NotNull OraSynonym s) {
        if (s == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(26);
        }
        if (s.getTargetDbLinkName() != null) {
            return null;
        }
        return GeneratedModelUtil.getTargetObject((BasicSynonym)s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraGeneratedModelUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 9: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 10: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraGeneratedModelUtil";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "identity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isElementSurrogate";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCreated";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "identity";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTargetSchema";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

