/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.oracle.introspector.OraCatalogAccessPermissions;
import com.intellij.database.dialects.oracle.introspector.OraTypeAndName;
import com.intellij.database.dialects.oracle.introspector.PortionType;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraCatalogObject;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraConstraint;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.dialects.oracle.model.OraViewTrigger;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.StringFun;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TLongHashSet;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u00ec\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060&j\u0002`'\u001a\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,\u001a\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\tH\u0000\u001a\u001a\u00100\u001a\u00020)2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\bH\u0000\u001a\u001a\u00104\u001a\u00020)2\u0006\u00105\u001a\u0002062\b\u00103\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0012\u00107\u001a\u00020$2\b\u00108\u001a\u0004\u0018\u000109H\u0000\u001a\u0018\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0000\u001a\u0012\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020\bH\u0000\u001a`\u0010B\u001a\u00020)2\u0006\u0010;\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010\b2\u0006\u0010I\u001a\u00020\u000e2\b\u0010J\u001a\u0004\u0018\u00010\b2\b\u0010K\u001a\u0004\u0018\u00010\b2\b\u0010L\u001a\u0004\u0018\u00010\b2\u0006\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020$H\u0000\u001aL\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020C2\b\u0010R\u001a\u0004\u0018\u00010\b2\b\u0010S\u001a\u0004\u0018\u00010\b2\b\u0010T\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010U\u001a\u00020\t2\b\b\u0002\u0010V\u001a\u00020\t2\b\b\u0002\u0010W\u001a\u00020\u000eH\u0000\u001a\u0010\u0010X\u001a\u00020@2\u0006\u0010Y\u001a\u00020\bH\u0000\u001a\"\u0010Z\u001a\u00020)2\u0006\u0010[\u001a\u00020\\2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020_0^\u001a\"\u0010`\u001a\u00020)2\u0006\u0010a\u001a\u00020b2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020_0^\u001a\u0010\u0010c\u001a\u00020\b2\u0006\u0010d\u001a\u00020\bH\u0001\u001a\u0016\u0010e\u001a\u0004\u0018\u00010f*\u00020g2\u0006\u0010d\u001a\u00020\bH\u0000\u001a\u0016\u0010h\u001a\u0004\u0018\u00010i*\u00020<2\u0006\u0010d\u001a\u00020\bH\u0000\u001a\u0016\u0010j\u001a\u0004\u0018\u000109*\u00020C2\u0006\u0010k\u001a\u00020lH\u0000\u001a\u0016\u0010m\u001a\u0004\u0018\u00010n*\u00020<2\u0006\u0010d\u001a\u00020\bH\u0000\u001a\u0016\u0010o\u001a\u0004\u0018\u00010p*\u00020<2\u0006\u0010q\u001a\u00020\bH\u0000\u001a \u0010r\u001a\u00020)*\u00020s2\b\u0010t\u001a\u0004\u0018\u00010u2\b\u0010v\u001a\u0004\u0018\u00010uH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0011\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0003\"\u0014\u0010\u0013\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0003\"\u0014\u0010\u0015\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0003\"\u0014\u0010\u0017\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0003\"\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001a\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0003\"\u000e\u0010\u001c\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0014\u0010!\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0003\u00a8\u0006w"}, d2={"AUTO_NOT_NULL_CHECK_PATTERN", "Lkotlin/text/Regex;", "getAUTO_NOT_NULL_CHECK_PATTERN", "()Lkotlin/text/Regex;", "COLLECTION_TYPE_SURROGATE_NAME_PATTERN", "getCOLLECTION_TYPE_SURROGATE_NAME_PATTERN", "DATA_TYPE_STAR_SIZE", "", "", "", "DB_LINK_AUTH_PATTERN", "DB_LINK_CONNECT_PATTERN", "DB_LINK_SHARED_PATTERN", "DELIMITER", "", "EXPLICIT_UNIT_DATA_TYPES", "", "INDEX_EXPRESSION_STUB_PATTERN", "getINDEX_EXPRESSION_STUB_PATTERN", "INDEX_SURROGATE_NAME_PATTERN", "getINDEX_SURROGATE_NAME_PATTERN", "NATIVE_TRIGGER_DEFINITION_PATTERN", "getNATIVE_TRIGGER_DEFINITION_PATTERN", "SEQUENCE_SURROGATE_NAME_PATTERN", "getSEQUENCE_SURROGATE_NAME_PATTERN", "SIMPLE_DATA_TYPES", "SIMPLE_QUOTED_NAME_PATTERN", "getSIMPLE_QUOTED_NAME_PATTERN", "SRC_NAMES_PORTION_SIZE", "SYSTEM_SCHEMAS", "Ljava/util/TreeSet;", "getSYSTEM_SCHEMAS", "()Ljava/util/TreeSet;", "obfuscationTextPattern", "getObfuscationTextPattern", "adjustStringLiteralsForOracle9i", "", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "analyzeDbLinkSrc", "", "src", "dbLink", "Lcom/intellij/database/dialects/oracle/model/OraDbLink;", "applicablePortionTypeFor", "Lcom/intellij/database/dialects/oracle/introspector/PortionType;", "n", "applyStoredProgramSources", "obj", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "text", "applyViewSources", "view", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "canCheckOutdated", "e", "Lcom/intellij/database/model/basic/BasicElement;", "dropUnexistentObjectsInSchema", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "identifiers", "Lgnu/trove/TLongHashSet;", "getObjectKindByOracleTypeName", "Lcom/intellij/database/model/ObjectKind;", "oracleTypeName", "makeArgument", "Lcom/intellij/database/model/basic/BasicSchema;", "routine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "position", "", "argName", "argDirection", "typeMod", "dataTypeSchemaName", "dataTypePackageName", "dataTypeSpec", "defaulted", "makeDataType", "Lcom/intellij/database/model/DataType;", "thisSchema", "typeSchemaName", "typePackageName", "typeSpec", "precision", "scale", "unitsCode", "oracleKindByMajorInternalCode", "code", "setOracleCatalogAccessModeParameters", "permissions", "Lcom/intellij/database/dialects/oracle/introspector/OraCatalogAccessPermissions;", "parameters", "", "", "setOracleSpecificParameters", "version", "Lcom/intellij/database/util/Version;", "unquoteNameIfPossible", "name", "findModConstraint", "Lcom/intellij/database/dialects/oracle/model/OraConstraint;", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "findModuleByName", "Lcom/intellij/database/dialects/oracle/model/OraModule;", "findOracleObjectByStringTypeAndName", "oracleTypeAndName", "Lcom/intellij/database/dialects/oracle/introspector/OraTypeAndName;", "findTableOrViewByName", "Lcom/intellij/database/dialects/oracle/model/OraLikeTable;", "findTrigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "triggerName", "setCreatedAndModifiedTimestamps", "Lcom/intellij/database/dialects/oracle/model/OraSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "intellij.database.dialects.oracle"})
@JvmName(name="OraIntrospectorFunctions")
public final class OraIntrospectorFunctions {
    @NotNull
    private static final TreeSet<String> SYSTEM_SCHEMAS = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])new String[]{"SYS", "SYSTEM", "ORDDATA", "AUDSYS", "CTXSYS", "ORDSYS", "MDSYS", "CTXSYS", "WMSYS", "DVSYS", "LBACSYS", "OLAPSYS", "OJVMSYS", "APPQOSSYS", "XDB", "PUBLIC"});
    public static final int SRC_NAMES_PORTION_SIZE = 100;
    private static final Set<String> SIMPLE_DATA_TYPES = SetsKt.setOf((Object[])new String[]{"INTEGER", "BINARY_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "DATE", "TIME", "ROWID", "UROWID", "CLOB", "BLOB", "LONG", "LONG RAW", "BFILE"});
    private static final Set<String> EXPLICIT_UNIT_DATA_TYPES = SetsKt.setOf((Object[])new String[]{"CHAR", "VARCHAR", "VARCHAR2"});
    private static final Map<String, Integer> DATA_TYPE_STAR_SIZE = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"NUMBER", (Object)0x7FFFFFFE), TuplesKt.to((Object)"FLOAT", (Object)126)});
    @NotNull
    private static final Regex NATIVE_TRIGGER_DEFINITION_PATTERN;
    @NotNull
    private static final Regex SIMPLE_QUOTED_NAME_PATTERN;
    @NotNull
    private static final Regex AUTO_NOT_NULL_CHECK_PATTERN;
    @NotNull
    private static final Regex COLLECTION_TYPE_SURROGATE_NAME_PATTERN;
    @NotNull
    private static final Regex INDEX_SURROGATE_NAME_PATTERN;
    @NotNull
    private static final Regex INDEX_EXPRESSION_STUB_PATTERN;
    @NotNull
    private static final Regex SEQUENCE_SURROGATE_NAME_PATTERN;
    public static final char DELIMITER = '\uffff';
    @NotNull
    private static final Regex obfuscationTextPattern;
    private static final Regex DB_LINK_SHARED_PATTERN;
    private static final Regex DB_LINK_CONNECT_PATTERN;
    private static final Regex DB_LINK_AUTH_PATTERN;

    @NotNull
    public static final TreeSet<String> getSYSTEM_SCHEMAS() {
        return SYSTEM_SCHEMAS;
    }

    @NotNull
    public static final PortionType applicablePortionTypeFor(int n) {
        return n <= 1 ? PortionType.ONE : (n <= PortionType.SMALL.getSize() ? PortionType.SMALL : (n <= PortionType.NORMAL.getSize() ? PortionType.NORMAL : PortionType.ALL));
    }

    public static final void setOracleCatalogAccessModeParameters(@NotNull OraCatalogAccessPermissions permissions, @NotNull Map<String, Object> parameters2) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        if (permissions.getHasSCR() || permissions.getHasSAD()) {
            parameters2.put("CAT", "sys.DBA");
            parameters2.put("DBA", true);
            parameters2.remove("SLOW");
            if (permissions.getFast()) {
                parameters2.put("FAST", true);
            } else {
                parameters2.remove("FAST");
            }
        } else {
            parameters2.put("CAT", "sys.ALL");
            parameters2.put("SLOW", true);
            parameters2.remove("DBA");
            parameters2.remove("FAST");
        }
    }

    public static final void setOracleSpecificParameters(@NotNull Version version, @NotNull Map<String, Object> parameters2) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        if (version.isOrGreater(new int[]{12, 2}) && Registry.is((String)"database.oracle.names.long")) {
            parameters2.put("N12", true);
        }
    }

    @NotNull
    public static final ObjectKind oracleKindByMajorInternalCode(@NotNull String code) {
        ObjectKind objectKind;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "TA": {
                ObjectKind objectKind2 = ObjectKind.TABLE;
                objectKind = objectKind2;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"TABLE");
                break;
            }
            case "CL": {
                ObjectKind objectKind3 = ObjectKind.CLUSTER;
                objectKind = objectKind3;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"CLUSTER");
                break;
            }
            case "VI": {
                ObjectKind objectKind4 = ObjectKind.VIEW;
                objectKind = objectKind4;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"VIEW");
                break;
            }
            case "SY": {
                ObjectKind objectKind5 = ObjectKind.SYNONYM;
                objectKind = objectKind5;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind5, (String)"SYNONYM");
                break;
            }
            case "SE": {
                ObjectKind objectKind6 = ObjectKind.SEQUENCE;
                objectKind = objectKind6;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind6, (String)"SEQUENCE");
                break;
            }
            case "PR": {
                ObjectKind objectKind7 = ObjectKind.ROUTINE;
                objectKind = objectKind7;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind7, (String)"ROUTINE");
                break;
            }
            case "FU": {
                ObjectKind objectKind8 = ObjectKind.ROUTINE;
                objectKind = objectKind8;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind8, (String)"ROUTINE");
                break;
            }
            case "PA": {
                ObjectKind objectKind9 = ObjectKind.PACKAGE;
                objectKind = objectKind9;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind9, (String)"PACKAGE");
                break;
            }
            case "MA": {
                ObjectKind objectKind10 = ObjectKind.MAT_VIEW;
                objectKind = objectKind10;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind10, (String)"MAT_VIEW");
                break;
            }
            case "YB": {
                ObjectKind objectKind11 = ObjectKind.OBJECT_TYPE;
                objectKind = objectKind11;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind11, (String)"OBJECT_TYPE");
                break;
            }
            case "YC": {
                ObjectKind objectKind12 = ObjectKind.COLLECTION_TYPE;
                objectKind = objectKind12;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind12, (String)"COLLECTION_TYPE");
                break;
            }
            case "DA": {
                ObjectKind objectKind13 = ObjectKind.DB_LINK;
                objectKind = objectKind13;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind13, (String)"DB_LINK");
                break;
            }
            default: {
                ObjectKind objectKind14 = ObjectKind.UNKNOWN_OBJECT;
                objectKind = objectKind14;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind14, (String)"UNKNOWN_OBJECT");
            }
        }
        return objectKind;
    }

    public static final void dropUnexistentObjectsInSchema(@NotNull OraSchema schema, @NotNull TLongHashSet identifiers) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)identifiers, (String)"identifiers");
        ModNamingIdentifyingFamily<? extends OraSequence> modNamingIdentifyingFamily = schema.getSequences();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.sequences");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily), identifiers);
        ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily2 = schema.getClusters();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"schema.clusters");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily2), identifiers);
        ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily3 = schema.getTables();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"schema.tables");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily3), identifiers);
        ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily4 = schema.getMatViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"schema.matViews");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily4), identifiers);
        ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily5 = schema.getViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"schema.views");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily5), identifiers);
        ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily6 = schema.getPackages();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"schema.packages");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily6), identifiers);
        ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily7 = schema.getObjectTypes();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"schema.objectTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily7), identifiers);
        ModNamingIdentifyingFamily<? extends OraCollectionType> modNamingIdentifyingFamily8 = schema.getCollectionTypes();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"schema.collectionTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily8), identifiers);
        ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily9 = schema.getRoutines();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily9, (String)"schema.routines");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily9), identifiers);
        ModNamingIdentifyingFamily<? extends OraSynonym> modNamingIdentifyingFamily10 = schema.getSynonyms();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily10, (String)"schema.synonyms");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily10), identifiers);
        Iterator iterator = schema.getClusters().iterator();
        while (iterator.hasNext()) {
            OraCluster cluster;
            OraCluster oraCluster = cluster = (OraCluster)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)oraCluster, (String)"cluster");
            ModSingletonFamily<? extends OraClusterIndex> modSingletonFamily = oraCluster.getIndices();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"cluster.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
        for (OraMajorObject table : schema.getTables()) {
            OraTable oraTable = table;
            Intrinsics.checkNotNullExpressionValue((Object)oraTable, (String)"table");
            ModNamingIdentifyingFamily<? extends OraIndex> modNamingIdentifyingFamily11 = oraTable.getIndices();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily11, (String)"table.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily11), identifiers);
            ModNamingIdentifyingFamily<? extends OraTableTrigger> modNamingIdentifyingFamily12 = table.getTriggers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily12, (String)"table.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily12), identifiers);
        }
        for (OraMajorObject table : schema.getMatViews()) {
        }
        iterator = schema.getViews().iterator();
        while (iterator.hasNext()) {
            OraView view;
            OraView oraView = view = (OraView)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)oraView, (String)"view");
            ModNamingIdentifyingFamily<? extends OraViewTrigger> modNamingIdentifyingFamily13 = oraView.getTriggers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily13, (String)"view.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily13), identifiers);
        }
        iterator = schema.getPackages().iterator();
        while (iterator.hasNext()) {
            OraPackage pack;
            OraPackage oraPackage = pack = (OraPackage)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)oraPackage, (String)"pack");
            ModSingletonFamily<? extends OraPackageBody> modSingletonFamily = oraPackage.getBodies();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"pack.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
        iterator = schema.getObjectTypes().iterator();
        while (iterator.hasNext()) {
            OraObjectType ot;
            OraObjectType oraObjectType = ot = (OraObjectType)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)oraObjectType, (String)"ot");
            ModSingletonFamily<? extends OraObjectTypeBody> modSingletonFamily = oraObjectType.getBodies();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"ot.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
    }

    public static final void setCreatedAndModifiedTimestamps(@NotNull OraSchemaObject $this$setCreatedAndModifiedTimestamps, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        Intrinsics.checkNotNullParameter((Object)$this$setCreatedAndModifiedTimestamps, (String)"$this$setCreatedAndModifiedTimestamps");
        $this$setCreatedAndModifiedTimestamps.setCreatedTimestamp(createdTimestamp);
        $this$setCreatedAndModifiedTimestamps.setModifiedTimestamp(modifiedTimestamp);
    }

    @Nullable
    public static final OraLikeTable findTableOrViewByName(@NotNull OraSchema $this$findTableOrViewByName, @NotNull String name2) {
        OraLikeTable oraLikeTable;
        Intrinsics.checkNotNullParameter((Object)$this$findTableOrViewByName, (String)"$this$findTableOrViewByName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraLikeTable oraLikeTable2 = (OraLikeTable)$this$findTableOrViewByName.getMatViews().get(name2);
        if (oraLikeTable2 == null) {
            oraLikeTable2 = oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getTables().get(name2);
        }
        if (oraLikeTable2 == null) {
            oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getViews().get(name2);
        }
        return oraLikeTable;
    }

    @Nullable
    public static final OraModule findModuleByName(@NotNull OraSchema $this$findModuleByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$findModuleByName, (String)"$this$findModuleByName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraModule oraModule = (OraModule)$this$findModuleByName.getObjectTypes().get(name2);
        if (oraModule == null) {
            oraModule = (OraModule)$this$findModuleByName.getPackages().get(name2);
        }
        return oraModule;
    }

    @Nullable
    public static final OraConstraint findModConstraint(@NotNull OraTable $this$findModConstraint, @NotNull String name2) {
        OraConstraint oraConstraint;
        Intrinsics.checkNotNullParameter((Object)$this$findModConstraint, (String)"$this$findModConstraint");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraConstraint oraConstraint2 = (OraConstraint)$this$findModConstraint.getKeys().get(name2);
        if (oraConstraint2 == null) {
            oraConstraint2 = oraConstraint = (OraConstraint)$this$findModConstraint.getForeignKeys().get(name2);
        }
        if (oraConstraint2 == null) {
            oraConstraint = (OraConstraint)$this$findModConstraint.getChecks().get(name2);
        }
        return oraConstraint;
    }

    @Nullable
    public static final OraTrigger findTrigger(@NotNull OraSchema $this$findTrigger, @NotNull String triggerName) {
        Intrinsics.checkNotNullParameter((Object)$this$findTrigger, (String)"$this$findTrigger");
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        OraTrigger trigger = null;
        Iterator iterator = $this$findTrigger.getTables().iterator();
        while (iterator.hasNext()) {
            OraTable table;
            OraTable oraTable = table = (OraTable)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)oraTable, (String)"table");
            trigger = (OraTrigger)oraTable.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        for (OraMajorObject view : $this$findTrigger.getViews()) {
            OraView oraView = view;
            Intrinsics.checkNotNullExpressionValue((Object)oraView, (String)"view");
            trigger = (OraTrigger)oraView.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        iterator = $this$findTrigger.getMatViews().iterator();
        while (iterator.hasNext()) {
            OraMajorObject view;
            OraMajorObject oraMajorObject = view = (OraMatView)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)oraMajorObject, (String)"view");
            trigger = (OraTrigger)oraMajorObject.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static final String unquoteNameIfPossible(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Object object = SIMPLE_QUOTED_NAME_PATTERN.matchEntire((CharSequence)name2);
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            object = name2;
        }
        return object;
    }

    public static final void makeArgument(@NotNull BasicSchema schema, @NotNull OraRoutine routine2, short position, @Nullable String argName, char argDirection, @Nullable String typeMod, @Nullable String dataTypeSchemaName, @Nullable String dataTypePackageName, @NotNull String dataTypeSpec, boolean defaulted) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        Intrinsics.checkNotNullParameter((Object)dataTypeSpec, (String)"dataTypeSpec");
        ArgumentDirection dir = ArgumentDirection.of((char)argDirection);
        if (dir == null && argName != null) {
            dir = ArgumentDirection.IN;
        }
        if (dir == null) {
            dir = ArgumentDirection.IN;
        }
        OraArgument argument = null;
        if (dir == ArgumentDirection.RETURN) {
            BasicModArgument basicModArgument = routine2.createOrGetReturnArgument();
            if (basicModArgument == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraArgument");
            }
            argument = (OraArgument)basicModArgument;
            argument.setRealName(argName);
        } else if (argName != null) {
            BasicModNamedElement basicModNamedElement = routine2.getArguments().createOrGet(argName);
            Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"routine.arguments.createOrGet(argName)");
            argument = (OraArgument)basicModNamedElement;
            argument.setPosition(position);
            argument.setArgumentDirection(dir);
        } else {
            return;
        }
        DataType dataType = OraIntrospectorFunctions.makeDataType$default(schema, dataTypeSchemaName, dataTypePackageName, dataTypeSpec, 0, 0, '\u0000', 112, null);
        CharSequence charSequence = typeMod;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            DataType dataType2 = dataType.withSuffix(StringUtil.toUpperCase((String)typeMod));
            Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"dataType.withSuffix(Stri\u2026til.toUpperCase(typeMod))");
            dataType = dataType2;
        }
        argument.setDataType(dataType);
        argument.setDefaulted(defaulted);
    }

    @NotNull
    public static final DataType makeDataType(@NotNull BasicSchema thisSchema, @Nullable String typeSchemaName, @Nullable String typePackageName, @Nullable String typeSpec, int precision, int scale, char unitsCode) {
        Intrinsics.checkNotNullParameter((Object)thisSchema, (String)"thisSchema");
        String spec = typeSpec;
        if (spec != null && spec.length() > 7 && StringsKt.startsWith$default((String)spec, (String)"PL/SQL ", (boolean)false, (int)2, null)) {
            String string = spec;
            int n = 7;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            spec = string2;
        }
        DataType type = null;
        if (spec == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataType.UNKNOWN");
            type = dataType;
        } else if (StringsKt.contains$default((CharSequence)spec, (CharSequence)"(", (boolean)false, (int)2, null)) {
            DataType dataType = DataTypeFactory.of((String)spec);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataTypeFactory.of(spec)");
            type = dataType;
        } else {
            DataType dataType;
            LengthUnit units;
            boolean customType = typeSchemaName != null;
            boolean simple = SIMPLE_DATA_TYPES.contains(spec) && !customType;
            boolean explicitUnits = EXPLICIT_UNIT_DATA_TYPES.contains(spec) && unitsCode == 'C' && !customType;
            switch (unitsCode) {
                case 'B': {
                    LengthUnit lengthUnit = LengthUnit.BYTE;
                    break;
                }
                case 'C': {
                    LengthUnit lengthUnit = LengthUnit.CHAR;
                    break;
                }
                case 'D': {
                    LengthUnit lengthUnit = LengthUnit.DIGIT;
                    break;
                }
                default: {
                    LengthUnit lengthUnit = units = null;
                }
            }
            String explicitSchemaName = customType ? (Intrinsics.areEqual((Object)thisSchema.getRealName(), (Object)typeSchemaName) || Intrinsics.areEqual((Object)typeSchemaName, (Object)"PUBLIC") ? null : typeSchemaName) : null;
            Integer starSize = DATA_TYPE_STAR_SIZE.get(spec);
            int p = starSize != null && precision == starSize ? 0x7FFFFFFE : precision;
            String suffix2 = null;
            if (StringsKt.startsWith((String)spec, (String)"TIMESTAMP ", (boolean)true)) {
                suffix2 = StringsKt.contains((CharSequence)spec, (CharSequence)"LOCAL", (boolean)true) ? "WITH LOCAL TIME ZONE" : "WITH TIME ZONE";
                spec = "TIMESTAMP";
            }
            if (customType) {
                DataType dataType2 = DataTypeFactory.of((String)explicitSchemaName, (String)typePackageName, (String)spec, (int)-1, (int)0, null, (String)suffix2, (boolean)false, (boolean)true);
                dataType = dataType2;
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"DataTypeFactory.of(expli\u2026ull, suffix, false, true)");
            } else if (simple) {
                DataType dataType3 = DataTypeFactory.of(null, (String)typePackageName, (String)spec, (int)-1, (int)-1, (LengthUnit)units, (String)suffix2, (boolean)false, (boolean)false);
                dataType = dataType3;
                Intrinsics.checkNotNullExpressionValue((Object)dataType3, (String)"DataTypeFactory.of(null,\u2026ts, suffix, false, false)");
            } else {
                DataType dataType4 = DataTypeFactory.of(null, (String)typePackageName, (String)spec, (int)p, (int)scale, (LengthUnit)units, (String)suffix2, (boolean)explicitUnits, (boolean)false);
                dataType = dataType4;
                Intrinsics.checkNotNullExpressionValue((Object)dataType4, (String)"DataTypeFactory.of(null,\u2026ix, explicitUnits, false)");
            }
            type = dataType;
        }
        return type;
    }

    public static /* synthetic */ DataType makeDataType$default(BasicSchema basicSchema, String string, String string2, String string3, int n, int n2, char c, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n = -1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            c = '\u0000';
        }
        return OraIntrospectorFunctions.makeDataType(basicSchema, string, string2, string3, n, n2, c);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void applyStoredProgramSources(@NotNull OraSourceAware obj2, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        if (text != null) {
            CharSequence charSequence = text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                obj2.setSourceText((CompositeText)new SimpleCompositeText((CharSequence)text, CompositeText.Kind.ORIGINAL_TEXT));
                return;
            }
        }
        obj2.setSourceText(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void applyViewSources(@NotNull BasicModSourceAware view, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (text != null) {
            CharSequence charSequence = text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                view.setSourceText((CompositeText)new SimpleCompositeText((CharSequence)text, CompositeText.Kind.ORIGINAL_TEXT));
                return;
            }
        }
        view.setSourceText((CompositeText)null);
    }

    @NotNull
    public static final Regex getNATIVE_TRIGGER_DEFINITION_PATTERN() {
        return NATIVE_TRIGGER_DEFINITION_PATTERN;
    }

    @NotNull
    public static final Regex getSIMPLE_QUOTED_NAME_PATTERN() {
        return SIMPLE_QUOTED_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getAUTO_NOT_NULL_CHECK_PATTERN() {
        return AUTO_NOT_NULL_CHECK_PATTERN;
    }

    @NotNull
    public static final Regex getCOLLECTION_TYPE_SURROGATE_NAME_PATTERN() {
        return COLLECTION_TYPE_SURROGATE_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getINDEX_SURROGATE_NAME_PATTERN() {
        return INDEX_SURROGATE_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getINDEX_EXPRESSION_STUB_PATTERN() {
        return INDEX_EXPRESSION_STUB_PATTERN;
    }

    @NotNull
    public static final Regex getSEQUENCE_SURROGATE_NAME_PATTERN() {
        return SEQUENCE_SURROGATE_NAME_PATTERN;
    }

    public static final boolean canCheckOutdated(@Nullable BasicElement e2) {
        return e2 == null || e2 instanceof OraCatalogObject && !(e2 instanceof OraSchema) && ((OraCatalogObject)e2).getObjectId() != Long.MIN_VALUE && ((OraCatalogObject)e2).getModifiedTimestamp() != null;
    }

    @Nullable
    public static final BasicElement findOracleObjectByStringTypeAndName(@NotNull BasicSchema $this$findOracleObjectByStringTypeAndName, @NotNull OraTypeAndName oracleTypeAndName) {
        Intrinsics.checkNotNullParameter((Object)$this$findOracleObjectByStringTypeAndName, (String)"$this$findOracleObjectByStringTypeAndName");
        Intrinsics.checkNotNullParameter((Object)oracleTypeAndName, (String)"oracleTypeAndName");
        String string = oracleTypeAndName.getType();
        if (string == null) {
            return null;
        }
        String objectTypeName = string;
        ObjectKind objectKind = OraIntrospectorFunctions.getObjectKindByOracleTypeName(objectTypeName);
        if (objectKind == null) {
            return null;
        }
        ObjectKind objectKind2 = objectKind;
        String string2 = oracleTypeAndName.getName();
        if (string2 == null) {
            return null;
        }
        String objectName = string2;
        ObjectKind objectKind3 = objectKind2;
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.OBJECT_TYPE)) {
            BasicElement o2;
            Family family1 = $this$findOracleObjectByStringTypeAndName.familyOf(ObjectKind.OBJECT_TYPE);
            Family family = family1;
            if (!(family instanceof NamingFamily)) {
                family = null;
            }
            NamingFamily namingFamily = (NamingFamily)family;
            BasicElement basicElement = o2 = namingFamily != null ? (BasicElement)namingFamily.get(objectName) : null;
            if (o2 == null) {
                Family family2 = $this$findOracleObjectByStringTypeAndName.familyOf(ObjectKind.COLLECTION_TYPE);
                Family family3 = family2;
                if (!(family3 instanceof NamingFamily)) {
                    family3 = null;
                }
                NamingFamily namingFamily2 = (NamingFamily)family3;
                o2 = namingFamily2 != null ? (BasicElement)namingFamily2.get(objectName) : null;
            }
            return o2;
        }
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.BODY)) {
            NamingFamily namingFamily;
            ObjectKind objectKind4;
            switch (objectTypeName.charAt(0)) {
                case 'P': {
                    objectKind4 = ObjectKind.PACKAGE;
                    break;
                }
                case 'T': {
                    objectKind4 = ObjectKind.OBJECT_TYPE;
                    break;
                }
                default: {
                    return null;
                }
            }
            ObjectKind parentKind = objectKind4;
            Family family = $this$findOracleObjectByStringTypeAndName.familyOf(parentKind);
            if (family == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)family, (String)"this.familyOf(parentKind) ?: return null");
            Family parentFamily = family;
            Family family4 = parentFamily;
            if (!(family4 instanceof NamingFamily)) {
                family4 = null;
            }
            if ((namingFamily = (NamingFamily)family4) == null || (namingFamily = (BasicElement)namingFamily.get(objectName)) == null) {
                return null;
            }
            NamingFamily parent2 = namingFamily;
            Family family5 = parent2.familyOf(ObjectKind.BODY);
            return family5 != null ? (BasicElement)CollectionsKt.firstOrNull((Iterable)((Iterable)family5)) : null;
        }
        Family family = $this$findOracleObjectByStringTypeAndName.familyOf(objectKind2);
        if (family == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)family, (String)"this.familyOf(objectKind) ?: return null");
        Family family6 = family;
        return family6 instanceof NamingFamily ? (BasicElement)((NamingFamily)family6).get(objectName) : null;
    }

    @Nullable
    public static final ObjectKind getObjectKindByOracleTypeName(@NotNull String oracleTypeName) {
        ObjectKind objectKind;
        Intrinsics.checkNotNullParameter((Object)oracleTypeName, (String)"oracleTypeName");
        switch (oracleTypeName) {
            case "INDEX": {
                objectKind = ObjectKind.INDEX;
                break;
            }
            case "TABLE": {
                objectKind = ObjectKind.TABLE;
                break;
            }
            case "CLUSTER": {
                objectKind = ObjectKind.CLUSTER;
                break;
            }
            case "VIEW": {
                objectKind = ObjectKind.VIEW;
                break;
            }
            case "SYNONYM": {
                objectKind = ObjectKind.SYNONYM;
                break;
            }
            case "SEQUENCE": {
                objectKind = ObjectKind.SEQUENCE;
                break;
            }
            case "PROCEDURE": {
                objectKind = ObjectKind.ROUTINE;
                break;
            }
            case "FUNCTION": {
                objectKind = ObjectKind.ROUTINE;
                break;
            }
            case "PACKAGE": {
                objectKind = ObjectKind.PACKAGE;
                break;
            }
            case "PACKAGE BODY": {
                objectKind = ObjectKind.BODY;
                break;
            }
            case "TRIGGER": {
                objectKind = ObjectKind.TRIGGER;
                break;
            }
            case "TYPE": {
                objectKind = ObjectKind.OBJECT_TYPE;
                break;
            }
            case "TYPE BODY": {
                objectKind = ObjectKind.BODY;
                break;
            }
            case "MATERIALIZED VIEW": {
                objectKind = ObjectKind.MAT_VIEW;
                break;
            }
            case "DATABASE LINK": {
                objectKind = ObjectKind.DB_LINK;
                break;
            }
            default: {
                objectKind = null;
            }
        }
        return objectKind;
    }

    @NotNull
    public static final Regex getObfuscationTextPattern() {
        return obfuscationTextPattern;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean adjustStringLiteralsForOracle9i(@NotNull StringBuilder buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int q = buf.indexOf("q'{");
        if (q < 0) {
            return false;
        }
        int p = buf.indexOf("}'", q + 3);
        if (p < 0) {
            return false;
        }
        buf.delete(p, p + 1);
        int n = p - 1;
        int n2 = q + 3;
        if (n >= n2) {
            while (true) {
                void i2;
                if (buf.charAt((int)i2) == '\'') {
                    buf.insert((int)(i2 + true), '\'');
                }
                if (i2 == n2) break;
                --i2;
            }
        }
        buf.delete(q + 2, q + 3);
        buf.delete(q, q + 1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final void analyzeDbLinkSrc(@NotNull String src2, @NotNull OraDbLink dbLink) {
        void authName;
        void connName;
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dbLink, (String)"dbLink");
        Function3<Regex, Integer, Integer, Pair<? extends String, ? extends String>> $fun$extractNamePwd$1 = new Function3<Regex, Integer, Integer, Pair<? extends String, ? extends String>>(src2){
            final /* synthetic */ String $src;

            @NotNull
            public final Pair<String, String> invoke(@NotNull Regex pattern, int index1, int index2) {
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                Pair np = StringFun.extract((CharSequence)this.$src, (Regex)pattern, (int)index1, (int)index2);
                if (np.getSecond() != null) {
                    Object object = np.getSecond();
                    Intrinsics.checkNotNull((Object)object);
                    if (StringsKt.startsWith$default((CharSequence)((CharSequence)object), (char)':', (boolean)false, (int)2, null)) {
                        np = new Pair(np.getFirst(), null);
                    }
                }
                return np;
            }
            {
                this.$src = string;
                super(3);
            }
        };
        CharSequence charSequence = src2;
        Regex regex = DB_LINK_SHARED_PATTERN;
        boolean bl = false;
        boolean shared = regex.matches(charSequence);
        Object object = $fun$extractNamePwd$1.invoke(DB_LINK_CONNECT_PATTERN, 1, 4);
        charSequence = (String)object.component1();
        String connPwd = (String)object.component2();
        Object object2 = $fun$extractNamePwd$1.invoke(DB_LINK_AUTH_PATTERN, 1, 4);
        object = (String)object2.component1();
        String authPwd = (String)object2.component2();
        object2 = dbLink;
        boolean bl2 = false;
        boolean bl3 = false;
        Object $this$apply = object2;
        boolean bl4 = false;
        $this$apply.setShared(shared);
        $this$apply.setConnectUserName((String)connName);
        $this$apply.setConnectUserPassword(connPwd);
        $this$apply.setAuthUserName((String)authName);
        $this$apply.setAuthUserPassword(authPwd);
    }

    static {
        String string = "(?s)^CREATE(\\s*OR\\s*REPLACE)?(\\s*[EN][A-Z]+)?\\s+TRIGGER.+$";
        boolean bl = false;
        NATIVE_TRIGGER_DEFINITION_PATTERN = new Regex(string);
        string = "^\\s*\"([^\"]*)\"\\s*$";
        bl = false;
        SIMPLE_QUOTED_NAME_PATTERN = new Regex(string);
        string = "\".+\" IS NOT NULL";
        bl = false;
        AUTO_NOT_NULL_CHECK_PATTERN = new Regex(string);
        string = "^SYS_PLSQL_[0-9A-F_]+(DUMMY[0-9A-F_]*)?$";
        bl = false;
        COLLECTION_TYPE_SURROGATE_NAME_PATTERN = new Regex(string);
        string = "^SYS_\\w*\\d+\\$*$";
        bl = false;
        INDEX_SURROGATE_NAME_PATTERN = new Regex(string);
        string = "^SYS_NC\\d+.$";
        bl = false;
        INDEX_EXPRESSION_STUB_PATTERN = new Regex(string);
        string = "^ISEQ\\$+_\\d+$";
        bl = false;
        SEQUENCE_SURROGATE_NAME_PATTERN = new Regex(string);
        obfuscationTextPattern = new Regex("^[^\\n]*wrapped\\s*\\n", RegexOption.DOT_MATCHES_ALL);
        DB_LINK_SHARED_PATTERN = new Regex("^\\s*CREATE\\s+(PUBLIC\\s+)?SHARED\\s.*$", SetsKt.setOf((Object[])new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.IGNORE_CASE}));
        DB_LINK_CONNECT_PATTERN = new Regex("CONNECT \\s+ TO \\s+ \"(.*?)(\"|\\s) \\s* (IDENTIFIED \\s+ BY \\s+ VALUES? \\s* '(.*?)')?", SetsKt.setOf((Object[])new RegexOption[]{RegexOption.COMMENTS, RegexOption.IGNORE_CASE}));
        DB_LINK_AUTH_PATTERN = new Regex("AUTHENTICATED \\s+ BY \\s+ \"(.*?)(\"|\\s) \\s* (IDENTIFIED \\s+ BY \\s+ VALUES? \\s* '(.*?)')?", SetsKt.setOf((Object[])new RegexOption[]{RegexOption.COMMENTS, RegexOption.IGNORE_CASE}));
    }
}

