/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.base.introspector.query.CommonPreprocessor;
import com.intellij.database.dialects.base.introspector.query.PreprocessedQuery;
import com.intellij.database.dialects.base.introspector.query.Preprocessor;
import com.intellij.database.dialects.oracle.introspector.MajorMinorName;
import com.intellij.database.dialects.oracle.introspector.OraCatalogAccessPermissions;
import com.intellij.database.dialects.oracle.introspector.OraIntroQueries;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraDatabaseRetriever$WhenMappings;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraSchemaRetriever$$special$;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraSchemaRetriever$extractPackageChildren$;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraSchemaRetriever$retrieveSources$;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$applySchemas$1$$special$;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorFunctions;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorSourcesHelperKt;
import com.intellij.database.dialects.oracle.introspector.OraMajorSourceText;
import com.intellij.database.dialects.oracle.introspector.OraMinorSourceText;
import com.intellij.database.dialects.oracle.introspector.OraObjectCodes;
import com.intellij.database.dialects.oracle.introspector.OraSlowDependencyEntry;
import com.intellij.database.dialects.oracle.introspector.OraTypeAndName;
import com.intellij.database.dialects.oracle.introspector.PortionType;
import com.intellij.database.dialects.oracle.model.OraAliasType;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraCatalogObject;
import com.intellij.database.dialects.oracle.model.OraCheck;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraConstraint;
import com.intellij.database.dialects.oracle.model.OraDataFile;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraException;
import com.intellij.database.dialects.oracle.model.OraForeignKey;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraInfraColumn;
import com.intellij.database.dialects.oracle.model.OraInnerRoutine;
import com.intellij.database.dialects.oracle.model.OraKey;
import com.intellij.database.dialects.oracle.model.OraLikeColumn;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModel;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeAttribute;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraObjectTypeRoutine;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraPackageVariable;
import com.intellij.database.dialects.oracle.model.OraRecordColumn;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.dialects.oracle.model.OraTablespace;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraUser;
import com.intellij.database.dialects.oracle.model.OraVariable;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.dialects.oracle.model.properties.OraDataFileAvailabilityStatus;
import com.intellij.database.dialects.oracle.model.properties.OraDataFileOnlineStatus;
import com.intellij.database.dialects.oracle.model.properties.OraMatViewRefreshMethod;
import com.intellij.database.dialects.oracle.model.properties.OraMatViewRefreshMode;
import com.intellij.database.dialects.oracle.model.properties.OraTableType;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceContentCategory;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceLogging;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceStatus;
import com.intellij.database.dialects.oracle.model.properties.TableOrganization;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.StringListAggregator;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.exceptions.DBAccessDeniedException;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.exceptions.NoTableOrViewException;
import com.intellij.database.remote.jdba.exceptions.OracleObjectNotFoundException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.CalendarFun;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.StringFun;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.ide.PlatformIdeService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.psi.OraMemberFunctionDefinitionImpl;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongHashSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 j2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\bjklmnopqB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u001e\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-H\u0002J.\u0010.\u001a\u0018\u0012\u0004\u0012\u00020\u00020/R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020\u0002H\u0014J4\u00102\u001a\u001e\u0012\u0004\u0012\u00020\u000303R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003042\u0006\u00100\u001a\u00020+2\u0006\u00105\u001a\u00020\u0003H\u0014J\b\u00106\u001a\u00020%H\u0002J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020%H\u0014J9\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u00162\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0@\"\u00020AH\u0016\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0014J\u001e\u0010D\u001a\u00020%2\u0006\u0010*\u001a\u00020+2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0014J\u0010\u0010F\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020IH\u0002J\u0012\u0010J\u001a\u00020\n2\b\u0010K\u001a\u0004\u0018\u00010LH\u0002J6\u0010M\u001a\u00020%2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020A0'2\u000e\u0010O\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030P2\u0006\u0010Q\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020SH\u0002J\u001e\u0010T\u001a\u00020%2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V0'2\u0006\u0010W\u001a\u00020\u0002H\u0002J6\u0010X\u001a\u00020%2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020A0'2\u000e\u0010O\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030P2\u0006\u0010Q\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020SH\u0002J\b\u0010Y\u001a\u00020\nH\u0002J\u0010\u0010Z\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020\\H\u0014J\b\u0010]\u001a\u00020%H\u0016J\"\u0010^\u001a\u000e\u0012\u0004\u0012\u00020_\u0012\u0004\u0012\u00020\u000f0\u00152\f\u0010`\u001a\b\u0012\u0004\u0012\u00020_0aH\u0016J/\u0010b\u001a\u0004\u0018\u0001Hc\"\b\b\u0000\u0010c*\u00020d2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002Hc0-H\u0002\u00a2\u0006\u0002\u0010eJ$\u0010f\u001a\u0004\u0018\u00010A*\u00020+2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00170-2\u0006\u0010h\u001a\u00020iH\u0002R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0094\u0004\u00a2\u0006\n\n\u0002\b\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u0017X\u0094D\u00a2\u0006\n\n\u0002\b\u001e\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "<set-?>", "Lcom/intellij/database/dialects/oracle/introspector/OraCatalogAccessPermissions;", "catalogPermissions", "getCatalogPermissions", "()Lcom/intellij/database/dialects/oracle/introspector/OraCatalogAccessPermissions;", "considerSurrogateNotNullChecks", "", "getConsiderSurrogateNotNullChecks", "()Z", "setConsiderSurrogateNotNullChecks", "(Z)V", "introspectorKindVersions", "", "Lcom/intellij/database/model/ObjectKind;", "", "getIntrospectorKindVersions", "()Ljava/util/Map;", "introspectorKindVersions$1", "introspectorVersion", "getIntrospectorVersion", "()I", "introspectorVersion$1", "queries", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries;", "sessionInfo", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSessionInfo;", "useXML", "applySchemas", "", "scs", "", "Lcom/intellij/database/introspection/LongIdName;", "checkQueryReturnRows", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "schema", "ensureCatalogAccessMode", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "initConnectionRelatedState", "introspectFragment", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "withSources", "objectKind", "objectNames", "", "", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespacesInTran", "introspectSchemasAuto", "schemas", "introspectSessionState", "logExpectedOraError", "e", "Lcom/intellij/database/remote/jdba/exceptions/DBException;", "obtainCatalogAccessMode", "model", "Lcom/intellij/database/dialects/oracle/model/OraModel;", "processNames", "items", "modelSchemas", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "renew", "affectedSchemaIdsContainer", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "processSynonyms", "ss", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSynonym;", "root", "processTheNames", "queryCatalogAccessMode", "queryPostPreprocess", "buf", "Ljava/lang/StringBuilder;", "retrieveAndApplySchemas", "retrieveInvalid", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "", "retrieveSmallSafe", "T", "", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;", "performQueryReturningXml", "xmlQuery", "preprocessor", "Lcom/intellij/database/dialects/base/introspector/query/Preprocessor;", "Companion", "Factory", "OraDatabaseFirstRetriever", "OraDatabaseIncRetriever", "OraDatabaseRetriever", "OraSchemaRetriever", "OraSchemaStat", "ResultIsNull", "intellij.database.dialects.oracle"})
public final class OraIntrospector
extends BaseSingleDatabaseIntrospector<OraRoot, OraSchema> {
    private final OraIntroQueries queries;
    private OraIntroQueries.OneSessionInfo sessionInfo;
    private final int introspectorVersion$1;
    @NotNull
    private final Map<ObjectKind, Integer> introspectorKindVersions$1;
    private OraCatalogAccessPermissions catalogPermissions;
    private boolean useXML;
    private boolean considerSurrogateNotNullChecks;
    public static final int introspectorVersion = 200820;
    @NotNull
    private static final Map<ObjectKind, Integer> introspectorKindVersions;
    @NotNull
    public static final String useXmlPropName = "database.introspection.oracle.use.xml";
    public static final int packSize = 100;
    @NotNull
    private static final String adjustXmlContextCommand;
    @NotNull
    private static final String closeXmlContextCommand;
    @NotNull
    private static final SqlQuery<String> retrieveXmlContentQuery;
    @NotNull
    public static final Companion Companion;

    @Override
    protected int getIntrospectorVersion() {
        return this.introspectorVersion$1;
    }

    @Override
    @NotNull
    protected Map<ObjectKind, Integer> getIntrospectorKindVersions() {
        return this.introspectorKindVersions$1;
    }

    @NotNull
    public final OraCatalogAccessPermissions getCatalogPermissions() {
        OraCatalogAccessPermissions oraCatalogAccessPermissions = this.catalogPermissions;
        if (oraCatalogAccessPermissions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"catalogPermissions");
        }
        return oraCatalogAccessPermissions;
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        if (!this.getServerVersion().isOrGreater(new int[]{10}) && this.getDriverVersion().isOrGreater(new int[]{12})) {
            String message2 = String.format("Unsupported combination of server/driver versions: found Oracle server version %s with JDBC driver version %s that is not compatible. Oracle server version 9.x must be connected by JDBC driver versions 9.x to 11.x.", this.getServerVersion(), this.getDriverVersion());
            throw (Throwable)new IllegalStateException(message2);
        }
        this.ensureCatalogAccessMode();
        int n = 10;
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), new IntRange(n, 12), this.getParametersMap());
        n = 18;
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), new IntRange(n, 19), this.getParametersMap());
        n = 10;
        IntRange intRange = new IntRange(n, 12);
        n = 1;
        BaseIntrospectionFunctions.setMajorMinorVersionParameters(this.getServerVersion(), intRange, new IntRange(n, 2), this.getParametersMap());
        OraIntrospectorFunctions.setOracleSpecificParameters(this.getServerVersion(), this.getParametersMap());
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCatalogAccessMode() {
        void var3_4;
        void _true_$iv;
        void $this$choose$iv;
        if (this.catalogPermissions == null) {
            OraModel model;
            BasicModModel basicModModel = this.getMyModel();
            if (!(basicModModel instanceof OraModel)) {
                basicModModel = null;
            }
            if ((model = (OraModel)basicModModel) == null) {
                this.logWarn("Called the initConnectionRelatedState() when no model yet: it reduced performance of incremental introspection");
            }
            OraCatalogAccessPermissions oraCatalogAccessPermissions = this.catalogPermissions = this.obtainCatalogAccessMode(model);
            if (oraCatalogAccessPermissions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"catalogPermissions");
            }
            OraIntrospectorFunctions.setOracleCatalogAccessModeParameters(oraCatalogAccessPermissions, this.getParametersMap());
            Object[] objectArray = new Object[3];
            objectArray[0] = this.getServerVersion();
            objectArray[1] = this.getDriverVersion();
            OraCatalogAccessPermissions oraCatalogAccessPermissions2 = this.catalogPermissions;
            if (oraCatalogAccessPermissions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"catalogPermissions");
            }
            objectArray[2] = oraCatalogAccessPermissions2.toString();
            String string = String.format("Oracle Introspector: initialized for Oracle version %s driver version %s using mode: %s", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(\"Oracle Introspec\u2026ogPermissions.toString())");
            this.logInfo(string);
        }
        this.useXML = Registry.is((String)useXmlPropName, (boolean)true);
        boolean model = this.useXML;
        String string = "XML";
        String _false_$iv = "conventional streams";
        boolean $i$f$choose = false;
        this.trace("Accessing LONG columns via " + (String)($this$choose$iv != false ? _true_$iv : var3_4));
    }

    /*
     * WARNING - void declaration
     */
    private final OraCatalogAccessPermissions obtainCatalogAccessMode(OraModel model) {
        void p;
        Object object;
        Ref.ObjectRef objectRef;
        OraRoot root2;
        OraModel oraModel = model;
        OraRoot oraRoot = root2 = oraModel != null ? oraModel.getRoot() : null;
        String ps = oraRoot != null ? oraRoot.getCatalogAccessPermissions() : null;
        Ref.ObjectRef objectRef2 = objectRef = new Ref.ObjectRef();
        String string = ps;
        if (string != null) {
            void p1;
            String string2 = string;
            OraCatalogAccessPermissions.Companion companion = OraCatalogAccessPermissions.Companion;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            Ref.ObjectRef objectRef3 = objectRef2;
            boolean bl3 = false;
            OraCatalogAccessPermissions oraCatalogAccessPermissions = companion.import((String)p1);
            objectRef2 = objectRef3;
            object = oraCatalogAccessPermissions;
        } else {
            object = objectRef2.element = null;
        }
        if ((OraCatalogAccessPermissions)p.element == null) {
            this.trace("Checking Catalog access permissions\u2026");
            p.element = this.queryCatalogAccessMode();
            this.trace("Catalog access permissions: " + (OraCatalogAccessPermissions)p.element);
            if (root2 != null) {
                model.modify(OraRoot.class, new ModelModifier((Ref.ObjectRef)p){
                    final /* synthetic */ Ref.ObjectRef $p;

                    public final void perform(OraRoot r) {
                        OraRoot oraRoot = r;
                        Intrinsics.checkNotNullExpressionValue((Object)oraRoot, (String)"r");
                        oraRoot.setCatalogAccessPermissions(((OraCatalogAccessPermissions)this.$p.element).export());
                    }
                    {
                        this.$p = objectRef;
                    }
                });
            }
        } else {
            this.trace("Using cached Catalog access permissions: " + (OraCatalogAccessPermissions)p.element);
        }
        return (OraCatalogAccessPermissions)p.element;
    }

    /*
     * WARNING - void declaration
     */
    private final OraCatalogAccessPermissions queryCatalogAccessMode() {
        void permissions;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = OraCatalogAccessPermissions.Companion.getNothing();
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, (Ref.ObjectRef)permissions){
            final /* synthetic */ OraIntrospector this$0;
            final /* synthetic */ Ref.ObjectRef $permissions;

            public final void invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                SqlQuery<Character[]> sqlQuery = OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).checkBaseDictionariesAccess;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.checkBaseDictionariesAccess");
                Object[] permissionChars = (Character[])OraIntrospector.access$retrieveSmallSafe(this.this$0, tran, sqlQuery);
                if (permissionChars != null) {
                    this.$permissions.element = OraCatalogAccessPermissions.Companion.of$default(OraCatalogAccessPermissions.Companion, ArraysKt.contains((Object[])permissionChars, (Object)Character.valueOf('C')), ArraysKt.contains((Object[])permissionChars, (Object)Character.valueOf('D')), false, 4, null);
                }
                if (((OraCatalogAccessPermissions)this.$permissions.element).getHasSAD()) {
                    SqlQuery<Boolean> sqlQuery2 = OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).checkFastDictionariesAccess;
                    Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"queries.checkFastDictionariesAccess");
                    boolean fast = OraIntrospector.access$checkQueryReturnRows(this.this$0, tran, sqlQuery2);
                    if (fast) {
                        this.$permissions.element = OraCatalogAccessPermissions.copy$default((OraCatalogAccessPermissions)this.$permissions.element, false, false, true, 3, null);
                    }
                }
            }
            {
                this.this$0 = oraIntrospector;
                this.$permissions = objectRef;
                super(1);
            }
        }));
        return (OraCatalogAccessPermissions)permissions.element;
    }

    private final <T> T retrieveSmallSafe(DBTransaction tran, SqlQuery<T> query) {
        Object object;
        try {
            object = IntrospectionQueryContext.runQuery$default((IntrospectionQueryContext)this, tran, query, null, null, 6, null);
        }
        catch (NoTableOrViewException _) {
            object = null;
        }
        catch (DBAccessDeniedException _) {
            object = null;
        }
        return (T)object;
    }

    private final boolean checkQueryReturnRows(DBTransaction tran, SqlQuery<Boolean> query) {
        boolean bl;
        try {
            bl = (Boolean)IntrospectionQueryContext.runQuery$default((IntrospectionQueryContext)this, tran, query, null, null, 6, null);
        }
        catch (NoTableOrViewException _) {
            bl = false;
        }
        catch (DBAccessDeniedException _) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean queryPostPreprocess(@NotNull StringBuilder buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (this.getServerVersion().less(new int[]{10})) {
            return OraIntrospectorFunctions.adjustStringLiteralsForOracle9i(buf);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String performQueryReturningXml(DBTransaction $this$performQueryReturningXml, SqlQuery<Integer> xmlQuery, Preprocessor preprocessor) {
        String string;
        PreprocessedQuery<Integer> preprocessedQuery = preprocessor.preprocess(xmlQuery);
        Intrinsics.checkNotNullExpressionValue(preprocessedQuery, (String)"preprocessor.preprocess(xmlQuery)");
        PreprocessedQuery<Integer> preprocessedQuery2 = preprocessedQuery;
        SqlQuery sqlQuery = preprocessedQuery2.query;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"preprocessedQuery.query");
        Integer ctxHandle = (Integer)IntrospectionQueryContext.runQuery$default((IntrospectionQueryContext)this, $this$performQueryReturningXml, sqlQuery, null, null, 6, null);
        this.trace("Received ctxHandle " + ctxHandle);
        if (ctxHandle == null) {
            return null;
        }
        try {
            $this$performQueryReturningXml.command(adjustXmlContextCommand).withParams(new Object[]{ctxHandle}).runOnce();
            String content = (String)$this$performQueryReturningXml.query(retrieveXmlContentQuery).withParams(new Object[]{ctxHandle}).runOnce();
            this.trace("Received XML content: " + (content != null ? String.valueOf(content.length()) + " chars" : "null"));
            string = content;
        }
        catch (Throwable throwable) {
            $this$performQueryReturningXml.command(closeXmlContextCommand).withParams(new Object[]{ctxHandle}).runOnce();
            this.trace("The ctxHandle " + ctxHandle + " is closed");
            throw throwable;
        }
        $this$performQueryReturningXml.command(closeXmlContextCommand).withParams(new Object[]{ctxHandle}).runOnce();
        this.trace("The ctxHandle " + ctxHandle + " is closed");
        return string;
    }

    public final boolean getConsiderSurrogateNotNullChecks() {
        return this.considerSurrogateNotNullChecks;
    }

    public final void setConsiderSurrogateNotNullChecks(boolean bl) {
        this.considerSurrogateNotNullChecks = bl;
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List schemas2;
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        SqlQuery<List<LongIdName>> sqlQuery = this.queries.retrieveAllSchemas;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveAllSchemas");
        List list = schemas2 = (List)IntrospectionQueryContext.runQuery$default((IntrospectionQueryContext)this, tran, sqlQuery, null, null, 6, null);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"schemas");
        this.applySchemas(list);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemas2 = (List)this.inTransaction((Function1)new Function1<DBTransaction, List<? extends LongIdName>>(this){
            final /* synthetic */ OraIntrospector this$0;

            @NotNull
            public final List<LongIdName> invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                SqlQuery<List<LongIdName>> sqlQuery = OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).retrieveAllSchemas;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveAllSchemas");
                Object object = IntrospectionQueryContext.runQuery$default((IntrospectionQueryContext)this.this$0, tran, sqlQuery, null, null, 6, null);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"tran.runQuery(queries.retrieveAllSchemas)");
                return (List)object;
            }
            {
                this.this$0 = oraIntrospector;
                super(1);
            }
        });
        this.applySchemas(schemas2);
    }

    private final void applySchemas(List<LongIdName> scs) {
        this.inModel((Function1)new Function1<OraRoot, Unit>(this, scs){
            final /* synthetic */ OraIntrospector this$0;
            final /* synthetic */ List $scs;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull OraRoot root2) {
                void $this$applySchemasImpl$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                Object object = OraIntrospector.access$getSessionInfo$p(this.this$0);
                if (object == null || (object = ((OraIntroQueries.OneSessionInfo)object).current_schema) == null) {
                    LongIdName longIdName = (LongIdName)CollectionsKt.firstOrNull((List)this.$scs);
                    object = longIdName != null ? longIdName.name : null;
                }
                Object current = object;
                ModNamingIdentifyingFamily<? extends OraSchema> modNamingIdentifyingFamily = root2.getSchemas();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"root.schemas");
                ModNamingFamily modNamingFamily = (ModNamingFamily)modNamingIdentifyingFamily;
                List scs$iv = this.$scs;
                boolean $i$f$applySchemasImpl = false;
                $this$applySchemasImpl$iv.markChildrenAsSyncPending();
                Iterable $this$forEach$iv$iv = scs$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void sc2;
                    T element$iv$iv;
                    T sc$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    LongIdName longIdName = (LongIdName)sc$iv;
                    void $this$applySchemasImpl = $this$applySchemasImpl$iv;
                    boolean bl2 = false;
                    BasicModNamedElement basicModNamedElement = root2.getSchemas().renew(sc2.id, sc2.name);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    OraSchema $this$apply = (OraSchema)basicModNamedElement;
                    boolean bl5 = false;
                    OraSchema oraSchema = $this$apply;
                    Intrinsics.checkNotNullExpressionValue((Object)oraSchema, (String)"this");
                    BasicSchema basicSchema = oraSchema.getSchema();
                    Intrinsics.checkNotNullExpressionValue((Object)basicSchema, (String)"this.schema");
                    $this$apply.setCurrent(Intrinsics.areEqual((Object)basicSchema.getName(), (Object)current));
                    OraSchema cfr_ignored_0 = (OraSchema)basicModNamedElement;
                }
                $this$applySchemasImpl$iv.removeSyncPendingChildren();
                $this$applySchemasImpl$iv.sort();
                boolean $i$f$cleanupFamilies = false;
                Function1 it = applySchemas$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                boolean bl = false;
                ModNamingIdentifyingFamily<? extends OraUser> modNamingIdentifyingFamily2 = root2.getUsers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"root.users");
                it.invoke(modNamingIdentifyingFamily2);
                boolean bl6 = false;
                for (LongIdName sc3 : this.$scs) {
                    if (sc3.id == 1L) continue;
                    root2.getUsers().renew(sc3.id, sc3.name);
                }
                it = applySchemas$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                $i$a$-cleanupFamilies-OraIntrospector$applySchemas$1$2 = false;
                ModNamingIdentifyingFamily<? extends OraUser> modNamingIdentifyingFamily3 = root2.getUsers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"root.users");
                it.invoke(modNamingIdentifyingFamily3);
            }
            {
                this.this$0 = oraIntrospector;
                this.$scs = list;
                super(1);
            }
        });
    }

    @Override
    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        SqlQuery<OraIntroQueries.OneSessionInfo> sqlQuery = this.queries.retrieveSessionInfo;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveSessionInfo");
        this.sessionInfo = (OraIntroQueries.OneSessionInfo)IntrospectionQueryContext.runQuery$default((IntrospectionQueryContext)this, tran, sqlQuery, null, null, 6, null);
    }

    @Override
    @NotNull
    public TreePattern getDefaultScope() {
        List names2;
        block3: {
            Object object;
            names2 = CollectionsKt.mutableListOf((Object[])new ObjectName[]{DataSourceSchemaMapping.CURRENT_NAMESPACE_NAME, ObjectName.quoted((String)"PUBLIC")});
            OraIntroQueries.OneSessionInfo oneSessionInfo = this.sessionInfo;
            if (oneSessionInfo == null) break block3;
            OraIntroQueries.OneSessionInfo oneSessionInfo2 = oneSessionInfo;
            boolean bl = false;
            boolean bl2 = false;
            OraIntroQueries.OneSessionInfo i2 = oneSessionInfo2;
            boolean bl3 = false;
            String string = i2.current_user;
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                object = Intrinsics.areEqual((Object)it, (Object)i2.current_schema) ^ true ? string2 : null;
            } else {
                object = oneSessionInfo = null;
            }
            if (object != null) {
                oneSessionInfo2 = oneSessionInfo;
                bl = false;
                bl2 = false;
                OraIntroQueries.OneSessionInfo it = oneSessionInfo2;
                boolean bl7 = false;
                names2.add(ObjectName.quoted((String)((Object)it)));
            }
        }
        return new TreePattern(TreePatternUtils.create((List)names2, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0]));
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends OraSchema> schemas2) {
        int currentIndex;
        int index$iv;
        ArrayList<OraSchema> reorderedSchemasToProcess;
        IntOpenHashSet affectedSchemaIds;
        String string;
        BaseIntrospector baseIntrospector;
        block22: {
            int n;
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
            ArrayList schemasToProcess = new ArrayList(schemas2);
            int n2 = schemasToProcess.size();
            this.trace("Oracle method introspectSchemasAuto: given " + n2 + " schemas to introspect");
            Iterator iterator = schemasToProcess.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"schemasToProcess.iterator()");
            Iterator it = iterator;
            while (it.hasNext()) {
                OraSchema s;
                OraSchema oraSchema = s = (OraSchema)it.next();
                Intrinsics.checkNotNullExpressionValue((Object)oraSchema, (String)"s");
                if (oraSchema.getObjectId() != Long.MIN_VALUE || !(Intrinsics.areEqual((Object)s.getName(), (Object)"SYS") ^ true)) continue;
                this.logWarn("Oracle schema " + s.getRealName() + " has no object Id");
                it.remove();
            }
            CollectionsKt.sortWith((List)schemasToProcess, (Comparator)introspectSchemasAuto.1.INSTANCE);
            ArrayList<OraSchema> schemasRegularInc = new ArrayList<OraSchema>(schemasToProcess.size());
            ArrayList schemasRegularFul = new ArrayList(schemasToProcess.size());
            ArrayList schemasSystemInc = new ArrayList(schemasToProcess.size());
            ArrayList schemasSystemFul = new ArrayList(schemasToProcess.size());
            Iterator iterator2 = schemasToProcess.iterator();
            while (iterator2.hasNext()) {
                ArrayList<OraSchema> arrayList;
                boolean $i$f$choose;
                boolean $this$choose$iv;
                boolean isSystem;
                OraSchema schema;
                OraSchema oraSchema = schema = (OraSchema)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)oraSchema, (String)"schema");
                boolean canIncrement = oraSchema.getIntrospectionTimestamp() != null;
                boolean bl = isSystem = OraIntrospectorFunctions.getSYSTEM_SCHEMAS().contains(schema.getName());
                if (!bl) {
                    $this$choose$iv = canIncrement;
                    $i$f$choose = false;
                    arrayList = $this$choose$iv ? schemasRegularInc : schemasRegularFul;
                } else if (bl) {
                    $this$choose$iv = canIncrement;
                    $i$f$choose = false;
                    arrayList = $this$choose$iv ? schemasSystemInc : schemasSystemFul;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                ArrayList<OraSchema> theList = arrayList;
                theList.add(schema);
            }
            int nRI = schemasRegularInc.size();
            int nRF = schemasRegularFul.size();
            int nSI = schemasSystemInc.size();
            int nSF = schemasSystemFul.size();
            BaseIntrospector this_$iv = this;
            boolean $i$f$trace = false;
            if (BaseIntrospector.access$getTracing$p(this_$iv)) {
                baseIntrospector = this_$iv;
                boolean bl = false;
                StringBuilder b = new StringBuilder();
                b.append("Decided to introspect:\n");
                if (nRI > 0) {
                    b.append("" + '\t' + nRI + " regular schemas incrementally: \n");
                    CollectionsKt.joinTo$default((Iterable)schemasRegularInc, (Appendable)b, (CharSequence)"", null, null, (int)0, null, (Function1)introspectSchemasAuto.2.1.INSTANCE, (int)60, null);
                }
                if (nRF > 0) {
                    b.append("" + '\t' + nRF + " regular schemas completely: \n");
                    CollectionsKt.joinTo$default((Iterable)schemasRegularFul, (Appendable)b, (CharSequence)"", null, null, (int)0, null, (Function1)introspectSchemasAuto.2.2.INSTANCE, (int)60, null);
                }
                if (nSI > 0) {
                    b.append("" + '\t' + nSI + " system schemas incrementally: \n");
                    CollectionsKt.joinTo$default((Iterable)schemasSystemInc, (Appendable)b, (CharSequence)"", null, null, (int)0, null, (Function1)introspectSchemasAuto.2.3.INSTANCE, (int)60, null);
                }
                if (nSF > 0) {
                    b.append("" + '\t' + nSF + " system schemas completely: \n");
                    CollectionsKt.joinTo$default((Iterable)schemasSystemFul, (Appendable)b, (CharSequence)"", null, null, (int)0, null, (Function1)introspectSchemasAuto.2.4.INSTANCE, (int)60, null);
                }
                String string2 = b.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"b.toString()");
                string = string2;
                BaseIntrospector.access$trace(baseIntrospector, string);
            }
            affectedSchemaIds = new IntOpenHashSet(n2);
            if (nRI > 0) {
                this.handleErrors("Introspect regular database stuff incrementally", (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, schemasRegularInc, affectedSchemaIds){
                    final /* synthetic */ OraIntrospector this$0;
                    final /* synthetic */ DBTransaction $tran;
                    final /* synthetic */ ArrayList $schemasRegularInc;
                    final /* synthetic */ IntOpenHashSet $affectedSchemaIds;

                    public final void invoke() {
                        OraDatabaseIncRetriever retriever1 = this.this$0.new OraDatabaseIncRetriever(this.$tran, this.$schemasRegularInc, false);
                        retriever1.setSystem(false);
                        retriever1.process();
                        this.$affectedSchemaIds.addAll((IntCollection)retriever1.getAffectedSchemaIds());
                    }
                    {
                        this.this$0 = oraIntrospector;
                        this.$tran = dBTransaction;
                        this.$schemasRegularInc = arrayList;
                        this.$affectedSchemaIds = intOpenHashSet;
                        super(0);
                    }
                }));
            }
            if (nSI > 0) {
                this.handleErrors("Introspect system database stuff incrementally", (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, schemasSystemInc, affectedSchemaIds){
                    final /* synthetic */ OraIntrospector this$0;
                    final /* synthetic */ DBTransaction $tran;
                    final /* synthetic */ ArrayList $schemasSystemInc;
                    final /* synthetic */ IntOpenHashSet $affectedSchemaIds;

                    public final void invoke() {
                        OraDatabaseIncRetriever retriever2 = this.this$0.new OraDatabaseIncRetriever(this.$tran, this.$schemasSystemInc, false);
                        retriever2.setSystem(true);
                        retriever2.process();
                        this.$affectedSchemaIds.addAll((IntCollection)retriever2.getAffectedSchemaIds());
                    }
                    {
                        this.this$0 = oraIntrospector;
                        this.$tran = dBTransaction;
                        this.$schemasSystemInc = arrayList;
                        this.$affectedSchemaIds = intOpenHashSet;
                        super(0);
                    }
                }));
            }
            if (nRF > 0) {
                this.handleErrors("Introspect regular database stuff completely", (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, schemasRegularFul, affectedSchemaIds){
                    final /* synthetic */ OraIntrospector this$0;
                    final /* synthetic */ DBTransaction $tran;
                    final /* synthetic */ ArrayList $schemasRegularFul;
                    final /* synthetic */ IntOpenHashSet $affectedSchemaIds;

                    public final void invoke() {
                        OraDatabaseFirstRetriever retriever3 = this.this$0.new OraDatabaseFirstRetriever(this.$tran, this.$schemasRegularFul, false);
                        retriever3.setSystem(false);
                        retriever3.process();
                        this.$affectedSchemaIds.addAll((IntCollection)retriever3.getAffectedSchemaIds());
                    }
                    {
                        this.this$0 = oraIntrospector;
                        this.$tran = dBTransaction;
                        this.$schemasRegularFul = arrayList;
                        this.$affectedSchemaIds = intOpenHashSet;
                        super(0);
                    }
                }));
            }
            if (nSF > 0) {
                this.handleErrors("Introspect system database stuff completely", (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, schemasSystemFul, affectedSchemaIds){
                    final /* synthetic */ OraIntrospector this$0;
                    final /* synthetic */ DBTransaction $tran;
                    final /* synthetic */ ArrayList $schemasSystemFul;
                    final /* synthetic */ IntOpenHashSet $affectedSchemaIds;

                    public final void invoke() {
                        OraDatabaseFirstRetriever retriever4 = this.this$0.new OraDatabaseFirstRetriever(this.$tran, this.$schemasSystemFul, false);
                        retriever4.setSystem(true);
                        retriever4.process();
                        this.$affectedSchemaIds.addAll((IntCollection)retriever4.getAffectedSchemaIds());
                    }
                    {
                        this.this$0 = oraIntrospector;
                        this.$tran = dBTransaction;
                        this.$schemasSystemFul = arrayList;
                        this.$affectedSchemaIds = intOpenHashSet;
                        super(0);
                    }
                }));
            }
            this.trace(StringsKt.repeat((CharSequence)"-", (int)140));
            BaseIntrospector this_$iv2 = this;
            boolean $i$f$trace2 = false;
            if (BaseIntrospector.access$getTracing$p(this_$iv2)) {
                baseIntrospector = this_$iv2;
                boolean bl = false;
                string = "Database retrievers completed, affected schemas:\n" + CollectionsKt.joinToString$default((Iterable)schemas2, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<OraSchema, CharSequence>(schemas2, affectedSchemaIds){
                    final /* synthetic */ List $schemas$inlined;
                    final /* synthetic */ IntOpenHashSet $affectedSchemaIds$inlined;
                    {
                        this.$schemas$inlined = list;
                        this.$affectedSchemaIds$inlined = intOpenHashSet;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final CharSequence invoke(@NotNull OraSchema it) {
                        void _true_$iv;
                        void $this$choose$iv;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        boolean bl = this.$affectedSchemaIds$inlined.contains((int)it.getObjectId());
                        String string = "yes";
                        String _false_$iv = "no";
                        boolean $i$f$choose = false;
                        return "\t[" + it.getObjectId() + "] " + it.getName() + " -> " + (String)($this$choose$iv != false ? _true_$iv : _false_$iv);
                    }
                }), (int)30, null);
                BaseIntrospector.access$trace(baseIntrospector, string);
            }
            reorderedSchemasToProcess = new ArrayList<OraSchema>(n2);
            reorderedSchemasToProcess.addAll((Collection)schemasRegularInc);
            reorderedSchemasToProcess.addAll(schemasRegularFul);
            reorderedSchemasToProcess.addAll(schemasSystemInc);
            reorderedSchemasToProcess.addAll(schemasSystemFul);
            List $this$indexOfFirst$iv = reorderedSchemasToProcess;
            boolean $i$f$indexOfFirst = false;
            index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                OraSchema it2 = (OraSchema)item$iv;
                boolean bl = false;
                if (it2.isCurrent()) {
                    n = index$iv;
                    break block22;
                }
                ++index$iv;
            }
            n = currentIndex = -1;
        }
        if (currentIndex >= 1) {
            Object e2 = reorderedSchemasToProcess.get(currentIndex);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"reorderedSchemasToProcess[currentIndex]");
            OraSchema currentSchema = (OraSchema)e2;
            reorderedSchemasToProcess.remove(currentIndex);
            reorderedSchemasToProcess.add(0, currentSchema);
        }
        List $this$sortBy$iv = reorderedSchemasToProcess;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            index$iv = 0;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(affectedSchemaIds){
                final /* synthetic */ IntOpenHashSet $affectedSchemaIds$inlined;
                {
                    this.$affectedSchemaIds$inlined = intOpenHashSet;
                }

                public final int compare(T a, T b) {
                    int _true_$iv;
                    boolean $this$choose$iv;
                    boolean bl = false;
                    OraSchema it = (OraSchema)a;
                    boolean bl2 = false;
                    boolean bl3 = this.$affectedSchemaIds$inlined.contains((int)it.getObjectId());
                    boolean bl4 = true;
                    int _false_$iv = 2;
                    boolean $i$f$choose = false;
                    it = (OraSchema)b;
                    Comparable comparable = Integer.valueOf($this$choose$iv ? _true_$iv : _false_$iv);
                    bl2 = false;
                    $this$choose$iv = this.$affectedSchemaIds$inlined.contains((int)it.getObjectId());
                    _true_$iv = 1;
                    _false_$iv = 2;
                    $i$f$choose = false;
                    Integer n = $this$choose$iv ? _true_$iv : _false_$iv;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            });
        }
        BaseIntrospector this_$iv = this;
        boolean $i$f$trace = false;
        if (BaseIntrospector.access$getTracing$p(this_$iv)) {
            baseIntrospector = this_$iv;
            boolean bl = false;
            string = "The schemas will be processed in the following order:\n" + CollectionsKt.joinToString$default((Iterable)reorderedSchemasToProcess, (CharSequence)"\n", null, null, (int)0, null, (Function1)introspectSchemasAuto.9.1.INSTANCE, (int)30, null);
            BaseIntrospector.access$trace(baseIntrospector, string);
        }
        for (OraSchema schema : reorderedSchemasToProcess) {
            StringBuilder stringBuilder = new StringBuilder().append("Introspect the schema ");
            OraSchema oraSchema = schema;
            Intrinsics.checkNotNullExpressionValue((Object)oraSchema, (String)"schema");
            this.handleErrors(stringBuilder.append(oraSchema.getName()).append(" stuff completely").toString(), (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, schema, affectedSchemaIds){
                final /* synthetic */ OraIntrospector this$0;
                final /* synthetic */ DBTransaction $tran;
                final /* synthetic */ OraSchema $schema;
                final /* synthetic */ IntOpenHashSet $affectedSchemaIds;

                public final void invoke() {
                    OraSchema oraSchema = this.$schema;
                    Intrinsics.checkNotNullExpressionValue((Object)oraSchema, (String)"schema");
                    OraSchemaRetriever oraSchemaRetriever = this.this$0.new OraSchemaRetriever(this.$tran, oraSchema);
                    boolean bl = false;
                    boolean bl2 = false;
                    OraSchemaRetriever $this$apply = oraSchemaRetriever;
                    boolean bl3 = false;
                    OraSchema oraSchema2 = this.$schema;
                    Intrinsics.checkNotNullExpressionValue((Object)oraSchema2, (String)"schema");
                    $this$apply.setMajorModificationsFound(this.$affectedSchemaIds.contains((int)oraSchema2.getObjectId()));
                    OraSchema oraSchema3 = this.$schema;
                    Intrinsics.checkNotNullExpressionValue((Object)oraSchema3, (String)"schema");
                    Date lastIntrospectionTimestamp = oraSchema3.getIntrospectionTimestamp();
                    Timestamp theGeneralFromTimestamp = $this$apply.getMode().increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO;
                    Long srcExistentVersion = this.this$0.getModel().getSchemaSourcesVersion((BasicSchema)this.$schema);
                    Timestamp theSrcFromTimestamp = srcExistentVersion != null && srcExistentVersion > 0L ? new Timestamp(srcExistentVersion) : BaseIntrospectionFunctions.AGES_AGO;
                    $this$apply.setFromTimestamps(theGeneralFromTimestamp, theSrcFromTimestamp);
                    OraSchemaRetriever retriever = oraSchemaRetriever;
                    retriever.retrieveMain();
                }
                {
                    this.this$0 = oraIntrospector;
                    this.$tran = dBTransaction;
                    this.$schema = oraSchema;
                    this.$affectedSchemaIds = intOpenHashSet;
                    super(0);
                }
            }));
        }
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        boolean bl = false;
        LinkedHashMap ids = new LinkedHashMap();
        for (BasicElement basicElement : elements2) {
            if (!(basicElement instanceof OraCatalogObject) || !OraIntrospectorFunctions.canCheckOutdated(basicElement)) continue;
            ((Map)ids).put(((OraCatalogObject)basicElement).getObjectId(), basicElement);
        }
        if (ids.isEmpty()) {
            return MapsKt.emptyMap();
        }
        this.trace("Retrieving states of " + ids.size() + " elements");
        boolean bl2 = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Map $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$_u24__u24$v = element$iv = iterator.next();
            boolean bl4 = false;
            Map.Entry entry = $dstr$_u24__u24$v;
            boolean bl5 = false;
            OraCatalogObject v2 = (OraCatalogObject)entry.getValue();
            ((Map)linkedHashMap).put(v2, false);
        }
        OraCatalogAccessPermissions oraCatalogAccessPermissions = this.catalogPermissions;
        if (oraCatalogAccessPermissions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"catalogPermissions");
        }
        SqlQuery<List<OraIntroQueries.OneState>> query = oraCatalogAccessPermissions.getFast() ? this.queries.retrieveStatesFast : this.queries.retrieveStates;
        Set set = ids.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"ids.keys");
        List packs = OraIntrospectorSourcesHelperKt.splitByPacks(set, 100);
        for (List pack : packs) {
            Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"object_ids", pack));
            SqlQuery<List<OraIntroQueries.OneState>> sqlQuery = query;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
            List<OraIntroQueries.OneState> states2 = this.performQuery(sqlQuery, params2);
            for (OraIntroQueries.OneState s : states2) {
                OraCatalogObject obj2;
                if ((OraCatalogObject)ids.get(s.object_id) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)obj2, (String)"ids[s.object_id] ?: continue");
                ((Map)linkedHashMap).put(obj2, Intrinsics.areEqual((Object)obj2.getModifiedTimestamp(), (Object)s.modified_timestamp));
            }
        }
        this.inModel((Function1)new Function1<OraRoot, Unit>(linkedHashMap){
            final /* synthetic */ LinkedHashMap $res;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull OraRoot it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Set<Map.Entry<K, V>> set = this.$res.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"res.entries");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void obj2;
                    Map.Entry $dstr$obj$ok = (Map.Entry)element$iv;
                    boolean bl = false;
                    Map.Entry entry = $dstr$obj$ok;
                    boolean bl2 = false;
                    BasicElement basicElement = (BasicElement)entry.getKey();
                    entry = $dstr$obj$ok;
                    bl2 = false;
                    Boolean ok = (Boolean)entry.getValue();
                    void v1 = obj2;
                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
                    }
                    ((BasicModElement)v1).setOutdated(ok == false);
                }
            }
            {
                this.$res = linkedHashMap;
                super(1);
            }
        });
        return linkedHashMap;
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)objectNames, (String)"objectNames");
        boolean bl = this.getModel().contains((DasObject)namespace);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = namespace instanceof OraSchema;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        OraSchema schema = (OraSchema)namespace;
        this.handleErrors("Introspect fragments " + ArraysKt.joinToString$default((Object[])objectNames, null, null, null, (int)0, null, null, (int)63, null), (Function0<Unit>)((Function0)new Function0<Unit>(this, schema, objectKind, objectNames, withSources){
            final /* synthetic */ OraIntrospector this$0;
            final /* synthetic */ OraSchema $schema;
            final /* synthetic */ ObjectKind $objectKind;
            final /* synthetic */ String[] $objectNames;
            final /* synthetic */ boolean $withSources;

            public final void invoke() {
                OraIntrospector.access$inTransactionUnit(this.this$0, (Function1)new Function1<DBTransaction, Unit>(this){
                    final /* synthetic */ introspectFragment.1 this$0;

                    public final void invoke(@NotNull DBTransaction tran) {
                        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                        OraSchemaRetriever retriever = this.this$0.this$0.new OraSchemaRetriever(tran, this.this$0.$schema);
                        retriever.setMode(IntrospectionMode.FRAGMENT);
                        retriever.setFragmentKind(this.this$0.$objectKind);
                        retriever.setFragmentNames(this.this$0.$objectNames);
                        retriever.setWithSources(this.this$0.$withSources);
                        retriever.setFromTimestamps(BaseIntrospectionFunctions.AGES_AGO, BaseIntrospectionFunctions.AGES_AGO);
                        retriever.retrieveMain();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = oraIntrospector;
                this.$schema = oraSchema;
                this.$objectKind = objectKind;
                this.$objectNames = stringArray;
                this.$withSources = bl;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void processNames(List<String> items, ModNamingIdentifyingFamily<? extends OraSchema> modelSchemas, boolean renew, IntOpenHashSet affectedSchemaIdsContainer) {
        void _true_$iv;
        void $this$choose$iv;
        int count = items.size();
        if (count == 0) {
            this.trace("No major names to process.");
            return;
        }
        boolean bl = renew;
        String string = "with";
        String _false_$iv = "without";
        boolean $i$f$choose = false;
        this.trace("Begin processing of " + count + " major names in " + modelSchemas.size() + " schemas " + (String)($this$choose$iv != false ? _true_$iv : _false_$iv) + " renew");
        long time1 = System.currentTimeMillis();
        this.processTheNames(items, modelSchemas, renew, affectedSchemaIdsContainer);
        long time2 = System.currentTimeMillis();
        double delta = (double)(time2 - time1) / 1000.0;
        this.trace("Processing of " + count + " major names in " + affectedSchemaIdsContainer.size() + " took " + delta + " s.");
    }

    private final void processTheNames(List<String> items, ModNamingIdentifyingFamily<? extends OraSchema> modelSchemas, boolean renew, IntOpenHashSet affectedSchemaIdsContainer) {
        int n;
        HashSet<ModNamingIdentifyingFamily> affectedFamilies = new HashSet<ModNamingIdentifyingFamily>();
        TIntObjectHashMap schemas2 = new TIntObjectHashMap(modelSchemas.size());
        for (String item : items) {
            try {
                BasicModNamedElement basicModNamedElement;
                OraSchemaObject oraSchemaObject;
                String objectName;
                ModNamingIdentifyingFamily family;
                ModNamingIdentifyingFamily f;
                String objectIdStr;
                String schemaIdStr;
                String kindCode;
                boolean bl = item.length() >= 24;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-OraIntrospector$processTheNames$22 = false;
                    String $i$a$-assert-OraIntrospector$processTheNames$22 = "The item should be at least 24 characters length";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-OraIntrospector$processTheNames$22));
                }
                String string = item;
                int $i$a$-assert-OraIntrospector$processTheNames$22 = 0;
                int n2 = 2;
                n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string2.substring($i$a$-assert-OraIntrospector$processTheNames$22, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                ObjectKind kind = OraIntrospectorFunctions.oracleKindByMajorInternalCode(kindCode);
                String string3 = item;
                n = 2;
                int n3 = 12;
                int n4 = 0;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = item;
                n3 = 12;
                n4 = 22;
                int n5 = 0;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string6.substring(n3, n4), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                char isSecondaryStr = item.charAt(22);
                String string7 = item;
                n5 = 23;
                boolean bl3 = false;
                String string8 = string7;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string8.substring(n5), (String)"(this as java.lang.String).substring(startIndex)");
                int schemaId = Integer.parseInt(schemaIdStr);
                int objectId = Integer.parseInt(objectIdStr);
                boolean isSecondary = isSecondaryStr == 'Y';
                affectedSchemaIdsContainer.add(schemaId);
                OraSchema schema = null;
                OraSchemaStat ss = (OraSchemaStat)schemas2.get(schemaId);
                if (ss == null) {
                    OraSchema oraSchema = (OraSchema)modelSchemas.getByObjectId((long)schemaId);
                    if (oraSchema == null) {
                        String string9 = "Schema should exist, id: " + schemaId;
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(string9.toString());
                    }
                    schema = oraSchema;
                    ss = new OraSchemaStat(schema);
                    schemas2.put(schemaId, (Object)ss);
                } else {
                    schema = ss.getSchema();
                }
                Map map2 = ss.getStats();
                Integer n6 = ss.getStats().get(kind);
                if (n6 == null) {
                    n6 = 0;
                }
                map2.put(kind, n6 + 1);
                if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.UNKNOWN_OBJECT)) continue;
                Family family2 = schema.familyOf(kind);
                if (!(family2 instanceof ModNamingIdentifyingFamily)) {
                    family2 = null;
                }
                if ((ModNamingIdentifyingFamily)family2 == null) {
                    continue;
                }
                if (f == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.families.ModNamingIdentifyingFamily<out com.intellij.database.dialects.oracle.model.OraSchemaObject>");
                }
                if (renew) {
                    oraSchemaObject = (OraSchemaObject)family.renew((long)objectId, objectName);
                } else {
                    basicModNamedElement = family.createOrGet(objectName);
                    boolean bl5 = false;
                    boolean bl6 = false;
                    OraSchemaObject $this$apply = (OraSchemaObject)basicModNamedElement;
                    boolean bl7 = false;
                    OraSchemaObject oraSchemaObject2 = $this$apply;
                    Intrinsics.checkNotNullExpressionValue((Object)oraSchemaObject2, (String)"this");
                    oraSchemaObject2.setObjectId(objectId);
                    oraSchemaObject = (OraSchemaObject)basicModNamedElement;
                }
                OraSchemaObject obj2 = oraSchemaObject;
                basicModNamedElement = obj2;
                if (basicModNamedElement instanceof OraTable) {
                    ((OraTable)obj2).setSecondary(isSecondary);
                } else if (basicModNamedElement instanceof OraSequence) {
                    if (((OraSequence)obj2).getCreatedTimestamp() == null) {
                        CharSequence charSequence = objectName;
                        Regex regex = OraIntrospectorFunctions.getSEQUENCE_SURROGATE_NAME_PATTERN();
                        boolean bl8 = false;
                        ((OraSequence)obj2).setNameSurrogate(regex.matches(charSequence));
                    }
                } else if (basicModNamedElement instanceof OraCollectionType) {
                    CharSequence charSequence = objectName;
                    Regex regex = OraIntrospectorFunctions.getCOLLECTION_TYPE_SURROGATE_NAME_PATTERN();
                    boolean bl9 = false;
                    ((OraCollectionType)obj2).setNameSurrogate(regex.matches(charSequence));
                }
                affectedFamilies.add(family);
            }
            catch (NumberFormatException e2) {
                String string = String.format("Failed to handle item '%s': %s: %s", item, e2.getClass().getSimpleName(), e2.getMessage());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(\"Failed to handle\u2026ss.simpleName, e.message)");
                this.logWarn(string);
            }
        }
        for (ModNamingIdentifyingFamily family : affectedFamilies) {
            family.sort();
        }
        BaseIntrospector this_$iv = this;
        boolean $i$f$trace = false;
        if (BaseIntrospector.access$getTracing$p(this_$iv)) {
            BaseIntrospector baseIntrospector = this_$iv;
            boolean bl = false;
            StringBuilder b = new StringBuilder();
            b.append("Updated names:");
            Object[] objectArray = schemas2.getValues();
            int n7 = objectArray.length;
            for (n = 0; n < n7; ++n) {
                Object ss1;
                Object object = ss1 = objectArray[n];
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.introspector.OraIntrospector.OraSchemaStat");
                }
                OraSchemaStat ss = (OraSchemaStat)object;
                b.append("\n\t").append(ss.getSchema().getName()).append(':');
                Set<Map.Entry<ObjectKind, Integer>> set = ss.getStats().entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"ss.stats.entries");
                CollectionsKt.joinTo$default((Iterable)set, (Appendable)b, (CharSequence)"", null, null, (int)0, null, (Function1)processTheNames.2.1.INSTANCE, (int)60, null);
            }
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"b.toString()");
            String string10 = string;
            BaseIntrospector.access$trace(baseIntrospector, string10);
        }
    }

    @Override
    @NotNull
    protected BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<OraRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull OraRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new OraDatabaseFirstRetriever(transaction, CollectionsKt.emptyList(), false);
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractSchemaRetriever<OraSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull OraSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new OraSchemaRetriever(transaction, schema);
    }

    private final void processSynonyms(List<OraIntroQueries.OneSynonym> ss, OraRoot root2) {
        Set affectedSchemas = new HashSet();
        for (OraIntroQueries.OneSynonym s : ss) {
            OraSchema schema;
            OraSynonym synonym2;
            if ((OraSchema)root2.getSchemas().get(s.synonym_schema_name) == null) {
                continue;
            }
            OraSynonym oraSynonym = synonym2 = (OraSynonym)schema.getSynonyms().renew(s.synonym_id, s.synonym_name);
            Intrinsics.checkNotNullExpressionValue((Object)oraSynonym, (String)"synonym");
            String string = s.origin_db_link;
            oraSynonym.setTargetDbLinkName(string != null ? this.dbIntern(string) : null);
            String string2 = s.origin_schema_name;
            synonym2.setTargetSchemaName(string2 != null ? this.dbIntern(string2) : null);
            String string3 = s.origin_object_name;
            synonym2.setTargetObjectName(string3 != null ? this.dbIntern(string3) : null);
            OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(synonym2, s.created_timestamp, s.modified_timestamp);
            synonym2.getTargetObject();
            affectedSchemas.add(schema);
        }
        for (OraSchema schema : affectedSchemas) {
            schema.getSynonyms().sort();
        }
    }

    private final void logExpectedOraError(DBException e2) {
        String message2 = "Expected Oracle error " + e2.vendorErrorCode + ": " + e2.getMessage();
        this.trace(message2);
        this.log.debug(message2);
    }

    public OraIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.ORACLE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.ORACLE");
        super(dbms, project, modelFactory);
        OraIntroQueries oraIntroQueries = OraIntroQueries.QUERIES;
        Intrinsics.checkNotNullExpressionValue((Object)oraIntroQueries, (String)"QUERIES");
        this.queries = oraIntroQueries;
        this.introspectorVersion$1 = 200820;
        this.introspectorKindVersions$1 = introspectorKindVersions;
        this.useXML = true;
    }

    static {
        Companion = new Companion(null);
        introspectorKindVersions = MapsKt.mapOf((Pair)TuplesKt.to((Object)ObjectKind.ROUTINE, (Object)200820));
        adjustXmlContextCommand = "declare\n    ctx binary_integer := ?;\nbegin  \n    dbms_xmlGen.setRowSetTag(ctx, '_:retrieving_objects:_');  \n    dbms_xmlGen.setRowTag(ctx, '_:object_element:_');  \n    dbms_xmlGen.setConvertSpecialChars(ctx, false);  \nend;";
        closeXmlContextCommand = "begin  \n    dbms_xmlGen.closeContext(?);  \nend;";
        retrieveXmlContentQuery = new SqlQuery("select dbms_xmlGen.getXml(?) from dual", Layouts.singleOf(String.class));
    }

    public static final /* synthetic */ OraCatalogAccessPermissions access$getCatalogPermissions$p(OraIntrospector $this) {
        OraCatalogAccessPermissions oraCatalogAccessPermissions = $this.catalogPermissions;
        if (oraCatalogAccessPermissions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"catalogPermissions");
        }
        return oraCatalogAccessPermissions;
    }

    public static final /* synthetic */ void access$setCatalogPermissions$p(OraIntrospector $this, OraCatalogAccessPermissions oraCatalogAccessPermissions) {
        $this.catalogPermissions = oraCatalogAccessPermissions;
    }

    public static final /* synthetic */ OraRoot access$getRoot$p(OraIntrospector $this) {
        return (OraRoot)$this.getRoot();
    }

    public static final /* synthetic */ void access$setSessionInfo$p(OraIntrospector $this, OraIntroQueries.OneSessionInfo oneSessionInfo) {
        $this.sessionInfo = oneSessionInfo;
    }

    public static final /* synthetic */ void access$trace(OraIntrospector $this, Function0 messageProducer) {
        $this.trace((Function0<String>)messageProducer);
    }

    public static final /* synthetic */ Object access$parseStatement(OraIntrospector $this, String src2) {
        return $this.parseStatement(src2);
    }

    public static final /* synthetic */ void access$setUseXML$p(OraIntrospector $this, boolean bl) {
        $this.useXML = bl;
    }

    public static final /* synthetic */ void access$writeSources(OraIntrospector $this, Function0 r) {
        $this.writeSources((Function0<Unit>)r);
    }

    public static final /* synthetic */ Object access$retrieveSmallSafe(OraIntrospector $this, DBTransaction tran, SqlQuery query) {
        return $this.retrieveSmallSafe(tran, query);
    }

    public static final /* synthetic */ boolean access$checkQueryReturnRows(OraIntrospector $this, DBTransaction tran, SqlQuery query) {
        return $this.checkQueryReturnRows(tran, (SqlQuery<Boolean>)query);
    }

    public static final /* synthetic */ void access$inTransactionUnit(OraIntrospector $this, Function1 block) {
        $this.inTransactionUnit((Function1<DBTransaction, Unit>)block);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.oracle"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return version.isOrGreater(new int[]{9});
        }

        @NotNull
        public OraIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new OraIntrospector(project, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return OraIntrospectorFunctions.canCheckOutdated(e2);
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.oracle"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
                Map map2 = vERSION.getMyVersions();
                ObjectKind objectKind = ObjectKind.PACKAGE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PACKAGE");
                ObjectKind objectKind2 = ObjectKind.PACKAGE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"PACKAGE");
                map2.put(objectKind, vERSION.get(objectKind2) + 2);
                Map map3 = vERSION.getMyVersions();
                ObjectKind objectKind3 = ObjectKind.OBJECT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"OBJECT_TYPE");
                ObjectKind objectKind4 = ObjectKind.OBJECT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"OBJECT_TYPE");
                map3.put(objectKind3, vERSION.get(objectKind4) + 2);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraSchemaStat;", "", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "(Lcom/intellij/database/dialects/oracle/model/OraSchema;)V", "getSchema", "()Lcom/intellij/database/dialects/oracle/model/OraSchema;", "stats", "Ljava/util/TreeMap;", "Lcom/intellij/database/model/ObjectKind;", "", "getStats", "()Ljava/util/TreeMap;", "intellij.database.dialects.oracle"})
    public static final class OraSchemaStat {
        @NotNull
        private final TreeMap<ObjectKind, Integer> stats;
        @NotNull
        private final OraSchema schema;

        @NotNull
        public final TreeMap<ObjectKind, Integer> getStats() {
            return this.stats;
        }

        @NotNull
        public final OraSchema getSchema() {
            return this.schema;
        }

        public OraSchemaStat(@NotNull OraSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this.schema = schema;
            this.stats = new TreeMap();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0005\b\u00a2\u0004\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u00020\u0001R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001f0\u001dH\u0002J\u001e\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\"\u001a\u00020\rH\u0004J\b\u0010#\u001a\u00020\u0016H\u0002J0\u0010$\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001e0%2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001f0\u001dH\u0014J0\u0010&\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001f0\u001dH\u0002J8\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001f0\u001dH\u0002J\b\u0010(\u001a\u00020\u0016H\u0016J\b\u0010)\u001a\u00020\u0016H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "affectedSchemaIds", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "getAffectedSchemaIds", "()Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "isSystem", "", "()Z", "setSystem", "(Z)V", "adjustNativeStatements", "", "", "text", "chopListAndRetrieveNativeDefinitions", "", "portionType", "Lcom/intellij/database/dialects/oracle/introspector/PortionType;", "elements", "", "Lcom/intellij/database/dialects/oracle/model/OraSchemaObject;", "result", "", "Lcom/intellij/database/model/basic/BasicElement;", "", "prepareParameters", "schemas", "glutton", "retrieveAllUsers", "retrieveNativeDefinitions", "", "retrieveNativeDefinitionsPortion", "retrieveNativeDefinitionsPortionSafe", "retrieveObjects", "retrieveTablespaces", "intellij.database.dialects.oracle"})
    private abstract class OraDatabaseRetriever
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<OraRoot> {
        @NotNull
        private final IntOpenHashSet affectedSchemaIds;
        private boolean isSystem;

        @NotNull
        public final IntOpenHashSet getAffectedSchemaIds() {
            return this.affectedSchemaIds;
        }

        public final boolean isSystem() {
            return this.isSystem;
        }

        public final void setSystem(boolean bl) {
            this.isSystem = bl;
        }

        protected final void prepareParameters(@NotNull List<? extends OraSchema> schemas2, boolean glutton) {
            Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
            this.setQueryParameter(glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter("CATDU", OraIntrospector.this.getCatalogPermissions().getAccessDBA() ? "sys.DBA" : "sys.USER");
            this.setQueryParameter("ALL_SCHEMA_IDS", schemas2.stream().map(prepareParameters.1.INSTANCE).toArray());
            this.setQueryParameter("ALL_SCHEMA_NAMES", schemas2.stream().map(prepareParameters.2.INSTANCE).toArray());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            List filteredElements = CollectionsKt.filterIsInstance(elements2, OraSchemaObject.class);
            int n = filteredElements.size();
            if (n == 0) {
                return;
            }
            PortionType portionType = OraIntrospectorFunctions.applicablePortionTypeFor(n);
            if (portionType == PortionType.ALL) {
                int stepSize = PortionType.NORMAL.getSize();
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)stepSize);
                int n2 = intProgression.getFirst();
                int n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                int n5 = n2;
                int n6 = n3;
                if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
                    while (true) {
                        void offset;
                        void var11_12 = offset + stepSize;
                        boolean bl = false;
                        List portion = filteredElements.subList((int)offset, Math.min((int)var11_12, n));
                        PortionType pt = OraIntrospectorFunctions.applicablePortionTypeFor(portion.size());
                        this.retrieveNativeDefinitionsPortionSafe(pt, portion, result2);
                        if (offset != n3) {
                            offset += n4;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.retrieveNativeDefinitionsPortionSafe(portionType, filteredElements, result2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void chopListAndRetrieveNativeDefinitions(PortionType portionType, List<? extends OraSchemaObject> elements2, Map<BasicElement, String[]> result2) {
            PortionType portionType2;
            switch (OraIntrospector$OraDatabaseRetriever$WhenMappings.$EnumSwitchMapping$0[portionType.ordinal()]) {
                case 1: {
                    portionType2 = PortionType.NORMAL;
                    break;
                }
                case 2: {
                    portionType2 = PortionType.SMALL;
                    break;
                }
                case 3: {
                    portionType2 = PortionType.ONE;
                    break;
                }
                case 4: {
                    throw (Throwable)new IllegalArgumentException("A portion of one element cannot be split into several portions");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            PortionType nextPortion = portionType2;
            int stepSize = nextPortion.getSize();
            int n = elements2.size();
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)stepSize);
            int n2 = intProgression.getFirst();
            int n3 = intProgression.getLast();
            int n4 = intProgression.getStep();
            int n5 = n2;
            int n6 = n3;
            if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void offset;
                    void var11_12 = offset + stepSize;
                    boolean bl = false;
                    List<? extends OraSchemaObject> portion = elements2.subList((int)offset, Math.min((int)var11_12, n));
                    PortionType pt = OraIntrospectorFunctions.applicablePortionTypeFor(portion.size());
                    this.retrieveNativeDefinitionsPortionSafe(pt, portion, result2);
                    if (offset == n3) break;
                    offset += n4;
                }
            }
        }

        private final void retrieveNativeDefinitionsPortionSafe(PortionType portionType, List<? extends OraSchemaObject> elements2, Map<BasicElement, String[]> result2) {
            try {
                this.retrieveNativeDefinitionsPortion(elements2, result2);
            }
            catch (DBException e2) {
                if (portionType.compareTo((Enum)PortionType.ONE) > 0) {
                    this.chopListAndRetrieveNativeDefinitions(portionType, elements2, result2);
                }
                OraSchemaObject element = (OraSchemaObject)CollectionsKt.first(elements2);
                String comment = "-- failed to obtain definition for " + element + ":\n--\t" + e2.getMessage();
                result2.put((BasicElement)element, new String[]{comment});
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveNativeDefinitionsPortion(List<? extends OraSchemaObject> elements2, Map<BasicElement, String[]> result2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = elements2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                OraSchemaObject oraSchemaObject = (OraSchemaObject)item$iv$iv;
                Collection collection2 = collection;
                boolean bl = false;
                Long l = it.getObjectId();
                collection2.add(l);
            }
            long[] identifiers = CollectionsKt.toLongArray((Collection)((List)collection));
            Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"identifiers", (Object)identifiers));
            SqlQuery<List<OraIntroQueries.OneNativeDefinition>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveNativeDefinitions;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveNativeDefinitions");
            List<OraIntroQueries.OneNativeDefinition> entries = this.performQuery(sqlQuery, params2, new Object[0]);
            MultiMap map2 = new MultiMap();
            for (OraIntroQueries.OneNativeDefinition oneNativeDefinition : entries) {
                Long l = oneNativeDefinition.object_id;
                String string = oneNativeDefinition.text;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.text");
                map2.putValues((Object)l, this.adjustNativeStatements(string));
            }
            for (OraSchemaObject oraSchemaObject : elements2) {
                Collection $this$toTypedArray$iv;
                Intrinsics.checkNotNullExpressionValue((Object)map2.get((Object)oraSchemaObject.getObjectId()), (String)"map[element.objectId]");
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                result2.put((BasicElement)oraSchemaObject, stringArray);
            }
        }

        private final Collection<String> adjustNativeStatements(String text) {
            CharSequence charSequence = text;
            boolean bl = false;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String txt = ((Object)StringsKt.trim((CharSequence)string)).toString();
            charSequence = txt;
            bl = false;
            if (charSequence.length() == 0) {
                return SetsKt.emptySet();
            }
            charSequence = txt;
            Regex regex = OraIntrospectorFunctions.getNATIVE_TRIGGER_DEFINITION_PATTERN();
            boolean bl2 = false;
            if (regex.matches(charSequence)) {
                int p = StringsKt.indexOf$default((CharSequence)txt, (String)"ALTER TRIGGER \"", (int)0, (boolean)false, (int)6, null);
                if (p > 0) {
                    String string2 = txt;
                    int n = 0;
                    boolean bl3 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n, p);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string4;
                    n = 0;
                    String string5 = string2;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String stmt1 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                    String string6 = txt;
                    bl3 = false;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(p);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                    string6 = string8;
                    bl3 = false;
                    String string9 = string6;
                    if (string9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String stmt2 = ((Object)StringsKt.trim((CharSequence)string9)).toString();
                    return CollectionsKt.listOf((Object[])new String[]{stmt1, stmt2});
                }
                Set<String> set = Collections.singleton(txt);
                Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(txt)");
                return set;
            }
            Set<String> set = Collections.singleton(txt);
            Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(txt)");
            return set;
        }

        @Override
        public void retrieveObjects() {
            super.retrieveObjects();
            this.retrieveTablespaces();
            this.retrieveAllUsers();
        }

        private final void retrieveTablespaces() {
            List list;
            SqlQuery<Long> hashQuery;
            SqlQuery<Long> sqlQuery = hashQuery = OraIntrospector.this.getCatalogPermissions().getAccessDBA() ? ((OraIntrospector)OraIntrospector.this).queries.calculateTablespacesHashDba : ((OraIntrospector)OraIntrospector.this).queries.calculateTablespacesHashUser;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"hashQuery");
            Long l = this.performQuery(sqlQuery);
            long actualHash = l != null ? l : 0L;
            long savedHash = OraIntrospector.access$getRoot$p(OraIntrospector.this).getTablespacesHash();
            OraIntrospector.this.trace("Tablespaces actual calculated hash: " + actualHash + ", old saved hash: " + savedHash);
            if (OraIntrospector.access$getRoot$p(OraIntrospector.this).getTablespacesHash() == actualHash) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneTablespace>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveTablespaces;
            Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"queries.retrieveTablespaces");
            List ts2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery2, null, 0, 6, null);
            if (OraIntrospector.this.getCatalogPermissions().getAccessDBA()) {
                SqlQuery<List<OraIntroQueries.OneDataFile>> sqlQuery3 = ((OraIntrospector)OraIntrospector.this).queries.retrieveDataFiles;
                Intrinsics.checkNotNullExpressionValue(sqlQuery3, (String)"queries.retrieveDataFiles");
                list = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery3, null, 0, 6, null);
            } else {
                list = CollectionsKt.emptyList();
            }
            List dfs = list;
            OraIntrospector.this.trace("Retrieved " + ts2.size() + " tablespaces and " + dfs.size() + " data files");
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(ts2, dfs, actualHash){
                final /* synthetic */ List $ts;
                final /* synthetic */ List $dfs;
                final /* synthetic */ long $actualHash;

                public final void invoke(@NotNull OraRoot root2) {
                    OraTablespace tablespace;
                    Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                    ModNamingFamily<? extends OraTablespace> modNamingFamily = root2.getTablespaces();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"root.tablespaces");
                    ModNamingFamily<? extends OraTablespace> tablespaces = modNamingFamily;
                    tablespaces.markChildrenAsSyncPending();
                    for (OraIntroQueries.OneTablespace t : this.$ts) {
                        OraTablespace oraTablespace = tablespace = (OraTablespace)tablespaces.createOrGet(t.name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraTablespace, (String)"tablespace");
                        oraTablespace.setBlockSize(t.block_size);
                        tablespace.setContentCategory(OraTablespaceContentCategory.Companion.of(t.content_category));
                        tablespace.setLogging(OraTablespaceLogging.Companion.of(t.logging));
                        tablespace.setStatus(OraTablespaceStatus.Companion.of(t.status));
                        tablespace.setBigFile(t.bigfile);
                        tablespace.setLocalExtentManagement(t.local_extent_management);
                        tablespace.setAutoSegmentManagement(t.auto_segment_management);
                        tablespace.getDataFiles().markChildrenAsSyncPending();
                    }
                    tablespaces.removeSyncPendingChildren();
                    for (OraIntroQueries.OneDataFile df : this.$dfs) {
                        OraDataFile datafile;
                        if ((OraTablespace)tablespaces.get(df.tablespace_name) == null) {
                            continue;
                        }
                        OraDataFile oraDataFile = datafile = (OraDataFile)tablespace.getDataFiles().renewAt(df.position, df.file_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraDataFile, (String)"datafile");
                        oraDataFile.setFileId(df.file_id);
                        datafile.setFileSize(df.file_size);
                        datafile.setUserSize(df.user_size);
                        datafile.setIncrementBy(df.increment_by);
                        datafile.setMaxSize(df.max_size);
                        datafile.setAutoExtensible(df.auto_extensible);
                        datafile.setAvailabilityStatus(OraDataFileAvailabilityStatus.Companion.of(df.availability_status));
                        datafile.setOnlineStatus(OraDataFileOnlineStatus.Companion.of(df.online_status));
                    }
                    Iterator iterator = tablespaces.iterator();
                    while (iterator.hasNext()) {
                        OraTablespace tablespace2;
                        OraTablespace oraTablespace = tablespace2 = (OraTablespace)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)oraTablespace, (String)"tablespace");
                        oraTablespace.getDataFiles().removeSyncPendingChildren();
                        tablespace2.getDataFiles().sort();
                    }
                    root2.setTablespacesHash(this.$actualHash);
                }
                {
                    this.$ts = list;
                    this.$dfs = list2;
                    this.$actualHash = l;
                    super(1);
                }
            });
        }

        private final void retrieveAllUsers() {
            SqlQuery<List<OraIntroQueries.OneUser>> query = OraIntrospector.this.getCatalogPermissions().getAccessDBA() ? ((OraIntrospector)OraIntrospector.this).queries.retrieveDbaUsers : ((OraIntrospector)OraIntrospector.this).queries.retrieveUserUsers;
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this, query){
                final /* synthetic */ OraDatabaseRetriever this$0;
                final /* synthetic */ SqlQuery $query;

                public final void invoke(@NotNull OraRoot r) {
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    SqlQuery sqlQuery = this.$query;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlQuery, (String)"query");
                    BaseIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, sqlQuery, 0, (Function1)new Function1<OraIntroQueries.OneUser, Unit>(r){
                        final /* synthetic */ OraRoot $r;

                        public final void invoke(OraIntroQueries.OneUser u) {
                            block0: {
                                OraUser oraUser = (OraUser)this.$r.getUsers().getByObjectId(u.user_id);
                                if (oraUser == null) break block0;
                                OraUser oraUser2 = oraUser;
                                boolean bl = false;
                                boolean bl2 = false;
                                OraUser $this$apply = oraUser2;
                                boolean bl3 = false;
                                String string = u.account_status;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"u.account_status");
                                $this$apply.setLocked(StringsKt.contains$default((CharSequence)string, (CharSequence)"LOCKED", (boolean)false, (int)2, null));
                                String string2 = u.account_status;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"u.account_status");
                                $this$apply.setExpired(StringsKt.contains$default((CharSequence)string2, (CharSequence)"EXPIRED", (boolean)false, (int)2, null));
                                $this$apply.setDefaultTablespace(u.default_tablespace);
                                $this$apply.setTemporaryTablespace(u.temporary_tablespace);
                            }
                        }
                        {
                            this.$r = oraRoot;
                            super(1);
                        }
                    }, 2, null);
                }
                {
                    this.this$0 = oraDatabaseRetriever;
                    this.$query = sqlQuery;
                    super(1);
                }
            });
        }

        public OraDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(OraIntrospector.this, transaction);
            this.affectedSchemaIds = new IntOpenHashSet();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseFirstRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schemas", "", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "glutton", "", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Ljava/util/List;Z)V", "prepareParameters", "", "process", "retrieveAllOrdinaryNames", "retrieveAllSynonyms", "intellij.database.dialects.oracle"})
    private final class OraDatabaseFirstRetriever
    extends OraDatabaseRetriever {
        private final List<OraSchema> schemas;
        private final boolean glutton;

        private final void prepareParameters() {
            this.prepareParameters(this.schemas, this.glutton);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void process() {
            void var3_3;
            void _true_$iv;
            void $this$choose$iv;
            boolean bl = this.isSystem();
            String string = "SYSTEM";
            String _false_$iv = "REGULAR";
            boolean $i$f$choose = false;
            OraIntrospector.this.trace(StringFun.centerAndPadAsTitle((String)("ORACLE FULL DATABASE RETRIEVER (" + (String)($this$choose$iv != false ? _true_$iv : var3_3) + ')'), (int)140, (char)'='));
            this.prepareParameters();
            this.retrieveObjects();
            this.retrieveAllOrdinaryNames();
            this.retrieveAllSynonyms();
        }

        private final void retrieveAllOrdinaryNames() {
            SqlQuery<List<String>> query;
            OraIntrospector.this.reportRetrieving("Major Object Names", "introspection.retrieve.majorObjectNames");
            SqlQuery<List<String>> sqlQuery = query = OraIntrospector.this.getCatalogPermissions().getFast() ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNames;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
            List items = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 8192, 2, null);
            OraIntrospector.this.trace("Retrieved " + items.size() + " major names");
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this, items){
                final /* synthetic */ OraDatabaseFirstRetriever this$0;
                final /* synthetic */ List $items;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                    for (OraSchema schema : OraDatabaseFirstRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root2.mod((BasicSchema)schema);
                        if (basicModSchema == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraSchema");
                        }
                        OraSchema ms = (OraSchema)basicModSchema;
                        ms.getSequences().clear();
                        ms.getObjectTypes().clear();
                        ms.getCollectionTypes().clear();
                        ms.getTables().clear();
                        ms.getMatViews().clear();
                        ms.getViews().clear();
                        ms.getPackages().clear();
                        ms.getRoutines().clear();
                    }
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    ModNamingIdentifyingFamily<? extends OraSchema> modNamingIdentifyingFamily = root2.getSchemas();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"root.schemas");
                    OraIntrospector.access$processNames(oraIntrospector, this.$items, modNamingIdentifyingFamily, false, this.this$0.getAffectedSchemaIds());
                }
                {
                    this.this$0 = oraDatabaseFirstRetriever;
                    this.$items = list;
                    super(1);
                }
            });
        }

        private final void retrieveAllSynonyms() {
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraIntrospector.this.trace("Retrieved " + ss.size() + " synonyms");
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this, ss){
                final /* synthetic */ OraDatabaseFirstRetriever this$0;
                final /* synthetic */ List $ss;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                    OraIntrospector.access$processSynonyms(this.this$0.OraIntrospector.this, this.$ss, root2);
                }
                {
                    this.this$0 = oraDatabaseFirstRetriever;
                    this.$ss = list;
                    super(1);
                }
            });
        }

        public OraDatabaseFirstRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas2, boolean glutton) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
            super(transaction);
            this.schemas = schemas2;
            this.glutton = glutton;
        }

        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseFirstRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseIncRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schemas", "", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "glutton", "", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Ljava/util/List;Z)V", "since", "Ljava/util/Date;", "determineAndRemoveAllDroppedStuff", "", "prepareParameters", "process", "retrieveAllOrdinaryNames", "root", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "retrieveAllSynonyms", "intellij.database.dialects.oracle"})
    private final class OraDatabaseIncRetriever
    extends OraDatabaseRetriever {
        private Date since;
        private final List<OraSchema> schemas;
        private final boolean glutton;

        /*
         * WARNING - void declaration
         */
        @Override
        public void process() {
            Timestamp timestamp;
            void _true_$iv;
            void $this$choose$iv;
            boolean bl = this.isSystem();
            String string = "SYSTEM";
            String _false_$iv = "REGULAR";
            boolean $i$f$choose = false;
            OraIntrospector.this.trace(StringFun.centerAndPadAsTitle((String)("ORACLE INCREMENTAL DATABASE RETRIEVER (" + (String)($this$choose$iv != false ? _true_$iv : _false_$iv) + ')'), (int)140, (char)'='));
            this.prepareParameters();
            this.retrieveObjects();
            this.determineAndRemoveAllDroppedStuff();
            OraIntroQueries.OneSessionInfo theSessionInfo = OraIntrospector.this.sessionInfo;
            if (theSessionInfo != null) {
                timestamp = theSessionInfo.now;
            } else {
                OraIntrospector.this.trace("The session info is not retrieved yet, so retrieving the current server time explicitly");
                DBTransaction dBTransaction = this.getTransaction();
                SqlQuery<Timestamp> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.askForTimeNow;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.askForTimeNow");
                timestamp = (Timestamp)IntrospectionQueryContext.runQuery$default((IntrospectionQueryContext)this, dBTransaction, sqlQuery, null, null, 6, null);
            }
            Timestamp oracleTimeNow = timestamp;
            StringBuilder b = new StringBuilder();
            StringBuilder stringBuilder = b.append("Oracle time now: ");
            Timestamp timestamp2 = oracleTimeNow;
            Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"oracleTimeNow");
            stringBuilder.append(CalendarFun.export((Date)timestamp2)).append("\n");
            b.append("Schemas:\n");
            long sinceTime = oracleTimeNow.getTime() - 999L;
            for (OraSchema schema : this.schemas) {
                long s;
                String schemaName;
                Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"schema.name");
                int schemaIntroVersion = schema.getIntrospectionVersion();
                Date schemaIntroTimestamp = schema.getIntrospectionTimestamp();
                StringBuilder stringBuilder2 = b.append('\t').append(schemaName).append(" v.").append(schemaIntroVersion).append(" at ");
                Object object = schemaIntroTimestamp;
                if (object == null || (object = CalendarFun.export((Date)object)) == null) {
                    object = "N/A";
                }
                stringBuilder2.append((String)object).append('\n');
                if (schemaIntroTimestamp == null || (s = schemaIntroTimestamp.getTime()) >= sinceTime) continue;
                sinceTime = s;
            }
            this.since = new Timestamp(sinceTime);
            b.append("Introspecting since ").append(CalendarFun.export((Date)this.since));
            String string2 = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"b.toString()");
            OraIntrospector.this.trace(string2);
            this.setQueryParameter("INC", Boolean.TRUE);
            this.setQueryParameter("SINCE", this.since);
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                    OraDatabaseIncRetriever.access$retrieveAllOrdinaryNames(this.this$0, root2);
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    super(1);
                }
            });
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                    OraDatabaseIncRetriever.access$retrieveAllSynonyms(this.this$0, root2);
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    super(1);
                }
            });
            BaseIntrospector this_$iv = OraIntrospector.this;
            boolean $i$f$trace = false;
            if (BaseIntrospector.access$getTracing$p(this_$iv)) {
                BaseIntrospector baseIntrospector = this_$iv;
                boolean bl2 = false;
                int n = this.getAffectedSchemaIds().size();
                String string3 = n > 0 ? "Affected " + n + " schemas: \n" + SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.schemas), (Function1)((Function1)new Function1<OraSchema, Boolean>(this){
                    final /* synthetic */ OraDatabaseIncRetriever this$0;
                    {
                        this.this$0 = oraDatabaseIncRetriever;
                        super(1);
                    }

                    public final boolean invoke(@NotNull OraSchema schema) {
                        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                        return this.this$0.getAffectedSchemaIds().contains((int)schema.getObjectId());
                    }
                })), (CharSequence)"\n", null, null, (int)0, null, (Function1)process.3.2.INSTANCE, (int)30, null) : "No affected schemas";
                BaseIntrospector.access$trace(baseIntrospector, string3);
            }
        }

        private final void prepareParameters() {
            this.prepareParameters(this.schemas, this.glutton);
        }

        private final void determineAndRemoveAllDroppedStuff() {
            SqlQuery<long[]> query;
            OraIntrospector.this.reportRetrieving("determining dropped objects", "introspection.retrieve.droppedObjects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.getCatalogPermissions().getFast() ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiers;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            OraIntrospector.this.trace("Listed " + idsArray.length + " live objects");
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this, identifiers){
                final /* synthetic */ OraDatabaseIncRetriever this$0;
                final /* synthetic */ TLongHashSet $identifiers;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                    for (OraSchema schema : OraDatabaseIncRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root2.mod((BasicSchema)schema);
                        if (basicModSchema == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraSchema");
                        }
                        OraSchema s = (OraSchema)basicModSchema;
                        OraIntrospectorFunctions.dropUnexistentObjectsInSchema(s, this.$identifiers);
                    }
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    this.$identifiers = tLongHashSet;
                    super(1);
                }
            });
        }

        private final void retrieveAllOrdinaryNames(OraRoot root2) {
            SqlQuery<List<String>> query;
            OraIntrospector.this.reportRetrieving("major object names", "introspection.retrieve.majorObjectNames");
            ModNamingIdentifyingFamily<? extends OraSchema> modNamingIdentifyingFamily = root2.getSchemas();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"root.schemas");
            ModNamingIdentifyingFamily<? extends OraSchema> modelSchemas = modNamingIdentifyingFamily;
            SqlQuery<List<String>> sqlQuery = query = OraIntrospector.this.getCatalogPermissions().getFast() ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNames;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
            List items = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            OraIntrospector.this.processNames(items, (ModNamingIdentifyingFamily<? extends OraSchema>)modelSchemas, true, this.getAffectedSchemaIds());
        }

        private final void retrieveAllSynonyms(OraRoot root2) {
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraIntrospector.this.processSynonyms(ss, root2);
        }

        public OraDatabaseIncRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas2, boolean glutton) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
            super(transaction);
            this.since = BaseIntrospectionFunctions.AGES_AGO;
            this.schemas = schemas2;
            this.glutton = glutton;
        }

        public static final /* synthetic */ void access$retrieveAllOrdinaryNames(OraDatabaseIncRetriever $this, OraRoot root2) {
            $this.retrieveAllOrdinaryNames(root2);
        }

        public static final /* synthetic */ void access$retrieveAllSynonyms(OraDatabaseIncRetriever $this, OraRoot root2) {
            $this.retrieveAllSynonyms(root2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ba\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0014\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u000105H\u0002J\b\u00106\u001a\u000207H\u0002J\u0018\u00108\u001a\u0002072\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020;H\u0002J0\u0010<\u001a\u0002072\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00110>2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001d0AH\u0002J&\u0010B\u001a\u0002072\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00110HH\u0002J\u0018\u0010I\u001a\u0002072\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0002J\u0018\u0010I\u001a\u0002072\u0006\u0010J\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0011H\u0002J\u0018\u0010P\u001a\u0002072\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0002J\u0016\u0010U\u001a\u0002072\f\u0010V\u001a\b\u0012\u0004\u0012\u00020X0WH\u0002J\b\u0010Y\u001a\u000207H\u0014J\b\u0010Z\u001a\u000207H\u0002J\u001a\u0010[\u001a\u0002072\u0006\u0010\\\u001a\u00020\u00142\b\u0010O\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010]\u001a\u0002072\u0006\u00109\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u0011H\u0002J\u0018\u0010^\u001a\u0002072\u0006\u0010_\u001a\u00020\u00182\u0006\u0010O\u001a\u00020\u0011H\u0002J\u0018\u0010`\u001a\u0002072\u0006\u0010a\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020\u0011H\u0002J*\u0010b\u001a\u0002072\f\u0010c\u001a\b\u0012\u0004\u0012\u00020e0d2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00110gH\u0002J\b\u0010h\u001a\u000207H\u0002J0\u0010i\u001a\u0004\u0018\u00010\u00112\f\u0010j\u001a\b\u0012\u0004\u0012\u0002010k2\u0016\b\u0002\u0010l\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020m\u0018\u00010AH\u0002J.\u0010n\u001a\u0004\u0018\u00010\u00112\f\u0010j\u001a\b\u0012\u0004\u0012\u0002010k2\u0006\u0010o\u001a\u00020\u00112\f\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00110WH\u0002J\b\u0010q\u001a\u000207H\u0014J\b\u0010r\u001a\u000207H\u0016J\b\u0010s\u001a\u000207H\u0002J*\u0010t\u001a\u0002072\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110H2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00110gH\u0002J@\u0010v\u001a\u0002072\u0014\u0010j\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020e0H0k2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110H2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00110gH\u0002J*\u0010w\u001a\u0002072\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110H2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00110gH\u0002J*\u0010x\u001a\u0002072\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110W2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00110gH\u0002J\b\u0010y\u001a\u000207H\u0002J\b\u0010z\u001a\u000207H\u0002J\b\u0010{\u001a\u000207H\u0002J\b\u0010|\u001a\u000207H\u0002J\u001c\u0010}\u001a\u0002072\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001d0AH\u0002J\u001c\u0010~\u001a\u0002072\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001d0AH\u0002J\b\u0010\u007f\u001a\u000207H\u0002J\t\u0010\u0080\u0001\u001a\u000207H\u0002J\t\u0010\u0081\u0001\u001a\u000207H\u0002J\t\u0010\u0082\u0001\u001a\u000207H\u0002J\t\u0010\u0083\u0001\u001a\u000207H\u0002J\t\u0010\u0084\u0001\u001a\u000207H\u0002J\t\u0010\u0085\u0001\u001a\u000207H\u0002J\t\u0010\u0086\u0001\u001a\u000207H\u0002J\t\u0010\u0087\u0001\u001a\u000207H\u0002J\t\u0010\u0088\u0001\u001a\u000207H\u0002J\t\u0010\u0089\u0001\u001a\u000207H\u0002J\t\u0010\u008a\u0001\u001a\u000207H\u0002J\t\u0010\u008b\u0001\u001a\u000207H\u0002J\t\u0010\u008c\u0001\u001a\u000207H\u0002J\t\u0010\u008d\u0001\u001a\u000207H\u0002J\t\u0010\u008e\u0001\u001a\u000207H\u0002J\t\u0010\u008f\u0001\u001a\u000207H\u0002J#\u0010\u008f\u0001\u001a\u0002072\u000e\u0010\u0090\u0001\u001a\t\u0012\u0004\u0012\u00020R0\u0091\u00012\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0002J\u001e\u0010\u0094\u0001\u001a\u0002072\u0013\u0010\u0095\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020R0AH\u0002J(\u0010\u0096\u0001\u001a\u0002072\u0013\u0010\u0095\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020R0A2\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0002J\t\u0010\u0097\u0001\u001a\u000207H\u0002J)\u0010\u0098\u0001\u001a\u0002072\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110H2\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009c\u00010\u009b\u0001H\u0002J)\u0010\u009d\u0001\u001a\u0002072\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110H2\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009c\u00010\u009b\u0001H\u0002J\u0007\u0010\u009e\u0001\u001a\u000207J\t\u0010\u009f\u0001\u001a\u000207H\u0014J\t\u0010\u00a0\u0001\u001a\u000207H\u0002J\u0010\u0010\u00a1\u0001\u001a\t\u0012\u0005\u0012\u00030\u009c\u00010WH\u0002J\t\u0010\u00a2\u0001\u001a\u000207H\u0002J\t\u0010\u00a3\u0001\u001a\u000207H\u0002J)\u0010\u00a4\u0001\u001a\u0002072\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110H2\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009c\u00010\u009b\u0001H\u0002J)\u0010\u00a5\u0001\u001a\u0002072\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110H2\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009c\u00010\u009b\u0001H\u0002J\t\u0010\u00a6\u0001\u001a\u000207H\u0002J\t\u0010\u00a7\u0001\u001a\u000207H\u0002J\t\u0010\u00a8\u0001\u001a\u000207H\u0002J\u0018\u0010\u00a9\u0001\u001a\u0002072\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110HH\u0002J\t\u0010\u00aa\u0001\u001a\u000207H\u0002J\t\u0010\u00ab\u0001\u001a\u000207H\u0002J\t\u0010\u00ac\u0001\u001a\u000207H\u0002J\t\u0010\u00ad\u0001\u001a\u000207H\u0002J\t\u0010\u00ae\u0001\u001a\u000207H\u0002J\t\u0010\u00af\u0001\u001a\u000207H\u0002J\t\u0010\u00b0\u0001\u001a\u000207H\u0002J\t\u0010\u00b1\u0001\u001a\u000207H\u0002J\t\u0010\u00b2\u0001\u001a\u000207H\u0002J\t\u0010\u00b3\u0001\u001a\u000207H\u0002J\t\u0010\u00b4\u0001\u001a\u000207H\u0002J\u0015\u0010\u00b5\u0001\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00110AH\u0002J\t\u0010\u00b6\u0001\u001a\u000207H\u0002J\u0010\u0010\u00b7\u0001\u001a\t\u0012\u0005\u0012\u00030\u009c\u00010WH\u0002J\t\u0010\u00b8\u0001\u001a\u000207H\u0002J\u0017\u0010\u00b9\u0001\u001a\b\u0012\u0004\u0012\u00020/0d2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\u00ba\u0001\u001a\u0002072\u0007\u0010\u00bb\u0001\u001a\u00020+2\u0006\u0010-\u001a\u00020+J\u0010\u0010\u00bc\u0001\u001a\u0002072\u0007\u0010\u00bd\u0001\u001a\u00020 J\t\u0010\u00be\u0001\u001a\u00020 H\u0002J\u0016\u0010\u00bf\u0001\u001a\u0005\u0018\u00010\u00c0\u00012\b\u0010\u00c1\u0001\u001a\u00030\u00c2\u0001H\u0002J#\u0010\u00c3\u0001\u001a\u0002072\u000e\u0010\u00c4\u0001\u001a\t\u0012\u0005\u0012\u00030\u00c5\u00010d2\b\u0010\u00c6\u0001\u001a\u00030\u00c7\u0001H\u0002J(\u0010\u00c8\u0001\u001a\u000207*\u00020\u00022\u0007\u0010\u00c9\u0001\u001a\u00020\u00112\u0007\u0010\u00ca\u0001\u001a\u00020\u00112\u0007\u0010\u00cb\u0001\u001a\u00020\u0011H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00cc\u0001"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/oracle/model/OraSchema;)V", "affectedClusters", "Ljava/util/HashSet;", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "affectedDepObjects", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "affectedInnerRoutines", "Lcom/intellij/database/model/basic/BasicRoutine;", "affectedLongMatViews", "", "affectedLongViews", "affectedModuleBodies", "Lcom/intellij/database/dialects/oracle/model/OraBody;", "affectedNormMatViews", "affectedNormViews", "affectedObjectTypeSpecs", "Lcom/intellij/database/dialects/oracle/model/OraObjectType;", "affectedPackageSpecs", "Lcom/intellij/database/dialects/oracle/model/OraPackage;", "affectedSingleRoutines", "affectedTables", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "affectedTriggerTables", "affectsClusters", "", "affectsIndices", "affectsMatLogs", "affectsMatViews", "affectsModulesOrBodies", "affectsTables", "affectsTriggers", "affectsViews", "haveDefaults", "majorModificationsFound", "myBeginTimestamp", "Ljava/sql/Timestamp;", "myFromTimestamp", "srcFromTimestamp", "tablesToReorderDetails", "Lcom/intellij/database/dialects/oracle/model/OraLikeTable;", "textLimit", "", "adjustBigIntegerForSequence", "Ljava/math/BigInteger;", "bigDecimalValue", "Ljava/math/BigDecimal;", "adjustInnerRoutines", "", "applyClusterInfo", "cluster", "c", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneCluster;", "applyDefaults", "defs", "Ljava/util/HashMap;", "Lcom/intellij/database/dialects/oracle/introspector/MajorMinorName;", "tables", "", "applyIndexingItems", "table", "Lcom/intellij/database/model/basic/BasicTable;", "index", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "items", "", "applyRoutineSource", "routine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "psiRoutine", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "Lcom/intellij/database/dialects/oracle/model/OraSingleRoutine;", "text", "applyRoutineSources", "module", "Lcom/intellij/database/dialects/oracle/model/OraModule;", "psiModule", "Lcom/intellij/sql/psi/SqlCreateStatement;", "applySourceLines", "lines", "", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSrcLine;", "clearSchema", "determineAndRemoveDroppedStuff", "determineWhetherTheBodyObfuscated", "body", "extractClusterColumns", "extractObjectTypeChildren", "objectType", "extractPackageChildren", "pkg", "fetchMinorTexts", "rows", "", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneMinorText;", "texts", "", "finalizeIntrospection", "performQueryReturningXml", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "namedParameters", "", "performQueryReturningXmlForStringLiterals", "paramName", "paramValues", "prepareParameters", "process", "reorderTableDetails", "retrieveCheckPredicates12", "predicates", "retrieveCheckPredicates12orLong", "retrieveCheckPredicatesLong", "retrieveCheckPredicatesXml", "retrieveChecks", "retrieveClusterIndices", "retrieveClusters", "retrieveCollectionTypes", "retrieveColumnDefaultsLong", "retrieveColumnDefaultsNorm", "retrieveColumns", "retrieveComments", "retrieveConstraintColumns", "retrieveDbLinks", "retrieveDebugInfoPresence", "retrieveDependencies", "retrieveDependenciesFast", "retrieveDependenciesSlow", "retrieveEntireSchema", "retrieveErrors", "retrieveForeignKeys", "retrieveFragment", "retrieveFragmentNewObjectNames", "retrieveHashRelatedObjects", "retrieveIndices", "retrieveIndicesColumns", "retrieveInnerRoutines", "affectedModules", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "retrieveInnerRoutinesArguments", "modules", "retrieveInnerRoutinesHeads", "retrieveKeys", "retrieveLongMatViewSources", "names", "container", "", "Lcom/intellij/database/dialects/oracle/introspector/OraMajorSourceText;", "retrieveLongViewSources", "retrieveMain", "retrieveMainContent", "retrieveMatLogs", "retrieveMatViewSources", "retrieveMatViews", "retrieveMostObjects", "retrieveNormMatViewSources", "retrieveNormViewSources", "retrieveObjectTypeAttributes", "retrieveObjectTypes", "retrievePackages", "retrieveProgramSourcePortion", "retrieveProgramSourcesByPortions", "retrieveSchemaInfo", "retrieveSchemaObjects", "retrieveSequences", "retrieveSingleRoutines", "retrieveSingleRoutinesArguments", "retrieveSourceRelatedObjects", "retrieveSources", "retrieveSynonyms", "retrieveTableClusterColumns", "retrieveTables", "retrieveTriggerSources", "retrieveTriggers", "retrieveViewSources", "retrieveViews", "seanceRelatedTablesAndViews", "setFromTimestamps", "generalFromTimestamp", "setMajorModificationsFound", "found", "shouldWeRetrieveTriggers", "trigTurnOf", "Lcom/intellij/database/model/TrigTurn;", "turn", "", "updateInvalidStatus", "family", "Lcom/intellij/database/model/basic/BasicModElement;", "invalids", "Lgnu/trove/TLongHashSet;", "applySources", "type", "name", "sourceText", "intellij.database.dialects.oracle"})
    private final class OraSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<OraSchema> {
        private Timestamp myFromTimestamp;
        private Timestamp myBeginTimestamp;
        private Timestamp srcFromTimestamp;
        private boolean majorModificationsFound;
        private boolean affectsClusters;
        private boolean affectsTables;
        private boolean affectsMatLogs;
        private boolean affectsMatViews;
        private boolean affectsViews;
        private boolean affectsIndices;
        private boolean affectsTriggers;
        private boolean affectsModulesOrBodies;
        private boolean haveDefaults;
        private final int textLimit;
        private final HashSet<OraLikeTable> tablesToReorderDetails;
        private final HashSet<OraCluster> affectedClusters;
        private final HashSet<OraPackage> affectedPackageSpecs;
        private final HashSet<OraObjectType> affectedObjectTypeSpecs;
        private final HashSet<OraBody> affectedModuleBodies;
        private final HashSet<BasicRoutine> affectedInnerRoutines;
        private final HashSet<BasicRoutine> affectedSingleRoutines;
        private final HashSet<BasicSchemaObject> affectedDepObjects;
        private final HashSet<OraTable> affectedTables;
        private final HashSet<String> affectedNormViews;
        private final HashSet<String> affectedLongViews;
        private final HashSet<String> affectedNormMatViews;
        private final HashSet<String> affectedLongMatViews;
        private final HashSet<String> affectedTriggerTables;

        public final void setMajorModificationsFound(boolean found) {
            this.majorModificationsFound = found;
        }

        public final void setFromTimestamps(@NotNull Timestamp generalFromTimestamp, @NotNull Timestamp srcFromTimestamp) {
            Intrinsics.checkNotNullParameter((Object)generalFromTimestamp, (String)"generalFromTimestamp");
            Intrinsics.checkNotNullParameter((Object)srcFromTimestamp, (String)"srcFromTimestamp");
            this.myFromTimestamp = generalFromTimestamp;
            this.srcFromTimestamp = srcFromTimestamp;
        }

        @Override
        protected void prepareParameters() {
            super.prepareParameters();
            String[] fragmentKindTypeNames = OraObjectCodes.KIND_ORACLE_NAMES.get(this.getFragmentKind());
            String string = ((OraSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"schema.name");
            this.setQueryParameter("schema_name_lit", OraIntrospectorSourcesHelperKt.quoteAsOraLiteral(string));
            this.setQueryParameter("major_object_type_names", fragmentKindTypeNames);
            this.setQueryParameter("major_object_names", this.getFragmentNames());
            this.setQueryParameter("src_since", this.srcFromTimestamp);
            this.setQueryParameter("text_limit", this.textLimit);
        }

        @Override
        public void process() {
            this.retrieveMain();
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveMain();
        }

        public final void retrieveMain() {
            String string = ((OraSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"schema.name");
            OraIntrospector.this.reportIntrospectingSchema(string, this.getMode());
            this.prepareParameters();
            if (this.getMode().fragment) {
                this.retrieveFragment();
            } else {
                this.retrieveEntireSchema();
            }
        }

        private final void retrieveEntireSchema() {
            boolean skipSystemSchema;
            boolean bl = skipSystemSchema = this.getMode().increment && OraIntrospectorFunctions.getSYSTEM_SCHEMAS().contains(((OraSchema)this.getSchema()).getName()) && !OraIntrospector.this.getConsiderSystemSchemasReinstrospection() && !((OraSchema)this.getSchema()).isCurrent() && !this.majorModificationsFound;
            if (skipSystemSchema) {
                OraIntrospector.this.trace("Considered to stop introspecting the system schema " + ((OraSchema)this.getSchema()).getName() + " at point S1");
                return;
            }
            DBTransaction dBTransaction = this.getTransaction();
            SqlQuery<Timestamp> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.askForTimeNow;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.askForTimeNow");
            Timestamp beginTimestamp = (Timestamp)IntrospectionQueryContext.runQuery$default((IntrospectionQueryContext)this, dBTransaction, sqlQuery, null, null, 6, null);
            boolean bl2 = beginTimestamp != null;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-OraIntrospector$OraSchemaRetriever$retrieveEntireSchema$22 = false;
                String $i$a$-assert-OraIntrospector$OraSchemaRetriever$retrieveEntireSchema$22 = "Failed to obtain the current timestamp from the database";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-OraIntrospector$OraSchemaRetriever$retrieveEntireSchema$22));
            }
            StringBuilder stringBuilder = new StringBuilder().append("Server time now: ");
            Timestamp timestamp = beginTimestamp;
            Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"beginTimestamp");
            OraIntrospector.this.trace(stringBuilder.append(CalendarFun.export((Date)timestamp)).toString());
            this.myBeginTimestamp = beginTimestamp;
            this.retrieveSchemaInfo();
            if (!this.majorModificationsFound) {
                boolean noMoreMajorChanges;
                OraIntrospector.this.trace("There're no major modifications, checking for possible non-major changes");
                Date modifiedTimestamp = ((OraSchema)this.getSchema()).getModifiedTimestamp();
                Timestamp srcFromTimestamp1 = this.srcFromTimestamp;
                boolean bl4 = noMoreMajorChanges = modifiedTimestamp != null && modifiedTimestamp.before(this.myFromTimestamp) && (!this.getWithSources() || srcFromTimestamp1 != null && !srcFromTimestamp1.before(modifiedTimestamp));
                if (noMoreMajorChanges) {
                    this.retrieveHashRelatedObjects();
                    OraIntrospector.this.trace("No more modifications found");
                    return;
                }
            }
            this.retrieveSchemaObjects();
            OraIntrospector.this.trace("Schema introspection completed successfully.");
            OraIntrospector.this.reportStatusDetails("finishing the schema...", "introspection.report.status.finishingTheSchema");
            this.finalizeIntrospection();
        }

        private final void retrieveSchemaObjects() {
            this.retrieveMostObjects();
            this.retrieveHashRelatedObjects();
            this.retrieveSourceRelatedObjects();
        }

        private final void retrieveMostObjects() {
            this.retrieveSequences();
            this.retrieveObjectTypes();
            this.retrieveCollectionTypes();
            this.retrieveObjectTypeAttributes();
            this.retrieveClusters();
            this.retrieveTables();
            this.retrieveMatLogs();
            this.retrieveMatViews();
            this.retrieveViews();
            this.retrieveColumns();
            this.retrieveClusterIndices();
            this.retrieveTableClusterColumns();
            this.retrieveIndices();
            this.retrieveIndicesColumns();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveChecks();
            this.retrieveConstraintColumns();
            this.reorderTableDetails();
            this.retrieveTriggers();
            this.retrievePackages();
            this.retrieveInnerRoutines();
            this.retrieveSingleRoutines();
            this.retrieveSingleRoutinesArguments();
        }

        private final void retrieveHashRelatedObjects() {
            this.retrieveDbLinks();
            this.retrieveComments();
        }

        private final void retrieveSourceRelatedObjects() {
            this.retrieveDependencies();
            this.retrieveSources();
            this.retrieveDebugInfoPresence();
            this.retrieveErrors();
        }

        private final void finalizeIntrospection() {
            Timestamp timestamp = this.myBeginTimestamp;
            if (timestamp == null) {
                timestamp = this.myFromTimestamp;
            }
            Timestamp introspectionTimestamp = timestamp;
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, introspectionTimestamp){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Timestamp $introspectionTimestamp;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    StringBuilder stringBuilder = new StringBuilder().append("Marking schema ").append(schema.getName()).append(" as introspected:\n").append("\tintrospection version:   ").append(schema.getIntrospectionVersion()).append(" -> ").append(this.this$0.OraIntrospector.this.getIntrospectorVersion()).append('\n').append("\tintrospection timestamp: ");
                    Object object = schema.getIntrospectionTimestamp();
                    if (object == null || (object = CalendarFun.export((Date)object)) == null) {
                        object = "null";
                    }
                    OraIntrospector.access$trace(oraIntrospector, stringBuilder.append((String)object).append(" -> ").append(CalendarFun.export((Date)this.$introspectionTimestamp)).toString());
                    schema.setIntrospectionVersion(this.this$0.OraIntrospector.this.getIntrospectorVersion());
                    schema.setIntrospectionTimestamp(this.$introspectionTimestamp);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$introspectionTimestamp = timestamp;
                    super(1);
                }
            });
            if (this.getWithSources()) {
                this.getModel().setSchemaSourcesVersion((BasicSchema)this.getSchema(), Long.valueOf(introspectionTimestamp.getTime()));
            }
        }

        private final void retrieveFragment() {
            block1: {
                ObjectKind objectKind;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block3: {
                                                    block2: {
                                                        block0: {
                                                            this.retrieveFragmentNewObjectNames();
                                                            this.determineAndRemoveDroppedStuff();
                                                            objectKind = this.getFragmentKind();
                                                            if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE)) break block0;
                                                            this.retrieveSequences();
                                                            break block1;
                                                        }
                                                        if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.CLUSTER)) break block2;
                                                        this.retrieveClusters();
                                                        this.retrieveColumns();
                                                        this.retrieveClusterIndices();
                                                        this.retrieveTableClusterColumns();
                                                        this.retrieveIndicesColumns();
                                                        break block1;
                                                    }
                                                    if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) break block3;
                                                    this.retrieveTables();
                                                    this.retrieveMatLogs();
                                                    this.retrieveColumns();
                                                    this.retrieveComments();
                                                    this.retrieveTableClusterColumns();
                                                    this.retrieveIndices();
                                                    this.retrieveIndicesColumns();
                                                    this.retrieveKeys();
                                                    this.retrieveForeignKeys();
                                                    this.retrieveChecks();
                                                    this.retrieveConstraintColumns();
                                                    this.retrieveTriggers();
                                                    this.reorderTableDetails();
                                                    this.retrieveDependencies();
                                                    this.retrieveSources();
                                                    this.retrieveErrors();
                                                    this.retrieveDebugInfoPresence();
                                                    break block1;
                                                }
                                                if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_LOG)) break block4;
                                                this.retrieveTables();
                                                this.retrieveMatLogs();
                                                this.retrieveColumns();
                                                break block1;
                                            }
                                            if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW)) break block5;
                                            this.retrieveTables();
                                            this.retrieveMatLogs();
                                            this.retrieveMatViews();
                                            this.retrieveColumns();
                                            this.retrieveIndices();
                                            this.retrieveIndicesColumns();
                                            this.retrieveKeys();
                                            this.retrieveConstraintColumns();
                                            this.retrieveComments();
                                            this.retrieveTriggers();
                                            this.reorderTableDetails();
                                            this.retrieveDependencies();
                                            this.retrieveSources();
                                            this.retrieveErrors();
                                            this.retrieveDebugInfoPresence();
                                            break block1;
                                        }
                                        if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) break block6;
                                        this.retrieveViews();
                                        this.retrieveColumns();
                                        this.retrieveComments();
                                        this.retrieveTriggers();
                                        this.reorderTableDetails();
                                        this.retrieveDependencies();
                                        this.retrieveSources();
                                        this.retrieveErrors();
                                        this.retrieveDebugInfoPresence();
                                        break block1;
                                    }
                                    if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) break block7;
                                    this.retrieveSingleRoutines();
                                    this.retrieveSingleRoutinesArguments();
                                    this.retrieveDependencies();
                                    this.retrieveSources();
                                    this.retrieveErrors();
                                    this.retrieveDebugInfoPresence();
                                    break block1;
                                }
                                if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE)) break block8;
                                this.retrievePackages();
                                this.retrieveInnerRoutines();
                                this.retrieveDependencies();
                                this.retrieveSources();
                                this.retrieveErrors();
                                this.retrieveDebugInfoPresence();
                                break block1;
                            }
                            if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) break block9;
                            this.retrieveObjectTypes();
                            this.retrieveObjectTypeAttributes();
                            this.retrieveInnerRoutines();
                            this.retrieveDependencies();
                            this.retrieveSources();
                            this.retrieveErrors();
                            this.retrieveDebugInfoPresence();
                            break block1;
                        }
                        if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION_TYPE)) break block10;
                        this.retrieveCollectionTypes();
                        break block1;
                    }
                    if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DB_LINK)) break block11;
                    this.retrieveDbLinks();
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SYNONYM)) break block1;
                this.retrieveSynonyms();
            }
        }

        private final String performQueryReturningXmlForStringLiterals(SqlQuery<Integer> query, String paramName, Collection<String> paramValues) {
            OraIntrospector.this.trace("Performing XML query with " + paramValues.size() + " string literals");
            String paramStr2 = CollectionsKt.joinToString$default((Iterable)paramValues, null, null, null, (int)0, null, (Function1)performQueryReturningXmlForStringLiterals.paramStr.1.INSTANCE, (int)31, null);
            Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)paramName, (Object)paramStr2));
            String content = this.performQueryReturningXml(query, params2);
            if (content == null) {
                OraIntrospector.this.logWarn("Query " + query.getDisplayName() + " returned null XML for given literals: " + paramStr2);
            }
            return content;
        }

        private final String performQueryReturningXml(SqlQuery<Integer> query, Map<String, ? extends Object> namedParameters) {
            CommonPreprocessor preprocessor = this.makePreprocessor(namedParameters);
            return OraIntrospector.this.performQueryReturningXml(this.getTransaction(), (SqlQuery<Integer>)query, preprocessor);
        }

        static /* synthetic */ String performQueryReturningXml$default(OraSchemaRetriever oraSchemaRetriever, SqlQuery sqlQuery, Map map2, int n, Object object) {
            if ((n & 2) != 0) {
                map2 = null;
            }
            return oraSchemaRetriever.performQueryReturningXml((SqlQuery<Integer>)sqlQuery, map2);
        }

        private final void retrieveFragmentNewObjectNames() {
            SqlQuery<List<String>> listIdsQuery;
            ObjectKind fragmentKind = this.getFragmentKind();
            SqlQuery<List<String>> sqlQuery = listIdsQuery = fragmentKind == ObjectKind.OBJECT_TYPE || fragmentKind == ObjectKind.COLLECTION_TYPE ? ((OraIntrospector)OraIntrospector.this).queries.listFragmentTypeIds : ((OraIntrospector)OraIntrospector.this).queries.listFragmentRegularIds;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"listIdsQuery");
            List items = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            IntOpenHashSet affectedSchemaIds = new IntOpenHashSet();
            this.getModel().modify(OraRoot.class, new ModelModifier(this, items, affectedSchemaIds){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $items;
                final /* synthetic */ IntOpenHashSet $affectedSchemaIds;

                public final void perform(OraRoot root2) {
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    OraRoot oraRoot = root2;
                    Intrinsics.checkNotNullExpressionValue((Object)oraRoot, (String)"root");
                    ModNamingIdentifyingFamily<? extends OraSchema> modNamingIdentifyingFamily = oraRoot.getSchemas();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"root.schemas");
                    OraIntrospector.access$processNames(oraIntrospector, this.$items, modNamingIdentifyingFamily, true, this.$affectedSchemaIds);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$items = list;
                    this.$affectedSchemaIds = intOpenHashSet;
                }
            });
        }

        private final void determineAndRemoveDroppedStuff() {
            SqlQuery<long[]> query;
            OraIntrospector.this.reportRetrieving("dropped objects", "introspection.retrieve.droppedObjects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.getCatalogPermissions().getFast() ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiers;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(identifiers){
                final /* synthetic */ TLongHashSet $identifiers;

                public final void invoke(@NotNull OraSchema s) {
                    Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                    OraIntrospectorFunctions.dropUnexistentObjectsInSchema(s, this.$identifiers);
                }
                {
                    this.$identifiers = tLongHashSet;
                    super(1);
                }
            });
        }

        @Override
        protected void clearSchema() {
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    BasicModMixinElement.dropChildren((BasicModElement)((BasicModElement)schema));
                    schema.setCreatedTimestamp(null);
                    schema.setModifiedTimestamp(null);
                    schema.setIntrospectionTimestamp(null);
                    OraSchemaRetriever.access$getModel$p(this.this$0).setSchemaSourcesVersion((BasicSchema)schema, null);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveSchemaInfo() {
            OraIntrospector.this.reportRetrieving("schema information", "introspection.retrieve.schemaInformation");
            boolean schemaIsPublic = Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC");
            SqlQuery<OraIntroQueries.OneSchemaInfo> sqlQuery = schemaIsPublic ? ((OraIntrospector)OraIntrospector.this).queries.retrievePublicSchemaInfo : ((OraIntrospector)OraIntrospector.this).queries.retrieveSchemaInfo;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"if (schemaIsPublic) quer\u2026ueries.retrieveSchemaInfo");
            OraIntroQueries.OneSchemaInfo info = this.performQuery(sqlQuery);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(info){
                final /* synthetic */ OraIntroQueries.OneSchemaInfo $info;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    schema.setObjectId(this.$info.user_id);
                    schema.setCreatedTimestamp(this.$info.created_timestamp);
                    schema.setModifiedTimestamp(this.$info.modified_timestamp);
                }
                {
                    this.$info = oneSchemaInfo;
                    super(1);
                }
            });
            this.setQueryParameter("SCHEMA_ID", info.user_id);
        }

        private final void retrieveSequences() {
            ModNamingIdentifyingFamily<? extends OraSequence> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getSequences();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.sequences");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SEQUENCE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SEQUENCE");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneSequence>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSequences;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveSequences");
            List ss = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (ss.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, ss){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ss;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneSequence s : this.$ss) {
                        v0 = sequence = (OraSequence)schema.getSequences().renew(s.object_id, s.sequence_name);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"sequence");
                        v0.setSequenceIdentity(SequenceIdentity.of((BigInteger)OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.min_value), (BigInteger)OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.last_number), (BigInteger)BigInteger.valueOf(s.increment_by), (BigInteger)OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.max_value)));
                        sequence.setOrdered(s.order_flag);
                        sequence.setCycled(s.cycle_flag);
                        v1 = s.cache_size;
                        sequence.setCacheSize(v1 != null ? (long)v1.intValue() : 0L);
                        sequence.setBelongsToColumn(s.generated);
                        if (!s.generated) ** GOTO lbl-1000
                        v2 = s.sequence_name;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"s.sequence_name");
                        var5_5 = v2;
                        var6_6 = OraIntrospectorFunctions.getSEQUENCE_SURROGATE_NAME_PATTERN();
                        var7_7 = false;
                        if (var6_6.matches(var5_5)) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        sequence.setNameSurrogate(v3);
                        sequence.setCreatedTimestamp(s.created_timestamp);
                        sequence.setModifiedTimestamp(s.modified_timestamp);
                    }
                    schema.getSequences().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ss = list;
                    super(1);
                }
            });
        }

        private final BigInteger adjustBigIntegerForSequence(BigDecimal bigDecimalValue) {
            BigInteger bigInteger;
            String str;
            if (bigDecimalValue == null) {
                return null;
            }
            BigInteger bi = bigDecimalValue.toBigInteger();
            String string = bi.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bi.toString()");
            switch (str = string) {
                case "99999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "9999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-99999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-9999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "1000000000000000000000000000": {
                    bigInteger = null;
                    break;
                }
                case "-1000000000000000000000000000": {
                    bigInteger = null;
                    break;
                }
                default: {
                    bigInteger = bi;
                }
            }
            return bigInteger;
        }

        private final void retrieveObjectTypes() {
            ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getObjectTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.objectTypes");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_TYPE");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneObjectType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypes;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveObjectTypes");
            List ots = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (ots.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, ots){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ots;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneObjectType ot : this.$ots) {
                        OraObjectType oType;
                        OraObjectType oraObjectType = oType = (OraObjectType)schema.getObjectTypes().renew(ot.object_id, ot.type_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraObjectType, (String)"oType");
                        oraObjectType.setSuperSchemaName(ot.supertype_schema_name);
                        oType.setSuperObjectName(ot.supertype_name);
                        oType.setIncomplete(ot.is_incomplete);
                        oType.setFinal(ot.is_final);
                        oType.setInstantiable(ot.is_instantiable);
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(oType, ot.created_timestamp, ot.modified_timestamp);
                        if (ot.body_object_id != 0L) {
                            OraObjectTypeBody body2;
                            OraObjectTypeBody oraObjectTypeBody = body2 = (OraObjectTypeBody)oType.getBodies().createOrGet();
                            Intrinsics.checkNotNullExpressionValue((Object)oraObjectTypeBody, (String)"body");
                            oraObjectTypeBody.setObjectId(ot.body_object_id);
                            body2.setName(ot.type_name);
                            OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(body2, ot.body_created_timestamp, ot.body_modified_timestamp);
                            OraSchemaRetriever.access$getAffectedModuleBodies$p(this.this$0).add(body2);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body2);
                        } else {
                            oType.getBodies().clear();
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(oType);
                        }
                        OraSchemaRetriever.access$getAffectedObjectTypeSpecs$p(this.this$0).add(oType);
                    }
                    schema.getObjectTypes().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ots = list;
                    super(1);
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveCollectionTypes() {
            ModNamingIdentifyingFamily<? extends OraCollectionType> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getCollectionTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.collectionTypes");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLLECTION_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLLECTION_TYPE");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneCollectionType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveCollectionTypes;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveCollectionTypes");
            List cts = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (cts.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(cts){
                final /* synthetic */ List $cts;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCollectionType ct : this.$cts) {
                        OraCollectionType cType;
                        OraCollectionType oraCollectionType = cType = (OraCollectionType)schema.getCollectionTypes().renew(ct.object_id, ct.type_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraCollectionType, (String)"cType");
                        oraCollectionType.setTypeKind(ct.collection_kind == 'A' ? OraCollectionTypeKind.VARIABLE_SIZE_ARRAY : OraCollectionTypeKind.NESTED_TABLE);
                        String string = ct.type_name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ct.type_name");
                        CharSequence charSequence = string;
                        Regex regex = OraIntrospectorFunctions.getCOLLECTION_TYPE_SURROGATE_NAME_PATTERN();
                        boolean bl = false;
                        cType.setNameSurrogate(regex.matches(charSequence));
                        cType.setUpperBound(ct.upper_bound);
                        DataType type = OraIntrospectorFunctions.makeDataType((BasicSchema)schema, ct.data_type_schema_name, null, ct.data_type, ct.data_size, ct.data_scale, ct.data_size_units);
                        cType.setElementType(type);
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(cType, ct.created_timestamp, ct.modified_timestamp);
                    }
                    schema.getCollectionTypes().sort();
                }
                {
                    this.$cts = list;
                    super(1);
                }
            });
        }

        private final void retrieveObjectTypeAttributes() {
            ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getObjectTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.objectTypes");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.OBJECT_ATTRIBUTE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_ATTRIBUTE");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneObjectTypeAttribute>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypeAttributes;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveObjectTypeAttributes");
            List attrs = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (attrs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(attrs){
                final /* synthetic */ List $attrs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    HashSet<OraObjectType> affectedObjectTypes = new HashSet<OraObjectType>(schema.getObjectTypes().size());
                    for (OraIntroQueries.OneObjectTypeAttribute ota : this.$attrs) {
                        OraObjectTypeAttribute attr;
                        OraObjectType ot;
                        OraObjectType oraObjectType = ot = (OraObjectType)schema.getObjectTypes().createOrGet(ota.type_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraObjectType, (String)"ot");
                        OraObjectTypeAttribute oraObjectTypeAttribute = attr = (OraObjectTypeAttribute)oraObjectType.getAttributes().createOrGet(ota.attr_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraObjectTypeAttribute, (String)"attr");
                        oraObjectTypeAttribute.setPosition(ota.position);
                        String mod = ota.attr_type_mod;
                        DataType type = OraIntrospectorFunctions.makeDataType((BasicSchema)schema, ota.data_type_schema, null, ota.data_type, ota.data_size, ota.data_scale, ota.data_size_units);
                        CharSequence charSequence = mod;
                        boolean bl = false;
                        boolean bl2 = false;
                        if (!(charSequence == null || charSequence.length() == 0)) {
                            DataType dataType = type.withSuffix(StringUtil.toUpperCase((String)mod));
                            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"type.withSuffix(StringUtil.toUpperCase(mod))");
                            type = dataType;
                        }
                        attr.setDataType(type);
                        affectedObjectTypes.add(ot);
                    }
                    Iterator<E> iterator = affectedObjectTypes.iterator();
                    while (iterator.hasNext()) {
                        OraObjectType objectType;
                        OraObjectType oraObjectType = objectType = (OraObjectType)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)oraObjectType, (String)"objectType");
                        oraObjectType.getAttributes().sort();
                    }
                }
                {
                    this.$attrs = list;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveClusters() {
            void cs;
            ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.clusters");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.CLUSTER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CLUSTER");
            OraIntrospector.this.reportRetrieving(objectKind);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = CollectionsKt.emptyList();
            boolean ora31603 = false;
            try {
                SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusters;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveClusters");
                cs.element = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            }
            catch (DBException e2) {
                if (e2.vendorErrorCode == 31603) {
                    ora31603 = true;
                    String string = ((OraSchema)this.getSchema()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"schema.name");
                    String schemaName = string;
                    OraIntrospector.this.logWarn("Oracle schema " + schemaName + ": Unable to retrieve CLUSTER details because the user has no SELECT_CATALOG_ROLE.");
                    PlatformIdeService.getInstance().notification("Oracle Introspector Unable To Retrieve Cluster Details", PlatformIdeService.NotificationType.WARNING, DatabaseBundle.message((String)"oracle.introspector.notification.clusterDetailsNotRetrieved", (Object[])new Object[0]), null, DatabaseBundle.message((String)"oracle.introspector.notification.clusterDetailsNotRetrieved.description", (Object[])new Object[]{schemaName}), null);
                }
                throw (Throwable)e2;
            }
            if (ora31603) {
                SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClustersWhenNoPermissions;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveClustersWhenNoPermissions");
                cs.element = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            }
            if (((List)cs.element).isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, (Ref.ObjectRef)cs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Ref.ObjectRef $cs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCluster c : (List)this.$cs.element) {
                        OraCluster cluster;
                        OraCluster oraCluster = cluster = (OraCluster)schema.getClusters().createOrGet(c.id);
                        Intrinsics.checkNotNullExpressionValue((Object)oraCluster, (String)"cluster");
                        OraSchemaRetriever.access$applyClusterInfo(this.this$0, oraCluster, c);
                        OraSchemaRetriever.access$getAffectedClusters$p(this.this$0).add(cluster);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cs = objectRef;
                    super(1);
                }
            });
            this.affectsClusters = true;
        }

        private final void applyClusterInfo(OraCluster cluster, OraIntroQueries.OneCluster c) {
            String string;
            cluster.setClusterType(ClusterType.of((char)c.type_code));
            cluster.setSingleTable(c.single_table);
            cluster.setBlockSize(c.block_size);
            String string2 = c.hash_expression;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            } else {
                string = null;
            }
            cluster.setHashExpression(string);
            cluster.setHashCardinality(c.hash_cardinality);
            cluster.setTablespaceName(c.tablespace_name);
            String decompiled_text = c.decompiled_text;
            if (decompiled_text != null) {
                String string5 = c.decompiled_text;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"c.decompiled_text");
                this.extractClusterColumns(cluster, string5);
            }
        }

        private final void extractClusterColumns(OraCluster cluster, String text) {
            Object object;
            ModPositioningNamingFamily<? extends OraClusterColumn> modPositioningNamingFamily = cluster.getColumns();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"cluster.columns");
            ModPositioningNamingFamily<? extends OraClusterColumn> columns = modPositioningNamingFamily;
            BaseIntrospector this_$iv = OraIntrospector.this;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = BaseIntrospector.access$getSqlHelper$p(this_$iv);
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(text, SqlCreateStatement.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw (Throwable)pce$iv;
            }
            catch (Exception e$iv) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            SqlCreateStatement statement = (SqlCreateStatement)object;
            if (statement == null || Intrinsics.areEqual((Object)statement.getKind(), (Object)ObjectKind.CLUSTER) ^ true) {
                columns.clear();
                return;
            }
            columns.markChildrenAsSyncPending();
            JBIterable jBIterable = statement.getDasChildren(ObjectKind.COLUMN);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"statement.getDasChildren(COLUMN)");
            JBIterable parsedColumns = jBIterable;
            Iterator iterator = parsedColumns.iterator();
            while (iterator.hasNext()) {
                DasObject c;
                DasObject dasObject = c = (DasObject)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)dasObject, (String)"c");
                OraClusterColumn column2 = (OraClusterColumn)columns.createOrGet(dasObject.getName());
                OraIntrospector.this.getSqlHelper().getBuilder().build((BasicModElement)column2, c, SqlObjectBuilder.INTROSPECTOR);
            }
            columns.removeSyncPendingChildren();
            columns.sort();
        }

        private final void retrieveTables() {
            ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.tables");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneTable>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTables;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveTables");
            List<OraIntroQueries.OneTable> tabs = this.performQuery(sqlQuery);
            if (tabs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, tabs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $tabs;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneTable tab : this.$tabs) {
                        block11: {
                            block12: {
                                block10: {
                                    tableName = tab.table_name;
                                    v0 = table = (OraTable)schema.getTables().renew(tab.object_id, tableName);
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"table");
                                    v0.setMasterTableName(tab.master_table_name);
                                    table.setClusterName(tab.cluster_name);
                                    table.setTemporary(tab.is_temp);
                                    table.setTemporaryPreserve(tab.is_temp_preserved);
                                    OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(table, tab.created_timestamp, tab.modified_timestamp);
                                    cluster = tab.cluster_name != null ? (OraCluster)schema.getClusters().get(tab.cluster_name) : null;
                                    clusterIsIndexed = cluster != null && cluster.getHashCardinality() == 0;
                                    switch (tab.organization_kind) {
                                        case 'I': {
                                            v1 = TableOrganization.INDEX;
                                            break;
                                        }
                                        case 'C': {
                                            if (clusterIsIndexed) {
                                                v1 = TableOrganization.ORA_CLUSTERED_BY_INDEX;
                                                break;
                                            }
                                            v1 = TableOrganization.ORA_CLUSTERED_BY_HASH;
                                            break;
                                        }
                                        default: {
                                            v1 = TableOrganization.DEFAULT;
                                        }
                                    }
                                    table.setOrganization(v1);
                                    table.setRowTypeSchemaName(tab.row_type_schema_name);
                                    table.setRowTypeObjectName(tab.row_type_name);
                                    if (!tab.is_mat_log) break block10;
                                    v2 = OraTableType.MAT_LOG;
                                    break block11;
                                }
                                if (!tab.is_mat_view) break block12;
                                v2 = OraTableType.MAT_VIEW;
                                break block11;
                            }
                            if (!tab.is_temp) ** GOTO lbl-1000
                            v3 = tableName;
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"tableName");
                            if (StringsKt.startsWith$default((String)v3, (String)"RUPD$_", (boolean)false, (int)2, null)) {
                                v2 = OraTableType.MAT_LOG_TEMP;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = OraTableType.BASIC;
                            }
                        }
                        table.setTableType(v2);
                        table.setNameSurrogate(table.getTableType() == OraTableType.MAT_LOG || table.getTableType() == OraTableType.MAT_LOG_TEMP);
                        if (tab.has_mat_log) {
                            table.getMatLogs().createOrGet();
                        } else {
                            table.getMatLogs().clear();
                        }
                        table.getChecks().clear();
                        table.getForeignKeys().clear();
                        table.getKeys().clear();
                        OraSchemaRetriever.access$getAffectedTables$p(this.this$0).add(table);
                        OraSchemaRetriever.access$setAffectsMatLogs$p(this.this$0, OraSchemaRetriever.access$getAffectsMatLogs$p(this.this$0) != false || tab.is_mat_log != false || tab.has_mat_log != false);
                        OraSchemaRetriever.access$setAffectsMatViews$p(this.this$0, OraSchemaRetriever.access$getAffectsMatViews$p(this.this$0) != false || tab.is_mat_view != false);
                    }
                    schema.getTables().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$tabs = list;
                    super(1);
                }
            });
            this.affectsTables = true;
        }

        private final void retrieveMatLogs() {
            if (!this.affectsMatLogs) {
                return;
            }
            ObjectKind objectKind = ObjectKind.MAT_LOG;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"MAT_LOG");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneMatLog>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatLogs;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveMatLogs");
            List<OraIntroQueries.OneMatLog> mls = this.performQuery(sqlQuery);
            if (mls.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(mls){
                final /* synthetic */ List $mls;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneMatLog m : this.$mls) {
                        OraTable table;
                        OraMatLog ml;
                        if ((OraTable)schema.getTables().get(m.table_name) == null) {
                            continue;
                        }
                        OraMatLog oraMatLog = ml = (OraMatLog)table.getMatLogs().createOrGet();
                        Intrinsics.checkNotNullExpressionValue((Object)oraMatLog, (String)"ml");
                        oraMatLog.setName(m.log_name);
                        ml.setNameSurrogate(true);
                        ml.setWithRowId(m.with_rowid);
                        ml.setWithObjectId(m.with_object_id);
                        ml.setWithPrimaryKey(m.with_primary_key);
                        ml.setWithSequence(m.with_sequence);
                        ml.setWithNewValues(m.with_new_values);
                    }
                }
                {
                    this.$mls = list;
                    super(1);
                }
            });
        }

        private final void retrieveMatViews() {
            ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.matViews");
            if (modNamingIdentifyingFamily.isEmpty() && !this.affectsMatViews) {
                return;
            }
            ObjectKind objectKind = ObjectKind.MAT_VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"MAT_VIEW");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneMatView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatViews;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveMatViews");
            List<OraIntroQueries.OneMatView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneMatView v2 : this.$vs) {
                        OraMatView view;
                        OraMatView oraMatView = view = (OraMatView)schema.getMatViews().renew(v2.object_id, v2.view_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraMatView, (String)"view");
                        oraMatView.setPrebuilt(v2.prebuilt);
                        view.setModifiable(v2.modifiable);
                        view.setRefreshMode(OraMatViewRefreshMode.byCode(v2.refresh_mode));
                        view.setRefreshMethod(OraMatViewRefreshMethod.byCode(v2.refresh_method));
                        view.setInvalid(v2.is_invalid);
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(view, v2.created_timestamp, v2.modified_timestamp);
                        if (this.this$0.getMode() == IntrospectionMode.INCREMENT) {
                            OraTable oraTable = (OraTable)schema.getTables().get(v2.view_name);
                            if (oraTable != null) {
                                oraTable.setTableType(OraTableType.MAT_VIEW);
                            }
                        }
                        (v2.text_length <= 4000 ? OraSchemaRetriever.access$getAffectedNormMatViews$p(this.this$0) : OraSchemaRetriever.access$getAffectedLongMatViews$p(this.this$0)).add(view.getName());
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs = list;
                    super(1);
                }
            });
            this.affectsMatViews = true;
        }

        private final void retrieveViews() {
            ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.views");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"VIEW");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViews;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveViews");
            List<OraIntroQueries.OneView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneView v2 : this.$vs) {
                        OraView view;
                        OraView oraView = view = (OraView)schema.getViews().renew(v2.object_id, v2.view_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraView, (String)"view");
                        oraView.setModifiable(v2.modifiable);
                        view.setInvalid(v2.is_invalid);
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(view, v2.created_timestamp, v2.modified_timestamp);
                        (v2.text_length <= 4000 ? OraSchemaRetriever.access$getAffectedNormViews$p(this.this$0) : OraSchemaRetriever.access$getAffectedLongViews$p(this.this$0)).add(view.getName());
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs = list;
                    super(1);
                }
            });
            this.affectsViews = true;
        }

        /*
         * Unable to fully structure code
         */
        private final void retrieveColumns() {
            this.haveDefaults = false;
            if (!(this.affectsClusters || this.affectsTables || this.affectsMatViews || this.affectsViews)) {
                return;
            }
            v0 = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"COLUMN");
            OraIntrospector.access$reportRetrieving(OraIntrospector.this, v0);
            v1 = OraIntrospector.access$getQueries$p((OraIntrospector)OraIntrospector.this).retrieveColumns;
            Intrinsics.checkNotNullExpressionValue(v1, (String)"queries.retrieveColumns");
            cols = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, v1, null, 0, 6, null);
            if (cols.isEmpty()) {
                return;
            }
            affectedTables = new HashSet<E>();
            tablesWithNormDefs = new LinkedHashMap<K, V>();
            tablesWithLongDefs = new LinkedHashMap<K, V>();
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, cols, affectedTables, tablesWithNormDefs, tablesWithLongDefs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $cols;
                final /* synthetic */ HashSet $affectedTables;
                final /* synthetic */ LinkedHashMap $tablesWithNormDefs;
                final /* synthetic */ LinkedHashMap $tablesWithLongDefs;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    major = null;
                    major_id = -9223372036854775808L;
                    for (OraIntroQueries.OneColumn col : this.$cols) {
                        block10: {
                            if (col.major_id == major_id) break block10;
                            var7_6 = (BasicSchema)schema;
                            objectId$iv = col.major_id;
                            $i$f$findById = false;
                            v0 = $this$findById$iv.getDatabase();
                            if (v0 == null) ** GOTO lbl-1000
                            $this$findById$iv$iv = v0;
                            $i$f$findById = false;
                            v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                            if (!(v1 instanceof OraMajorObject)) {
                                v1 = null;
                            }
                            if ((v0 = (BasicIdentifiedElement)((OraMajorObject)v1)) != null) {
                                var11_12 = v0;
                                var12_13 = false;
                                var13_14 = false;
                                it$iv = var11_12;
                                $i$a$-takeIf-ModelFun$findById$1$iv = false;
                                v2 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? var11_12 : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 /* !! */  = null;
                            }
                            if ((major = (OraMajorObject)v2 /* !! */ ) == null) continue;
                            major_id = col.major_id;
                            $this$findById$iv = major;
                            if (!($this$findById$iv instanceof OraLikeTable)) continue;
                            ((OraLikeTable)major).getColumns().markChildrenAsSyncPending();
                            this.$affectedTables.add(major);
                        }
                        if (major == null) {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)major.getName(), (String)"major.name");
                        var9_9 = major;
                        if (!(var9_9 instanceof OraLikeTable)) continue;
                        Intrinsics.checkNotNullExpressionValue(((OraLikeTable)major).getColumns(), (String)"when (major) {\n         \u2026e@columns\n              }");
                        v3 = tableColumns.createOrGet(col.column_name);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"tableColumns.createOrGet(col.column_name)");
                        column = (OraInfraColumn)v3;
                        column.resetSyncPending();
                        column.setPosition(col.column_position);
                        type = OraIntrospectorFunctions.makeDataType((BasicSchema)schema, col.data_type_schema_name, null, col.data_type, col.data_size, col.data_scale, col.data_size_units);
                        column.setDataType(type);
                        if (column instanceof OraLikeColumn) {
                            ((OraLikeColumn)column).setNotNull(col.mandatory);
                        }
                        if (!(column instanceof OraTableColumn) || !(major instanceof OraTable)) continue;
                        ((OraTableColumn)column).setAutoInc(col.identity_column);
                        ((OraTableColumn)column).setDefaultOnNull(col.default_on_null);
                        if (col.default_expression_length > 0 && !col.identity_column) {
                            if (OraIntrospector.access$getUseXML$p(this.this$0.OraIntrospector.this) && col.default_expression_length < OraSchemaRetriever.access$getTextLimit$p(this.this$0)) {
                                ((Map)this.$tablesWithNormDefs).put(majorName, major);
                                continue;
                            }
                            ((Map)this.$tablesWithLongDefs).put(majorName, major);
                            continue;
                        }
                        ((OraTableColumn)column).setDefaultExpression(null);
                    }
                    if (this.this$0.getMode().increment || this.this$0.getMode().fragment) {
                        var6_4 = this.$affectedTables.iterator();
                        while (var6_4.hasNext()) {
                            v4 = affectedTable = (OraLikeTable)var6_4.next();
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"affectedTable");
                            v4.getColumns().removeSyncPendingChildren();
                        }
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cols = list;
                    this.$affectedTables = hashSet;
                    this.$tablesWithNormDefs = linkedHashMap;
                    this.$tablesWithLongDefs = linkedHashMap2;
                    super(1);
                }
            });
            this.tablesToReorderDetails.addAll((Collection<OraLikeTable>)affectedTables);
            var5_5 = tablesWithNormDefs;
            var6_6 = false;
            if (var5_5.isEmpty() == false) ** GOTO lbl-1000
            var5_5 = tablesWithLongDefs;
            var6_6 = false;
            if (var5_5.isEmpty() == false) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            this.haveDefaults = v2;
            v3 = tablesWithNormDefs.keySet();
            v4 = tablesWithLongDefs.keySet();
            Intrinsics.checkNotNullExpressionValue(v4, (String)"tablesWithLongDefs.keys");
            v3.removeAll((Collection)v4);
            var5_5 = tablesWithNormDefs;
            var6_6 = false;
            if (var5_5.isEmpty() == false) {
                this.retrieveColumnDefaultsNorm((Map<String, ? extends OraTable>)tablesWithNormDefs);
            }
            var5_5 = tablesWithLongDefs;
            var6_6 = false;
            if (var5_5.isEmpty() == false) {
                this.retrieveColumnDefaultsLong((Map<String, ? extends OraTable>)tablesWithLongDefs);
            }
        }

        private final void retrieveColumnDefaultsNorm(Map<String, ? extends OraTable> tables) {
            OraIntrospector.this.reportRetrieving("Table Column Defaults (normal ones)", "introspection.retrieve.tableColumnDefaults.normal");
            List packs = OraIntrospectorSourcesHelperKt.splitByPacks(CollectionsKt.toList((Iterable)tables.keySet()), 100);
            HashMap<MajorMinorName, String> defs = new HashMap<MajorMinorName, String>(tables.size() * 4);
            OraIntrospector.this.trace("Retrieving column defaults for " + tables.size() + " tables in " + packs.size() + " portions");
            for (List pack : packs) {
                OraIntrospector.this.handleErrors("Retrieve column defaults via XML for " + pack.size() + " tables (" + CollectionsKt.joinToString$default((Iterable)pack, null, null, null, (int)0, null, null, (int)63, null) + ')', (Function0<Unit>)((Function0)new Function0<Unit>(this, pack, defs){
                    final /* synthetic */ OraSchemaRetriever this$0;
                    final /* synthetic */ List $pack;
                    final /* synthetic */ HashMap $defs;

                    public final void invoke() {
                        SqlQuery<Integer> sqlQuery = OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0.OraIntrospector.this).retrieveColumnDefaultsXml;
                        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveColumnDefaultsXml");
                        String xmlText = OraSchemaRetriever.access$performQueryReturningXmlForStringLiterals(this.this$0, sqlQuery, "names_lit", this.$pack);
                        if (xmlText == null) {
                            throw (Throwable)new ResultIsNull();
                        }
                        OraIntrospectorSourcesHelperKt.parseMinorSources(xmlText, this.$defs);
                        OraIntrospector.access$trace(this.this$0.OraIntrospector.this, "parsed " + this.$defs.size() + " default expressions from XML");
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                        this.$pack = list;
                        this.$defs = hashMap;
                        super(0);
                    }
                }));
            }
            this.applyDefaults(defs, tables);
        }

        private final void retrieveColumnDefaultsLong(Map<String, ? extends OraTable> tables) {
            OraIntrospector.this.reportRetrieving("Table Column Defaults (huge ones)", "introspection.retrieve.tableColumnDefaults.long");
            List packs = OraIntrospectorSourcesHelperKt.splitByPacks(CollectionsKt.toList((Iterable)tables.keySet()), 100);
            HashMap<MajorMinorName, String> defs = new HashMap<MajorMinorName, String>(tables.size());
            for (List pack : packs) {
                String namesLit2 = CollectionsKt.joinToString$default((Iterable)pack, null, null, null, (int)0, null, (Function1)retrieveColumnDefaultsLong.namesLit.1.INSTANCE, (int)31, null);
                Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"names_lit", (Object)namesLit2));
                SqlQuery<List<OraIntroQueries.OneMinorText>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumnDefaultsLong;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveColumnDefaultsLong");
                List rows = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, params2, 0, 4, null);
                if (rows.isEmpty()) continue;
                this.fetchMinorTexts(rows, (Map<MajorMinorName, String>)defs);
            }
            this.applyDefaults(defs, tables);
        }

        private final void applyDefaults(HashMap<MajorMinorName, String> defs, Map<String, ? extends OraTable> tables) {
            this.inSchema((Function1)new Function1<OraSchema, Unit>(defs, tables){
                final /* synthetic */ HashMap $defs;
                final /* synthetic */ Map $tables;

                public final void invoke(@NotNull OraSchema it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    for (Map.Entry<K, V> d : this.$defs.entrySet()) {
                        OraTableColumn column2;
                        OraTable table;
                        if ((OraTable)this.$tables.get(((MajorMinorName)d.getKey()).getMajor()) == null) {
                            continue;
                        }
                        if ((OraTableColumn)table.getColumns().get(((MajorMinorName)d.getKey()).getMinor()) == null) {
                            continue;
                        }
                        V v2 = d.getValue();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"d.value");
                        String string = (String)v2;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String content = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        column2.setDefaultExpression(content);
                    }
                }
                {
                    this.$defs = hashMap;
                    this.$tables = map2;
                    super(1);
                }
            });
        }

        private final void retrieveClusterIndices() {
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery;
            ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.clusters");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            if (OraIntrospector.this.getCatalogPermissions().getFast()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesFast;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> query = sqlQuery;
            OraIntrospector.this.reportRetrieving("Cluster indices", "introspection.retrieve.clusterIndices");
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery2 = query;
            Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneClusterIndex> inds = this.performQuery(sqlQuery2);
            if (inds.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, inds){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $inds;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneClusterIndex ind : this.$inds) {
                        OraCluster cluster;
                        OraClusterIndex index2;
                        if ((OraCluster)schema.getClusters().get(ind.cluster_name) == null) {
                            continue;
                        }
                        OraClusterIndex oraClusterIndex = index2 = (OraClusterIndex)cluster.getIndices().createOrGet();
                        Intrinsics.checkNotNullExpressionValue((Object)oraClusterIndex, (String)"index");
                        oraClusterIndex.setObjectId(ind.index_id);
                        index2.setName(ind.index_name);
                        String string = ind.index_name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ind.index_name");
                        CharSequence charSequence = string;
                        Regex regex = OraIntrospectorFunctions.getINDEX_SURROGATE_NAME_PATTERN();
                        boolean bl = false;
                        index2.setNameSurrogate(regex.matches(charSequence));
                        index2.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(index2, ind.created_timestamp, ind.modified_timestamp);
                        if (!this.this$0.getMode().fragment) continue;
                        index2.setColNames(CollectionsKt.emptyList());
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$inds = list;
                    super(1);
                }
            });
        }

        private final void retrieveTableClusterColumns() {
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> query;
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> sqlQuery;
            ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.clusters");
            if (modNamingIdentifyingFamily.isEmpty() || this.affectedTables.isEmpty()) {
                return;
            }
            OraIntrospector.this.reportRetrieving("tables' clustered columns", "introspection.retrieve.tableClusteredColumns");
            if (OraIntrospector.this.getCatalogPermissions().getAccessDBA()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTableClusterColumnsDba;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTableClusterColumnsUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> sqlQuery2 = query = sqlQuery;
            Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneTableClusterColumn> cols2 = this.performQuery(sqlQuery2);
            if (cols2.isEmpty()) {
                return;
            }
            StringListAggregator g = new StringListAggregator();
            for (OraIntroQueries.OneTableClusterColumn col : cols2) {
                String string = col.table_name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"col.table_name");
                String string2 = col.column_name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"col.column_name");
                g.add((Object)string, (Object)string2);
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(g){
                final /* synthetic */ StringListAggregator $g;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    Object object = this.$g.getResult();
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void tableName;
                        Map.Entry<K, V> entry;
                        Map.Entry<K, V> entry2 = entry = iterator.next();
                        boolean bl2 = false;
                        object = (String)entry2.getKey();
                        entry2 = entry;
                        bl2 = false;
                        List colNames = (List)entry2.getValue();
                        OraTable oraTable = (OraTable)schema.getTables().get((String)tableName);
                        if (oraTable == null) continue;
                        oraTable.setClusterColNames(colNames);
                    }
                }
                {
                    this.$g = stringListAggregator;
                    super(1);
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void retrieveIndices() {
            if (!this.affectsTables && !this.affectsMatViews) {
                if (!OraIntrospector.this.getServerVersion().isOrGreater(new int[]{19})) return;
                ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.tables");
                if (!modNamingIdentifyingFamily.isNotEmpty()) {
                    ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily2 = ((OraSchema)this.getSchema()).getMatViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"schema.matViews");
                    if (!modNamingIdentifyingFamily2.isNotEmpty()) return;
                }
            }
            boolean bl = true;
            boolean toRetrieve = bl;
            if (!toRetrieve) {
                return;
            }
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneIndex>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndices;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveIndices");
            List indices = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (indices.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, indices){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $indices;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneIndex ind : this.$indices) {
                        OraTable table;
                        OraIndex index2;
                        if ((OraTable)schema.getTables().get(ind.table_name) == null) {
                            continue;
                        }
                        OraIndex oraIndex = index2 = (OraIndex)table.getIndices().renew(ind.object_id, ind.index_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraIndex, (String)"index");
                        String string = ind.index_name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ind.index_name");
                        CharSequence charSequence = string;
                        Regex regex = OraIntrospectorFunctions.getINDEX_SURROGATE_NAME_PATTERN();
                        boolean bl = false;
                        oraIndex.setNameSurrogate(regex.matches(charSequence) || table.getTableType() == OraTableType.MAT_VIEW);
                        index2.setUnique(ind.uniqueness);
                        index2.setClustering(ind.clustering);
                        index2.setFunctionBased(ind.function_based);
                        index2.setBitmap(ind.bitmap);
                        index2.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(index2, ind.created_timestamp, ind.modified_timestamp);
                        index2.setIndextypeOwner(ind.indextype_owner);
                        index2.setIndextypeName(ind.indextype_name);
                        if (this.this$0.getMode().fragment) {
                            index2.setColNames(CollectionsKt.emptyList());
                        }
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$indices = list;
                    super(1);
                }
            });
            this.affectsIndices = true;
        }

        private final void retrieveIndicesColumns() {
            boolean bl;
            Object object;
            if (!this.affectsIndices) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneIndexItem>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesColumns;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveIndicesColumns");
            List<OraIntroQueries.OneIndexItem> ics = this.performQuery(sqlQuery);
            if (ics.isEmpty()) {
                return;
            }
            StringListAggregator columns = new StringListAggregator();
            boolean hasExpressions = false;
            for (OraIntroQueries.OneIndexItem ic : ics) {
                String key2 = ic.table_name + '\uffff' + ic.index_name;
                String string = ic.item;
                if (string == null) {
                    string = "???[" + ic.column_position + ']';
                }
                String item = string;
                char c = ic.direction;
                boolean bl2 = false;
                columns.add((Object)key2, (Object)(String.valueOf(c) + item));
                CharSequence charSequence = item;
                object = OraIntrospectorFunctions.getINDEX_EXPRESSION_STUB_PATTERN();
                bl = false;
                boolean isExpression = object.matches(charSequence);
                hasExpressions = hasExpressions || isExpression;
            }
            if (hasExpressions) {
                SqlQuery<List<OraIntroQueries.OneIndexItem>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesExpressions;
                Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"queries.retrieveIndicesExpressions");
                List<OraIntroQueries.OneIndexItem> ies = this.performQuery(sqlQuery2);
                for (OraIntroQueries.OneIndexItem ie : ies) {
                    String key3 = ie.table_name + '\uffff' + ie.index_name;
                    short position = ie.column_position;
                    char c = ie.direction;
                    Intrinsics.checkNotNullExpressionValue((Object)ie.item, (String)"ie.item");
                    bl = false;
                    columns.set(key3, position - 1, String.valueOf(c) + (String)object);
                }
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, columns){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $columns;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    Object object = this.$columns.getResult();
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        OraIndex index2;
                        String indexName;
                        OraTable table;
                        String tableName;
                        void key2;
                        Map.Entry<K, V> entry;
                        Map.Entry<K, V> entry2 = entry = iterator.next();
                        boolean bl2 = false;
                        object = (String)entry2.getKey();
                        entry2 = entry;
                        bl2 = false;
                        List items = (List)entry2.getValue();
                        int d_pos = StringsKt.indexOf$default((CharSequence)((CharSequence)key2), (char)'\uffff', (int)0, (boolean)false, (int)6, null);
                        if (d_pos < 0) continue;
                        void var8_11 = key2;
                        int n = 0;
                        int n2 = 0;
                        void v0 = var8_11;
                        if (v0 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)v0.substring(n, d_pos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        void var9_12 = key2;
                        n2 = d_pos + 1;
                        boolean bl3 = false;
                        void v1 = var9_12;
                        if (v1 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)v1.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                        if ((OraTable)schema.getTables().get(tableName) == null) {
                            continue;
                        }
                        if ((OraIndex)table.getIndices().get(indexName) == null) {
                            continue;
                        }
                        OraSchemaRetriever.access$applyIndexingItems(this.this$0, (BasicTable)table, index2, items);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$columns = stringListAggregator;
                    super(1);
                }
            });
        }

        private final void applyIndexingItems(BasicTable table, OraIndex index2, List<String> items) {
            int n = items.size();
            if (n == 0) {
                index2.setColNames(CollectionsKt.emptyList());
                index2.setReverseColNames(SetsKt.emptySet());
                return;
            }
            if (index2.isFunctionBased()) {
                ArrayList<String> expressions = new ArrayList<String>(n);
                TreeSet<String> reverse = new TreeSet<String>();
                PositioningNamingFamily positioningNamingFamily = table.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"table.columns");
                TreeSet tableColumnNames = new TreeSet(positioningNamingFamily.getNames());
                for (String item : items) {
                    String string;
                    if (item.length() < 2) continue;
                    String string2 = item;
                    int n2 = 1;
                    char c = '\u0000';
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    String c2 = OraIntrospectorFunctions.unquoteNameIfPossible(string4);
                    boolean isColumn = tableColumnNames.contains(c2);
                    if (isColumn) {
                        string = c2;
                    } else {
                        c = '\u001b';
                        boolean bl = false;
                        string = String.valueOf(c) + c2;
                    }
                    String x = string;
                    expressions.add(x);
                    if (item.charAt(0) != '-') continue;
                    reverse.add(x);
                }
                index2.setColNames((List<String>)expressions);
                Collection collection = reverse;
                boolean bl = false;
                index2.setReverseColNames(!collection.isEmpty() ? (Set)reverse : SetsKt.emptySet());
            } else {
                ArrayList<String> columns = new ArrayList<String>(n);
                TreeSet<String> reverse = new TreeSet<String>();
                for (String item : items) {
                    String c;
                    if (item.length() < 2) continue;
                    String string = item;
                    int n3 = 1;
                    boolean bl = false;
                    String string5 = string;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                    columns.add(c);
                    if (item.charAt(0) != '-') continue;
                    reverse.add(c);
                }
                index2.setColNames((List<String>)columns);
                Collection collection = reverse;
                boolean bl = false;
                index2.setReverseColNames(!collection.isEmpty() ? (Set)reverse : SetsKt.emptySet());
            }
        }

        private final void retrieveKeys() {
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"KEY");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneKey>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveKeys;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveKeys");
            List keys = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (keys.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(keys){
                final /* synthetic */ List $keys;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneKey k : this.$keys) {
                        OraKey key2;
                        OraTable table;
                        if (k.table_name == null || k.constraint_name == null) continue;
                        OraTable oraTable = table = (OraTable)schema.getTables().createOrGet(k.table_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraTable, (String)"table");
                        OraKey oraKey = key2 = (OraKey)oraTable.getKeys().createOrGet(k.constraint_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraKey, (String)"key");
                        oraKey.setColNames(CollectionsKt.emptyList());
                        key2.setNameSurrogate(k.is_surrogate_name);
                        key2.setPrimary(k.is_pk);
                        key2.setDeferrable(k.is_deferrable);
                        key2.setInitiallyDeferred(k.is_initially_deferred);
                        key2.setModifiedTimestamp(k.modified_timestamp);
                        key2.setUnderlyingIndexName(k.index_name);
                    }
                }
                {
                    this.$keys = list;
                    super(1);
                }
            });
        }

        private final void retrieveForeignKeys() {
            SqlQuery<List<OraIntroQueries.OneForeignKey>> query;
            if (!this.affectsTables) {
                return;
            }
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FOREIGN_KEY");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneForeignKey>> sqlQuery = query = OraIntrospector.this.getCatalogPermissions().getFast() ? ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeysFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeys;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
            List fks = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (fks.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(fks){
                final /* synthetic */ List $fks;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    database = schema.getParent();
                    for (OraIntroQueries.OneForeignKey fk : this.$fks) {
                        block8: {
                            if ((fk.table_id > 0L ? (OraTable)schema.getTables().getByObjectId(fk.table_id) : (OraTable)schema.getTables().get(fk.table_name)) == null) {
                                continue;
                            }
                            table = table;
                            v0 = fkey = (OraForeignKey)table.getForeignKeys().createOrGet(fk.constraint_name);
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"fkey");
                            v0.setColNames(CollectionsKt.emptyList());
                            v1 = fkey;
                            v2 = fk.ref_schema_name;
                            if (v2 != null) break block8;
                            v3 = database;
                            Intrinsics.checkNotNull((Object)v3);
                            v4 = (OraSchema)v3.getSchemas().getByObjectId(fk.ref_schema_id);
                            if (v4 == null) ** GOTO lbl-1000
                            var7_7 = v4;
                            var8_8 = false;
                            var9_9 = false;
                            var10_10 = var7_7;
                            var12_12 = v1;
                            $i$a$-takeIf-OraIntrospector$OraSchemaRetriever$retrieveForeignKeys$1$1 = false;
                            var13_13 = Intrinsics.areEqual((Object)it, (Object)schema) ^ true;
                            v1 = var12_12;
                            v4 = var13_13 != false ? var7_7 : null;
                            if (v4 != null) {
                                v2 = v4.getName();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = null;
                            }
                        }
                        v1.setRefSchemaName(v2);
                        fkey.setRefTableName(fk.ref_table_name);
                        fkey.setRefKeyName(fk.ref_key_name);
                        fkey.setNameSurrogate(fk.is_surrogate_name);
                        fkey.setDeferrable(fk.is_deferrable);
                        fkey.setInitiallyDeferred(fk.is_initially_deferred);
                        switch (fk.cascade_rule) {
                            case 'C': {
                                v5 = CascadeRule.cascade;
                                break;
                            }
                            case 'N': {
                                v5 = CascadeRule.set_null;
                                break;
                            }
                            default: {
                                v5 = CascadeRule.restrict;
                            }
                        }
                        fkey.setOnDelete(v5);
                        fkey.setModifiedTimestamp(fk.modified_timestamp);
                    }
                }
                {
                    this.$fks = list;
                    super(1);
                }
            });
        }

        private final void retrieveChecks() {
            if (!this.affectsTables) {
                return;
            }
            ObjectKind objectKind = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CHECK");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneCheck>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveChecks;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveChecks");
            List cks = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (cks.isEmpty()) {
                return;
            }
            LinkedHashSet<String> tablesWithPredicates = new LinkedHashSet<String>();
            Iterable $this$forEach$iv = cks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OraIntroQueries.OneCheck ck = (OraIntroQueries.OneCheck)element$iv;
                boolean bl = false;
                tablesWithPredicates.add(ck.table_name);
            }
            HashMap predicates = new HashMap(tablesWithPredicates.size() * 4);
            boolean v12 = OraIntrospector.this.getServerVersion().isOrGreater(new int[]{12});
            if (v12 || OraIntrospector.this.useXML) {
                if (v12) {
                    this.retrieveCheckPredicates12(CollectionsKt.toList((Iterable)tablesWithPredicates), predicates);
                } else {
                    this.retrieveCheckPredicatesXml((Collection<String>)tablesWithPredicates, predicates);
                }
                List<String> list = predicates.entrySet().stream().filter(retrieveChecks.tablesWithLongPredicates.1.INSTANCE).map(retrieveChecks.tablesWithLongPredicates.2.INSTANCE).distinct().collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"predicates.entries\n     \u2026lect(Collectors.toList())");
                List<String> tablesWithLongPredicates2 = list;
                Collection collection = tablesWithLongPredicates2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    this.retrieveCheckPredicatesLong(tablesWithLongPredicates2, predicates);
                }
            } else {
                this.retrieveCheckPredicatesLong(CollectionsKt.toList((Iterable)tablesWithPredicates), predicates);
            }
            OraIntrospector.this.reportStatusDetails("applying Check Predicates", "introspection.report.status.applying.checkPredicates");
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, cks, predicates){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $cks;
                final /* synthetic */ HashMap $predicates;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCheck ck : this.$cks) {
                        OraCheck check;
                        OraTable table;
                        String predicate;
                        String string = ck.table_name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ck.table_name");
                        String string2 = ck.constraint_name;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ck.constraint_name");
                        MajorMinorName name2 = new MajorMinorName(string, string2);
                        String string3 = (String)this.$predicates.get(name2);
                        if (string3 == null) {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"predicates[name] ?: continue");
                        CharSequence charSequence = predicate = string3;
                        boolean bl = false;
                        String string4 = charSequence;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        predicate = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                        if (!this.this$0.OraIntrospector.this.getConsiderSurrogateNotNullChecks() && ck.is_surrogate_name) {
                            charSequence = predicate;
                            Regex regex = OraIntrospectorFunctions.getAUTO_NOT_NULL_CHECK_PATTERN();
                            boolean bl2 = false;
                            if (regex.matches(charSequence)) continue;
                        }
                        OraTable oraTable = table = (OraTable)schema.getTables().createOrGet(ck.table_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraTable, (String)"table");
                        OraCheck oraCheck = check = (OraCheck)oraTable.getChecks().createOrGet(ck.constraint_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraCheck, (String)"check");
                        oraCheck.setColNames(CollectionsKt.emptyList());
                        check.setNameSurrogate(ck.is_surrogate_name);
                        check.setPredicate(predicate);
                        check.setDeferrable(ck.is_deferrable);
                        check.setInitiallyDeferred(ck.is_initially_deferred);
                        check.setModifiedTimestamp(ck.modified_timestamp);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cks = list;
                    this.$predicates = hashMap;
                    super(1);
                }
            });
        }

        private final void retrieveCheckPredicatesXml(Collection<String> tables, Map<MajorMinorName, String> predicates) {
            List packs = OraIntrospectorSourcesHelperKt.splitByPacks(CollectionsKt.toList((Iterable)tables), 100);
            OraIntrospector.this.trace("Retrieving check predicates for " + tables.size() + " tables in " + packs.size() + " portions");
            for (List pack : packs) {
                OraIntrospector.this.handleErrors("Retrieve check predicates via XML for " + pack.size() + " tables (" + CollectionsKt.joinToString$default((Iterable)pack, null, null, null, (int)0, null, null, (int)63, null) + ')', (Function0<Unit>)((Function0)new Function0<Unit>(this, pack, predicates){
                    final /* synthetic */ OraSchemaRetriever this$0;
                    final /* synthetic */ List $pack;
                    final /* synthetic */ Map $predicates;

                    public final void invoke() {
                        SqlQuery<Integer> sqlQuery = OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0.OraIntrospector.this).retrieveCheckPredicatesXml;
                        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveCheckPredicatesXml");
                        String xmlText = OraSchemaRetriever.access$performQueryReturningXmlForStringLiterals(this.this$0, sqlQuery, "names_lit", this.$pack);
                        if (xmlText == null) {
                            throw (Throwable)new ResultIsNull();
                        }
                        OraIntrospectorSourcesHelperKt.parseMinorSources(xmlText, this.$predicates);
                        OraIntrospector.access$trace(this.this$0.OraIntrospector.this, "parsed " + this.$predicates.size() + " check predicates from XML");
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                        this.$pack = list;
                        this.$predicates = map2;
                        super(0);
                    }
                }));
            }
        }

        private final void retrieveCheckPredicates12(List<String> tables, Map<MajorMinorName, String> predicates) {
            OraIntrospector.this.reportRetrieving("Check constraint predicates", "introspection.retrieve.checkPredicates.normal");
            OraIntrospector.this.trace("Retrieving check predicates using Oracle12 way for " + tables.size() + " tables");
            SqlQuery<List<OraIntroQueries.OneMinorText>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveCheckPredicates12;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveCheckPredicates12");
            this.retrieveCheckPredicates12orLong(sqlQuery, tables, predicates);
        }

        private final void retrieveCheckPredicatesLong(List<String> tables, Map<MajorMinorName, String> predicates) {
            OraIntrospector.this.reportRetrieving("Check Constraints with LONG predicates", "introspection.retrieve.checkPredicates.long");
            OraIntrospector.this.trace("Retrieving check predicates via XML for " + tables.size() + " tables");
            SqlQuery<List<OraIntroQueries.OneMinorText>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveCheckPredicatesLong;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveCheckPredicatesLong");
            this.retrieveCheckPredicates12orLong(sqlQuery, tables, predicates);
        }

        private final void retrieveCheckPredicates12orLong(SqlQuery<? extends List<OraIntroQueries.OneMinorText>> query, List<String> tables, Map<MajorMinorName, String> predicates) {
            List packs = OraIntrospectorSourcesHelperKt.splitByPacks(CollectionsKt.toList((Iterable)tables), 100);
            for (List pack : packs) {
                Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"names", pack));
                List<OraIntroQueries.OneMinorText> rows = this.performQuery(query, params2, new Object[0]);
                if (rows.isEmpty()) continue;
                this.fetchMinorTexts((Iterable<OraIntroQueries.OneMinorText>)rows, predicates);
            }
        }

        private final void fetchMinorTexts(Iterable<OraIntroQueries.OneMinorText> rows, Map<MajorMinorName, String> texts) {
            for (OraIntroQueries.OneMinorText r : rows) {
                String text;
                String minorName;
                String majorName;
                if (r.major_name == null) {
                    continue;
                }
                if (r.minor_name == null) {
                    continue;
                }
                if (r.text == null) {
                    continue;
                }
                texts.put(new MajorMinorName(majorName, minorName), text);
            }
        }

        private final void retrieveConstraintColumns() {
            if (!this.affectsTables) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneConstraintColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveConstraintColumns;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveConstraintColumns");
            List ccs = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (ccs.isEmpty()) {
                return;
            }
            StringListAggregator agg = new StringListAggregator();
            for (OraIntroQueries.OneConstraintColumn cc : ccs) {
                String key2 = cc.table_name + '\uffff' + cc.constraint_name;
                String string = cc.column_name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cc.column_name");
                agg.add((Object)key2, (Object)string);
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, agg){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $agg;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    Object object = this.$agg.getResult();
                    boolean bl = false;
                    for (Map.Entry<K, V> entry : object.entrySet()) {
                        OraConstraint constraint;
                        OraTable table;
                        void tableName;
                        void key2;
                        Object object2 = entry;
                        boolean bl2 = false;
                        object = (String)object2.getKey();
                        object2 = entry;
                        bl2 = false;
                        List colNames = (List)object2.getValue();
                        Object object3 = StringFun.unPair((String)key2, (char)'\uffff');
                        object2 = (String)object3.component1();
                        String constraintName = (String)object3.component2();
                        object3 = (CharSequence)tableName;
                        boolean bl3 = false;
                        if (object3.length() == 0) continue;
                        object3 = constraintName;
                        bl3 = false;
                        if (object3.length() == 0) continue;
                        if ((OraTable)schema.getTables().get((String)tableName) == null) {
                            continue;
                        }
                        if (OraIntrospectorFunctions.findModConstraint(table, constraintName) == null) {
                            continue;
                        }
                        constraint.setColNames(colNames);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$agg = stringListAggregator;
                    super(1);
                }
            });
        }

        private final void reorderTableDetails() {
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraSchema it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    for (OraLikeTable table : OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0)) {
                        OraLikeTable oraLikeTable = table;
                        if (oraLikeTable instanceof OraTable) {
                            OraLikeTable oraLikeTable2 = table;
                            Intrinsics.checkNotNullExpressionValue((Object)oraLikeTable2, (String)"table");
                            ((OraTable)oraLikeTable2).getColumns().sort();
                            ((OraTable)table).getIndices().sort();
                            ((OraTable)table).getKeys().sort();
                            ((OraTable)table).getForeignKeys().sort();
                            ((OraTable)table).getChecks().sort();
                            continue;
                        }
                        OraLikeTable oraLikeTable3 = table;
                        Intrinsics.checkNotNullExpressionValue((Object)oraLikeTable3, (String)"table");
                        oraLikeTable3.getColumns().sort();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers() {
            void also_retrieve_update_columns;
            if (!this.shouldWeRetrieveTriggers()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneTrigger>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggers;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveTriggers");
            List ts2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (ts2.isEmpty()) {
                return;
            }
            HashSet tables = new HashSet(ts2.size());
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, ts2, (Ref.BooleanRef)also_retrieve_update_columns, tables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ts;
                final /* synthetic */ Ref.BooleanRef $also_retrieve_update_columns;
                final /* synthetic */ HashSet $tables;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneTrigger trig : this.$ts) {
                        OraLikeTable table;
                        OraTrigger trigger;
                        String string = trig.table_name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trig.table_name");
                        if (OraIntrospectorFunctions.findTableOrViewByName(schema, string) == null) {
                            continue;
                        }
                        OraTrigger oraTrigger = trigger = (OraTrigger)table.getTriggers().renew(trig.trigger_id, trig.trigger_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraTrigger, (String)"trigger");
                        oraTrigger.setEvents(TrigEvent.of((String)trig.events));
                        trigger.setTurn(OraSchemaRetriever.access$trigTurnOf(this.this$0, trig.turn));
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(trigger, trig.created_timestamp, trig.modified_timestamp);
                        if (trigger instanceof OraTableTrigger) {
                            ((OraTableTrigger)trigger).setCondition(StringKt.nullize((String)trig.condition, (boolean)true));
                        }
                        this.$also_retrieve_update_columns.element |= trig.has_on_update_columns;
                        this.$tables.add(table);
                        OraSchemaRetriever.access$getAffectedTriggerTables$p(this.this$0).add(table.getName());
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(trigger);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ts = list;
                    this.$also_retrieve_update_columns = booleanRef;
                    this.$tables = hashSet;
                    super(1);
                }
            });
            if (also_retrieve_update_columns.element) {
                SqlQuery<List<String[]>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerUpdateColumns;
                Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"queries.retrieveTriggerUpdateColumns");
                List cols2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery2, null, 0, 6, null);
                StringListAggregator columns = new StringListAggregator();
                for (String[] col : cols2) {
                    String tableName = col[0];
                    String triggerName = col[1];
                    String columnName = col[2];
                    if (tableName == null || triggerName == null || columnName == null) continue;
                    String key2 = tableName + '\uffff' + triggerName;
                    columns.add((Object)key2, (Object)columnName);
                }
                this.inSchema((Function1)new Function1<OraSchema, Unit>(columns){
                    final /* synthetic */ StringListAggregator $columns;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull OraSchema schema) {
                        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                        Object object = this.$columns.getResult();
                        boolean bl = false;
                        for (Map.Entry<K, V> entry : object.entrySet()) {
                            OraTrigger trigger;
                            OraLikeTable table;
                            void tableName;
                            void key2;
                            Object object2 = entry;
                            boolean bl2 = false;
                            object = (String)object2.getKey();
                            object2 = entry;
                            bl2 = false;
                            List names2 = (List)object2.getValue();
                            Object object3 = StringFun.unPair((String)key2, (char)'\uffff');
                            object2 = (String)object3.component1();
                            String triggerName = (String)object3.component2();
                            object3 = (CharSequence)tableName;
                            boolean bl3 = false;
                            if (object3.length() == 0) continue;
                            object3 = triggerName;
                            bl3 = false;
                            if (object3.length() == 0) continue;
                            if (OraIntrospectorFunctions.findTableOrViewByName(schema, (String)tableName) == null) {
                                continue;
                            }
                            if ((OraTrigger)table.getTriggers().get(triggerName) == null) {
                                continue;
                            }
                            trigger.setColNames(names2);
                        }
                    }
                    {
                        this.$columns = stringListAggregator;
                        super(1);
                    }
                });
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(tables){
                final /* synthetic */ HashSet $tables;

                public final void invoke(@NotNull OraSchema it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Iterator<E> iterator = this.$tables.iterator();
                    while (iterator.hasNext()) {
                        OraLikeTable table;
                        OraLikeTable oraLikeTable = table = (OraLikeTable)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)oraLikeTable, (String)"table");
                        oraLikeTable.getTriggers().sort();
                    }
                }
                {
                    this.$tables = hashSet;
                    super(1);
                }
            });
            this.affectsTriggers = true;
        }

        private final TrigTurn trigTurnOf(short turn) {
            TrigTurn trigTurn;
            switch (turn) {
                case -2: {
                    trigTurn = TrigTurn.BEFORE_STMT;
                    break;
                }
                case -1: {
                    trigTurn = TrigTurn.BEFORE_ROW;
                    break;
                }
                case 1: {
                    trigTurn = TrigTurn.AFTER_ROW;
                    break;
                }
                case 2: {
                    trigTurn = TrigTurn.AFTER_STMT;
                    break;
                }
                case 0: {
                    trigTurn = TrigTurn.INSTEAD_OF;
                    break;
                }
                default: {
                    trigTurn = null;
                }
            }
            return trigTurn;
        }

        private final void retrievePackages() {
            ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getPackages();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.packages");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.PACKAGE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PACKAGE");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OnePackage>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrievePackages;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrievePackages");
            List packages = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (packages.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, packages){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $packages;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OnePackage p : this.$packages) {
                        OraPackageBody body2;
                        OraPackage pack;
                        if (!p.is_body) {
                            OraPackage oraPackage = pack = (OraPackage)schema.getPackages().renew(p.object_id, p.package_name);
                            Intrinsics.checkNotNullExpressionValue((Object)oraPackage, (String)"pack");
                            oraPackage.setInvalid(p.is_invalid);
                            OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(pack, p.created_timestamp, p.modified_timestamp);
                            OraSchemaRetriever.access$getAffectedPackageSpecs$p(this.this$0).add(pack);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(pack);
                            continue;
                        }
                        OraPackage oraPackage = pack = (OraPackage)schema.getPackages().createOrGet(p.package_name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraPackage, (String)"pack");
                        OraPackageBody oraPackageBody = body2 = (OraPackageBody)oraPackage.getBodies().createOrGet();
                        Intrinsics.checkNotNullExpressionValue((Object)oraPackageBody, (String)"body");
                        oraPackageBody.setObjectId(p.object_id);
                        body2.setInvalid(p.is_invalid);
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(body2, p.created_timestamp, p.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedModuleBodies$p(this.this$0).add(body2);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body2);
                    }
                    schema.getPackages().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$packages = list;
                    super(1);
                }
            });
            this.affectsModulesOrBodies = true;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveInnerRoutines(Set<? extends OraModule> affectedModules, ObjectKind kind) {
            Collection collection = affectedModules;
            boolean bl = false;
            if (!collection.isEmpty()) {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = affectedModules;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    String string;
                    void it;
                    OraModule oraModule = (OraModule)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"it.name");
                    map2.put(string, element$iv$iv);
                }
                Map modules = destination$iv$iv;
                this.retrieveInnerRoutinesHeads(modules, kind);
                this.retrieveInnerRoutinesArguments(modules);
            }
        }

        private final void retrieveInnerRoutines() {
            OraIntrospector.this.reportRetrieving("Inner procedures and functions", "introspection.retrieve.innerRoutines");
            Set set = this.affectedPackageSpecs;
            ObjectKind objectKind = ObjectKind.PACKAGE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PACKAGE");
            this.retrieveInnerRoutines(set, objectKind);
            Set set2 = this.affectedObjectTypeSpecs;
            ObjectKind objectKind2 = ObjectKind.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"OBJECT_TYPE");
            this.retrieveInnerRoutines(set2, objectKind2);
            this.adjustInnerRoutines();
        }

        private final void retrieveInnerRoutinesHeads(Map<String, ? extends OraModule> modules, ObjectKind kind) {
            Object object;
            SqlQuery<List<OraIntroQueries.OneTypeMethod>> _true_$iv;
            boolean $i$f$choose;
            Object _false_$iv;
            boolean v11 = OraIntrospector.this.getServerVersion().isOrGreater(new int[]{11});
            ObjectKind objectKind = kind;
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE)) {
                boolean bl = v11;
                SqlQuery<List<OraIntroQueries.OnePackageRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutines11;
                _false_$iv = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutines10;
                $i$f$choose = false;
                object = bl ? _true_$iv : _false_$iv;
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) {
                boolean bl = v11;
                _true_$iv = ((OraIntrospector)OraIntrospector.this).queries.retrieveTypeMethods11;
                _false_$iv = ((OraIntrospector)OraIntrospector.this).queries.retrieveTypeMethods10;
                $i$f$choose = false;
                object = bl ? _true_$iv : _false_$iv;
            } else {
                return;
            }
            Object query = object;
            List portions = OraIntrospectorSourcesHelperKt.splitByPacks((Collection)modules.keySet(), 100);
            for (List list : portions) {
                Object object2 = query;
                Intrinsics.checkNotNullExpressionValue(object2, (String)"query");
                List<OraIntroQueries.OneTypeMethod> routines = this.performQuery(object2, MapsKt.mapOf((Pair)TuplesKt.to((Object)"module_names", (Object)list)), new Object[0]);
                this.inSchema((Function1)new Function1<OraSchema, Unit>(this, list, modules, routines){
                    final /* synthetic */ OraSchemaRetriever this$0;
                    final /* synthetic */ List $portion;
                    final /* synthetic */ Map $modules;
                    final /* synthetic */ List $routines;

                    public final void invoke(@NotNull OraSchema it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Map portionModules = new HashMap<K, V>(this.$portion.size());
                        for (String name2 : this.$portion) {
                            OraModule m;
                            if ((OraModule)this.$modules.get(name2) == null) {
                                continue;
                            }
                            m.getRoutines().markChildrenAsSyncPending();
                            portionModules.put(name2, m);
                        }
                        Iterator<Object> iterator = this.$routines.iterator();
                        while (iterator.hasNext()) {
                            OraModule module;
                            OraIntroQueries.OneInnerRoutine r;
                            OraIntroQueries.OneInnerRoutine oneInnerRoutine = r = (OraIntroQueries.OneInnerRoutine)iterator.next();
                            Intrinsics.checkNotNullExpressionValue((Object)oneInnerRoutine, (String)"r");
                            if ((OraModule)portionModules.get(oneInnerRoutine.getModuleName()) == null) {
                                continue;
                            }
                            OraInnerRoutine routine2 = (OraInnerRoutine)module.getRoutines().get(r.getRoutineName(), true, new Predicate(r){
                                final /* synthetic */ OraIntroQueries.OneInnerRoutine $r;

                                public final boolean test(OraInnerRoutine it) {
                                    OraInnerRoutine oraInnerRoutine = it;
                                    Intrinsics.checkNotNullExpressionValue((Object)oraInnerRoutine, (String)"it");
                                    short s = oraInnerRoutine.getOverloadNr();
                                    OraIntroQueries.OneInnerRoutine oneInnerRoutine = this.$r;
                                    Intrinsics.checkNotNullExpressionValue((Object)oneInnerRoutine, (String)"r");
                                    return s == oneInnerRoutine.getOverloadNr();
                                }
                                {
                                    this.$r = oneInnerRoutine;
                                }
                            });
                            if (routine2 == null) {
                                BasicModElement basicModElement = module.getRoutines().createNewOne();
                                Intrinsics.checkNotNull((Object)basicModElement);
                                routine2 = (OraInnerRoutine)basicModElement;
                                routine2.setName(r.getRoutineName());
                                routine2.setOverloadNr(r.getOverloadNr());
                            }
                            routine2.setDeterministic(r.isDeterministic());
                            if (routine2 instanceof OraObjectTypeRoutine) {
                                OraIntroQueries.OneInnerRoutine oneInnerRoutine2 = r;
                                if (!(oneInnerRoutine2 instanceof OraIntroQueries.OneTypeMethod)) {
                                    oneInnerRoutine2 = null;
                                }
                                if ((OraIntroQueries.OneTypeMethod)oneInnerRoutine2 != null) {
                                    OraIntroQueries.OneTypeMethod oneTypeMethod;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    OraIntroQueries.OneTypeMethod it2 = oneTypeMethod;
                                    boolean bl3 = false;
                                    ((OraObjectTypeRoutine)routine2).setFinal(it2.is_final);
                                    ((OraObjectTypeRoutine)routine2).setInstantiable(it2.is_instantiable);
                                    ((OraObjectTypeRoutine)routine2).setOverriding(it2.is_overriding);
                                }
                            }
                            routine2.resetSyncPending();
                            OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0).add(routine2);
                        }
                        for (OraModule module : portionModules.values()) {
                            ModNamingFamily<? extends OraInnerRoutine> moduleRoutines;
                            Intrinsics.checkNotNullExpressionValue(module.getRoutines(), (String)"module.routines");
                            moduleRoutines.removeSyncPendingChildren();
                            moduleRoutines.sort();
                        }
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                        this.$portion = list;
                        this.$modules = map2;
                        this.$routines = list2;
                        super(1);
                    }
                });
            }
        }

        private final void retrieveInnerRoutinesArguments(Map<String, ? extends OraModule> modules) {
            OraIntrospector.this.reportRetrieving("Inner procedures and functions (arguments and result types)", "introspection.retrieve.innerRoutinesArguments");
            List portions = OraIntrospectorSourcesHelperKt.splitByPacks((Collection)modules.keySet(), 100);
            for (List portion : portions) {
                SqlQuery<List<OraIntroQueries.OneInnerRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutineArguments;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveInnerRoutineArguments");
                List args2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, MapsKt.mapOf((Pair)TuplesKt.to((Object)"module_names", portion)), 0, 4, null);
                this.inSchema((Function1)new Function1<OraSchema, Unit>(this, portion, modules, args2){
                    final /* synthetic */ OraSchemaRetriever this$0;
                    final /* synthetic */ List $portion;
                    final /* synthetic */ Map $modules;
                    final /* synthetic */ List $args;

                    public final void invoke(@NotNull OraSchema it) {
                        OraModule m;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Map portionModules = new HashMap<K, V>(this.$portion.size());
                        for (String name2 : this.$portion) {
                            if ((OraModule)this.$modules.get(name2) == null) {
                                continue;
                            }
                            ModNamingFamily<? extends OraInnerRoutine> modNamingFamily = m.getRoutines();
                            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"m.routines");
                            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                OraInnerRoutine r = (OraInnerRoutine)element$iv;
                                boolean bl = false;
                                OraInnerRoutine oraInnerRoutine = r;
                                Intrinsics.checkNotNullExpressionValue((Object)oraInnerRoutine, (String)"r");
                                oraInnerRoutine.getArguments().markChildrenAsSyncPending();
                            }
                            portionModules.put(name2, m);
                        }
                        for (OraIntroQueries.OneInnerRoutineArgument a : this.$args) {
                            OraInnerRoutine routine2;
                            if (a.package_name == null || a.routine_name == null) continue;
                            OraSchema oraSchema = (OraSchema)this.this$0.getSchema();
                            String string = a.package_name;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"a.package_name");
                            if (OraIntrospectorFunctions.findModuleByName(oraSchema, string) == null) {
                                continue;
                            }
                            if ((OraInnerRoutine)m.getRoutines().get(a.routine_name, true, new Predicate(a){
                                final /* synthetic */ OraIntroQueries.OneInnerRoutineArgument $a;

                                public final boolean test(OraInnerRoutine it) {
                                    OraInnerRoutine oraInnerRoutine = it;
                                    Intrinsics.checkNotNullExpressionValue((Object)oraInnerRoutine, (String)"it");
                                    return oraInnerRoutine.getOverloadNr() == this.$a.overload_nr;
                                }
                                {
                                    this.$a = oneInnerRoutineArgument;
                                }
                            }) == null) {
                                continue;
                            }
                            BasicSchema basicSchema = (BasicSchema)this.this$0.getSchema();
                            OraRoutine oraRoutine = routine2;
                            short s = a.position;
                            String string2 = a.arg_name;
                            char c = a.arg_direction;
                            String string3 = a.type_mod;
                            String string4 = a.data_type_schema_name;
                            String string5 = a.data_type_package_name;
                            String string6 = a.data_type;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"a.data_type");
                            OraIntrospectorFunctions.makeArgument(basicSchema, oraRoutine, s, string2, c, string3, string4, string5, string6, a.is_defaulted);
                        }
                        Iterable $this$forEach$iv = portionModules.values();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            OraModule module = (OraModule)element$iv;
                            boolean bl = false;
                            ModNamingFamily<? extends OraInnerRoutine> modNamingFamily = module.getRoutines();
                            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"module.routines");
                            Iterable $this$forEach$iv2 = (Iterable)modNamingFamily;
                            boolean $i$f$forEach2 = false;
                            for (T element$iv2 : $this$forEach$iv2) {
                                OraInnerRoutine routine3 = (OraInnerRoutine)element$iv2;
                                boolean bl2 = false;
                                OraInnerRoutine oraInnerRoutine = routine3;
                                Intrinsics.checkNotNullExpressionValue((Object)oraInnerRoutine, (String)"routine");
                                oraInnerRoutine.getArguments().removeSyncPendingChildren();
                                routine3.getArguments().sort();
                            }
                        }
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                        this.$portion = list;
                        this.$modules = map2;
                        this.$args = list2;
                        super(1);
                    }
                });
            }
        }

        private final void adjustInnerRoutines() {
            if (this.affectedInnerRoutines.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraSchema it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    for (BasicRoutine routine2 : OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0)) {
                        if (!(routine2 instanceof BasicModRoutine)) continue;
                        ((BasicModRoutine)routine2).setRoutineKind(((BasicModRoutine)routine2).getReturnArgument() == null ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveSingleRoutines() {
            ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.routines");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneSingleRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutines;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveSingleRoutines");
            List routines = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            if (routines.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneSingleRoutine r : this.$routines) {
                        OraSingleRoutine routine2;
                        OraSingleRoutine oraSingleRoutine = routine2 = (OraSingleRoutine)schema.getRoutines().renew(r.object_id, r.name);
                        Intrinsics.checkNotNullExpressionValue((Object)oraSingleRoutine, (String)"routine");
                        oraSingleRoutine.setRoutineKind(DasRoutine.Kind.byChar((char)r.kind));
                        routine2.setInvalid(r.is_invalid);
                        routine2.setDeterministic(r.is_deterministic);
                        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps(routine2, r.created_timestamp, r.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).add(routine2);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(routine2);
                    }
                    schema.getRoutines().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines = list;
                    super(1);
                }
            });
        }

        private final void retrieveSingleRoutinesArguments() {
            if (this.affectedSingleRoutines.isEmpty()) {
                return;
            }
            OraIntrospector.this.reportRetrieving("Procedures and functions (arguments and result types)", "introspection.retrieve.singleRoutinesArguments");
            SqlQuery<List<OraIntroQueries.OneSingleRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutineArguments;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveSingleRoutineArguments");
            List args2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, null, 0, 6, null);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, args2){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $args;

                public final void invoke(@NotNull OraSchema schema) {
                    BasicRoutine r;
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    Iterator<E> iterator = OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        BasicRoutine basicRoutine = r = (BasicRoutine)iterator.next();
                        if (basicRoutine == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraRoutine");
                        }
                        ((OraRoutine)basicRoutine).getArguments().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneSingleRoutineArgument a : this.$args) {
                        OraSingleRoutine routine2;
                        if (a.routine_name == null) continue;
                        if ((OraSingleRoutine)schema.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = (BasicSchema)schema;
                        OraRoutine oraRoutine = routine2;
                        short s = a.position;
                        String string = a.arg_name;
                        char c = a.arg_direction;
                        String string2 = a.type_mod;
                        String string3 = a.data_type_schema_name;
                        String string4 = a.data_type_package_name;
                        String string5 = a.data_type;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"a.data_type");
                        OraIntrospectorFunctions.makeArgument(basicSchema, oraRoutine, s, string, c, string2, string3, string4, string5, a.is_defaulted);
                    }
                    iterator = OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        ModPositioningNamingFamily<? extends OraArgument> arguments;
                        BasicRoutine basicRoutine = r = (BasicRoutine)iterator.next();
                        if (basicRoutine == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraRoutine");
                        }
                        Intrinsics.checkNotNullExpressionValue(((OraRoutine)basicRoutine).getArguments(), (String)"(r as OraRoutine).arguments");
                        arguments.removeSyncPendingChildren();
                        arguments.sort();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$args = list;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDbLinks() {
            void links;
            long hash;
            ObjectKind objectKind = ObjectKind.DB_LINK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DB_LINK");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<Long> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.calculateDbLinksHash;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.calculateDbLinksHash");
            Long l = this.performQuery(sqlQuery);
            long l2 = hash = l != null ? l : 0L;
            if (hash == ((OraSchema)this.getSchema()).getDbLinksHash() && ((OraSchema)this.getSchema()).getDbLinksHash() != -1L) {
                return;
            }
            if (hash == 0L) {
                ModNamingFamily<? extends OraDbLink> modNamingFamily = ((OraSchema)this.getSchema()).getDbLinks();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"schema.dbLinks");
                if (modNamingFamily.isNotEmpty()) {
                    this.inSchema((Function1)new Function1<OraSchema, Unit>(hash){
                        final /* synthetic */ long $hash;

                        public final void invoke(@NotNull OraSchema schema) {
                            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                            schema.getDbLinks().clear();
                            schema.setDbLinksHash(this.$hash);
                        }
                        {
                            this.$hash = l;
                            super(1);
                        }
                    });
                }
                return;
            }
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            if (OraIntrospector.this.getCatalogPermissions().getHasSCR()) {
                try {
                    OraIntrospector.this.trace("Retrieving DB links with sources");
                    SqlQuery<List<OraIntroQueries.OneDbLink>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveDbLinksWithSrc;
                    Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"queries.retrieveDbLinksWithSrc");
                    links.element = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery2, null, 0, 6, null);
                    OraIntrospector.this.trace("Retrieved " + ((List)links.element).size() + " DB links with sources");
                }
                catch (NoTableOrViewException e2) {
                    OraIntrospector.this.logExpectedOraError((DBException)((Object)e2));
                }
                catch (DBAccessDeniedException e3) {
                    OraIntrospector.this.logExpectedOraError((DBException)((Object)e3));
                }
                catch (OracleObjectNotFoundException e4) {
                    OraIntrospector.this.logExpectedOraError((DBException)((Object)e4));
                }
            }
            if ((List)links.element == null) {
                OraIntrospector.this.trace("Retrieving DB links in simple mode");
                SqlQuery<List<OraIntroQueries.OneDbLink>> sqlQuery3 = ((OraIntrospector)OraIntrospector.this).queries.retrieveDbLinks;
                Intrinsics.checkNotNullExpressionValue(sqlQuery3, (String)"queries.retrieveDbLinks");
                links.element = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery3, null, 0, 6, null);
                OraIntrospector.this.trace("Retrieved " + ((List)links.element).size() + " DB links (in simple mode, no sources)");
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, (Ref.ObjectRef)links, hash){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Ref.ObjectRef $links;
                final /* synthetic */ long $hash;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    schema.getDbLinks().markChildrenAsSyncPending();
                    for (OraIntroQueries.OneDbLink l : (List)this.$links.element) {
                        String name2;
                        if (l.name == null) {
                            continue;
                        }
                        BasicModNamedElement basicModNamedElement = schema.getDbLinks().createOrGet(name2);
                        Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"schema.dbLinks.createOrGet(name)");
                        OraDbLink dbLink = (OraDbLink)basicModNamedElement;
                        dbLink.setRemoteDatabaseString(l.remote_db);
                        dbLink.setSystem(Intrinsics.areEqual((Object)name2, (Object)"DBMS_CLRDBLINK") || StringsKt.startsWith$default((String)name2, (String)"DBMS_CLRDBLINK.", (boolean)false, (int)2, null));
                        dbLink.setConnectUserName(l.connect_user_name);
                        dbLink.setCreatedTimestamp(l.created_timestamp);
                        String src2 = l.src;
                        if (src2 == null) continue;
                        OraIntrospectorFunctions.analyzeDbLinkSrc(src2, dbLink);
                    }
                    schema.getDbLinks().removeSyncPendingChildren();
                    schema.getDbLinks().sort();
                    schema.setDbLinksHash(this.this$0.getMode() == IntrospectionMode.FRAGMENT ? -1L : this.$hash);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$links = objectRef;
                    this.$hash = l;
                    super(1);
                }
            });
        }

        private final void retrieveComments() {
            long hash;
            ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.tables");
            if (modNamingIdentifyingFamily.isEmpty()) {
                ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily2 = ((OraSchema)this.getSchema()).getMatViews();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"schema.matViews");
                if (modNamingIdentifyingFamily2.isEmpty()) {
                    ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily3 = ((OraSchema)this.getSchema()).getViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"schema.views");
                    if (modNamingIdentifyingFamily3.isEmpty()) {
                        if (((OraSchema)this.getSchema()).getCommentsHash() != 0L) {
                            this.inSchema(retrieveComments.1.INSTANCE);
                        }
                        return;
                    }
                }
            }
            OraIntrospector.this.reportRetrieving("Comments", "introspection.retrieve.comments");
            SqlQuery<Long> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.calculateCommentsHash;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.calculateCommentsHash");
            Long l = this.performQuery(sqlQuery);
            long l2 = hash = l != null ? l : 0L;
            if (hash == ((OraSchema)this.getSchema()).getCommentsHash()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneComment>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveComments;
            Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"queries.retrieveComments");
            List<OraIntroQueries.OneComment> comments = this.performQuery(sqlQuery2);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, hash, comments){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ long $hash;
                final /* synthetic */ List $comments;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    schema.setCommentsHash(this.this$0.getMode() == IntrospectionMode.FRAGMENT ? -1L : this.$hash);
                    HashSet<Object> touched = new HashSet<Object>();
                    for (OraIntroQueries.OneComment c : this.$comments) {
                        OraLikeColumn column2;
                        OraLikeTable table;
                        String string = c.table_name;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.table_name");
                        if (OraIntrospectorFunctions.findTableOrViewByName(schema, string) == null) {
                            continue;
                        }
                        if (c.column_name == null) {
                            table.setComment(c.comments);
                            touched.add(table);
                            continue;
                        }
                        if ((OraLikeColumn)table.getColumns().get(c.column_name) == null) {
                            continue;
                        }
                        column2.setComment(c.comments);
                        touched.add(column2);
                    }
                    for (OraLikeTable t : OraSchemaRetriever.access$seanceRelatedTablesAndViews(this.this$0, schema)) {
                        if (!touched.contains(t)) {
                            t.setComment(null);
                        }
                        for (OraLikeColumn column3 : t.getColumns()) {
                            if (touched.contains(column3)) continue;
                            OraLikeColumn oraLikeColumn = column3;
                            Intrinsics.checkNotNullExpressionValue((Object)oraLikeColumn, (String)"column");
                            oraLikeColumn.setComment(null);
                        }
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$hash = l;
                    this.$comments = list;
                    super(1);
                }
            });
        }

        private final Iterable<OraLikeTable> seanceRelatedTablesAndViews(OraSchema schema) {
            if (this.getMode() == IntrospectionMode.FRAGMENT) {
                JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from((Iterable)((Iterable)schema.getTables())).filter(new Condition(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraTable it) {
                        Object[] objectArray = this.this$0.getFragmentNames();
                        OraTable oraTable = it;
                        Intrinsics.checkNotNullExpressionValue((Object)oraTable, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraTable.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)((Iterable)schema.getMatViews())).filter(new Condition(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraMatView it) {
                        Object[] objectArray = this.this$0.getFragmentNames();
                        OraMatView oraMatView = it;
                        Intrinsics.checkNotNullExpressionValue((Object)oraMatView, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraMatView.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)((Iterable)schema.getViews())).filter(new Condition(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraView it) {
                        Object[] objectArray = this.this$0.getFragmentNames();
                        OraView oraView = it;
                        Intrinsics.checkNotNullExpressionValue((Object)oraView, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraView.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.empty<OraLike\u2026.name in fragmentNames })");
                return (Iterable)jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from((Iterable)((Iterable)schema.getTables()))).append((Iterable)JBIterable.from((Iterable)((Iterable)schema.getMatViews()))).append((Iterable)JBIterable.from((Iterable)((Iterable)schema.getViews())));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.empty<OraLike\u2026rable.from(schema.views))");
            return (Iterable)jBIterable;
        }

        private final void retrieveDependencies() {
            if (this.affectedDepObjects.isEmpty()) {
                return;
            }
            if (Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"SYS") || Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC")) {
                return;
            }
            OraIntrospector.this.reportRetrieving("Dependencies", "introspection.retrieve.dependencies");
            if (OraIntrospector.this.getCatalogPermissions().getFast()) {
                this.retrieveDependenciesFast();
            } else {
                this.retrieveDependenciesSlow();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDependenciesFast() {
            void $this$groupByTo$iv$iv;
            SqlQuery<List<OraIntroQueries.OneDependency>> query;
            SqlQuery<List<OraIntroQueries.OneDependency>> sqlQuery = query = ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesFast;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
            List<OraIntroQueries.OneDependency> deps = this.performQuery(sqlQuery);
            if (deps.isEmpty()) {
                return;
            }
            List<OraIntroQueries.OneDependency> list = deps;
            Intrinsics.checkNotNullExpressionValue(list, (String)"deps");
            Iterable $this$groupBy$iv = list;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object;
                OraIntroQueries.OneDependency it2 = (OraIntroQueries.OneDependency)element$iv$iv;
                boolean $i$a$-groupBy-OraIntrospector$OraSchemaRetriever$retrieveDependenciesFast$g$32 = false;
                Long key$iv$iv = it2.object_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                OraIntroQueries.OneDependency $i$a$-groupBy-OraIntrospector$OraSchemaRetriever$retrieveDependenciesFast$g$32 = (OraIntroQueries.OneDependency)element$iv$iv;
                List list2 = list$iv$iv;
                boolean bl = false;
                Long l = it.referenced_id;
                list2.add(l);
            }
            Map g = destination$iv$iv;
            this.inSchema((Function1)new Function1<OraSchema, Unit>(g){
                final /* synthetic */ Map $g;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    BasicDatabase basicDatabase = schema.getDatabase();
                    if (basicDatabase == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModDatabase");
                    }
                    BasicModDatabase db = (BasicModDatabase)basicDatabase;
                    Map map2 = this.$g;
                    boolean bl = false;
                    for (Map.Entry<K, V> d : map2.entrySet()) {
                        BasicIdentifiedElement o2 = db.findIdentifiedElement(((Number)d.getKey()).longValue());
                        if (!(o2 instanceof OraSourceAware) || ((OraSourceAware)o2).getSchema() != schema) continue;
                        BasicElement parent2 = ((OraSourceAware)o2).getParent();
                        BasicElement basicElement = parent2;
                        if (!(basicElement instanceof BasicIdentifiedElement)) {
                            basicElement = null;
                        }
                        BasicIdentifiedElement basicIdentifiedElement = (BasicIdentifiedElement)basicElement;
                        long parentId = basicIdentifiedElement != null ? basicIdentifiedElement.getObjectId() : Long.MIN_VALUE;
                        ((OraSourceAware)o2).setDependsOnIds(SetsKt.minus((Set)CollectionsKt.toSortedSet((Iterable)((Iterable)d.getValue())), (Object)parentId));
                    }
                }
                {
                    this.$g = map2;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDependenciesSlow() {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            SqlQuery<List<OraIntroQueries.OneSlowDependency>> query;
            if (this.affectedDepObjects.isEmpty()) {
                return;
            }
            if (Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"SYS") || Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC")) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneSlowDependency>> sqlQuery = query = this.getMode().fragment ? ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesSlowFrag : ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesSlow;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
            List<OraIntroQueries.OneSlowDependency> deps = this.performQuery(sqlQuery);
            if (deps.isEmpty()) {
                return;
            }
            List<OraIntroQueries.OneSlowDependency> list = deps;
            Intrinsics.checkNotNullExpressionValue(list, (String)"deps");
            Iterable iterable = list;
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                OraIntroQueries.OneSlowDependency oneSlowDependency = (OraIntroQueries.OneSlowDependency)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                OraTypeAndName oraTypeAndName = new OraTypeAndName(x.type, x.name);
                String string = x.referenced_schema_name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"x.referenced_schema_name");
                OraSlowDependencyEntry oraSlowDependencyEntry = new OraSlowDependencyEntry(oraTypeAndName, string, new OraTypeAndName(x.referenced_type, x.referenced_name), x.referenced_id);
                collection.add(oraSlowDependencyEntry);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                OraSlowDependencyEntry d = (OraSlowDependencyEntry)element$iv$iv;
                boolean bl = false;
                OraTypeAndName key$iv$iv = d.getDepObject();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object g = destination$iv$iv;
            this.inSchema((Function1)new Function1<OraSchema, Unit>((Map)g){
                final /* synthetic */ Map $g;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    BasicDatabase basicDatabase = schema.getDatabase();
                    if (basicDatabase == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModDatabase");
                    }
                    BasicModDatabase db = (BasicModDatabase)basicDatabase;
                    Map map2 = this.$g;
                    boolean bl = false;
                    for (Map.Entry<K, V> d : map2.entrySet()) {
                        BasicElement o2 = OraIntrospectorFunctions.findOracleObjectByStringTypeAndName((BasicSchema)schema, (OraTypeAndName)d.getKey());
                        if (o2 == null || !(o2 instanceof OraSourceAware)) continue;
                        List refIds = new ArrayList<E>(((List)d.getValue()).size());
                        for (OraSlowDependencyEntry e2 : (List)d.getValue()) {
                            long refObjectId = 0L;
                            if (e2.getRefId() != 0L) {
                                refObjectId = e2.getRefId();
                            } else {
                                BasicElement refObject;
                                BasicModSchema basicModSchema;
                                if (Intrinsics.areEqual((Object)e2.getRefSchemaName(), (Object)"@")) {
                                    basicModSchema = schema;
                                } else {
                                    basicModSchema = (BasicModSchema)db.getSchemas().get(e2.getRefSchemaName());
                                    if (basicModSchema == null) {
                                        continue;
                                    }
                                }
                                BasicModSchema refSchema = basicModSchema;
                                if (OraIntrospectorFunctions.findOracleObjectByStringTypeAndName((BasicSchema)refSchema, e2.getRefObject()) == null) {
                                    continue;
                                }
                                if (refObject instanceof BasicIdentifiedElement) {
                                    refObjectId = ((BasicIdentifiedElement)refObject).getObjectId();
                                }
                            }
                            if (refObjectId == 0L) continue;
                            refIds.add(refObjectId);
                        }
                        BasicElement parent2 = ((OraSourceAware)o2).getParent();
                        BasicElement basicElement = parent2;
                        if (!(basicElement instanceof BasicIdentifiedElement)) {
                            basicElement = null;
                        }
                        BasicIdentifiedElement basicIdentifiedElement = (BasicIdentifiedElement)basicElement;
                        long parentId = basicIdentifiedElement != null ? basicIdentifiedElement.getObjectId() : Long.MIN_VALUE;
                        ((OraSourceAware)o2).setDependsOnIds(SetsKt.minus((Set)CollectionsKt.toSortedSet((Iterable)refIds), (Object)parentId));
                    }
                }
                {
                    this.$g = map2;
                    super(1);
                }
            });
        }

        private final void retrieveSources() {
            boolean hP;
            if (!this.getWithSources()) {
                return;
            }
            boolean hV = ((OraSchema)this.getSchema()).getViews().hasChildren();
            boolean hM = ((OraSchema)this.getSchema()).getMatViews().hasChildren();
            boolean hT = ModelFun.hasTriggers((BasicSchema)((BasicSchema)this.getSchema()));
            boolean bl = hP = ((OraSchema)this.getSchema()).getPackages().hasChildren() || ((OraSchema)this.getSchema()).getRoutines().hasChildren() || ((OraSchema)this.getSchema()).getObjectTypes().hasChildren();
            if (!(hV || hM || hT || hP)) {
                return;
            }
            this.retrieveProgramSourcesByPortions();
            Collection<OraMajorSourceText> matViewBodies = this.retrieveMatViewSources();
            Collection<OraMajorSourceText> viewBodies = this.retrieveViewSources();
            Map<MajorMinorName, String> triggerBodies = this.retrieveTriggerSources();
            if (viewBodies.isEmpty() && matViewBodies.isEmpty() && triggerBodies.isEmpty()) {
                return;
            }
            OraIntrospector.this.reportStatusDetails("applying sources", "introspection.report.status.applying.sources");
            BaseIntrospector this_$iv = OraIntrospector.this;
            boolean $i$f$writeSources = false;
            this_$iv.getModel().writeSources(new Runnable(this, matViewBodies, viewBodies, triggerBodies){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Collection $matViewBodies$inlined;
                final /* synthetic */ Collection $viewBodies$inlined;
                final /* synthetic */ Map $triggerBodies$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$matViewBodies$inlined = collection;
                    this.$viewBodies$inlined = collection2;
                    this.$triggerBodies$inlined = map2;
                }

                public final void run() {
                    boolean bl = false;
                    Object object = this.$matViewBodies$inlined;
                    boolean bl2 = false;
                    if (!object.isEmpty()) {
                        OraIntrospector.access$trace(this.this$0.OraIntrospector.this, "Applying sources for " + this.$matViewBodies$inlined.size() + " materialized views");
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraSchema, Unit>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull OraSchema schema) {
                                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                                for (OraMajorSourceText v2 : this.this$0.$matViewBodies$inlined) {
                                    BasicModSourceAware view = (BasicModSourceAware)schema.getMatViews().get(v2.name);
                                    if (view == null) continue;
                                    OraIntrospectorFunctions.applyViewSources(view, v2.text);
                                }
                            }
                        });
                    }
                    object = this.$viewBodies$inlined;
                    bl2 = false;
                    if (!object.isEmpty()) {
                        OraIntrospector.access$trace(this.this$0.OraIntrospector.this, "Applying sources for " + this.$viewBodies$inlined.size() + " views");
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraSchema, Unit>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull OraSchema schema) {
                                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                                for (OraMajorSourceText v2 : this.this$0.$viewBodies$inlined) {
                                    BasicModSourceAware view = (BasicModSourceAware)schema.getViews().get(v2.name);
                                    if (view == null) continue;
                                    OraIntrospectorFunctions.applyViewSources(view, v2.text);
                                }
                            }
                        });
                    }
                    object = this.$triggerBodies$inlined;
                    bl2 = false;
                    if (!object.isEmpty()) {
                        OraIntrospector.access$trace(this.this$0.OraIntrospector.this, "Applying sources for " + this.$triggerBodies$inlined.size() + " triggers");
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraSchema, Unit>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull OraSchema schema) {
                                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                                Iterator<Map.Entry<K, V>> iterator = this.this$0.$triggerBodies$inlined.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    OraTrigger trigger;
                                    OraLikeTable table;
                                    void ident;
                                    Map.Entry<K, V> entry;
                                    Map.Entry<K, V> entry2 = entry = iterator.next();
                                    boolean bl = false;
                                    MajorMinorName majorMinorName = (MajorMinorName)entry2.getKey();
                                    entry2 = entry;
                                    bl = false;
                                    String text = (String)entry2.getValue();
                                    if (OraIntrospectorFunctions.findTableOrViewByName(schema, ident.getMajor()) == null) {
                                        continue;
                                    }
                                    if ((OraTrigger)table.getTriggers().get(ident.getMinor()) == null) {
                                        continue;
                                    }
                                    CharSequence charSequence = text;
                                    boolean bl2 = false;
                                    trigger.setSourceText(!StringsKt.isBlank((CharSequence)charSequence) ? (CompositeText)new SimpleCompositeText((CharSequence)text, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                }
                            }
                        });
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveProgramSourcesByPortions() {
            Object[] names2 = null;
            if (this.getMode().fragment) {
                names2 = this.getFragmentNames();
            } else {
                OraIntrospector.this.reportStatusDetails("listing sources to retrieve", "introspection.report.status.listing.sources");
                SqlQuery<String[]> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.listSourceNames;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.listSourceNames");
                String[] stringArray = this.performQuery(sqlQuery);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"performQuery(queries.listSourceNames)");
                names2 = stringArray;
            }
            int n = names2.length;
            if (n == 0) {
                return;
            }
            OraIntrospector.this.reportRetrieving("Program Sources", "introspection.retrieve.program.sources");
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)100);
            int n2 = intProgression.getFirst();
            int n3 = intProgression.getLast();
            int n4 = intProgression.getStep();
            int n5 = n2;
            int n6 = n3;
            if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void offset;
                    void var7_7 = offset + 100;
                    boolean bl = false;
                    List<String> portionOfNames = ArraysKt.asList((Object[])names2).subList((int)offset, Math.min((int)var7_7, n));
                    this.retrieveProgramSourcePortion(portionOfNames);
                    if (offset == n3) break;
                    n2 = offset + n4;
                }
            }
        }

        private final void retrieveProgramSourcePortion(List<String> names2) {
            Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"portion_names", names2));
            SqlQuery<List<OraIntroQueries.OneSrcLine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrievePortionOfSources;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrievePortionOfSources");
            List lines = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, params2, 0, 4, null);
            Collection collection = lines;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.applySourceLines(lines);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void applySourceLines(Collection<OraIntroQueries.OneSrcLine> lines) {
            void theName;
            void theType;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = "";
            StringBuilder buf = new StringBuilder();
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, lines, (Ref.ObjectRef)theType, (Ref.ObjectRef)theName, buf){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Collection $lines;
                final /* synthetic */ Ref.ObjectRef $theType;
                final /* synthetic */ Ref.ObjectRef $theName;
                final /* synthetic */ StringBuilder $buf;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    BaseIntrospector this_$iv = this.this$0.OraIntrospector.this;
                    boolean $i$f$writeSources = false;
                    this_$iv.getModel().writeSources(new Runnable(this, schema){
                        final /* synthetic */ applySourceLines.1 this$0;
                        final /* synthetic */ OraSchema $schema$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$schema$inlined = oraSchema;
                        }

                        public final void run() {
                            boolean bl = false;
                            for (OraIntroQueries.OneSrcLine line : this.this$0.$lines) {
                                boolean theSame;
                                boolean bl2 = theSame = Intrinsics.areEqual((Object)((String)this.this$0.$theType.element), (Object)line.type) && Intrinsics.areEqual((Object)((String)this.this$0.$theName.element), (Object)line.name);
                                if (!theSame) {
                                    OraSchemaRetriever oraSchemaRetriever = this.this$0.this$0;
                                    String string = (String)this.this$0.$theType.element;
                                    String string2 = (String)this.this$0.$theName.element;
                                    String string3 = this.this$0.$buf.toString();
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"buf.toString()");
                                    OraSchemaRetriever.access$applySources(oraSchemaRetriever, this.$schema$inlined, string, string2, string3);
                                    Ref.ObjectRef objectRef = this.this$0.$theType;
                                    Intrinsics.checkNotNullExpressionValue((Object)line.type, (String)"line.type");
                                    objectRef.element = objectRef.element;
                                    Ref.ObjectRef objectRef2 = this.this$0.$theName;
                                    Intrinsics.checkNotNullExpressionValue((Object)line.name, (String)"line.name");
                                    objectRef2.element = objectRef2.element;
                                    this.this$0.$buf.delete(0, this.this$0.$buf.length());
                                }
                                this.this$0.$buf.append(line.text);
                            }
                            OraSchemaRetriever oraSchemaRetriever = this.this$0.this$0;
                            String string = (String)this.this$0.$theType.element;
                            String string4 = (String)this.this$0.$theName.element;
                            String string5 = this.this$0.$buf.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"buf.toString()");
                            OraSchemaRetriever.access$applySources(oraSchemaRetriever, this.$schema$inlined, string, string4, string5);
                        }
                    });
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$lines = collection;
                    this.$theType = objectRef;
                    this.$theName = objectRef2;
                    this.$buf = stringBuilder;
                    super(1);
                }
            });
        }

        private final void applySources(OraSchema $this$applySources, String type, String name2, String sourceText) {
            block17: {
                Object object;
                OraSourceAware sourceAware;
                block19: {
                    block18: {
                        block16: {
                            OraSourceAware oraSourceAware;
                            CharSequence charSequence = sourceText;
                            boolean bl = false;
                            if (charSequence.length() == 0) {
                                return;
                            }
                            switch (type) {
                                case "TYPE": {
                                    BasicModNamedElement basicModNamedElement = $this$applySources.getObjectTypes().createOrGet(name2);
                                    Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"this.objectTypes.createOrGet(name)");
                                    oraSourceAware = (OraSourceAware)basicModNamedElement;
                                    break;
                                }
                                case "TYPE BODY": {
                                    BasicModNamedElement basicModNamedElement = $this$applySources.getObjectTypes().createOrGet(name2);
                                    Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"this.objectTypes.createOrGet(name)");
                                    BasicModElement basicModElement = ((OraObjectType)basicModNamedElement).getBodies().createOrGet();
                                    Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"this.objectTypes.createO\u2026ame).bodies.createOrGet()");
                                    oraSourceAware = (OraSourceAware)basicModElement;
                                    break;
                                }
                                case "PACKAGE": {
                                    BasicModNamedElement basicModNamedElement = $this$applySources.getPackages().createOrGet(name2);
                                    Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"this.packages.createOrGet(name)");
                                    oraSourceAware = (OraSourceAware)basicModNamedElement;
                                    break;
                                }
                                case "PACKAGE BODY": {
                                    BasicModNamedElement basicModNamedElement = $this$applySources.getPackages().createOrGet(name2);
                                    Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"this.packages.createOrGet(name)");
                                    BasicModElement basicModElement = ((OraPackage)basicModNamedElement).getBodies().createOrGet();
                                    Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"this.packages.createOrGe\u2026ame).bodies.createOrGet()");
                                    oraSourceAware = (OraSourceAware)basicModElement;
                                    break;
                                }
                                case "PROCEDURE": 
                                case "FUNCTION": {
                                    BasicModNamedElement basicModNamedElement = $this$applySources.getRoutines().createOrGet(name2);
                                    Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"this.routines.createOrGet(name)");
                                    oraSourceAware = (OraSourceAware)basicModNamedElement;
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            sourceAware = oraSourceAware;
                            OraIntrospectorFunctions.applyStoredProgramSources(sourceAware, sourceText);
                            object = sourceAware;
                            if (!(object instanceof OraSingleRoutine)) break block16;
                            this.applyRoutineSource((OraSingleRoutine)sourceAware, "CREATE " + sourceText);
                            break block17;
                        }
                        if (!(object instanceof OraObjectType)) break block18;
                        this.extractObjectTypeChildren((OraObjectType)sourceAware, "CREATE " + sourceText);
                        break block17;
                    }
                    if (!(object instanceof OraPackage)) break block19;
                    this.extractPackageChildren((OraPackage)sourceAware, "CREATE " + sourceText);
                    break block17;
                }
                if (!(object instanceof OraBody)) break block17;
                this.determineWhetherTheBodyObfuscated((OraBody)sourceAware, sourceText);
            }
        }

        private final void applyRoutineSource(OraSingleRoutine routine2, String text) {
            Object object;
            BaseIntrospector this_$iv = OraIntrospector.this;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = BaseIntrospector.access$getSqlHelper$p(this_$iv);
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(text, SqlRoutineDefinition.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw (Throwable)pce$iv;
            }
            catch (Exception e$iv) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            SqlRoutineDefinition sqlRoutineDefinition = (SqlRoutineDefinition)object;
            if (sqlRoutineDefinition == null) {
                return;
            }
            SqlRoutineDefinition psiRoutine = sqlRoutineDefinition;
            this.applyRoutineSource((OraRoutine)routine2, psiRoutine);
        }

        private final void applyRoutineSource(OraRoutine routine2, SqlRoutineDefinition psiRoutine) {
            Casing casing = OraDialect.INSTANCE.getCasing(ObjectKind.ARGUMENT, null);
            Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"OraDialect.INSTANCE.getCasing(ARGUMENT, null)");
            Casing casing2 = casing;
            Iterator iterator = psiRoutine.getArguments().iterator();
            while (iterator.hasNext()) {
                OraArgument arg;
                String argName;
                SqlParameterDefinition psiArg;
                SqlParameterDefinition sqlParameterDefinition = psiArg = (SqlParameterDefinition)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)sqlParameterDefinition, (String)"psiArg");
                Intrinsics.checkNotNullExpressionValue((Object)SqlImplUtil.getEffectiveName((String)sqlParameterDefinition.getName(), (boolean)DbSqlUtilCore.isQuoted((DasObject)((DasObject)psiArg)), (Casing)casing2), (String)"SqlImplUtil.getEffective\u2026isQuoted(psiArg), casing)");
                if ((OraArgument)routine2.getArguments().get(argName) == null) {
                    continue;
                }
                arg.setDataType(psiArg.getDataType());
            }
            DasArgument psiRetArg = psiRoutine.getReturnArgument();
            if (psiRetArg != null) {
                BasicArgument basicArgument = routine2.getReturnArgument();
                if (!(basicArgument instanceof OraArgument)) {
                    basicArgument = null;
                }
                OraArgument oraArgument = (OraArgument)basicArgument;
                if (oraArgument != null) {
                    oraArgument.setDataType(psiRetArg.getDataType());
                }
            }
            if (routine2 instanceof OraObjectTypeRoutine && psiRoutine instanceof OraMemberFunctionDefinitionImpl) {
                ((OraObjectTypeRoutine)routine2).setMemberKind(((OraMemberFunctionDefinitionImpl)psiRoutine).getMemberKind());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void applyRoutineSources(OraModule module, SqlCreateStatement psiModule) {
            String effectiveName;
            Casing casing = OraDialect.INSTANCE.getCasing(ObjectKind.ROUTINE, null);
            Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"OraDialect.INSTANCE.getCasing(ROUTINE, null)");
            Casing casing2 = casing;
            MultiMap psiRoutinesByName = new MultiMap();
            Iterator iterator = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)psiModule)).filter(SqlRoutineDefinition.class).iterator();
            while (iterator.hasNext()) {
                SqlRoutineDefinition psiRoutine;
                SqlRoutineDefinition sqlRoutineDefinition = psiRoutine = (SqlRoutineDefinition)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)sqlRoutineDefinition, (String)"psiRoutine");
                Intrinsics.checkNotNullExpressionValue((Object)SqlImplUtil.getEffectiveName((String)sqlRoutineDefinition.getName(), (boolean)DbSqlUtilCore.isQuoted((DasObject)((DasObject)psiRoutine)), (Casing)casing2), (String)"SqlImplUtil.getEffective\u2026oted(psiRoutine), casing)");
                psiRoutinesByName.putValue((Object)effectiveName, (Object)psiRoutine);
            }
            iterator = psiRoutinesByName.entrySet().iterator();
            while (iterator.hasNext()) {
                void routineName;
                Collection psiRoutines;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl = false;
                effectiveName = (String)entry2.getKey();
                entry2 = entry;
                bl = false;
                Collection collection = psiRoutines = (Collection)entry2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"psiRoutines");
                SqlRoutineDefinition singlePsiRoutine = (SqlRoutineDefinition)CollectionsKt.singleOrNull((Iterable)collection);
                if (singlePsiRoutine != null) {
                    OraInnerRoutine routine2;
                    if ((OraInnerRoutine)module.getRoutines().get((String)routineName, true) == null) {
                        continue;
                    }
                    this.applyRoutineSource(routine2, singlePsiRoutine);
                    continue;
                }
                boolean routine2 = false;
                for (SqlRoutineDefinition psiRoutine : (Iterable)psiRoutines) {
                    void i2;
                    if ((OraInnerRoutine)module.getRoutines().get((String)routineName, true, new Predicate((int)i2){
                        final /* synthetic */ int $i;

                        public final boolean test(OraInnerRoutine it) {
                            OraInnerRoutine oraInnerRoutine = it;
                            Intrinsics.checkNotNullExpressionValue((Object)oraInnerRoutine, (String)"it");
                            return oraInnerRoutine.getOverloadNr() == this.$i + 1;
                        }
                        {
                            this.$i = n;
                        }
                    }) == null) {
                    } else {
                        OraInnerRoutine routine3;
                        OraRoutine oraRoutine = routine3;
                        SqlRoutineDefinition sqlRoutineDefinition = psiRoutine;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlRoutineDefinition, (String)"psiRoutine");
                        this.applyRoutineSource(oraRoutine, sqlRoutineDefinition);
                    }
                    ++i2;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void extractObjectTypeChildren(OraObjectType objectType, String text) {
            Object object;
            void this_$iv;
            BaseIntrospector baseIntrospector = OraIntrospector.this;
            OraModule oraModule = objectType;
            OraSchemaRetriever oraSchemaRetriever = this;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = BaseIntrospector.access$getSqlHelper$p((BaseIntrospector)this_$iv);
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(text, SqlCreateTypeStatement.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw (Throwable)pce$iv;
            }
            catch (Exception e$iv) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            Object object2 = object;
            SqlCreateTypeStatement sqlCreateTypeStatement = (SqlCreateTypeStatement)object2;
            if (sqlCreateTypeStatement == null) {
                return;
            }
            oraSchemaRetriever.applyRoutineSources(oraModule, (SqlCreateStatement)sqlCreateTypeStatement);
        }

        /*
         * WARNING - void declaration
         */
        private final void extractPackageChildren(OraPackage pkg, String text) {
            Object object;
            void this_$iv;
            boolean $i$f$cleanupFamilies = false;
            Function1 it = OraSchemaRetriever$extractPackageChildren$$inlined$cleanupFamilies$1.INSTANCE;
            boolean $i$a$-cleanupFamilies-OraIntrospector$OraSchemaRetriever$extractPackageChildren$32 = false;
            ModNamingFamily<? extends OraAliasType> modNamingFamily = pkg.getAliasTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"pkg.aliasTypes");
            it.invoke(modNamingFamily);
            ModNamingFamily<? extends OraPackageCollectionType> modNamingFamily2 = pkg.getCollectionTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"pkg.collectionTypes");
            it.invoke(modNamingFamily2);
            ModPositioningNamingFamily<? extends OraPackageVariable> modPositioningNamingFamily = pkg.getVariables();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"pkg.variables");
            it.invoke(modPositioningNamingFamily);
            ModNamingFamily<? extends OraException> modNamingFamily3 = pkg.getExceptions();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"pkg.exceptions");
            it.invoke(modNamingFamily3);
            boolean bl = false;
            BaseIntrospector $i$a$-cleanupFamilies-OraIntrospector$OraSchemaRetriever$extractPackageChildren$32 = OraIntrospector.this;
            String src$iv = text;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = BaseIntrospector.access$getSqlHelper$p((BaseIntrospector)this_$iv);
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(src$iv, SqlCreateStatement.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw (Throwable)pce$iv;
            }
            catch (Exception e$iv) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            SqlCreateStatement statement = (SqlCreateStatement)object;
            if (statement == null || Intrinsics.areEqual((Object)statement.getKind(), (Object)ObjectKind.PACKAGE) ^ true) {
                return;
            }
            short vc = (short)0;
            Iterator iterator = statement.getDasChildren(null).iterator();
            while (iterator.hasNext()) {
                ModPositioningNamingFamily<? extends OraRecordColumn> modPositioningNamingFamily2;
                ModPositioningNamingFamily<? extends OraRecordColumn> modPositioningNamingFamily3;
                ModNamingFamily<? extends OraException> family;
                DasObject child;
                DasObject dasObject = child = (DasObject)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)dasObject, (String)"child");
                ObjectKind $i$f$statements = dasObject.getKind();
                if ((Intrinsics.areEqual((Object)$i$f$statements, (Object)ObjectKind.VARIABLE) ? (ModNamingFamily<? extends OraException>)pkg.getVariables() : (Intrinsics.areEqual((Object)$i$f$statements, (Object)ObjectKind.EXCEPTION) ? pkg.getExceptions() : (Intrinsics.areEqual((Object)$i$f$statements, (Object)ObjectKind.ALIAS_TYPE) ? pkg.getAliasTypes() : (Intrinsics.areEqual((Object)$i$f$statements, (Object)ObjectKind.COLLECTION_TYPE) ? pkg.getCollectionTypes() : null)))) == null) {
                    continue;
                }
                family = family;
                BasicModNamedElement obj2 = family.createOrGet(child.getName());
                boolean $i$f$cleanupFamilies2 = false;
                Function1 it2 = OraSchemaRetriever$$special$$inlined$cleanupFamilies$1.INSTANCE;
                boolean bl2 = false;
                BasicModNamedElement basicModNamedElement = obj2;
                if (!(basicModNamedElement instanceof OraAliasType)) {
                    basicModNamedElement = null;
                }
                if ((modPositioningNamingFamily3 = (ModPositioningNamingFamily<? extends OraRecordColumn>)basicModNamedElement) != null && (modPositioningNamingFamily3 = modPositioningNamingFamily3.getRecordColumns()) != null) {
                    Unit cfr_ignored_0 = (Unit)it2.invoke(modPositioningNamingFamily3);
                }
                boolean bl3 = false;
                OraIntrospector.this.getSqlHelper().getBuilder().build((BasicModElement)obj2, child, SqlObjectBuilder.INTROSPECTOR);
                it2 = OraSchemaRetriever$$special$$inlined$cleanupFamilies$2.INSTANCE;
                bl2 = false;
                BasicModNamedElement basicModNamedElement2 = obj2;
                if (!(basicModNamedElement2 instanceof OraAliasType)) {
                    basicModNamedElement2 = null;
                }
                if ((modPositioningNamingFamily2 = (ModPositioningNamingFamily<? extends OraRecordColumn>)basicModNamedElement2) != null && (modPositioningNamingFamily2 = modPositioningNamingFamily2.getRecordColumns()) != null) {
                    Unit cfr_ignored_1 = (Unit)it2.invoke(modPositioningNamingFamily2);
                }
                if (!(obj2 instanceof OraVariable)) continue;
                vc = (short)(vc + 1);
                ((OraVariable)obj2).setPosition(vc);
            }
            this.applyRoutineSources(pkg, statement);
            it = OraSchemaRetriever$extractPackageChildren$$inlined$cleanupFamilies$2.INSTANCE;
            boolean bl4 = false;
            ModNamingFamily<? extends OraAliasType> modNamingFamily4 = pkg.getAliasTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"pkg.aliasTypes");
            it.invoke(modNamingFamily4);
            ModNamingFamily<? extends OraPackageCollectionType> modNamingFamily5 = pkg.getCollectionTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"pkg.collectionTypes");
            it.invoke(modNamingFamily5);
            ModPositioningNamingFamily<? extends OraPackageVariable> modPositioningNamingFamily4 = pkg.getVariables();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily4, (String)"pkg.variables");
            it.invoke(modPositioningNamingFamily4);
            ModNamingFamily<? extends OraException> modNamingFamily6 = pkg.getExceptions();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"pkg.exceptions");
            it.invoke(modNamingFamily6);
        }

        private final void determineWhetherTheBodyObfuscated(OraBody body2, String text) {
            if (text == null) {
                body2.setObfuscated(false);
                return;
            }
            body2.setObfuscated(Regex.find$default((Regex)OraIntrospectorFunctions.getObfuscationTextPattern(), (CharSequence)text, (int)0, (int)2, null) != null);
        }

        private final Collection<OraMajorSourceText> retrieveMatViewSources() {
            int longViewsCount;
            int normViewsCount = this.affectedNormMatViews.size();
            int n = normViewsCount + (longViewsCount = this.affectedLongMatViews.size());
            if (n == 0) {
                return SetsKt.emptySet();
            }
            OraIntrospector.this.trace("Affected materialized views: " + normViewsCount + " normal + " + longViewsCount + " long = " + n + " total");
            ArrayList texts = new ArrayList(n);
            if (OraIntrospector.this.useXML) {
                this.retrieveNormMatViewSources(CollectionsKt.toList((Iterable)this.affectedNormMatViews), texts);
                this.retrieveLongMatViewSources(CollectionsKt.toList((Iterable)this.affectedLongMatViews), texts);
            } else {
                Set affectedMatViewSources = CollectionsKt.union((Iterable)this.affectedNormMatViews, (Iterable)this.affectedLongMatViews);
                this.retrieveLongMatViewSources(CollectionsKt.toList((Iterable)affectedMatViewSources), texts);
            }
            return texts;
        }

        private final void retrieveNormMatViewSources(List<String> names2, Collection<OraMajorSourceText> container) {
            if (names2.isEmpty()) {
                return;
            }
            OraIntrospector.this.reportRetrieving("Materialized View Sources", "introspection.retrieve.matView.sources");
            List<List<String>> packs = OraIntrospectorSourcesHelperKt.splitByPacks(names2, 100);
            OraIntrospector.this.trace("Retrieving sources for " + names2.size() + " materialized views in " + packs.size() + " portions");
            for (List<String> pack : packs) {
                OraIntrospector.this.handleErrors("Retrieve materialized view sources via XML for " + pack.size() + " views (" + CollectionsKt.joinToString$default((Iterable)pack, null, null, null, (int)0, null, null, (int)63, null) + ')', (Function0<Unit>)((Function0)new Function0<Unit>(this, pack, container){
                    final /* synthetic */ OraSchemaRetriever this$0;
                    final /* synthetic */ List $pack;
                    final /* synthetic */ Collection $container;

                    public final void invoke() {
                        SqlQuery<Integer> sqlQuery = OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0.OraIntrospector.this).retrieveMatViewSourcesXml;
                        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveMatViewSourcesXml");
                        String string = OraSchemaRetriever.access$performQueryReturningXmlForStringLiterals(this.this$0, sqlQuery, "names_lit", this.$pack);
                        if (string == null) {
                            throw (Throwable)new ResultIsNull();
                        }
                        String hugeText = string;
                        OraIntrospectorSourcesHelperKt.parseMajorSources(hugeText, this.$container);
                        OraIntrospector.access$trace(this.this$0.OraIntrospector.this, "parsed " + this.$container.size() + " view sources from XML");
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                        this.$pack = list;
                        this.$container = collection;
                        super(0);
                    }
                }));
            }
        }

        private final void retrieveLongMatViewSources(List<String> names2, Collection<OraMajorSourceText> container) {
            if (names2.isEmpty()) {
                return;
            }
            OraIntrospector.this.reportRetrieving("LONG Materialized View Sources", "introspection.retrieve.matView.sources.long");
            List<List<String>> packs = OraIntrospectorSourcesHelperKt.splitByPacks(names2, 100);
            for (List<String> pack : packs) {
                List<OraMajorSourceText> texts;
                Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"names", pack));
                SqlQuery<List<OraMajorSourceText>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatViewSourcesLong;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveMatViewSourcesLong");
                List<OraMajorSourceText> list = texts = this.performQuery(sqlQuery, params2, new Object[0]);
                Intrinsics.checkNotNullExpressionValue(list, (String)"texts");
                container.addAll((Collection<OraMajorSourceText>)list);
            }
        }

        private final Collection<OraMajorSourceText> retrieveViewSources() {
            int longViewsCount;
            int normViewsCount = this.affectedNormViews.size();
            int n = normViewsCount + (longViewsCount = this.affectedLongViews.size());
            if (n == 0) {
                return SetsKt.emptySet();
            }
            OraIntrospector.this.trace("Affected views: " + normViewsCount + " normal + " + longViewsCount + " long = " + n + " total");
            ArrayList texts = new ArrayList(n);
            if (OraIntrospector.this.useXML) {
                this.retrieveNormViewSources(CollectionsKt.toList((Iterable)this.affectedNormViews), texts);
                this.retrieveLongViewSources(CollectionsKt.toList((Iterable)this.affectedLongViews), texts);
            } else {
                Set affectedViews = CollectionsKt.union((Iterable)this.affectedNormViews, (Iterable)this.affectedLongViews);
                this.retrieveLongViewSources(CollectionsKt.toList((Iterable)affectedViews), texts);
            }
            return texts;
        }

        private final void retrieveNormViewSources(List<String> names2, Collection<OraMajorSourceText> container) {
            if (names2.isEmpty()) {
                return;
            }
            OraIntrospector.this.reportRetrieving("View Sources", "introspection.retrieve.view.sources");
            List<List<String>> packs = OraIntrospectorSourcesHelperKt.splitByPacks(names2, 100);
            OraIntrospector.this.trace("Retrieving sources for " + names2.size() + " views in " + packs.size() + " portions");
            for (List<String> pack : packs) {
                if (OraIntrospector.this.getServerVersion().isOrGreater(new int[]{12})) {
                    List<OraMajorSourceText> texts;
                    Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"names", pack));
                    SqlQuery<List<OraMajorSourceText>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViewSources12;
                    Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveViewSources12");
                    List<OraMajorSourceText> list = texts = this.performQuery(sqlQuery, params2, new Object[0]);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"texts");
                    container.addAll((Collection<OraMajorSourceText>)list);
                    continue;
                }
                OraIntrospector.this.handleErrors("Retrieve view sources via XML for " + pack.size() + " views (" + CollectionsKt.joinToString$default((Iterable)pack, null, null, null, (int)0, null, null, (int)63, null) + ')', (Function0<Unit>)((Function0)new Function0<Unit>(this, pack, container){
                    final /* synthetic */ OraSchemaRetriever this$0;
                    final /* synthetic */ List $pack;
                    final /* synthetic */ Collection $container;

                    public final void invoke() {
                        SqlQuery<Integer> sqlQuery = OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0.OraIntrospector.this).retrieveViewSourcesXml;
                        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveViewSourcesXml");
                        String string = OraSchemaRetriever.access$performQueryReturningXmlForStringLiterals(this.this$0, sqlQuery, "names_lit", this.$pack);
                        if (string == null) {
                            throw (Throwable)new ResultIsNull();
                        }
                        String hugeText = string;
                        OraIntrospectorSourcesHelperKt.parseMajorSources(hugeText, this.$container);
                        OraIntrospector.access$trace(this.this$0.OraIntrospector.this, "parsed " + this.$container.size() + " view sources from XML");
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                        this.$pack = list;
                        this.$container = collection;
                        super(0);
                    }
                }));
            }
        }

        private final void retrieveLongViewSources(List<String> names2, Collection<OraMajorSourceText> container) {
            if (names2.isEmpty()) {
                return;
            }
            OraIntrospector.this.reportRetrieving("LONG View Sources", "introspection.retrieve.view.sources.long");
            List<List<String>> packs = OraIntrospectorSourcesHelperKt.splitByPacks(names2, 100);
            for (List<String> pack : packs) {
                List<OraMajorSourceText> texts;
                Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"names", pack));
                SqlQuery<List<OraMajorSourceText>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViewSourcesLong;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveViewSourcesLong");
                List<OraMajorSourceText> list = texts = this.performQuery(sqlQuery, params2, new Object[0]);
                Intrinsics.checkNotNullExpressionValue(list, (String)"texts");
                container.addAll((Collection<OraMajorSourceText>)list);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Map<MajorMinorName, String> retrieveTriggerSources() {
            Set longTriggerTables;
            HashMap texts;
            block13: {
                block10: {
                    int n = this.affectedTriggerTables.size();
                    OraIntrospector.this.trace("Affected triggers: " + n);
                    if (n == 0) {
                        return MapsKt.emptyMap();
                    }
                    texts = new HashMap(n * 2);
                    if (OraIntrospector.this.useXML) {
                        List packs = OraIntrospectorSourcesHelperKt.splitByPacks(CollectionsKt.toList((Iterable)this.affectedTriggerTables), 100);
                        OraIntrospector.this.trace("Retrieving sources for triggers using XML in " + packs.size() + " portions");
                        for (List list : packs) {
                            OraIntrospector.this.handleErrors("Retrieve trigger sources via XML for " + list.size() + " tables (" + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null) + ')', (Function0<Unit>)((Function0)new Function0<Unit>(this, list, texts){
                                final /* synthetic */ OraSchemaRetriever this$0;
                                final /* synthetic */ List $pack;
                                final /* synthetic */ HashMap $texts;

                                public final void invoke() {
                                    SqlQuery<Integer> sqlQuery = OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0.OraIntrospector.this).retrieveTriggerSourcesXml;
                                    Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveTriggerSourcesXml");
                                    String hugeText = OraSchemaRetriever.access$performQueryReturningXmlForStringLiterals(this.this$0, sqlQuery, "names_lit", this.$pack);
                                    if (hugeText != null) {
                                        OraIntrospectorSourcesHelperKt.parseMinorSources(hugeText, this.$texts);
                                        OraIntrospector.access$trace(this.this$0.OraIntrospector.this, "parsed " + this.$texts.size() + " trigger source texts from XML");
                                    }
                                }
                                {
                                    this.this$0 = oraSchemaRetriever;
                                    this.$pack = list;
                                    this.$texts = hashMap;
                                    super(0);
                                }
                            }));
                        }
                    }
                    longTriggerTables = null;
                    if (!OraIntrospector.this.useXML) break block10;
                    longTriggerTables = new HashSet();
                    Iterator bl = texts.entrySet().iterator();
                    while (bl.hasNext()) {
                        void ident;
                        block12: {
                            String text;
                            block11: {
                                Map.Entry entry;
                                Map.Entry entry2 = entry = bl.next();
                                boolean bl2 = false;
                                MajorMinorName majorMinorName = (MajorMinorName)entry2.getKey();
                                entry2 = entry;
                                bl2 = false;
                                text = (String)entry2.getValue();
                                if (text.length() <= 3600) break block11;
                                String string = text;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                                if (!StringsKt.endsWith((String)string, (String)"END;", (boolean)true)) break block12;
                            }
                            if (text.length() != 4000) continue;
                        }
                        longTriggerTables.add(ident.getMajor());
                    }
                    OraIntrospector.this.trace(longTriggerTables.isEmpty() ? "All triggers have normal size" : "Detected " + longTriggerTables.size() + " long triggers");
                    break block13;
                }
                longTriggerTables = this.affectedTriggerTables;
            }
            Collection collection = longTriggerTables;
            boolean bl = false;
            if (!collection.isEmpty()) {
                List list = OraIntrospectorSourcesHelperKt.splitByPacks(CollectionsKt.toList((Iterable)longTriggerTables), 100);
                OraIntrospector.this.trace("Retrieving sources for triggers using LONG objects in " + list.size() + " portions");
                for (List list2 : list) {
                    Map params2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"names", (Object)list2));
                    SqlQuery<List<OraMinorSourceText>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerSourcesLong;
                    Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveTriggerSourcesLong");
                    List<OraMinorSourceText> rows = this.performQuery(sqlQuery, params2, new Object[0]);
                    for (OraMinorSourceText r : rows) {
                        Map map2 = texts;
                        String string = r.majorName;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"r.majorName");
                        String string2 = r.minorName;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"r.minorName");
                        MajorMinorName majorMinorName = new MajorMinorName(string, string2);
                        String string3 = r.text;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"r.text");
                        map2.put(majorMinorName, string3);
                    }
                }
            }
            return texts;
        }

        private final boolean shouldWeRetrieveTriggers() {
            return OraIntrospector.this.getServerVersion().less(new int[]{12}) ? this.affectsTables || this.affectsMatViews || this.affectsViews : ((OraSchema)this.getSchema()).getTables().hasChildren() || ((OraSchema)this.getSchema()).getMatViews().hasChildren() || ((OraSchema)this.getSchema()).getViews().hasChildren();
        }

        private final void retrieveSynonyms() {
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
            OraIntrospector.this.reportRetrieving(objectKind);
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveFragmentSynonyms;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveFragmentSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this, ss){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ss;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    List list = this.$ss;
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ss");
                    OraIntrospector.access$processSynonyms(oraIntrospector, list, root2);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ss = list;
                    super(1);
                }
            });
        }

        private final void retrieveErrors() {
            long[] invalidObjectsAr;
            SqlQuery<long[]> invalidObjectsQuery;
            OraIntrospector.this.reportRetrieving("Statuses and Errors", "introspection.retrieve.statusesAndErrors");
            SqlQuery<long[]> sqlQuery = invalidObjectsQuery = OraIntrospector.this.getCatalogPermissions().getFast() ? ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsFast : ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjects;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"invalidObjectsQuery");
            long[] lArray = invalidObjectsAr = this.performQuery(sqlQuery);
            boolean bl = false;
            OraIntrospector.this.trace(lArray.length == 0 ? "No invalid objects found" : "Found " + invalidObjectsAr.length + " invalid objects");
            TLongHashSet invalids = new TLongHashSet(invalidObjectsAr);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, invalids){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $invalids;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily = schema.getObjectTypes();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.objectTypes");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, (Iterable)modNamingIdentifyingFamily, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily2 = schema.getPackages();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"schema.packages");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, (Iterable)modNamingIdentifyingFamily2, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily3 = schema.getRoutines();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"schema.routines");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, (Iterable)modNamingIdentifyingFamily3, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily4 = schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"schema.tables");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, (Iterable)modNamingIdentifyingFamily4, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily5 = schema.getViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"schema.views");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, (Iterable)modNamingIdentifyingFamily5, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraSynonym> modNamingIdentifyingFamily6 = schema.getSynonyms();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"schema.synonyms");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, (Iterable)modNamingIdentifyingFamily6, this.$invalids);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$invalids = tLongHashSet;
                    super(1);
                }
            });
            if (invalids.isEmpty()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneError>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveErrors;
            Intrinsics.checkNotNullExpressionValue(sqlQuery2, (String)"queries.retrieveErrors");
            List<OraIntroQueries.OneError> errs = this.performQuery(sqlQuery2);
            OraIntrospector.this.trace(errs.isEmpty() ? "No errors found" : "Found " + errs.size() + " errors");
            if (errs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(errs){
                final /* synthetic */ List $errs;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    BasicModSourceAware src2;
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    MultiMap map2 = new MultiMap();
                    for (OraIntroQueries.OneError err : this.$errs) {
                        src2 = null;
                        switch (err.type_code) {
                            case 'R': {
                                src2 = (BasicModSourceAware)schema.getRoutines().get(err.name);
                                break;
                            }
                            case 'V': {
                                src2 = (BasicModSourceAware)schema.getViews().get(err.name);
                                break;
                            }
                            case 'T': {
                                OraObjectType m = (OraObjectType)schema.getObjectTypes().get(err.name);
                                if (m == null) break;
                                src2 = err.is_body ? (BasicModSourceAware)m.getBodies().get() : (BasicModSourceAware)m;
                                break;
                            }
                            case 'P': {
                                OraPackage p = (OraPackage)schema.getPackages().get(err.name);
                                if (p == null) break;
                                src2 = err.is_body ? (BasicModSourceAware)p.getBodies().get() : (BasicModSourceAware)p;
                                break;
                            }
                            case 'G': {
                                String string = err.name;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"err.name");
                                src2 = OraIntrospectorFunctions.findTrigger(schema, string);
                                break;
                            }
                        }
                        if (src2 == null) continue;
                        SourceError error = SourceError.of((int)err.line, (int)err.position, (String)err.message);
                        map2.putValue((Object)src2, (Object)error);
                    }
                    Iterator<E> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void key2;
                        Map.Entry entry;
                        Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                        boolean bl = false;
                        src2 = (BasicModSourceAware)entry2.getKey();
                        entry2 = entry;
                        bl = false;
                        Collection value = (Collection)entry2.getValue();
                        void v1 = key2;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key");
                        v1.setErrors((List)ImmutableList.copyOf((Collection)value));
                    }
                }
                {
                    this.$errs = list;
                    super(1);
                }
            });
        }

        private final void updateInvalidStatus(Iterable<? extends BasicModElement> family, TLongHashSet invalids) {
            for (BasicModElement basicModElement : family) {
                BasicModElement basicModElement2;
                if (basicModElement instanceof BasicModSourceAware && basicModElement instanceof BasicIdentifiedElement) {
                    boolean invalid = invalids.contains(((BasicIdentifiedElement)basicModElement).getObjectId());
                    ((BasicModSourceAware)basicModElement).setInvalid(invalid);
                    if (!invalid) {
                        ((BasicModSourceAware)basicModElement).setErrors(ModelConsts.NO_ERRORS);
                    }
                }
                if ((basicModElement2 = basicModElement) instanceof OraLikeTable) {
                    ModNamingIdentifyingFamily<? extends OraTrigger> modNamingIdentifyingFamily = ((OraLikeTable)basicModElement).getTriggers();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"e.triggers");
                    this.updateInvalidStatus((Iterable)modNamingIdentifyingFamily, invalids);
                    continue;
                }
                if (basicModElement2 instanceof OraObjectType) {
                    ModSingletonFamily<? extends OraObjectTypeBody> modSingletonFamily = ((OraObjectType)basicModElement).getBodies();
                    Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"e.bodies");
                    this.updateInvalidStatus((Iterable)modSingletonFamily, invalids);
                    continue;
                }
                if (!(basicModElement2 instanceof OraPackage)) continue;
                ModSingletonFamily<? extends OraPackageBody> modSingletonFamily = ((OraPackage)basicModElement).getBodies();
                Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"e.bodies");
                this.updateInvalidStatus((Iterable)modSingletonFamily, invalids);
            }
        }

        private final void retrieveDebugInfoPresence() {
            OraIntrospector.this.reportRetrieving("Debug info presence", "introspection.retrieve.debugInfoPresence");
            long[] xIds = null;
            try {
                SqlQuery<long[]> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveDebugInfoPresence;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"queries.retrieveDebugInfoPresence");
                xIds = this.performQuery(sqlQuery);
            }
            catch (NoTableOrViewException e2) {
                OraIntrospector.this.logExpectedOraError((DBException)((Object)e2));
                return;
            }
            catch (DBAccessDeniedException e3) {
                OraIntrospector.this.logExpectedOraError((DBException)((Object)e3));
                return;
            }
            long[] e3 = xIds;
            boolean bl = false;
            long[] lArray = e3;
            boolean bl2 = false;
            OraIntrospector.this.trace(!(lArray.length == 0) ? "Found debug info for " + xIds.length + " objects" : "No debug info found");
            e3 = xIds;
            bl = false;
            if (e3.length == 0) {
                return;
            }
            BasicRoot basicRoot = this.getModel().getRoot();
            if (basicRoot == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraRoot");
            }
            OraRoot root2 = (OraRoot)basicRoot;
            this.inSchema((Function1)new Function1<OraSchema, Unit>(xIds, root2){
                final /* synthetic */ long[] $xIds;
                final /* synthetic */ OraRoot $root;

                public final void invoke(@NotNull OraSchema it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    long[] lArray = this.$xIds;
                    int n = lArray.length;
                    for (int j = 0; j < n; ++j) {
                        OraSourceAware sa;
                        BasicIdentifiedElement obj2;
                        long xId;
                        long l = xId = lArray[j];
                        boolean bl = false;
                        long id = Math.abs(l);
                        if (this.$root.findIdentifiedElement(id) == null) {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)obj2, (String)"root.findIdentifiedElement(id) ?: continue");
                        BasicIdentifiedElement basicIdentifiedElement = obj2;
                        if (!(basicIdentifiedElement instanceof OraSourceAware)) {
                            basicIdentifiedElement = null;
                        }
                        if ((OraSourceAware)basicIdentifiedElement == null) {
                            continue;
                        }
                        sa.setWithDebugInfo(xId > 0L);
                    }
                }
                {
                    this.$xIds = lArray;
                    this.$root = oraRoot;
                    super(1);
                }
            });
        }

        public OraSchemaRetriever(@NotNull DBTransaction transaction, OraSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseIntrospector)OraIntrospector.this, transaction, (BasicModSchema)schema);
            this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.majorModificationsFound = true;
            this.textLimit = OraIntrospector.this.getServerVersion().isOrGreater(new int[]{12, 1}) ? 16384 : 4000;
            this.tablesToReorderDetails = new HashSet();
            this.affectedClusters = new HashSet();
            this.affectedPackageSpecs = new HashSet();
            this.affectedObjectTypeSpecs = new HashSet();
            this.affectedModuleBodies = new HashSet();
            this.affectedInnerRoutines = new HashSet();
            this.affectedSingleRoutines = new HashSet();
            this.affectedDepObjects = new HashSet();
            this.affectedTables = new HashSet();
            this.affectedNormViews = new HashSet();
            this.affectedLongViews = new HashSet();
            this.affectedNormMatViews = new HashSet();
            this.affectedLongMatViews = new HashSet();
            this.affectedTriggerTables = new HashSet();
        }

        public static final /* synthetic */ BasicModModel access$getModel$p(OraSchemaRetriever $this) {
            return $this.getModel();
        }

        public static final /* synthetic */ BigInteger access$adjustBigIntegerForSequence(OraSchemaRetriever $this, BigDecimal bigDecimalValue) {
            return $this.adjustBigIntegerForSequence(bigDecimalValue);
        }

        public static final /* synthetic */ HashSet access$getAffectedModuleBodies$p(OraSchemaRetriever $this) {
            return $this.affectedModuleBodies;
        }

        public static final /* synthetic */ HashSet access$getAffectedDepObjects$p(OraSchemaRetriever $this) {
            return $this.affectedDepObjects;
        }

        public static final /* synthetic */ HashSet access$getAffectedObjectTypeSpecs$p(OraSchemaRetriever $this) {
            return $this.affectedObjectTypeSpecs;
        }

        public static final /* synthetic */ void access$applyClusterInfo(OraSchemaRetriever $this, OraCluster cluster, OraIntroQueries.OneCluster c) {
            $this.applyClusterInfo(cluster, c);
        }

        public static final /* synthetic */ HashSet access$getAffectedClusters$p(OraSchemaRetriever $this) {
            return $this.affectedClusters;
        }

        public static final /* synthetic */ HashSet access$getAffectedTables$p(OraSchemaRetriever $this) {
            return $this.affectedTables;
        }

        public static final /* synthetic */ boolean access$getAffectsMatLogs$p(OraSchemaRetriever $this) {
            return $this.affectsMatLogs;
        }

        public static final /* synthetic */ void access$setAffectsMatLogs$p(OraSchemaRetriever $this, boolean bl) {
            $this.affectsMatLogs = bl;
        }

        public static final /* synthetic */ boolean access$getAffectsMatViews$p(OraSchemaRetriever $this) {
            return $this.affectsMatViews;
        }

        public static final /* synthetic */ void access$setAffectsMatViews$p(OraSchemaRetriever $this, boolean bl) {
            $this.affectsMatViews = bl;
        }

        public static final /* synthetic */ HashSet access$getAffectedNormMatViews$p(OraSchemaRetriever $this) {
            return $this.affectedNormMatViews;
        }

        public static final /* synthetic */ HashSet access$getAffectedLongMatViews$p(OraSchemaRetriever $this) {
            return $this.affectedLongMatViews;
        }

        public static final /* synthetic */ HashSet access$getAffectedNormViews$p(OraSchemaRetriever $this) {
            return $this.affectedNormViews;
        }

        public static final /* synthetic */ HashSet access$getAffectedLongViews$p(OraSchemaRetriever $this) {
            return $this.affectedLongViews;
        }

        public static final /* synthetic */ int access$getTextLimit$p(OraSchemaRetriever $this) {
            return $this.textLimit;
        }

        public static final /* synthetic */ String access$performQueryReturningXmlForStringLiterals(OraSchemaRetriever $this, SqlQuery query, String paramName, Collection paramValues) {
            return $this.performQueryReturningXmlForStringLiterals((SqlQuery<Integer>)query, paramName, paramValues);
        }

        public static final /* synthetic */ HashSet access$getTablesToReorderDetails$p(OraSchemaRetriever $this) {
            return $this.tablesToReorderDetails;
        }

        public static final /* synthetic */ void access$applyIndexingItems(OraSchemaRetriever $this, BasicTable table, OraIndex index2, List items) {
            $this.applyIndexingItems(table, index2, items);
        }

        public static final /* synthetic */ TrigTurn access$trigTurnOf(OraSchemaRetriever $this, short turn) {
            return $this.trigTurnOf(turn);
        }

        public static final /* synthetic */ HashSet access$getAffectedTriggerTables$p(OraSchemaRetriever $this) {
            return $this.affectedTriggerTables;
        }

        public static final /* synthetic */ HashSet access$getAffectedPackageSpecs$p(OraSchemaRetriever $this) {
            return $this.affectedPackageSpecs;
        }

        public static final /* synthetic */ HashSet access$getAffectedInnerRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedInnerRoutines;
        }

        public static final /* synthetic */ HashSet access$getAffectedSingleRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedSingleRoutines;
        }

        public static final /* synthetic */ Iterable access$seanceRelatedTablesAndViews(OraSchemaRetriever $this, OraSchema schema) {
            return $this.seanceRelatedTablesAndViews(schema);
        }

        public static final /* synthetic */ void access$inSchema(OraSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$applySources(OraSchemaRetriever $this, OraSchema $this$access_u24applySources, String type, String name2, String sourceText) {
            $this.applySources($this$access_u24applySources, type, name2, sourceText);
        }

        public static final /* synthetic */ void access$updateInvalidStatus(OraSchemaRetriever $this, Iterable family, TLongHashSet invalids) {
            $this.updateInvalidStatus(family, invalids);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$ResultIsNull;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "intellij.database.dialects.oracle"})
    public static final class ResultIsNull
    extends Exception {
        public ResultIsNull() {
            super("Result is null");
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$Companion;", "", "()V", "adjustXmlContextCommand", "", "getAdjustXmlContextCommand", "()Ljava/lang/String;", "closeXmlContextCommand", "getCloseXmlContextCommand", "introspectorKindVersions", "", "Lcom/intellij/database/model/ObjectKind;", "", "getIntrospectorKindVersions$intellij_database_dialects_oracle", "()Ljava/util/Map;", "introspectorVersion", "packSize", "retrieveXmlContentQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "getRetrieveXmlContentQuery", "()Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "useXmlPropName", "intellij.database.dialects.oracle"})
    public static final class Companion {
        @NotNull
        public final Map<ObjectKind, Integer> getIntrospectorKindVersions$intellij_database_dialects_oracle() {
            return introspectorKindVersions;
        }

        @NotNull
        public final String getAdjustXmlContextCommand() {
            return adjustXmlContextCommand;
        }

        @NotNull
        public final String getCloseXmlContextCommand() {
            return closeXmlContextCommand;
        }

        @NotNull
        public final SqlQuery<String> getRetrieveXmlContentQuery() {
            return retrieveXmlContentQuery;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

