/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.console.ConsoleErrorProviderFactory;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.oracle.ObjectInfo;
import com.intellij.database.dialects.oracle.OraStatementAnalysis;
import com.intellij.database.dialects.oracle.OraUtils;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.ContainerUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraConsoleErrorProvider
extends DataAuditors.Adapter
implements JdbcConsole.RawErrorsObtainer {
    private static final Logger LOG = Logger.getInstance(OraConsoleErrorProvider.class);
    private static final Pattern COMPILATION_ERROR_POSITION_PATTERN = Pattern.compile("^(\\d{1,6}):(\\d{1,6}):");
    private static final String CONDITION_PARAMETER = "#CONDITION";
    private static final String RETRIEVE_ERRORS_QUERY_U = "select line||':'||position||':'||text as message \nfrom sys.user_errors \nwhere type #CONDITION \n  and name = ? \norder by sequence \n";
    private static final int[] USER_QUERY_PLACEHOLDERS = StatementParameters.Companion.findParameters("select line||':'||position||':'||text as message \nfrom sys.user_errors \nwhere type #CONDITION \n  and name = ? \norder by sequence \n");
    private static final String RETRIEVE_ERRORS_QUERY_Q = "select line||':'||position||':'||text as message\nfrom sys.all_errors\nwhere type #CONDITION \n  and owner = ? \n  and name = ? \norder by sequence \n";
    private static final int[] ALL_QUERY_PLACEHOLDERS = StatementParameters.Companion.findParameters("select line||':'||position||':'||text as message\nfrom sys.all_errors\nwhere type #CONDITION \n  and owner = ? \n  and name = ? \norder by sequence \n");
    @NotNull
    private final Project myProject;
    @NotNull
    private final LocalDataSource myDataSource;
    @Nullable
    private final DataAuditor mySink;

    public OraConsoleErrorProvider(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable DataAuditor sink) {
        if (project == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.mySink = sink;
    }

    public void afterStatement(@NotNull DataRequest.Context context) {
        DatabaseConnection connection;
        if (context == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(2);
        }
        if (this.mySink == null) {
            return;
        }
        String query = context.getQuery();
        if (StringUtil.isNotEmpty((String)query) && (connection = OraUtils.getConnection(context)) != null) {
            this.obtainErrors(query, connection, context.getSearchPath(), e2 -> this.mySink.error(context, e2, null));
        }
    }

    public void obtainErrors(@NotNull String queryText, @NotNull DatabaseConnection connection, @Nullable SearchPath searchPath, @NotNull Consumer<@Nls String> sink) {
        ObjectPath link;
        Dbms dbms;
        if (queryText == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(5);
        }
        if (!(dbms = this.myDataSource.getDbms()).isOracle()) {
            return;
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.findSqlDialect((LocalDataSource)this.myDataSource);
        if (dialect == null) {
            return;
        }
        ObjectInfo info = OraStatementAnalysis.parseAffectedObjectInfo(queryText, dialect, this.myProject);
        if (info == null) {
            return;
        }
        String objectName = info.getObjectName();
        String schemaName = info.getSchemaName();
        if (schemaName == null && (link = (ObjectPath)ContainerUtil.find((Iterable)SearchPath.getElements((SearchPath)searchPath), e2 -> e2.kind == ObjectKind.SCHEMA)) != null) {
            schemaName = link.name;
        }
        String condition = OraStatementAnalysis.getOracleTypeLikeConditionFor(info.getKind());
        try {
            List<String> errors = schemaName == null ? OraUtils.queryForStrings(connection, RETRIEVE_ERRORS_QUERY_U.replace(CONDITION_PARAMETER, condition), OraConsoleErrorProvider.calculatePlaceholdersOffsets(condition, USER_QUERY_PLACEHOLDERS), objectName) : OraUtils.queryForStrings(connection, RETRIEVE_ERRORS_QUERY_Q.replace(CONDITION_PARAMETER, condition), OraConsoleErrorProvider.calculatePlaceholdersOffsets(condition, ALL_QUERY_PLACEHOLDERS), schemaName, objectName);
            if (!errors.isEmpty()) {
                OraConsoleErrorProvider.showErrors(sink, errors);
                this.navigateToTheErrorPosition(errors.get(0));
            }
        }
        catch (SQLException ex) {
            String name2 = this.myDataSource.getName();
            String message2 = "Failed to obtain compilation errors using data source \"" + name2 + "\": Error " + ex.getErrorCode() + ": " + ex.getMessage();
            LOG.warn(message2, (Throwable)ex);
        }
        catch (Exception e3) {
            String name3 = this.myDataSource.getName();
            String message3 = "Failed to obtain compilation errors using data source \"" + name3 + "\": " + e3.getClass().getSimpleName() + ": " + e3.getMessage();
            LOG.warn(message3, (Throwable)e3);
        }
    }

    private static void showErrors(@NotNull Consumer<String> sink, @NotNull List<String> errors) {
        if (sink == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(6);
        }
        if (errors == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(7);
        }
        for (String error : errors) {
            sink.accept(error);
        }
    }

    private void navigateToTheErrorPosition(@NotNull String errorMessage) {
        if (errorMessage == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(8);
        }
        try {
            Matcher m = COMPILATION_ERROR_POSITION_PATTERN.matcher(errorMessage);
            if (m.find()) {
                int line = Integer.parseInt(m.group(1));
                int n = Integer.parseInt(m.group(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
    }

    private static int[] calculatePlaceholdersOffsets(@NotNull String condition, int[] offsets) {
        if (condition == null) {
            OraConsoleErrorProvider.$$$reportNull$$$0(9);
        }
        int delta = condition.length() - CONDITION_PARAMETER.length();
        return IntStream.of(offsets).map(i2 -> i2 + delta).toArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/oracle/OraConsoleErrorProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "afterStatement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "obtainErrors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToTheErrorPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "calculatePlaceholdersOffsets";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Factory
    implements ConsoleErrorProviderFactory {
        @NotNull
        public DataAuditor createErrorProvider(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable DataAuditor sink) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new OraConsoleErrorProvider(project, dataSource, sink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/oracle/OraConsoleErrorProvider$Factory";
            objectArray[2] = "createErrorProvider";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

