/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.model.properties;

import com.intellij.database.dialects.mysqlbase.model.properties.MysqlEventStatus;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlObjectGrant;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlObjectGrantController;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlRoleGrant;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlSslType;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface MysqlBasePropertyConverter
extends PropertyConverter {
    public static final BasicMetaType<MysqlEventStatus> T_MYSQL_EVENT_STATUS = new BasicMetaType(MysqlEventStatus.class, MysqlBasePropertyConverter::importMysqlEventStatus, PropertyConverter::export);
    public static final BasicMetaType<MysqlSslType> T_MYSQL_SSL_TYPE = new BasicMetaType(MysqlSslType.class, MysqlBasePropertyConverter::importMysqlSslType, PropertyConverter::export);
    public static final BasicMetaType<List<MysqlRoleGrant>> T_LIST_OF_MYSQL_ROLE_GRANT = new BasicMetaType.CollectionMetaType(List.class, MysqlRoleGrant.class, MysqlBasePropertyConverter::importListOfMysqlRoleGrant, MysqlBasePropertyConverter::exportListOfMysqlRoleGrant);
    public static final BasicMetaType<Grants<MysqlObjectGrant>> T_GRANTS_MYSQL_OBJECT_GRANT = new BasicMetaType(Grants.class, MysqlBasePropertyConverter::importGrantsMysqlObjectGrant, PropertyConverter::export);

    public static Grants<MysqlObjectGrant> importGrantsMysqlObjectGrant(String text) {
        return new Grants((Grants.Controller)MysqlObjectGrantController.INSTANCE, text);
    }

    public static MysqlEventStatus importMysqlEventStatus(String text) {
        return (MysqlEventStatus)PropertyConverter.importEnum(MysqlEventStatus.class, (String)text);
    }

    public static MysqlSslType importMysqlSslType(String text) {
        return (MysqlSslType)PropertyConverter.importEnum(MysqlSslType.class, (String)text);
    }

    public static String exportListOfMysqlRoleGrant(List<MysqlRoleGrant> columns) {
        StringBuilder sb = new StringBuilder();
        for (MysqlRoleGrant column2 : columns) {
            sb.append(column2.export()).append("\n");
        }
        return sb.toString();
    }

    @NotNull
    public static List<MysqlRoleGrant> importListOfMysqlRoleGrant(String text) {
        String[] lines;
        if (text == null || text.length() == 0) {
            List<MysqlRoleGrant> list = Collections.emptyList();
            if (list == null) {
                MysqlBasePropertyConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<MysqlRoleGrant> res2 = new ArrayList<MysqlRoleGrant>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            res2.add(new MysqlRoleGrant(line));
        }
        ArrayList<MysqlRoleGrant> arrayList = res2;
        if (arrayList == null) {
            MysqlBasePropertyConverter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/mysqlbase/model/properties/MysqlBasePropertyConverter", "importListOfMysqlRoleGrant"));
    }
}

