/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BitDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.CustomSuitabilityDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Float1Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.MysqlFloatDomain;
import com.intellij.database.data.types.domain.MysqlNumber2Domain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class MysqlBaseDomains
extends BaseDomainRegistry {
    private static final int MIN_MYSQL_MEDIUM_INT = -16777216;
    private static final int MAX_MYSQL_MEDIUM_INT = 0xFFFFFF;
    private static final int MAX_PRECISION = 53;
    private static final int MAX_SCALE = 30;
    private static final int MAX_CHAR = 255;
    private static final long MAX_LONG = 0xFFFFFFL;
    private static final int MAX_VARBINARY = 65535;
    private static final int MAX_VARCHAR = 21845;
    private static final long INTEGER_UNSIGNED_MAX = 0xFFFFFFFFL;

    public MysqlBaseDomains(@NotNull Dbms dbms) {
        if (dbms == null) {
            MysqlBaseDomains.$$$reportNull$$$0(0);
        }
        this(dbms, true);
    }

    public MysqlBaseDomains(final @NotNull Dbms dbms, boolean sizedFloats) {
        if (dbms == null) {
            MysqlBaseDomains.$$$reportNull$$$0(1);
        }
        this.add((Domain)new CustomSuitabilityDomain.LessOrEqual((Domain)new BooleanDomain("bit", ConversionPoint.BOOLEAN), 1));
        this.add((Domain)new CustomSuitabilityDomain.Greater((Domain)new BitDomain("bit", ConversionPoint.BINARY, 64L, -1L, true), 1));
        this.add((Domain)new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add((Domain)new IntegerDomain("mediumint", ConversionPoint.NUMBER, -1.6777216E7, 1.6777215E7));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new YearDomain());
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("smallint unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, 65535.0));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add((Domain)new IntegerDomain("tinyint unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, 127.0));
        if (sizedFloats) {
            this.add((Domain)new MysqlNumber2Domain((Domain)new Number2Domain("double precision", ConversionPoint.DOUBLE_PRECISION, 53, 30, true)));
            this.add((Domain)new MysqlNumber2Domain((Domain)new Number2Domain("double", ConversionPoint.DOUBLE_PRECISION, 53, 30, true)));
            this.add((Domain)new MysqlFloatDomain((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE)));
            this.add((Domain)new MysqlFloatDomain((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE)));
        } else {
            this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
            this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        }
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 53, 30, true));
        this.add((Domain)new Number2Domain("dec", ConversionPoint.BIG_DECIMAL, 53, 30, true));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("tinytext", ConversionPoint.VARCHAR, 255L));
        this.add((Domain)new TextDomain("text", ConversionPoint.TEXT, 65535L));
        this.add(new TextDomain("mediumtext", ConversionPoint.CLOB, 0xFFFFFFL){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return descriptor.getType() == 12 || super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$1", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("longtext", ConversionPoint.CLOB, 0xFFFFFFFFL){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                return descriptor.getType() == -1 || super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$2", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 255L, 1L, true, false));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 21845L, TextDomain.Length.mandatory((long)4369L, (boolean)true)){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                return !dbms.is(Dbms.MARIA) && super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$3", "isSuitable"));
            }
        });
        this.add((Domain)new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 21845L, TextDomain.Length.mandatory((long)4369L, (boolean)true)){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    4.$$$reportNull$$$0(0);
                }
                return !dbms.is(Dbms.MARIA) && super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$4", "isSuitable"));
            }
        });
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 255L, -1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, 65535L).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("tinyblob", ConversionPoint.BLOB, 255L).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("mediumblob", ConversionPoint.BLOB, 0xFFFFFFL).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("longblob", ConversionPoint.BLOB, 0xFFFFFFFFL).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 65535L, TextDomain.Length.mandatory((long)13107L, (boolean)true)).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new IntegerDomain("integer unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, 4.294967295E9));
        this.add((Domain)new IntegerDomain("int unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, 4.294967295E9));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new IntegerDomain("bigint unsigned", ConversionPoint.UNSIGNED_NUMBER, 0.0, DomainRegistry.CommonLimits.BIGINT_UNSIGNED_MAX));
        if (sizedFloats) {
            this.add((Domain)new MysqlNumber2Domain((Domain)new Number2Domain("float", ConversionPoint.SINGLE_PRECISION, 53, 30, true)));
            this.add((Domain)new MysqlNumber2Domain((Domain)new Number2Domain("real", ConversionPoint.SINGLE_PRECISION, 53, 30, true)));
            this.add((Domain)new MysqlFloatDomain((Domain)new Float1Domain("float", ConversionPoint.SINGLE_PRECISION, new DomainRegistry.Limits(new DomainRegistry.Limit[]{new DomainRegistry.Limit((Number)23, (Number)Float.valueOf(-3.4028235E38f), (Number)Float.valueOf(Float.MAX_VALUE)), new DomainRegistry.Limit((Number)53, (Number)-1.7976931348623157E308, (Number)Double.MAX_VALUE)}))));
            this.add((Domain)new MysqlFloatDomain((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38)));
        } else {
            this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
            this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        }
        this.add(new SimpleDomain("json", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN).withOperationSupport(OperationSupport.SUPPORTS_LIKE).withVersion(v2 -> dbms.is(Dbms.MYSQL) ? v2.isOrGreater(new int[]{5, 7, 8}) : (dbms.is(Dbms.MYSQL_AURORA) ? v2.isOrGreater(new int[]{2}) : true)));
        this.add(new SimpleDomain("enum", ConversionPoint.TEXT, PhysicalDomainType.UNKNOWN){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    5.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = domain instanceof SimpleDomain && StringUtil.equals((CharSequence)domain.name(), (CharSequence)this.name()) ? Compatibility.full((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : Compatibility.incompatible();
                if (compatibility == null) {
                    5.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new SimpleDomain("set", ConversionPoint.TEXT, PhysicalDomainType.UNKNOWN){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    6.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = domain instanceof SimpleDomain && StringUtil.equals((CharSequence)domain.name(), (CharSequence)this.name()) ? Compatibility.full((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : Compatibility.incompatible();
                if (compatibility == null) {
                    6.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new SimpleDomain("geometry", ConversionPoint.GEOMETRY, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("point", ConversionPoint.GEOMETRY, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("polygon", ConversionPoint.GEOMETRY, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("linestring", ConversionPoint.GEOMETRY, PhysicalDomainType.UNKNOWN));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains", "<init>"));
    }

    private static class YearDomain
    extends IntegerDomain {
        public static final int MIN = 1901;
        public static final int MAX = 2155;

        YearDomain() {
            super("year", ConversionPoint.NUMBER, 1901.0, 2155.0);
            this.withOperationSupport(OperationSupport.SUPPORTS_LIKE);
        }

        @NotNull
        protected Number trim(@NotNull Number n) {
            long l;
            if (n == null) {
                YearDomain.$$$reportNull$$$0(0);
            }
            Long l2 = (l = YearDomain.convert(n.longValue())) <= 2155L && l >= 1901L ? l : 0L;
            if (l2 == null) {
                YearDomain.$$$reportNull$$$0(1);
            }
            return l2;
        }

        private static long convert(long value) {
            return value <= 69L && value >= 1L ? 2000L + value : (value >= 70L && value <= 99L ? 1900L + value : value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$YearDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDomains$YearDomain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trim";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

