/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsDescriptionService;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsForeignKey;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsLikeTable;
import com.intellij.database.dialects.mssql.model.MsRole;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsSecurityPredicate;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.MsSourceAware;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.properties.MsRoutineType;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateOperationType;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DatabaseViewOptionsFunKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00101\u001a\u00020\u00042\u0006\u0010\f\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u0002052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00106\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u00107\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00108\u001a\u0002092\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006:"}, d2={"Lcom/intellij/database/dialects/mssql/model/MsDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExtProps", "Lcom/intellij/database/dialects/mssql/model/MsExtendedPropertiesHolder;", "describeMsAliasType", "type", "Lcom/intellij/database/dialects/mssql/model/MsAliasType;", "describeMsDatabase", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "database", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "describeMsDefaultConstraint", "def", "Lcom/intellij/database/dialects/mssql/model/MsDefaultConstraint;", "describeMsForeignKey", "key", "Lcom/intellij/database/dialects/mssql/model/MsForeignKey;", "describeMsIndex", "index", "Lcom/intellij/database/dialects/mssql/model/MsIndex;", "project", "Lcom/intellij/openapi/project/Project;", "describeMsRole", "role", "Lcom/intellij/database/dialects/mssql/model/MsRole;", "describeMsRoutine", "routine", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "describeMsSecurityPredicate", "predicate", "Lcom/intellij/database/dialects/mssql/model/MsSecurityPredicate;", "describeMsSequence", "sequence", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "describeMsStoredColumn", "col", "Lcom/intellij/database/dialects/mssql/model/MsStoredColumn;", "describeMsTable", "table", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "describeMsTableType", "Lcom/intellij/database/dialects/mssql/model/MsTableType;", "describeMsTrigger", "trigger", "Lcom/intellij/database/dialects/mssql/model/MsTrigger;", "options", "updatePresentation", "o", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects.mssql"})
public final class MsDescriptionService
extends DescriptionService {
    @NotNull
    public String options(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<Boolean> basicMetaPropertyId = MsSourceAware.ENCRYPTED;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsStoredColumn.HIDDEN;
        bl = false;
        collection.add(basicMetaPropertyId);
        return super.options(e2, context) + (e2 instanceof MsSourceAware && ((MsSourceAware)e2).isEncrypted() ? " [encrypted]" : "") + (e2 instanceof MsStoredColumn && ((MsStoredColumn)e2).isHidden() ? " [hidden]" : "");
    }

    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        String string = basicElement instanceof MsSequence ? this.describeMsSequence((MsSequence)e2, context) : (basicElement instanceof MsAliasType ? this.describeMsAliasType((MsAliasType)e2, context) : (basicElement instanceof MsTableType ? this.describeMsTableType((MsTableType)e2, context) : (basicElement instanceof MsTable ? this.describeMsTable((MsTable)e2, context) : (basicElement instanceof MsStoredColumn ? this.describeMsStoredColumn((MsStoredColumn)e2, context) : (basicElement instanceof MsDefaultConstraint ? this.describeMsDefaultConstraint((MsDefaultConstraint)e2, context) : (basicElement instanceof MsIndex ? this.describeMsIndex((MsIndex)e2, context) : (basicElement instanceof MsForeignKey ? this.describeMsForeignKey((MsForeignKey)e2, context) : (basicElement instanceof MsTrigger ? this.describeMsTrigger((MsTrigger)e2, context) : (basicElement instanceof MsRoutine ? this.describeMsRoutine((MsRoutine)e2, context) : (basicElement instanceof MsRole ? this.describeMsRole((MsRole)e2, context) : super.content(e2, context)))))))))));
        basicElement = e2;
        return string + (basicElement instanceof MsExtendedPropertiesHolder ? this.describeExtProps((MsExtendedPropertiesHolder)e2) : "");
    }

    private final String describeMsSequence(MsSequence sequence, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId basicMetaPropertyId = MsSequence.CYCLED;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsSequence.CACHE_SIZE;
        bl = false;
        collection.add(basicMetaPropertyId);
        if (!context.getWithSurrogates()) {
            collection = context.getDescribed();
            basicMetaPropertyId = MsSequence.DATA_TYPE;
            bl = false;
            collection.add(basicMetaPropertyId);
        }
        return super.content((BasicElement)sequence, context);
    }

    private final String describeMsAliasType(MsAliasType type, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId basicMetaPropertyId = MsAliasType.DATA_TYPE;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsAliasType.NOT_NULL;
        bl = false;
        collection.add(basicMetaPropertyId);
        if (!context.getWithSurrogates()) {
            collection = context.getDescribed();
            basicMetaPropertyId = MsAliasType.TYPE_ID;
            bl = false;
            collection.add(basicMetaPropertyId);
        }
        return type.getDataType().toString() + (type.isNotNull() ? " NN" : "");
    }

    private final String describeMsTableType(MsTableType type, DescriptionService.Context context) {
        if (!context.getWithSurrogates()) {
            Collection collection = context.getDescribed();
            BasicMetaPropertyId basicMetaPropertyId = MsTableType.TYPE_ID;
            boolean bl = false;
            collection.add(basicMetaPropertyId);
        }
        return super.content((BasicElement)type, context);
    }

    private final String describeMsTable(MsTable table, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId basicMetaPropertyId = MsTable.EXTENDED_PROPERTIES;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        return super.content((BasicElement)table, context);
    }

    private final String describeMsIndex(MsIndex index2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<Boolean> basicMetaPropertyId = MsIndex.CLUSTERING;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsIndex.FULLTEXT;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsIndex.CONDITION;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsIndex.UNIQUE;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsIndex.INCLUDE_COL_NAMES;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsIndex.FULLTEXT_UNIQUE_INDEX_ID;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsIndex.COL_NAMES;
        bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsIndex.REVERSE_COL_NAMES;
        bl = false;
        collection.add(basicMetaPropertyId);
        if (index2.getParent() instanceof MsTableType) {
            collection = context.getDescribed();
            basicMetaPropertyId = MsIndex.OPTION_ALLOW_ROW_LOCKS;
            bl = false;
            collection.add(basicMetaPropertyId);
            collection = context.getDescribed();
            basicMetaPropertyId = MsIndex.OPTION_ALLOW_PAGE_LOCKS;
            bl = false;
            collection.add(basicMetaPropertyId);
        }
        String prefix = index2.isClustering() ? "clustered " : (index2.isFulltext() ? "fulltext " : "");
        String inner = this.describeIndexingItems((BasicIndex)index2);
        String condition = index2.getCondition();
        String d = (index2.isUnique() ? "unique" : "index") + " (" + inner + ')';
        List<String> list = index2.getIncludeColNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"index.includeColNames");
        Collection collection2 = list;
        boolean bl2 = false;
        if (!collection2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append(d).append(" include (");
            List<String> list2 = index2.getIncludeColNames();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"index.includeColNames");
            d = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(')').toString();
        }
        if (condition != null) {
            d = d + " when " + condition;
        }
        if (index2.getFulltextUniqueIndexId() != 0) {
            d = d + " unique_index_id: " + index2.getFulltextUniqueIndexId();
        }
        return prefix + d;
    }

    private final String describeMsDefaultConstraint(MsDefaultConstraint def, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<String> basicMetaPropertyId = MsDefaultConstraint.COL_NAMES;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsDefaultConstraint.DEFAULT_EXPRESSION;
        bl = false;
        collection.add(basicMetaPropertyId);
        String string = StringUtil.join((Collection)def.getColNames(), (String)",");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.join(def.colNames, \",\")");
        String columnName = string;
        String string2 = def.getDefaultExpression();
        if (string2 == null) {
            string2 = "???";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"def.defaultExpression ?: \"???\"");
        String defaultExpression = string2;
        return columnName + " = " + defaultExpression;
    }

    private final String describeMsStoredColumn(MsStoredColumn col, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = MsStoredColumn.SPARSE;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = MsStoredColumn.COLUMN_SET;
        bl = false;
        collection.add(object);
        if (!context.getWithSurrogates()) {
            collection = context.getDescribed();
            object = MsStoredColumn.DEFAULT_CONSTRAINT_NAME;
            bl = false;
            collection.add(object);
        }
        String s = super.content((BasicElement)col, context);
        return col.isSparse() ? s + " sparse" : (col.isColumnSet() ? s + " column_set for all_sparse_columns" : s);
    }

    private final String describeMsForeignKey(MsForeignKey key2, DescriptionService.Context context) {
        if (!context.getWithSurrogates()) {
            Collection collection = context.getDescribed();
            BasicMetaPropertyId<Long> basicMetaPropertyId = MsForeignKey.REF_TABLE_ID;
            boolean bl = false;
            collection.add(basicMetaPropertyId);
        }
        return super.content((BasicElement)key2, context);
    }

    private final String describeMsTrigger(MsTrigger trigger, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<Boolean> basicMetaPropertyId = MsTrigger.DISABLED;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        collection = context.getDescribed();
        basicMetaPropertyId = MsTrigger.NOT_FOR_REPLICATION;
        bl = false;
        collection.add(basicMetaPropertyId);
        return super.content((BasicElement)trigger, context);
    }

    private final String describeMsRoutine(MsRoutine routine2, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<MsRoutineType> basicMetaPropertyId = MsRoutine.ROUTINE_TYPE;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        return super.content((BasicElement)routine2, context);
    }

    private final String describeMsRole(MsRole role, DescriptionService.Context context) {
        Collection collection = context.getDescribed();
        Object object = MsRole.OWNER_ID;
        boolean bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = MsRole.TYPE;
        bl = false;
        collection.add(object);
        collection = context.getDescribed();
        object = MsRole.AUTH_TYPE;
        bl = false;
        collection.add(object);
        return super.content((BasicElement)role, context);
    }

    public void updatePresentation(@NotNull Project project, @NotNull DasObject o2, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o2;
        if (dasObject instanceof MsIndex) {
            this.describeMsIndex(presentation, (MsIndex)o2, project);
        } else if (dasObject instanceof MsSecurityPredicate) {
            this.describeMsSecurityPredicate(presentation, (MsSecurityPredicate)o2);
        } else if (dasObject instanceof MsDatabase) {
            this.describeMsDatabase(presentation, (MsDatabase)o2);
        } else {
            super.updatePresentation(project, o2, presentation);
        }
    }

    private final void describeMsIndex(PresentationData presentation, MsIndex index2, Project project) {
        String text = " ";
        DatabaseViewOptions databaseViewOptions = DatabaseViewOptions.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)databaseViewOptions, (String)"DatabaseViewOptions.getInstance(project)");
        if (DatabaseViewOptionsFunKt.getUnnestTableSubObjects((DatabaseViewOptions)databaseViewOptions)) {
            MsLikeTable msLikeTable = index2.getLikeTable();
            String tableName = StringKt.nullize((String)(msLikeTable != null ? msLikeTable.getName() : null), (boolean)true);
            if (tableName != null) {
                text = text + "on " + tableName + ' ';
            }
        }
        String unique = index2.isUnique() ? " UNIQUE" : "";
        String indexingItems = this.describeIndexingItems((BasicIndex)index2);
        text = text + '(' + indexingItems + ')' + unique;
        List<String> list = index2.getIncludeColNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"index.includeColNames");
        List<String> includingColNames = list;
        Collection collection = includingColNames;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String string = StringUtil.join((Collection)includingColNames, (String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.join(includingColNames, \", \")");
            String icn = string;
            text = text + " include (" + icn + ')';
        }
        presentation.addText(text, DbPresentationCore.INFO_ATTRS);
        String condition = index2.getCondition();
        if (condition != null) {
            String conditionClause = " where " + condition;
            presentation.addText(conditionClause, DbPresentationCore.INFO_ATTRS);
        }
    }

    private final void describeMsSecurityPredicate(PresentationData presentation, MsSecurityPredicate predicate) {
        boolean bl;
        String string;
        Enum it;
        boolean bl2;
        boolean bl3;
        Enum enum_;
        boolean bl4 = false;
        boolean bl5 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl8 = false;
        MsSecurityPredicateType msSecurityPredicateType = predicate.getPredicateType();
        if (msSecurityPredicateType != null) {
            enum_ = msSecurityPredicateType;
            bl3 = false;
            bl2 = false;
            it = enum_;
            boolean bl9 = false;
            string = it.name();
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            $this$buildString.append(string3).append(" ");
        }
        String string4 = predicate.getTargetSchemaName();
        String string5 = predicate.getTargetTableName();
        if (string5 == null) {
            string5 = "???";
        }
        $this$buildString.append(StringUtil.getQualifiedName((String)string4, (String)string5));
        MsSecurityPredicateOperationType msSecurityPredicateOperationType = predicate.getOperationType();
        if (msSecurityPredicateOperationType != null) {
            enum_ = msSecurityPredicateOperationType;
            bl3 = false;
            bl2 = false;
            it = enum_;
            boolean bl10 = false;
            StringBuilder stringBuilder2 = $this$buildString.append(" ");
            string = it.name();
            bl = false;
            String string6 = string;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
            stringBuilder2.append(StringsKt.replace$default((String)string7, (char)'_', (char)' ', (boolean)false, (int)4, null));
        }
        String string8 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"StringBuilder().apply(builderAction).toString()");
        String text = string8;
        presentation.addText(text, DbPresentationCore.INFO_ATTRS);
    }

    private final void describeMsDatabase(PresentationData presentation, MsDatabase database) {
        if (!database.isOnline()) {
            presentation.setIcon(IconLoader.getDisabledIcon((Icon)DatabaseIcons.Database));
        }
    }

    private final String describeExtProps(MsExtendedPropertiesHolder e2) {
        String string;
        if (e2.getExtendedProperties().isEmpty()) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(" [");
            List<NameValueType> list = e2.getExtendedProperties();
            Intrinsics.checkNotNullExpressionValue(list, (String)"e.extendedProperties");
            string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)describeExtProps.1.INSTANCE, (int)31, null)).append("]").toString();
        }
        return string;
    }
}

