/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.translator.tree_creator.builder;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mongo.translator.MongoToDatabaseScriptTranslator;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.IMongoLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoBooleanLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoInfinityLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoIntegerLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoNanLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoNullLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoRealLiteral;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.primitive.MongoStringLiteral;
import com.intellij.database.dialects.mongo.translator.tree_creator.builder.IMongoLiteralBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoLiteralBuilder;", "Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/IMongoLiteralBuilder;", "o", "Lcom/intellij/sql/psi/SqlLiteralExpression;", "root", "Lcom/intellij/sql/psi/SqlElement;", "(Lcom/intellij/sql/psi/SqlLiteralExpression;Lcom/intellij/sql/psi/SqlElement;)V", "category", "Lcom/intellij/sql/psi/SqlType$Category;", "getO", "()Lcom/intellij/sql/psi/SqlLiteralExpression;", "getRoot", "()Lcom/intellij/sql/psi/SqlElement;", "text", "", "build", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/literal/primitive/IMongoLiteral;", "v", "intellij.database.dialects.mongo"})
public final class MongoLiteralBuilder
implements IMongoLiteralBuilder {
    private String text;
    private SqlType.Category category;
    @NotNull
    private final SqlLiteralExpression o;
    @NotNull
    private final SqlElement root;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IMongoLiteral build() {
        IMongoLiteral iMongoLiteral;
        String text;
        String string = this.text;
        if (string == null) throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        String string2 = text = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        String upperText = string4;
        if (this.category == SqlType.Category.INTEGER && StringsKt.toLongOrNull((String)text) != null) {
            string2 = text;
            bl = false;
            long l = Long.parseLong(string2);
            String string5 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"o.text");
            iMongoLiteral = new MongoIntegerLiteral(l, string5);
            return iMongoLiteral;
        }
        if (this.category == SqlType.Category.BOOLEAN) {
            if (Intrinsics.areEqual((Object)upperText, (Object)"TRUE") ^ true && Intrinsics.areEqual((Object)upperText, (Object)"FALSE") ^ true) {
                throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
            }
            boolean bl2 = Intrinsics.areEqual((Object)upperText, (Object)"TRUE");
            String string6 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"o.text");
            return new MongoBooleanLiteral(bl2, string6);
        }
        if (this.category == SqlType.Category.STRING) {
            iMongoLiteral = new MongoStringLiteral(text);
            return iMongoLiteral;
        }
        if (this.category != SqlType.Category.UNKNOWN) {
            String string7 = DatabaseBundle.message((String)"MongoTranslator.errors.incorrect.literal.0", (Object[])new Object[]{text});
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"DatabaseBundle.message(\"\u2026correct.literal.0\", text)");
            throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string7, (PsiElement)this.o, (PsiElement)this.root);
        }
        if (Intrinsics.areEqual((Object)upperText, (Object)"NULL")) {
            String string8 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"o.text");
            iMongoLiteral = new MongoNullLiteral(string8);
            return iMongoLiteral;
        }
        if (Intrinsics.areEqual((Object)upperText, (Object)"INFINITY")) {
            String string9 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"o.text");
            iMongoLiteral = new MongoInfinityLiteral(string9);
            return iMongoLiteral;
        }
        if (Intrinsics.areEqual((Object)upperText, (Object)"NAN")) {
            String string10 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"o.text");
            iMongoLiteral = new MongoNanLiteral(string10);
            return iMongoLiteral;
        }
        if (StringsKt.toDoubleOrNull((String)text) != null) {
            string2 = text;
            bl = false;
            double d = Double.parseDouble(string2);
            String string11 = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"o.text");
            iMongoLiteral = new MongoRealLiteral(d, string11);
            return iMongoLiteral;
        }
        String string12 = DatabaseBundle.message((String)"MongoTranslator.errors.incorrect.literal.0", (Object[])new Object[]{text});
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"DatabaseBundle.message(\"\u2026correct.literal.0\", text)");
        throw (Throwable)MongoToDatabaseScriptTranslator.Companion.createTranslationException(string12, (PsiElement)this.o, (PsiElement)this.root);
    }

    @Override
    @NotNull
    public MongoLiteralBuilder text(@NotNull String v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoLiteralBuilder mongoLiteralBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoLiteralBuilder $this$apply = mongoLiteralBuilder;
        boolean bl3 = false;
        $this$apply.text = v2;
        return mongoLiteralBuilder;
    }

    @Override
    @NotNull
    public MongoLiteralBuilder category(@NotNull SqlType.Category v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoLiteralBuilder mongoLiteralBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        MongoLiteralBuilder $this$apply = mongoLiteralBuilder;
        boolean bl3 = false;
        $this$apply.category = v2;
        return mongoLiteralBuilder;
    }

    @NotNull
    public final SqlLiteralExpression getO() {
        return this.o;
    }

    @NotNull
    public final SqlElement getRoot() {
        return this.root;
    }

    public MongoLiteralBuilder(@NotNull SqlLiteralExpression o2, @NotNull SqlElement root2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.o = o2;
        this.root = root2;
    }
}

