/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HsqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected HsqlDialect() {
        super(new TypeHelper.HSQLTypeHelper());
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.HSQL;
        if (dbms == null) {
            HsqlDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "HSQLDB";
    }

    @Override
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            HsqlDialect.$$$reportNull$$$0(1);
        }
        return "x" + super.getBinaryLiteralString(binaryData);
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            HsqlDialect.$$$reportNull$$$0(2);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("set schema %s", schema);
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition2) {
        if (builder == null) {
            HsqlDialect.$$$reportNull$$$0(3);
        }
        if (view == null) {
            HsqlDialect.$$$reportNull$$$0(4);
        }
        if (definition2 == null) {
            HsqlDialect.$$$reportNull$$$0(5);
        }
        builder.keywords(new String[]{"CREATE", "VIEW"}).space();
        builder.qualifiedRef((DasObject)view);
        JBIterable columns = view.getDasChildren(ObjectKind.COLUMN);
        if (!columns.isEmpty()) {
            builder.symbol("(");
            int offset = builder.length();
            for (DasObject column2 : columns) {
                if (builder.length() != offset) {
                    builder.symbol(", ");
                }
                builder.identifier(column2);
            }
            builder.symbol(")");
        }
        builder.space().keyword("AS").space();
        builder.plain(definition2);
        return builder;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            HsqlDialect.$$$reportNull$$$0(6);
        }
        if (sequence == null) {
            HsqlDialect.$$$reportNull$$$0(7);
        }
        DdlBuilder ddlBuilder = builder.keywords(new String[]{"DROP", "SEQUENCE"}).space().qualifiedRef(sequence);
        if (ddlBuilder == null) {
            HsqlDialect.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            HsqlDialect.$$$reportNull$$$0(9);
        }
        if (view == null) {
            HsqlDialect.$$$reportNull$$$0(10);
        }
        DdlBuilder ddlBuilder = builder.keywords(new String[]{"DROP", "VIEW"}).space().qualifiedRef((DasObject)view);
        if (ddlBuilder == null) {
            HsqlDialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            HsqlDialect.$$$reportNull$$$0(12);
        }
        String templateStr = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = ''{0}'' and TABLE_SCHEMA = ''{1}'' ";
        return Pair.create((Object)MessageFormat.format(templateStr, element.getName(), DasUtil.getSchema((DasObject)element)), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            HsqlDialect.$$$reportNull$$$0(13);
        }
        String templateStr = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = ''{0}'' and ROUTINE_SCHEMA = ''{1}'' ";
        Pair pair = Pair.create((Object)MessageFormat.format(templateStr, element.getName(), DasUtil.getSchema((DasObject)element)), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            HsqlDialect.$$$reportNull$$$0(14);
        }
        return pair;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            HsqlDialect.$$$reportNull$$$0(15);
        }
        if (qualifier == null) {
            HsqlDialect.$$$reportNull$$$0(16);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            HsqlDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnectionCore connection) throws SQLException {
        if (system == null) {
            HsqlDialect.$$$reportNull$$$0(18);
        }
        if (connection == null) {
            HsqlDialect.$$$reportNull$$$0(19);
        }
        Map rs = DbImplUtilCore.resultRowAsMap((DatabaseConnectionCore)connection, (String)"select current_catalog d, current_schema s from (values (1))", (String[])new String[0]);
        String d = (String)ObjectUtils.tryCast(rs.get("D"), String.class);
        String s = (String)ObjectUtils.tryCast(rs.get("S"), String.class);
        return StringUtil.isEmpty((String)s) || StringUtil.isEmpty((String)d) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)d, (ObjectKind)ObjectKind.DATABASE).append(s, ObjectKind.SCHEMA));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/hsql/HsqlDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/hsql/HsqlDialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

