/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.CallableSmartStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.db2.model.Db2DefType;
import com.intellij.database.dialects.db2.model.properties.Db2DataTypeSubKind;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Db2BaseDialect
extends AbstractDatabaseDialect {
    private final Dbms myDbms;

    public Db2BaseDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            Db2BaseDialect.$$$reportNull$$$0(0);
        }
        super(new TypeHelper.DB2TypeHelper());
        this.myDbms = dbms;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            Db2BaseDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        String string = StringUtil.trimStart((String)this.myDbms.getDisplayName(), (String)"IBM ");
        if (string == null) {
            Db2BaseDialect.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            Db2BaseDialect.$$$reportNull$$$0(3);
        }
        if (qualifier == null) {
            Db2BaseDialect.$$$reportNull$$$0(4);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), catalog, DasUtil.getName((DasObject)catalog), pkg, pkgName);
        if (ddlBuilder == null) {
            Db2BaseDialect.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            Db2BaseDialect.$$$reportNull$$$0(6);
        }
        String string = "BLOB(x'" + DialectUtils.toHexString((byte[])binaryData) + "')";
        if (string == null) {
            Db2BaseDialect.$$$reportNull$$$0(7);
        }
        return string;
    }

    public Dbms guessExactDbms(@Nullable DasObject element) {
        if (this.myDbms != Dbms.DB2) {
            return this.myDbms;
        }
        return DbImplUtilCore.getDbms((DasObject)element);
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            Db2BaseDialect.$$$reportNull$$$0(8);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", current.getName());
    }

    @NotNull
    public DdlBuilder generated(@NotNull DdlBuilder builder) {
        if (builder == null) {
            Db2BaseDialect.$$$reportNull$$$0(9);
        }
        DdlBuilder ddlBuilder = builder.space().keywords(new String[]{"GENERATED", "ALWAYS", "AS", "IDENTITY"}).plain("(").keywords(new String[]{"START", "WITH"}).space().literal("1").space().keywords(new String[]{"INCREMENT", "BY"}).space().literal("1").plain(")");
        if (ddlBuilder == null) {
            Db2BaseDialect.$$$reportNull$$$0(10);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            Db2BaseDialect.$$$reportNull$$$0(11);
        }
        if (sequence == null) {
            Db2BaseDialect.$$$reportNull$$$0(12);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL((DdlBuilder)builder, (DasObject)sequence, (Boolean)false);
        if (ddlBuilder == null) {
            Db2BaseDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        Dbms dbms;
        if (element == null) {
            Db2BaseDialect.$$$reportNull$$$0(14);
        }
        String query = (dbms = this.guessExactDbms(element)) == Dbms.DB2_IS ? "SELECT 'CREATE VIEW ' || TABLE_NAME || ' AS ' || VIEW_DEFINITION FROM QSYS2.SYSVIEWS WHERE TABLE_SCHEMA = '" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(TABLE_NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "'" : (dbms == Dbms.DB2_ZOS ? "SELECT STATEMENT FROM SYSIBM.SYSVIEWS WHERE CREATOR = '" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "'" : "SELECT TEXT FROM SYSCAT.VIEWS WHERE VIEWSCHEMA = '" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(VIEWNAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "'");
        return Pair.create((Object)query, (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            Db2BaseDialect.$$$reportNull$$$0(15);
        }
        DasRoutine.Kind type = element.getRoutineKind();
        Dbms dbms = this.guessExactDbms((DasObject)element);
        String query = dbms == Dbms.DB2_IS ? "SELECT ROUTINE_DEFINITION FROM QSYS2.SYSROUTINES  WHERE ROUTINE_SCHEMA='" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(ROUTINE_NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' AND ROUTINE_TYPE = '" + (type == DasRoutine.Kind.FUNCTION ? "FUNCTION" : "PROCEDURE") + "'" : (dbms == Dbms.DB2_ZOS ? "SELECT TEXT FROM SYSIBM.ROUTINES WHERE SCHEMA='" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' AND ROUTINETYPE = '" + (type == DasRoutine.Kind.FUNCTION ? "F" : "P") + "'" : "SELECT TEXT FROM SYSCAT.ROUTINES WHERE ROUTINESCHEMA='" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(ROUTINENAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' AND ROUTINETYPE = '" + (type == DasRoutine.Kind.FUNCTION ? "F" : "P") + "'");
        Pair pair = Pair.create((Object)query, (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            Db2BaseDialect.$$$reportNull$$$0(16);
        }
        return pair;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return true;
    }

    @Nullable
    public SqlType getSqlType(@Nullable PsiElement refElement, @NotNull DbElement resolved) {
        Object delegate;
        if (resolved == null) {
            Db2BaseDialect.$$$reportNull$$$0(17);
        }
        if ((delegate = resolved.getDelegate()) instanceof Db2DefType) {
            Db2DataTypeSubKind subKind = ((Db2DefType)delegate).getSubKind();
            return SqlTableTypeBase.createObjectTypeType((DasObject)resolved, (PsiElement)resolved, (PsiElement)refElement, (subKind == Db2DataTypeSubKind.ROW ? 1 : 0) != 0);
        }
        return null;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            Db2BaseDialect.$$$reportNull$$$0(18);
        }
        return dialect instanceof Db2BaseDialect;
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnectionCore connection) throws Exception {
        if (element == null) {
            Db2BaseDialect.$$$reportNull$$$0(19);
        }
        if (connection == null) {
            Db2BaseDialect.$$$reportNull$$$0(20);
        }
        Dbms dbms = connection.getDbms();
        Map map2 = DbImplUtilCore.resultRowAsMap((DatabaseConnectionCore)connection, (String)String.format("SELECT tabname, card, collationname, create_time FROM syscat.tables WHERE owner = '%s' AND tabname LIKE '%s' ESCAPE '#'", DbImplUtilCore.escapeStr((String)DasUtil.getSchema((DasObject)element)), DbImplUtilCore.escapeSql((Object)element.getName(), (boolean)true, (Dbms)dbms)), (String[])new String[]{"CARD", "rows", "COLLATIONNAME", "collation", "CREATE_TIME", "created"});
        if (map2 == null) {
            Db2BaseDialect.$$$reportNull$$$0(21);
        }
        return map2;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnectionCore connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            Db2BaseDialect.$$$reportNull$$$0(22);
        }
        if (connection == null) {
            Db2BaseDialect.$$$reportNull$$$0(23);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtilCore.concatStringResults((DatabaseConnectionCore)connection, (Dbms)(dbms = connection.getDbms()), (String)"select current_schema from sysibm.sysdummy1", (int)1, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.LINES))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnectionCore connection) throws Exception {
        if (table == null) {
            Db2BaseDialect.$$$reportNull$$$0(24);
        }
        if (connection == null) {
            Db2BaseDialect.$$$reportNull$$$0(25);
        }
        CallableSmartStatement statement = SmartStatementFactoryService.getInstance().poweredBy(connection).call();
        CallableStatementData data = new StatementParameters().text(QNameUtil.getQualifiedName((DasObject)table)).parameter(2, 4).asCallData("CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)");
        Either token = statement.execute((Object)data, (ExecutionMode)StandardExecutionMode.UPDATE, StandardResultsProcessors.parameterRetriever((int)2));
        Dbms dbms = connection.getDbms();
        String string = token.isLeft() ? "Failed to load table definition" : StringUtil.trimEnd((String)DbImplUtilCore.concatStringResults((DatabaseConnectionCore)connection, (Dbms)dbms, (String)("SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = " + EitherKt.tryGet((Either)token)), (int)1, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.NO_CONCAT), (String)";");
        if (string == null) {
            Db2BaseDialect.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/Db2BaseDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/Db2BaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generated";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 26: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generated";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

