/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class CassDomains
extends BaseDomainRegistry {
    private static final Condition<@NotNull Version> CASS_2_2 = v2 -> v2.isOrGreater(new int[]{2, 2});
    private static final Condition<@NotNull Version> CASS_3_10 = v2 -> v2.isOrGreater(new int[]{3, 10});

    public CassDomains() {
        this.add((Domain)new TextDomain("ascii", ConversionPoint.TEXT, Integer.MAX_VALUE){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = StringUtil.equalsIgnoreCase((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? super.getCompatibility(domain) : Compatibility.incompatible();
                if (compatibility == null) {
                    1.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/cassandra/CassDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/cassandra/CassDomains$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE, Integer.MAX_VALUE, false, true));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, false));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new IntegerDomain("counter", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new SimpleDomain("inet", ConversionPoint.INET, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.isSuitable(descriptor) || StringUtil.equalsIgnoreCase((CharSequence)"varchar", (CharSequence)descriptor.getTypeName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/cassandra/CassDomains$2", "isSuitable"));
            }
        });
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6));
        this.add((Domain)new SimpleDomain("uuid", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new SimpleDomain("timeuuid", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new IntegerDomain("varint", ConversionPoint.BIG_DECIMAL, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE).withVersion(CASS_2_2));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false).withVersion(CASS_2_2));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0).withVersion(CASS_2_2));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0).withVersion(CASS_2_2));
        this.add(new SimpleDomain("duration", ConversionPoint.INTERVAL, PhysicalDomainType.UNKNOWN).withVersion(CASS_3_10));
    }
}

