/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseErrorHandlerSink;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigQueryErrorHandler
extends BaseDatabaseErrorHandler {
    private final Pattern myErrorOffsetPattern = Pattern.compile("Message: Syntax error:.*at \\[(\\d+):(\\d+)]");

    public int getErrorOffsetFromException(@NotNull Project project, @NotNull Throwable error, @NotNull String queryText) {
        Matcher matcher;
        if (project == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(0);
        }
        if (error == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(1);
        }
        if (queryText == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(2);
        }
        if (!(matcher = this.myErrorOffsetPattern.matcher(StringUtil.notNullize((String)error.getMessage()))).find()) {
            return -1;
        }
        int line = StringUtil.parseInt((String)matcher.group(1), (int)0) - 1;
        int column2 = StringUtil.parseInt((String)matcher.group(2), (int)0) - 1;
        if (line == -1 || column2 == -1) {
            return -1;
        }
        return StringUtil.lineColToOffset((CharSequence)queryText, (int)line, (int)column2);
    }

    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @NotNull DatabaseErrorHandlerSink sink) {
        if (original == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(3);
        }
        if (cause == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(5);
        }
        @Nls StringBuilder sb = new StringBuilder();
        String causeMsg = JdbcUtil.getMessage((Throwable)cause);
        if (original instanceof SQLException && cause instanceof RuntimeException) {
            BigQueryErrorHandler.appendGenericMessage((Throwable)original, (StringBuilder)sb);
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)causeMsg) == -1) {
                sb.append(JdbcUtil.getMessagePrefix((Throwable)cause)).append(causeMsg);
            }
            String string = sb.toString();
            if (string == null) {
                BigQueryErrorHandler.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = super.getErrorMessage(dataSource, original, cause, sink);
        if (string == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/bigquery/BigQueryErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/bigquery/BigQueryErrorHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffsetFromException";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

