/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.AuditFacade;
import com.intellij.database.layoutedQueries.BaseFacade;
import com.intellij.database.layoutedQueries.DBFacade;
import com.intellij.database.layoutedQueries.impl.AdaptIntermediateFacade;
import com.intellij.database.layoutedQueries.impl.IntegralIntermediateFacade;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/base/introspector/DBFacadeProvider;", "", "()V", "createFacadeWithSingleLeasedConnection", "Lcom/intellij/database/layoutedQueries/DBFacade;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "getRemoteIntermediateFacade", "Lcom/intellij/database/remote/jdba/RemoteFacade;", "ProjectDBFacade", "intellij.database.dialects.base.core"})
public final class DBFacadeProvider {
    @NotNull
    public static final DBFacadeProvider INSTANCE;

    @JvmStatic
    @NotNull
    public static final DBFacade createFacadeWithSingleLeasedConnection(@NotNull DatabaseConnectionCore connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RemoteFacade primeIntermediateFacade = INSTANCE.getRemoteIntermediateFacade(connection);
        AdaptIntermediateFacade integralIntermediateFacade = new AdaptIntermediateFacade((PrimeIntermediateFacade)new AuditFacade(primeIntermediateFacade, connection));
        ProjectDBFacade facade = new ProjectDBFacade(connection.getAuditService().getProject(), (IntegralIntermediateFacade)integralIntermediateFacade);
        facade.connect();
        return (DBFacade)facade;
    }

    private final RemoteFacade getRemoteIntermediateFacade(DatabaseConnectionCore connection) {
        RemoteConnection remoteConnection = connection.getRemoteConnection();
        Intrinsics.checkNotNullExpressionValue((Object)remoteConnection, (String)"connection.remoteConnection");
        RemoteConnection remoteConnection2 = remoteConnection;
        RemoteFacade remoteFacade = remoteConnection2.jpdaFacade();
        Intrinsics.checkNotNullExpressionValue((Object)remoteFacade, (String)"remoteConnection.jpdaFacade()");
        return remoteFacade;
    }

    private DBFacadeProvider() {
    }

    static {
        DBFacadeProvider dBFacadeProvider;
        INSTANCE = dBFacadeProvider = new DBFacadeProvider();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/DBFacadeProvider$ProjectDBFacade;", "Lcom/intellij/database/layoutedQueries/BaseFacade;", "project", "Lcom/intellij/openapi/project/Project;", "facade", "Lcom/intellij/database/layoutedQueries/impl/IntegralIntermediateFacade;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/layoutedQueries/impl/IntegralIntermediateFacade;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.database.dialects.base.core"})
    public static final class ProjectDBFacade
    extends BaseFacade {
        @Nullable
        private final Project project;

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        public ProjectDBFacade(@Nullable Project project, @NotNull IntegralIntermediateFacade facade) {
            Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
            super(facade);
            this.project = project;
        }
    }
}

