/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainOrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DdlBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a4\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0007\u001aX\u0010\n\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00072 \u0010\u0018\u001a\u001c\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0019j\u0004\u0018\u0001`\u001cH\u0002\u00a8\u0006\u001d"}, d2={"generateOrderBy", "", "orderBy", "Lcom/intellij/database/script/generator/dml/ColumnsOrderBy;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "printOrderByKeyword", "", "Lcom/intellij/database/script/generator/dml/OrderBy;", "Lcom/intellij/database/script/generator/dml/PlainOrderBy;", "generateWhere", "dbms", "Lcom/intellij/database/Dbms;", "whereClause", "Lcom/intellij/database/script/generator/dml/WhereClause;", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "printWhereKeyword", "insertNewLines", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "op", "", "processor", "Lkotlin/Function2;", "Lcom/intellij/database/data/types/ColumnRef;", "Lcom/intellij/database/data/types/PredicateValue;", "Lcom/intellij/database/script/generator/dml/ColumnValueConsumer;", "intellij.database.dialects.base.core"})
public final class UtilKt {
    public static final void generateWhere(@NotNull Dbms dbms, @Nullable WhereClause whereClause, @NotNull DdlBuilder builder, @NotNull DmlTask<?> task, boolean printWhereKeyword) {
        block3: {
            WhereClause whereClause2;
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    Intrinsics.checkNotNullParameter(task, (String)"task");
                    whereClause2 = whereClause;
                    if (!(whereClause2 instanceof ValuesWhereClause)) break block2;
                    List predicates = ((ValuesWhereClause)whereClause).getPredicates(dbms, DmlTaskKt.getTableAlias(task), DmlTaskKt.getVersion(task), DmlTaskKt.inUpdate(task));
                    UtilKt.generateWhere(builder, DmlTaskKt.insertNewLines(task), predicates, ((ValuesWhereClause)whereClause).getOp(), printWhereKeyword, (Function2<? super ColumnRef, ? super PredicateValue, Unit>)((ValuesWhereClause)whereClause).getProcessor());
                    break block3;
                }
                if (!(whereClause2 instanceof PredicatesWhereClause)) break block4;
                UtilKt.generateWhere(builder, DmlTaskKt.insertNewLines(task), ((PredicatesWhereClause)whereClause).getPredicates(), ((PredicatesWhereClause)whereClause).getOp(), printWhereKeyword, (Function2<? super ColumnRef, ? super PredicateValue, Unit>)((PredicatesWhereClause)whereClause).getProcessor());
                break block3;
            }
            if (!(whereClause2 instanceof PlainWhereClause)) break block3;
            if (StringsKt.isBlank((CharSequence)((PlainWhereClause)whereClause).getFilter())) {
                return;
            }
            if (printWhereKeyword) {
                builder.keyword("WHERE");
            }
            Intrinsics.checkNotNullExpressionValue((Object)builder.space().plain(((PlainWhereClause)whereClause).getFilter()), (String)"builder.space().plain(whereClause.filter)");
        }
    }

    private static final void generateWhere(DdlBuilder builder, boolean insertNewLines, List<PredicatesHelper.PredicateProducer> predicates, String op, boolean printWhereKeyword, Function2<? super ColumnRef, ? super PredicateValue, Unit> processor) {
        if (predicates.isEmpty()) {
            return;
        }
        if (printWhereKeyword) {
            builder.keyword("WHERE").space();
        }
        boolean first2 = true;
        for (PredicatesHelper.PredicateProducer predicate : predicates) {
            if (first2) {
                first2 = false;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)DmlUtilKt.space((DdlBuilder)builder, (boolean)insertNewLines).keyword(op).space(), (String)"builder.space(insertNewLines).keyword(op).space()");
            }
            if (processor != null) {
                Iterable $this$forEach$iv = predicate.getColumnRefs();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ColumnRef it = (ColumnRef)element$iv;
                    boolean bl = false;
                    processor.invoke((Object)it, (Object)predicate.getValue());
                }
            }
            predicate.getProduce().invoke((Object)builder);
        }
    }

    public static final void generateOrderBy(@NotNull OrderBy orderBy, @NotNull DdlBuilder builder, boolean printOrderByKeyword) {
        block1: {
            OrderBy orderBy2;
            block0: {
                Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                orderBy2 = orderBy;
                if (!(orderBy2 instanceof ColumnsOrderBy)) break block0;
                UtilKt.generateOrderBy((ColumnsOrderBy)orderBy, builder, printOrderByKeyword);
                break block1;
            }
            if (!(orderBy2 instanceof PlainOrderBy)) break block1;
            UtilKt.generateOrderBy((PlainOrderBy)orderBy, builder, printOrderByKeyword);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void generateOrderBy(ColumnsOrderBy orderBy, DdlBuilder builder, boolean printOrderByKeyword) {
        boolean first2 = true;
        for (Pair pair : orderBy.getColumns()) {
            void name2;
            String string = (String)pair.component1();
            RowSortOrder.Type order = (RowSortOrder.Type)pair.component2();
            if (first2) {
                if (printOrderByKeyword) {
                    builder.keywords(new String[]{"ORDER", "BY"}).space();
                }
                first2 = false;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)builder.symbol(",").space(), (String)"builder.symbol(\",\").space()");
            }
            builder.columnRef((String)name2);
            if (order == RowSortOrder.Type.ASC) continue;
            builder.space().keyword(order.toString());
        }
    }

    private static final void generateOrderBy(PlainOrderBy orderBy, DdlBuilder builder, boolean printOrderByKeyword) {
        if (StringsKt.isBlank((CharSequence)orderBy.getText())) {
            return;
        }
        if (printOrderByKeyword) {
            builder.keywords(new String[]{"ORDER", "BY"}).space();
        }
        builder.plain(orderBy.getText());
    }
}

