/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.BaseDropGenerator;
import com.intellij.database.dialects.base.generator.EffectType;
import com.intellij.database.dialects.base.generator.Node;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OperationType;
import com.intellij.database.dialects.base.generator.ScenarioOperations;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0017J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0007H\u0017J$\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\fH\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/base/generator/BaseDropGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "prepared", "", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/dialects/base/generator/Operation;", "getPrepared", "()Ljava/util/Map;", "clear", "", "elements", "", "fillDependencies", "fillDropDependants", "e", "getEdgeFixers", "", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$EdgeFixer;", "makeDropOperation", "element", "root", "makeOperation", "prepareElement", "forceRoot", "", "prepareScenario", "Companion", "intellij.database.dialects.base.core"})
public class BaseDropGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final Map<BasicElement, Operation> prepared;
    @NotNull
    private static final OperationType DROP;
    private static final Companion.DROP_FK_FIXER.1 DROP_FK_FIXER;
    @NotNull
    private static final List<AbstractCodeGenerator.EdgeFixer> DROP_FIXERS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Map<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    @Override
    @TestOnly
    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Operation res2 = this.makeDropOperation(element, this.getScenario().getRoot());
        BasicModel basicModel = ScriptingTaskKt.getAnyModel((ScriptingTask)this.getContext().getTask());
        if (basicModel != null && (basicModel = basicModel.basicTraverser()) != null) {
            Iterable $this$forEach$iv = (Iterable)basicModel;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                BasicElement basicElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"it");
                this.fillDropDependants(basicElement);
            }
        }
        return res2;
    }

    @Override
    @TestOnly
    public void clear() {
        this.prepared.clear();
    }

    @Override
    public void prepareScenario() {
        Iterable $this$forEach$iv = this.elements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it = (BasicElement)element$iv;
            boolean bl = false;
            BaseDropGenerator.prepareElement$default(this, it, this.getScenario().getRoot(), false, 4, null);
        }
        this.fillDependencies();
    }

    private final Collection<BasicElement> elements() {
        Object object;
        ScriptingTask scriptingTask = this.getContext().getTask();
        if (!(scriptingTask instanceof ScriptingSingleModelTask)) {
            scriptingTask = null;
        }
        if ((object = (ScriptingSingleModelTask)scriptingTask) == null || (object = object.getElements()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final void fillDependencies() {
        Iterable $this$forEach$iv = this.prepared.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it = (BasicElement)element$iv;
            boolean bl = false;
            this.fillDropDependants(it);
        }
    }

    public final void fillDropDependants(@NotNull BasicElement e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Iterable iterable = e2.getPredecessors();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"e.predecessors");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it = (BasicElement)element$iv;
            boolean bl = false;
            Operation operation2 = this.prepared.get(it);
            if (operation2 == null) continue;
            ScenarioOperations.requires(operation2, ScenarioOperations.matches$default(EffectType.Unexistent, e2, null, 2, null));
        }
    }

    @Nullable
    public Operation prepareElement(@NotNull BasicElement element, @NotNull Operation root2, boolean forceRoot) {
        Operation operation2;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                operation2 = this.prepared.get(element);
                if (operation2 == null) break block4;
                Operation operation3 = operation2;
                boolean bl = false;
                boolean bl2 = false;
                Operation $this$apply = operation3;
                boolean bl3 = false;
                if (forceRoot) {
                    $this$apply.setParent((Node)root2);
                }
                if ((operation2 = operation3) != null) break block5;
            }
            operation2 = this.makeDropOperation(element, root2);
        }
        return operation2;
    }

    public static /* synthetic */ Operation prepareElement$default(BaseDropGenerator baseDropGenerator, BasicElement basicElement, Operation operation2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseDropGenerator.prepareElement(basicElement, operation2, bl);
    }

    @NotNull
    public Operation makeDropOperation(@NotNull BasicElement element, @NotNull Operation root2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        return this.getContext().getHelper().createDropProducer(this.getContext(), element).register(this, root2);
    }

    @Override
    @NotNull
    public List<AbstractCodeGenerator.EdgeFixer> getEdgeFixers() {
        return DROP_FIXERS;
    }

    public BaseDropGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.prepared = new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        DROP = new OperationType("drop");
        DROP_FK_FIXER = new AbstractCodeGenerator.EdgeFixer(){

            /*
             * WARNING - void declaration
             */
            public boolean fix(@NotNull Operation root2, @NotNull Operation op1, @NotNull Operation op2, @Nullable Function1<? super BasicElement, Operation> parent2) {
                BasicElement basicElement;
                void $this$element$iv;
                BasicElement basicElement2;
                void $this$element$iv2;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                Intrinsics.checkNotNullParameter((Object)op1, (String)"op1");
                Intrinsics.checkNotNullParameter((Object)op2, (String)"op2");
                if (Intrinsics.areEqual((Object)((Operation)op1.getParent()), (Object)root2)) {
                    return false;
                }
                Operation operation2 = op2;
                Object t$iv = BaseDropGenerator.Companion.getDROP();
                boolean $i$f$element = false;
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$this$element$iv2), (Object)t$iv)) {
                    BasicElement basicElement3 = ScenarioOperations.element((Operation)$this$element$iv2);
                    if (!(basicElement3 instanceof BasicLikeTable)) {
                        basicElement3 = null;
                    }
                    basicElement2 = (BasicElement)((BasicLikeTable)basicElement3);
                } else {
                    basicElement2 = null;
                }
                BasicLikeTable basicLikeTable = (BasicLikeTable)basicElement2;
                if (basicLikeTable == null) {
                    return false;
                }
                BasicLikeTable tgt = basicLikeTable;
                t$iv = op1;
                OperationType t$iv2 = BaseDropGenerator.Companion.getDROP();
                boolean $i$f$element2 = false;
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$this$element$iv), (Object)t$iv2)) {
                    BasicElement basicElement4 = ScenarioOperations.element((Operation)$this$element$iv);
                    if (!(basicElement4 instanceof BasicForeignKey)) {
                        basicElement4 = null;
                    }
                    basicElement = (BasicElement)((BasicForeignKey)basicElement4);
                } else {
                    basicElement = null;
                }
                BasicForeignKey basicForeignKey = (BasicForeignKey)basicElement;
                if (basicForeignKey == null) {
                    return false;
                }
                BasicForeignKey fk = basicForeignKey;
                if (Intrinsics.areEqual((Object)fk.getRefTable(), (Object)tgt) ^ true) {
                    return false;
                }
                Object object = parent2;
                if (object == null || (object = (Operation)object.invoke((Object)fk)) == null) {
                    object = root2;
                }
                Object newParent = object;
                if (Intrinsics.areEqual((Object)((Operation)op1.getParent()), newParent) ^ true) {
                    op1.setParent((Node)newParent);
                } else if (Intrinsics.areEqual((Object)((Operation)op1.getParent()), (Object)((Operation)op2.getParent())) ^ true) {
                    op1.setParent(op2.getParent());
                } else {
                    return false;
                }
                return true;
            }

            public boolean isBackward() {
                return true;
            }
        };
        DROP_FIXERS = CollectionsKt.listOf((Object)DROP_FK_FIXER);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003*\u0001\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/base/generator/BaseDropGenerator$Companion;", "", "()V", "DROP", "Lcom/intellij/database/dialects/base/generator/OperationType;", "getDROP", "()Lcom/intellij/database/dialects/base/generator/OperationType;", "DROP_FIXERS", "", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$EdgeFixer;", "getDROP_FIXERS$intellij_database_dialects_base_core", "()Ljava/util/List;", "DROP_FK_FIXER", "com/intellij/database/dialects/base/generator/BaseDropGenerator$Companion$DROP_FK_FIXER$1", "Lcom/intellij/database/dialects/base/generator/BaseDropGenerator$Companion$DROP_FK_FIXER$1;", "intellij.database.dialects.base.core"})
    public static final class Companion {
        @NotNull
        public final OperationType getDROP() {
            return DROP;
        }

        @NotNull
        public final List<AbstractCodeGenerator.EdgeFixer> getDROP_FIXERS$intellij_database_dialects_base_core() {
            return DROP_FIXERS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

