/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.DbmsOutputHelper;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "sessionIfSupported", "Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSessionIfSupported", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/database/console/session/DatabaseSession;", "isSelected", "", "e", "setSelected", "", "state", "update", "Companion", "MyDataAuditor", "intellij.database.dialects.base"})
public final class ProcessDbmsOutputAction
extends ToggleAction {
    private static final Key<MyDataAuditor> DBMS_LISTENER;
    @NotNull
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DatabaseSession session = this.getSessionIfSupported(e2);
        Presentation presentation = e2.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(session != null);
        if (session != null) {
            super.update(e2);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DatabaseSession databaseSession = this.getSessionIfSupported(e2);
        return (databaseSession != null ? (MyDataAuditor)((Object)databaseSession.getUserData(DBMS_LISTENER)) : null) != null;
    }

    public void setSelected(@NotNull AnActionEvent e2, boolean state2) {
        block2: {
            DatabaseSession session;
            block1: {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                DatabaseSession databaseSession = this.getSessionIfSupported(e2);
                if (databaseSession == null) {
                    return;
                }
                session = databaseSession;
                if (!state2) break block1;
                MyDataAuditor listener = new MyDataAuditor(session);
                Disposer.register((Disposable)((Disposable)session), (Disposable)listener);
                session.getMessageBus().addAuditor((DataAuditor)listener);
                session.putUserData(DBMS_LISTENER, (Object)listener);
                break block2;
            }
            MyDataAuditor myDataAuditor = (MyDataAuditor)((Object)session.getUserData(DBMS_LISTENER));
            if (myDataAuditor == null) break block2;
            MyDataAuditor myDataAuditor2 = myDataAuditor;
            boolean bl = false;
            boolean bl2 = false;
            MyDataAuditor listener = myDataAuditor2;
            boolean bl3 = false;
            session.putUserData(DBMS_LISTENER, null);
            Disposer.dispose((Disposable)listener);
        }
    }

    private final DatabaseSession getSessionIfSupported(AnActionEvent $this$sessionIfSupported) {
        Object object;
        DatabaseSession databaseSession = DatabaseSessionManager.findSession((AnActionEvent)$this$sessionIfSupported);
        if (databaseSession != null) {
            DatabaseSession databaseSession2 = databaseSession;
            boolean bl = false;
            boolean bl2 = false;
            DatabaseSession it = databaseSession2;
            boolean bl3 = false;
            LocalDataSource localDataSource = (LocalDataSource)it.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"it.target");
            Dbms dbms = localDataSource.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"it.target.dbms");
            Dbms dbms2 = dbms;
            object = dbms2.isOracle() || Intrinsics.areEqual((Object)dbms2, (Object)Dbms.DB2_LUW) ? databaseSession2 : null;
        } else {
            object = null;
        }
        return object;
    }

    static {
        Companion = new Companion(null);
        Key key2 = Key.create((String)"DBMS_LISTENER");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<MyDataAuditor>(\"DBMS_LISTENER\")");
        DBMS_LISTENER = key2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0082\bJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor;", "Lcom/intellij/database/datagrid/DataAuditors$Adapter;", "Lcom/intellij/openapi/Disposable;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "(Lcom/intellij/database/console/session/DatabaseSession;)V", "helper", "Lcom/intellij/database/dialects/base/DbmsOutputHelper;", "beforeStatement", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "dispose", "handle", "call", "Lkotlin/Function0;", "requestFinished", "intellij.database.dialects.base"})
    private static final class MyDataAuditor
    extends DataAuditors.Adapter
    implements Disposable {
        private final DbmsOutputHelper helper;
        private final DatabaseSession session;

        private final void handle(DataRequest.Context context, Function0<Unit> call2) {
            int $i$f$handle = 0;
            try {
                call2.invoke();
            }
            catch (Exception e2) {
                context.reportException((Throwable)e2, null);
            }
        }

        public void beforeStatement(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            DatabaseConnection databaseConnection = Companion.getConnection(context);
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection connection = databaseConnection;
            MyDataAuditor this_$iv = this;
            boolean $i$f$handle = false;
            try {
                boolean bl = false;
                DbmsOutputHelper.enable$default(this.helper, connection, 0, 2, null);
            }
            catch (Exception e$iv) {
                context.reportException((Throwable)e$iv, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestFinished(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            DatabaseConnection databaseConnection = Companion.getConnection(context);
            if (databaseConnection == null) {
                return;
            }
            DatabaseConnection connection = databaseConnection;
            try {
                this.helper.processOutput(connection, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, context){
                    final /* synthetic */ MyDataAuditor this$0;
                    final /* synthetic */ DataRequest.Context $context;

                    public final void invoke(@NotNull String line) {
                        block3: {
                            DataRequest.Owner owner;
                            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                            LogView logView = DatabaseSessionViewService.Companion.getInstance().getViewIfAny((VisibleSession)MyDataAuditor.access$getSession$p(this.this$0));
                            if (logView != null && (logView = logView.getHistoryLogger()) != null) {
                                logView.warn(this.$context, line);
                            }
                            if (!((owner = this.$context.request.owner) instanceof DatabaseSessionClientWithFile)) {
                                owner = null;
                            }
                            DatabaseSessionClientWithFile databaseSessionClientWithFile = (DatabaseSessionClientWithFile)owner;
                            if (databaseSessionClientWithFile == null) break block3;
                            DatabaseSessionClientWithFile databaseSessionClientWithFile2 = databaseSessionClientWithFile;
                            boolean bl = false;
                            boolean bl2 = false;
                            DatabaseSessionClientWithFile owner2 = databaseSessionClientWithFile2;
                            boolean bl3 = false;
                            LogView logView2 = DatabaseSessionViewService.Companion.getInstance().getClientViewIfAny(owner2);
                            if (logView2 != null && (logView2 = logView2.getHistoryLogger()) != null) {
                                logView2.warn(this.$context, line);
                            }
                        }
                    }
                    {
                        this.this$0 = myDataAuditor;
                        this.$context = context;
                        super(1);
                    }
                }));
            }
            catch (SQLException this_$iv) {
            }
            catch (Exception e2) {
                context.reportException((Throwable)e2, null);
            }
            finally {
                MyDataAuditor this_$iv = this;
                boolean $i$f$handle = false;
                try {
                    boolean bl = false;
                    this.helper.disable(connection);
                }
                catch (Exception e$iv) {
                    context.reportException((Throwable)e$iv, null);
                }
            }
        }

        public void dispose() {
        }

        public MyDataAuditor(@NotNull DatabaseSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
            LocalDataSource localDataSource = (LocalDataSource)this.session.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"session.target");
            Dbms dbms = localDataSource.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"session.target.dbms");
            this.helper = new DbmsOutputHelper(dbms);
        }

        public static final /* synthetic */ DatabaseSession access$getSession$p(MyDataAuditor $this) {
            return $this.session;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$Companion;", "", "()V", "DBMS_LISTENER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/dialects/base/ProcessDbmsOutputAction$MyDataAuditor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/database/datagrid/DataRequest$Context;", "getConnection", "(Lcom/intellij/database/datagrid/DataRequest$Context;)Lcom/intellij/database/dataSource/DatabaseConnection;", "intellij.database.dialects.base"})
    public static final class Companion {
        @Nullable
        public final DatabaseConnection getConnection(@NotNull DataRequest.Context $this$connection) {
            Intrinsics.checkNotNullParameter((Object)$this$connection, (String)"$this$connection");
            DataProducer dataProducer = $this$connection.producer;
            if (!(dataProducer instanceof JdbcEngine)) {
                dataProducer = null;
            }
            JdbcEngine jdbcEngine = (JdbcEngine)dataProducer;
            return jdbcEngine != null ? jdbcEngine.getCurrentConnectionIfValid() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

