/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.LimitPlace;
import com.intellij.database.dialects.base.generator.dml.BaseColumnsOrderByGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseDeleteRowsGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseInsertRowsGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseMultiInsertRowsGenerator;
import com.intellij.database.dialects.base.generator.dml.BasePredicatesWhereClauseGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseQueryColumnsGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseSelectGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseUpdateRowGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseValuesWhereClauseGenerator;
import com.intellij.database.dialects.base.generator.dml.BaseWrapInSelectGenerator;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.generator.dml.ColumnsOrderByTask;
import com.intellij.database.script.generator.dml.DeleteRowsTask;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.InsertRowsTask;
import com.intellij.database.script.generator.dml.MultiInsertRowsTask;
import com.intellij.database.script.generator.dml.PredicatesWhereClauseTask;
import com.intellij.database.script.generator.dml.QueryColumnsTask;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.UpdateRowTask;
import com.intellij.database.script.generator.dml.ValuesWhereClauseTask;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0016J0\u0010 \u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u000eH\u0016J\u001e\u0010'\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020$J \u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u00101\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0018\u00102\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00103\u001a\u00020$H\u0004J!\u00104\u001a\u0002H5\"\u0004\b\u0000\u001052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H507H\u0016\u00a2\u0006\u0002\u00108J0\u00109\u001a\u0016\u0012\u0004\u0012\u0002H5\u0012\n\u0012\b\u0012\u0004\u0012\u0002H507\u0018\u00010:\"\u0004\b\u0000\u001052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H507H\u0014J\b\u0010;\u001a\u00020<H\u0016J\u001a\u0010=\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u001e2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0012\u0010@\u001a\u00020\u000e2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J \u0010C\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00103\u001a\u00020$2\u0006\u0010&\u001a\u00020\u000eH\u0004J \u0010D\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\n\u00a8\u0006F"}, d2={"Lcom/intellij/database/dialects/base/BaseDmlHelper;", "Lcom/intellij/database/script/generator/dml/DmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "emptyFilterText", "", "getEmptyFilterText", "()Ljava/lang/String;", "emptySortingText", "getEmptySortingText", "hideRowId", "", "getHideRowId", "()Z", "needAliasInDeleteStatement", "getNeedAliasInDeleteStatement", "orderByPrefix", "getOrderByPrefix", "supportsInsertDefaultValues", "getSupportsInsertDefaultValues", "wherePrefix", "getWherePrefix", "appendFromTable", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "dasTable", "Lcom/intellij/database/model/DasTable;", "alias", "appendLimit", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "appendNumericProperty", "property", "value", "appendPlaceholderForInsert", "d", "Lcom/intellij/database/datagrid/AutoValueDescriptor;", "table", "appendPlaceholderForUpdate", "data", "Lcom/intellij/database/datagrid/mutating/ColumnQueryData;", "appendRowId", "fetchFirst", "rows", "generate", "OUT", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "(Lcom/intellij/database/script/generator/dml/DmlTask;)Ljava/lang/Object;", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/LimitPlace;", "hasRowId", "version", "Lcom/intellij/database/util/Version;", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "rowNumLimit", "top", "topWord", "intellij.database.dialects.base.core"})
public class BaseDmlHelper
implements DmlHelper {
    @NotNull
    private final String emptyFilterText;
    @NotNull
    private final String wherePrefix;
    @NotNull
    private final String emptySortingText;
    @NotNull
    private final String orderByPrefix;
    private final boolean supportsInsertDefaultValues;
    private final boolean needAliasInDeleteStatement;
    private final boolean hideRowId;
    @NotNull
    private final Dbms dbms;

    @NotNull
    public String getEmptyFilterText() {
        return this.emptyFilterText;
    }

    @NotNull
    public String getWherePrefix() {
        return this.wherePrefix;
    }

    @NotNull
    public String getEmptySortingText() {
        return this.emptySortingText;
    }

    @NotNull
    public String getOrderByPrefix() {
        return this.orderByPrefix;
    }

    public boolean getSupportsInsertDefaultValues() {
        return this.supportsInsertDefaultValues;
    }

    public boolean getNeedAliasInDeleteStatement() {
        return this.needAliasInDeleteStatement;
    }

    public boolean getHideRowId() {
        return this.hideRowId;
    }

    public <OUT> OUT generate(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlGenerator<OUT, DmlTask<OUT>> dmlGenerator = this.getGenerator(task);
        if (dmlGenerator == null) {
            throw (Throwable)new UnsupportedOperationException("Task is not supported " + task);
        }
        DmlGenerator<OUT, DmlTask<OUT>> generator = dmlGenerator;
        return generator.generate();
    }

    @Nullable
    protected <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(@NotNull DmlTask<? extends OUT> task) {
        DmlGenerator dmlGenerator;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlTask<? extends OUT> dmlTask = task;
        if (!((dmlTask instanceof DeleteRowsTask ? (DmlGenerator)new BaseDeleteRowsGenerator((DeleteRowsTask)task, this.dbms) : (dmlTask instanceof ValuesWhereClauseTask ? (DmlGenerator)new BaseValuesWhereClauseGenerator((ValuesWhereClauseTask)task, this.dbms) : (dmlTask instanceof PredicatesWhereClauseTask ? (DmlGenerator)new BasePredicatesWhereClauseGenerator((PredicatesWhereClauseTask)task, this.dbms) : (dmlTask instanceof ColumnsOrderByTask ? (DmlGenerator)new BaseColumnsOrderByGenerator((ColumnsOrderByTask)task, this.dbms) : (dmlTask instanceof InsertRowsTask ? (DmlGenerator)new BaseInsertRowsGenerator((InsertRowsTask)task, this.dbms) : (dmlTask instanceof WrapInSelectTask ? (DmlGenerator)new BaseWrapInSelectGenerator((WrapInSelectTask)task, this.dbms) : (dmlTask instanceof QueryColumnsTask ? (DmlGenerator)new BaseQueryColumnsGenerator((QueryColumnsTask)task, this.dbms) : (dmlTask instanceof SelectTask ? (DmlGenerator)new BaseSelectGenerator((SelectTask)task, this.dbms, this) : (dmlTask instanceof MultiInsertRowsTask ? (DmlGenerator)new BaseMultiInsertRowsGenerator((MultiInsertRowsTask)task, this.dbms) : (dmlGenerator = dmlTask instanceof UpdateRowTask ? (DmlGenerator)new BaseUpdateRowGenerator((UpdateRowTask)task, this.dbms) : null)))))))))) instanceof DmlGenerator)) {
            dmlGenerator = null;
        }
        return dmlGenerator;
    }

    @NotNull
    public LimitPlace getPlaceForLimit() {
        return LimitPlace.END;
    }

    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return builder;
    }

    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return false;
    }

    public void appendFromTable(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dasTable, (String)"dasTable");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        builder.keyword("FROM").space().qualifiedRef((DasObject)dasTable).space().alias(alias);
    }

    @NotNull
    public DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        DdlBuilder b = builder;
        if (!DbImplUtilCore.isPageSizeUnlimited((int)limit)) {
            b = this.appendNumericProperty(builder, "LIMIT", limit);
        }
        if (offset != 0 && DbImplUtilCore.supportsOffset((Dbms)this.dbms)) {
            b = this.appendNumericProperty(builder, "OFFSET", offset);
        }
        return b;
    }

    @NotNull
    protected final DdlBuilder top(@NotNull DdlBuilder builder, @NotNull String topWord, int limit) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)topWord, (String)"topWord");
        DdlBuilder ddlBuilder = builder.keyword(topWord).space().literal(String.valueOf(limit)).space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.keyword(topWord)\u2026limit.toString()).space()");
        return ddlBuilder;
    }

    @NotNull
    public final DdlBuilder appendNumericProperty(@NotNull DdlBuilder builder, @NotNull String property, int value) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        DdlBuilder ddlBuilder = builder.newLine().keyword(property).space().literal(String.valueOf(value));
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.newLine().keywor\u2026literal(value.toString())");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder fetchFirst(@NotNull DdlBuilder builder, int rows) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.newLine().keywords(new String[]{"FETCH", "FIRST"}).space().literal(String.valueOf(rows)).space().keywords(new String[]{"ROWS", "ONLY"});
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder.newLine().keywor\u2026.keywords(\"ROWS\", \"ONLY\")");
        return ddlBuilder;
    }

    @NotNull
    protected final DdlBuilder rowNumLimit(@NotNull DdlBuilder builder, int rows, boolean atBeginning) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (atBeginning) {
            DdlBuilder ddlBuilder2 = builder.keyword("SELECT").space().symbol("*").space().keyword("FROM").space().symbol("(").indent("    ").newLine();
            ddlBuilder = ddlBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"builder.keyword(\"SELECT\"\u2026.indent(\"    \").newLine()");
        } else {
            DdlBuilder ddlBuilder3 = builder.indent(null).newLine().symbol(")").space().keyword("WHERE").space().keyword("ROWNUM").space().symbol("<=").space().literal(String.valueOf(rows));
            ddlBuilder = ddlBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder3, (String)"builder.indent(null).new\u2026.literal(rows.toString())");
        }
        return ddlBuilder;
    }

    public boolean isEditableTable(@Nullable ObjectKind kind) {
        ObjectKind objectKind = kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIRTUAL_TABLE) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE);
    }

    public void appendPlaceholderForInsert(@NotNull AutoValueDescriptor d, @NotNull DasTable table, @NotNull DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (d.isAutogenerated() || d.hasDefault()) {
            builder.plain("DEFAULT");
        } else {
            builder.placeholder();
        }
    }

    public boolean appendPlaceholderForUpdate(@NotNull ColumnQueryData data, @NotNull DasTable table, @NotNull DdlBuilder builder) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Object value = data.getObject();
        if (value == ReservedCellValue.DEFAULT) {
            builder.keyword("DEFAULT");
            bl = false;
        } else if (JdbcEngineUtils.shouldValueBeInlined((Object)value, (String)data.getColumn().typeName, (Dbms)this.dbms)) {
            builder.plain(String.valueOf(value));
            bl = false;
        } else {
            builder.placeholder();
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    public BaseDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.emptyFilterText = "";
        this.wherePrefix = "WHERE";
        this.emptySortingText = "";
        this.orderByPrefix = "ORDER BY";
        this.hideRowId = true;
    }
}

