/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.types;

import io.kinference.onnx.TensorProto;
import io.kinference.onnx.TypeProto;
import io.kinference.onnx.ValueInfoProto;
import io.kinference.types.SequenceInfo;
import io.kinference.types.TensorInfo;
import io.kinference.types.TensorShape;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lio/kinference/types/ValueInfo;", "", "name", "", "type", "Lio/kinference/onnx/TensorProto$DataType;", "(Ljava/lang/String;Lio/kinference/onnx/TensorProto$DataType;)V", "getName", "()Ljava/lang/String;", "getType", "()Lio/kinference/onnx/TensorProto$DataType;", "Companion", "inference"})
public abstract class ValueInfo {
    @NotNull
    private final String name;
    @NotNull
    private final TensorProto.DataType type;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final TensorProto.DataType getType() {
        return this.type;
    }

    public ValueInfo(@NotNull String name, @NotNull TensorProto.DataType type) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.name = name;
        this.type = type;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/kinference/types/ValueInfo$Companion;", "", "()V", "create", "Lio/kinference/types/ValueInfo;", "proto", "Lio/kinference/onnx/ValueInfoProto;", "inference"})
    public static final class Companion {
        @NotNull
        public final ValueInfo create(@NotNull ValueInfoProto proto) {
            ValueInfo valueInfo;
            Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
            TypeProto typeProto = proto.getType();
            if (typeProto == null) {
                Intrinsics.throwNpe();
            }
            TypeProto type = typeProto;
            if (type.getTensor_type() != null) {
                Integer n = type.getTensor_type().getElem_type();
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                TensorProto.DataType dataType = TensorProto.DataType.Companion.fromValue(n);
                if (dataType == null) {
                    Intrinsics.throwNpe();
                }
                TensorProto.DataType dataType2 = dataType;
                TensorShape shape = type.getTensor_type().getShape() == null ? TensorShape.Companion.empty() : TensorShape.Companion.invoke(type.getTensor_type().getShape());
                String string = proto.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                valueInfo = new TensorInfo(string, dataType2, shape);
            } else if (type.getSequence_type() != null) {
                TypeProto typeProto2 = type.getSequence_type().getElem_type();
                if (typeProto2 == null) {
                    Intrinsics.throwNpe();
                }
                TypeProto.Tensor tensor = typeProto2.getTensor_type();
                if (tensor == null) {
                    Intrinsics.throwNpe();
                }
                TypeProto.Tensor tensorTypes = tensor;
                String string = proto.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Integer n = tensorTypes.getElem_type();
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                TensorProto.DataType dataType = TensorProto.DataType.Companion.fromValue(n);
                if (dataType == null) {
                    Intrinsics.throwNpe();
                }
                valueInfo = new SequenceInfo(string, dataType);
            } else {
                if (type.getMap_type() != null) {
                    String string = "Maps are not supported";
                    boolean bl = false;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                }
                String string = "Unsupported data type";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return valueInfo;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

