/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.types;

import io.kinference.onnx.TensorProto;
import io.kinference.onnx.TensorShapeProto;
import io.kinference.onnx.TypeProto;
import io.kinference.types.TensorShape;
import io.kinference.types.ValueTypeInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/kinference/types/TensorTypeInfo;", "Lio/kinference/types/ValueTypeInfo;", "proto", "Lio/kinference/onnx/TypeProto$Tensor;", "(Lio/kinference/onnx/TypeProto$Tensor;)V", "shape", "Lio/kinference/types/TensorShape;", "type", "Lio/kinference/onnx/TensorProto$DataType;", "(Lio/kinference/types/TensorShape;Lio/kinference/onnx/TensorProto$DataType;)V", "getShape", "()Lio/kinference/types/TensorShape;", "inference"})
public final class TensorTypeInfo
extends ValueTypeInfo {
    @NotNull
    private final TensorShape shape;

    @NotNull
    public final TensorShape getShape() {
        return this.shape;
    }

    public TensorTypeInfo(@NotNull TensorShape shape, @NotNull TensorProto.DataType type) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        super(type);
        this.shape = shape;
    }

    public TensorTypeInfo(@NotNull TypeProto.Tensor proto) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
        TensorShapeProto tensorShapeProto = proto.getShape();
        if (tensorShapeProto == null) {
            Intrinsics.throwNpe();
        }
        TensorShape tensorShape = TensorShape.Companion.invoke(tensorShapeProto);
        Integer n = proto.getElem_type();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        TensorProto.DataType dataType = TensorProto.DataType.Companion.fromValue(n);
        if (dataType == null) {
            Intrinsics.throwNpe();
        }
        this(tensorShape, dataType);
    }
}

