/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.operators.math;

import io.kinference.attributes.Attribute;
import io.kinference.data.tensors.Tensor;
import io.kinference.data.tensors.TensorExtensionsKt;
import io.kinference.graph.Context;
import io.kinference.ndarray.Strides;
import io.kinference.ndarray.arrays.ByteNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.UByteNDArray;
import io.kinference.ndarray.arrays.pointers.BytePointer;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.pointers.UBytePointer;
import io.kinference.ndarray.arrays.tiled.ByteTiledArray;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.ndarray.arrays.tiled.UByteTiledArray;
import io.kinference.ndarray.extensions.MatrixKt;
import io.kinference.onnx.TensorProto;
import io.kinference.operators.IOInfo;
import io.kinference.operators.Operator;
import io.kinference.operators.OperatorInfo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.UByteArray;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB;\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\u000bJ(\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lio/kinference/operators/math/MatMulInteger;", "Lio/kinference/operators/Operator;", "Lio/kinference/data/tensors/Tensor;", "attributes", "", "", "Lio/kinference/attributes/Attribute;", "", "inputs", "", "outputs", "(Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "apply", "context", "Lio/kinference/graph/Context;", "Companion", "inference"})
public final class MatMulInteger
extends Operator<Tensor, Tensor> {
    private static final Set<TensorProto.DataType> IN_TYPE_CONSTRAINTS;
    private static final Set<TensorProto.DataType> OUT_TYPE_CONSTRAINTS;
    private static final List<IOInfo> INPUTS_INFO;
    private static final List<IOInfo> OUTPUTS_INFO;
    private static final OperatorInfo INFO;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<Tensor> apply(@NotNull Context context, @NotNull List<Tensor> inputs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Tensor tensor = inputs.get(0);
        if (tensor == null) {
            Intrinsics.throwNpe();
        }
        NDArray nDArray = tensor.getData();
        if (nDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArray");
        }
        NumberNDArray first = (NumberNDArray)nDArray;
        Tensor tensor2 = inputs.get(1);
        if (tensor2 == null) {
            Intrinsics.throwNpe();
        }
        NDArray nDArray2 = tensor2.getData();
        if (nDArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArray");
        }
        NumberNDArray second = (NumberNDArray)nDArray2;
        Tensor tensor3 = (Tensor)CollectionsKt.getOrNull(inputs, (int)2);
        Object object = tensor3 != null ? tensor3.getData() : null;
        if (!(object instanceof NumberNDArray)) {
            object = null;
        }
        NumberNDArray firstZero = (NumberNDArray)object;
        Tensor tensor4 = (Tensor)CollectionsKt.getOrNull(inputs, (int)3);
        Object object2 = tensor4 != null ? tensor4.getData() : null;
        if (!(object2 instanceof NumberNDArray)) {
            object2 = null;
        }
        NumberNDArray secondZero = (NumberNDArray)object2;
        IntNDArray firstBiased = firstZero == null ? MatMulInteger.Companion.toIntNDArray(first) : first.withZeroPoint(firstZero);
        IntNDArray secondBiased = secondZero == null ? MatMulInteger.Companion.toIntNDArray(second) : second.withZeroPoint(secondZero);
        return CollectionsKt.listOf((Object)TensorExtensionsKt.asTensor((NDArray)MatrixKt.matmul((NumberNDArray)((NumberNDArray)firstBiased), (NumberNDArray)((NumberNDArray)secondBiased)), "y"));
    }

    public MatMulInteger(@NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
        super(INFO, attributes, inputs, outputs);
    }

    static {
        Companion = new Companion(null);
        IN_TYPE_CONSTRAINTS = SetsKt.setOf((Object[])new TensorProto.DataType[]{TensorProto.DataType.UINT8, TensorProto.DataType.INT8});
        OUT_TYPE_CONSTRAINTS = SetsKt.setOf((Object)((Object)TensorProto.DataType.INT32));
        INPUTS_INFO = CollectionsKt.listOf((Object[])new IOInfo[]{new IOInfo(0, IN_TYPE_CONSTRAINTS, "A", false, null, false, null, 0, 240, null), new IOInfo(1, IN_TYPE_CONSTRAINTS, "B", false, null, false, null, 0, 240, null), new IOInfo(2, IN_TYPE_CONSTRAINTS, "a_zero_point", true, null, false, null, 0, 240, null), new IOInfo(3, IN_TYPE_CONSTRAINTS, "b_zero_point", true, null, false, null, 0, 240, null)});
        OUTPUTS_INFO = CollectionsKt.listOf((Object)new IOInfo(0, OUT_TYPE_CONSTRAINTS, "Y", false, null, false, null, 0, 240, null));
        INFO = new OperatorInfo("MatMulInteger", MapsKt.emptyMap(), INPUTS_INFO, OUTPUTS_INFO);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/kinference/operators/math/MatMulInteger$Companion;", "", "()V", "INFO", "Lio/kinference/operators/OperatorInfo;", "INPUTS_INFO", "", "Lio/kinference/operators/IOInfo;", "IN_TYPE_CONSTRAINTS", "", "Lio/kinference/onnx/TensorProto$DataType;", "OUTPUTS_INFO", "OUT_TYPE_CONSTRAINTS", "toIntNDArray", "Lio/kinference/ndarray/arrays/IntNDArray;", "Lio/kinference/ndarray/arrays/NumberNDArray;", "inference"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final IntNDArray toIntNDArray(@NotNull NumberNDArray $this$toIntNDArray) {
            IntNDArray result = new IntNDArray(IntTiledArray.Companion.invoke$default((IntTiledArray.Companion)IntTiledArray.Companion, (Strides)$this$toIntNDArray.getStrides(), (int)0, (int)2, null), $this$toIntNDArray.getStrides());
            NumberNDArray numberNDArray = $this$toIntNDArray;
            if (numberNDArray instanceof UByteNDArray) {
                int end$iv;
                byte[] srcBlock$iv;
                void container$iv;
                void $this$mapTo$iv;
                UBytePointer uBytePointer = UByteTiledArray.pointer$default((UByteTiledArray)((UByteNDArray)$this$toIntNDArray).getArray(), (int)0, (int)1, null);
                IntPointer intPointer = IntTiledArray.pointer$default((IntTiledArray)result.getArray(), (int)0, (int)1, null);
                int count$iv = $this$toIntNDArray.getLinearSize();
                boolean $i$f$mapTo = false;
                void $this$isCompatibleBySize$iv$iv22 = $this$mapTo$iv;
                boolean $i$f$isCompatibleBySize = false;
                boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= count$iv && container$iv.getArray().getSize() - container$iv.getLinearIndex() >= count$iv;
                $i$f$isCompatibleBySize = false;
                boolean bl = false;
                if (!$this$isCompatibleBySize$iv$iv22) {
                    boolean bl2 = false;
                    String string = "Pointers not compatible by available elements";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                void $this$isCompatibleWith$iv$iv = $this$mapTo$iv;
                boolean $i$f$isCompatibleWith = false;
                if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == container$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == container$iv.getArray().getBlockSize()) {
                    int offset$iv;
                    for (end$iv = count$iv; end$iv > 0; end$iv -= UByteArray.getSize-impl((byte[])srcBlock$iv) - offset$iv) {
                        int n;
                        srcBlock$iv = $this$mapTo$iv.getCurrentBlock();
                        offset$iv = $this$mapTo$iv.getIndexInBlock();
                        void this_$iv$iv = $this$mapTo$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            void v0 = this_$iv$iv;
                            int n2 = v0.getBlockNum();
                            v0.setBlockNum(n2 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock-GBYM_sE(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()].unbox-impl());
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        int[] dstBlock$iv = container$iv.getCurrentBlock();
                        void this_$iv$iv22 = container$iv;
                        int $i$f$blockIncrement2 = 0;
                        if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                            void v1 = this_$iv$iv22;
                            n = v1.getBlockNum();
                            v1.setBlockNum(n + 1);
                            this_$iv$iv22.setIndexInBlock(0);
                            this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                        } else {
                            this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                        }
                        int this_$iv$iv22 = offset$iv;
                        n = UByteArray.getSize-impl((byte[])srcBlock$iv);
                        int n3 = offset$iv + end$iv;
                        boolean bl3 = false;
                        $i$f$blockIncrement2 = Math.min(n, n3);
                        while (this_$iv$iv22 < $i$f$blockIncrement2) {
                            int n4;
                            void it;
                            void index$iv;
                            byte by = UByteArray.get-impl((byte[])srcBlock$iv, (int)index$iv);
                            void var25_78 = index$iv++;
                            int[] nArray = dstBlock$iv;
                            boolean bl4 = false;
                            void var19_70 = it;
                            boolean bl5 = false;
                            nArray[var25_78] = n4 = var19_70 & 0xFF;
                        }
                    }
                } else {
                    while (end$iv > 0) {
                        byte by;
                        srcBlock$iv = container$iv;
                        void this_$iv$iv = $this$mapTo$iv;
                        boolean $i$f$getAndIncrement = false;
                        byte value$iv$iv = UByteArray.get-impl((byte[])this_$iv$iv.getCurrentBlock(), (int)this_$iv$iv.getIndexInBlock());
                        void this_$iv$iv$iv3 = this_$iv$iv;
                        boolean $i$f$increment = false;
                        if (this_$iv$iv$iv3.getIndexInBlock() < this_$iv$iv$iv3.getArray().getBlockSize() - 1) {
                            void v2 = this_$iv$iv$iv3;
                            int n = v2.getIndexInBlock();
                            v2.setIndexInBlock(n + 1);
                        } else {
                            void this_$iv$iv$iv$iv = this_$iv$iv$iv3;
                            boolean $i$f$blockIncrement4 = false;
                            if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                void v3 = this_$iv$iv$iv$iv;
                                int it = v3.getBlockNum();
                                v3.setBlockNum(it + 1);
                                this_$iv$iv$iv$iv.setIndexInBlock(0);
                                this_$iv$iv$iv$iv.setCurrentBlock-GBYM_sE(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()].unbox-impl());
                            } else {
                                this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                            }
                        }
                        byte it = by = value$iv$iv;
                        boolean bl6 = false;
                        byte by2 = it;
                        boolean bl7 = false;
                        int value$iv$iv2 = by2 & 0xFF;
                        int $i$f$set = 0;
                        this_$iv$iv2.getCurrentBlock()[this_$iv$iv2.getIndexInBlock()] = value$iv$iv2;
                        void this_$iv$iv2 = container$iv;
                        boolean $i$f$increment22 = false;
                        if (this_$iv$iv2.getIndexInBlock() < this_$iv$iv2.getArray().getBlockSize() - 1) {
                            void v4 = this_$iv$iv2;
                            $i$f$set = v4.getIndexInBlock();
                            v4.setIndexInBlock($i$f$set + 1);
                        } else {
                            void this_$iv$iv$iv2 = this_$iv$iv2;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                                void v5 = this_$iv$iv$iv2;
                                int this_$iv$iv$iv3 = v5.getBlockNum();
                                v5.setBlockNum(this_$iv$iv$iv3 + 1);
                                this_$iv$iv$iv2.setIndexInBlock(0);
                                this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                            }
                        }
                        --end$iv;
                    }
                }
            } else if (numberNDArray instanceof ByteNDArray) {
                int end$iv;
                Object srcBlock$iv;
                BytePointer $this$mapTo$iv = ByteTiledArray.pointer$default((ByteTiledArray)((ByteNDArray)$this$toIntNDArray).getArray(), (int)0, (int)1, null);
                IntPointer container$iv = IntTiledArray.pointer$default((IntTiledArray)result.getArray(), (int)0, (int)1, null);
                int count$iv = $this$toIntNDArray.getLinearSize();
                boolean $i$f$mapTo = false;
                BytePointer $this$isCompatibleBySize$iv$iv32 = $this$mapTo$iv;
                boolean $i$f$isCompatibleBySize = false;
                boolean $this$isCompatibleBySize$iv$iv32 = $this$isCompatibleBySize$iv$iv32.getArray().getSize() - $this$isCompatibleBySize$iv$iv32.getLinearIndex() >= count$iv && container$iv.getArray().getSize() - container$iv.getLinearIndex() >= count$iv;
                $i$f$isCompatibleBySize = false;
                boolean $i$f$increment22 = false;
                if (!$this$isCompatibleBySize$iv$iv32) {
                    boolean bl = false;
                    String $i$f$increment22 = "Pointers not compatible by available elements";
                    throw (Throwable)new IllegalArgumentException($i$f$increment22.toString());
                }
                BytePointer $this$isCompatibleWith$iv$iv = $this$mapTo$iv;
                boolean $i$f$isCompatibleWith = false;
                if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == container$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == container$iv.getArray().getBlockSize()) {
                    int offset$iv;
                    for (end$iv = count$iv; end$iv > 0; end$iv -= ((IntPointer)srcBlock$iv).length - offset$iv) {
                        int $i$f$increment;
                        srcBlock$iv = $this$mapTo$iv.getCurrentBlock();
                        offset$iv = $this$mapTo$iv.getIndexInBlock();
                        BytePointer this_$iv$iv = $this$mapTo$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            BytePointer bytePointer = this_$iv$iv;
                            int this_$iv$iv$iv3 = bytePointer.getBlockNum();
                            bytePointer.setBlockNum(this_$iv$iv$iv3 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        int[] dstBlock$iv = container$iv.getCurrentBlock();
                        IntPointer this_$iv$iv32 = container$iv;
                        int $i$f$blockIncrement3 = 0;
                        if (this_$iv$iv32.getBlockNum() < this_$iv$iv32.getArray().getBlocksNum() - 1) {
                            IntPointer intPointer = this_$iv$iv32;
                            $i$f$increment = intPointer.getBlockNum();
                            intPointer.setBlockNum($i$f$increment + 1);
                            this_$iv$iv32.setIndexInBlock(0);
                            this_$iv$iv32.setCurrentBlock(this_$iv$iv32.getArray().getBlocks()[this_$iv$iv32.getBlockNum()]);
                        } else {
                            this_$iv$iv32.setIndexInBlock(this_$iv$iv32.getArray().getBlockSize());
                        }
                        int this_$iv$iv32 = offset$iv;
                        $i$f$increment = ((IntPointer)srcBlock$iv).length;
                        int this_$iv$iv$iv$iv = offset$iv + end$iv;
                        boolean $i$f$blockIncrement4 = false;
                        $i$f$blockIncrement3 = Math.min($i$f$increment, this_$iv$iv$iv$iv);
                        while (this_$iv$iv32 < $i$f$blockIncrement3) {
                            void index$iv;
                            IntPointer it = srcBlock$iv[index$iv];
                            void var25_79 = index$iv++;
                            int[] nArray = dstBlock$iv;
                            boolean bl = false;
                            IntPointer intPointer = it;
                            nArray[var25_79] = (int)intPointer;
                        }
                    }
                } else {
                    while (end$iv > 0) {
                        int n;
                        srcBlock$iv = container$iv;
                        BytePointer this_$iv$iv = $this$mapTo$iv;
                        boolean $i$f$getAndIncrement = false;
                        int value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                        BytePointer this_$iv$iv$iv = this_$iv$iv;
                        boolean $i$f$increment = false;
                        if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                            BytePointer bytePointer = this_$iv$iv$iv;
                            int this_$iv$iv$iv$iv = bytePointer.getIndexInBlock();
                            bytePointer.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                        } else {
                            BytePointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                BytePointer bytePointer = this_$iv$iv$iv$iv;
                                int n5 = bytePointer.getBlockNum();
                                bytePointer.setBlockNum(n5 + 1);
                                this_$iv$iv$iv$iv.setIndexInBlock(0);
                                this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                            }
                        }
                        int it = n = value$iv$iv;
                        boolean bl = false;
                        int value$iv$iv3 = it;
                        int $i$f$set = 0;
                        this_$iv$iv3.getCurrentBlock()[this_$iv$iv3.getIndexInBlock()] = value$iv$iv3;
                        IntPointer this_$iv$iv3 = container$iv;
                        $i$f$increment22 = false;
                        if (this_$iv$iv3.getIndexInBlock() < this_$iv$iv3.getArray().getBlockSize() - 1) {
                            IntPointer intPointer = this_$iv$iv3;
                            $i$f$set = intPointer.getIndexInBlock();
                            intPointer.setIndexInBlock($i$f$set + 1);
                        } else {
                            IntPointer this_$iv$iv$iv4 = this_$iv$iv3;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv4.getBlockNum() < this_$iv$iv$iv4.getArray().getBlocksNum() - 1) {
                                IntPointer intPointer = this_$iv$iv$iv4;
                                int n6 = intPointer.getBlockNum();
                                intPointer.setBlockNum(n6 + 1);
                                this_$iv$iv$iv4.setIndexInBlock(0);
                                this_$iv$iv$iv4.setCurrentBlock(this_$iv$iv$iv4.getArray().getBlocks()[this_$iv$iv$iv4.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv4.setIndexInBlock(this_$iv$iv$iv4.getArray().getBlockSize());
                            }
                        }
                        --end$iv;
                    }
                }
            } else {
                String string = "Unsupported data type: " + $this$toIntNDArray.getType();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

