/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.operators.math;

import io.kinference.attributes.Attribute;
import io.kinference.data.tensors.Tensor;
import io.kinference.data.tensors.TensorExtensionsKt;
import io.kinference.graph.Context;
import io.kinference.ndarray.arrays.MutableDoubleNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.pointers.DoublePointer;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.tiled.DoubleTiledArray;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.onnx.TensorProto;
import io.kinference.operators.IOInfo;
import io.kinference.operators.Operator;
import io.kinference.operators.OperatorInfo;
import io.kinference.operators.math.Gelu$Companion$WhenMappings;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB=\u0012\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\u000bJ(\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lio/kinference/operators/math/Gelu;", "Lio/kinference/operators/Operator;", "Lio/kinference/data/tensors/Tensor;", "attributes", "", "", "Lio/kinference/attributes/Attribute;", "", "inputs", "", "outputs", "(Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "apply", "context", "Lio/kinference/graph/Context;", "Companion", "inference"})
public final class Gelu
extends Operator<Tensor, Tensor> {
    private static final Set<TensorProto.DataType> TYPE_CONSTRAINTS;
    private static final double SQRT2;
    private static final List<IOInfo> INPUTS_INFO;
    private static final List<IOInfo> OUTPUTS_INFO;
    private static final OperatorInfo INFO;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<Tensor> apply(@NotNull Context context, @NotNull List<Tensor> inputs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Tensor tensor = inputs.get(0);
        if (tensor == null) {
            Intrinsics.throwNpe();
        }
        NDArray nDArray = tensor.getData();
        if (nDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArray");
        }
        NumberNDArray input = (NumberNDArray)nDArray;
        return CollectionsKt.listOf((Object)TensorExtensionsKt.asTensor((NDArray)Companion.gelu((MutableNumberNDArray)NDArray.DefaultImpls.toMutable$default((NDArray)input, null, (int)1, null)), "Y"));
    }

    public Gelu(@NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
        super(INFO, attributes, inputs, outputs);
    }

    public /* synthetic */ Gelu(Map map, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map, list, list2);
    }

    static {
        Companion = new Companion(null);
        TYPE_CONSTRAINTS = Operator.Companion.getFLOAT_DATA_TYPES();
        double d = 2.0;
        boolean bl = false;
        SQRT2 = Math.sqrt(d);
        INPUTS_INFO = CollectionsKt.listOf((Object)new IOInfo(0, TYPE_CONSTRAINTS, "X", false, null, false, null, 0, 240, null));
        OUTPUTS_INFO = CollectionsKt.listOf((Object)new IOInfo(0, TYPE_CONSTRAINTS, "y", false, null, false, null, 0, 240, null));
        INFO = new OperatorInfo("Gelu", MapsKt.emptyMap(), INPUTS_INFO, OUTPUTS_INFO);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/kinference/operators/math/Gelu$Companion;", "", "()V", "INFO", "Lio/kinference/operators/OperatorInfo;", "INPUTS_INFO", "", "Lio/kinference/operators/IOInfo;", "OUTPUTS_INFO", "SQRT2", "", "TYPE_CONSTRAINTS", "", "Lio/kinference/onnx/TensorProto$DataType;", "gelu", "Lio/kinference/ndarray/arrays/NumberNDArray;", "array", "Lio/kinference/ndarray/arrays/MutableNumberNDArray;", "inference"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NumberNDArray gelu(@NotNull MutableNumberNDArray array) {
            Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
            switch (Gelu$Companion$WhenMappings.$EnumSwitchMapping$0[array.getType().ordinal()]) {
                case 1: {
                    int offset$iv;
                    float[] block$iv;
                    FloatPointer pointer;
                    MutableFloatNDArray cfr_ignored_0 = (MutableFloatNDArray)array;
                    FloatPointer floatPointer = pointer = FloatTiledArray.pointer$default((FloatTiledArray)((MutableFloatNDArray)array).getArray(), (int)0, (int)1, null);
                    int count$iv = array.getLinearSize();
                    boolean $i$f$map = false;
                    for (int end$iv = count$iv; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        int n;
                        void $this$map$iv;
                        block$iv = $this$map$iv.getCurrentBlock();
                        offset$iv = $this$map$iv.getIndexInBlock();
                        void this_$iv$iv22 = $this$map$iv;
                        int $i$f$blockIncrement = 0;
                        if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                            void v0 = this_$iv$iv22;
                            n = v0.getBlockNum();
                            v0.setBlockNum(n + 1);
                            this_$iv$iv22.setIndexInBlock(0);
                            this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                        } else {
                            this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                        }
                        int this_$iv$iv22 = offset$iv;
                        n = block$iv.length;
                        int n2 = offset$iv + end$iv;
                        boolean bl = false;
                        $i$f$blockIncrement = Math.min(n, n2);
                        while (this_$iv$iv22 < $i$f$blockIncrement) {
                            void it;
                            float f;
                            void index$iv;
                            float f2 = block$iv[index$iv];
                            void var18_33 = index$iv++;
                            float[] fArray = block$iv;
                            boolean bl2 = false;
                            fArray[var18_33] = f = 0.5f * it * (1.0f + ((MutableFloatNDArray)array).erfFor((Object)Float.valueOf((float)(it / (float)SQRT2))).floatValue());
                        }
                    }
                    break;
                }
                case 2: {
                    int offset$iv;
                    double[] block$iv;
                    DoublePointer pointer;
                    MutableDoubleNDArray cfr_ignored_1 = (MutableDoubleNDArray)array;
                    DoublePointer $this$map$iv = pointer = DoubleTiledArray.pointer$default((DoubleTiledArray)((MutableDoubleNDArray)array).getArray(), (int)0, (int)1, null);
                    int count$iv = array.getLinearSize();
                    boolean $i$f$map = false;
                    for (int end$iv = count$iv; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        int n;
                        block$iv = $this$map$iv.getCurrentBlock();
                        offset$iv = $this$map$iv.getIndexInBlock();
                        DoublePointer this_$iv$iv32 = $this$map$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv32.getBlockNum() < this_$iv$iv32.getArray().getBlocksNum() - 1) {
                            DoublePointer doublePointer = this_$iv$iv32;
                            n = doublePointer.getBlockNum();
                            doublePointer.setBlockNum(n + 1);
                            this_$iv$iv32.setIndexInBlock(0);
                            this_$iv$iv32.setCurrentBlock(this_$iv$iv32.getArray().getBlocks()[this_$iv$iv32.getBlockNum()]);
                        } else {
                            this_$iv$iv32.setIndexInBlock(this_$iv$iv32.getArray().getBlockSize());
                        }
                        int this_$iv$iv32 = offset$iv;
                        n = block$iv.length;
                        int n3 = offset$iv + end$iv;
                        boolean bl = false;
                        int n4 = Math.min(n, n3);
                        while (this_$iv$iv32 < n4) {
                            double d;
                            void index$iv;
                            double it = block$iv[index$iv];
                            void var18_34 = index$iv++;
                            double[] dArray = block$iv;
                            boolean bl3 = false;
                            dArray[var18_34] = d = 0.5 * it * (1.0 + ((MutableDoubleNDArray)array).erfFor((Object)(it / SQRT2)));
                        }
                    }
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unsupported type");
                }
            }
            return (NumberNDArray)array;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

