/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.operators.layer.recurrent.lstm;

import io.kinference.data.tensors.Tensor;
import io.kinference.data.tensors.TensorExtensionsKt;
import io.kinference.ndarray.Strides;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.PrimitiveToPrimitiveFunction;
import io.kinference.ndarray.extensions.ArrayFactoriesKt;
import io.kinference.ndarray.extensions.NDArrayExtensionsKt;
import io.kinference.ndarray.extensions.SplitKt;
import io.kinference.onnx.TensorProto;
import io.kinference.operators.activations.Activation;
import io.kinference.operators.layer.recurrent.lstm.GatesData;
import io.kinference.operators.layer.recurrent.lstm.LSTMBase;
import io.kinference.operators.layer.recurrent.lstm.LSTMData;
import io.kinference.operators.layer.recurrent.lstm.State;
import io.kinference.primitives.types.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0014JP\u0010\u001c\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%H\u0002JJ\u0010(\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0002J\u0017\u0010-\u001a\u00020#*\b\u0012\u0004\u0012\u00020#0.H\u0004\u00a2\u0006\u0002\u0010/R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/kinference/operators/layer/recurrent/lstm/LSTMLayer;", "Lio/kinference/operators/layer/recurrent/lstm/LSTMBase;", "hiddenSize", "", "activations", "", "", "direction", "(ILjava/util/List;Ljava/lang/String;)V", "lstmData", "Lio/kinference/operators/layer/recurrent/lstm/LSTMData;", "apply", "Lio/kinference/data/tensors/Tensor;", "inputs", "Lio/kinference/ndarray/arrays/NDArray;", "sequenceLens", "", "outputArray", "Lio/kinference/ndarray/arrays/MutableNDArray;", "startOffset", "parseTempInputs", "", "weights", "recurrentWeights", "bias", "initialOutput", "initialCellState", "peepholes", "step", "input", "output", "outputOffset", "gatesData", "Lio/kinference/operators/layer/recurrent/lstm/GatesData;", "lastState", "Lio/kinference/operators/layer/recurrent/lstm/State;", "f", "Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;", "g", "h", "processGate", "lstmWeight", "lstmGate", "activation", "recurrent", "toOutput", "", "([Lio/kinference/operators/layer/recurrent/lstm/State;)Lio/kinference/operators/layer/recurrent/lstm/State;", "Companion", "inference"})
public class LSTMLayer
extends LSTMBase {
    private LSTMData lstmData;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Tensor> apply(@NotNull List<? extends NDArray> inputs, @NotNull int[] sequenceLens, @NotNull MutableNDArray outputArray, int startOffset) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull((Object)sequenceLens, (String)"sequenceLens");
        Intrinsics.checkParameterIsNotNull((Object)outputArray, (String)"outputArray");
        Integer n = this.getBatchSize();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        int batchSize = n;
        Integer n2 = this.getSeqLength();
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        int seqLength = n2;
        DataType dataType = this.getType();
        if (dataType == null) {
            Intrinsics.throwNpe();
        }
        DataType type = dataType;
        LSTMData lSTMData = this.lstmData;
        if (lSTMData == null) {
            Intrinsics.throwNpe();
        }
        LSTMData lstmData = lSTMData;
        Iterable $this$map$iv = this.getActivations();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PrimitiveToPrimitiveFunction primitiveToPrimitiveFunction = Activation.Companion.create((String)it, type);
            collection.add(primitiveToPrimitiveFunction);
        }
        List list = (List)destination$iv$iv;
        $this$map$iv = list;
        $i$f$map = false;
        PrimitiveToPrimitiveFunction primitiveToPrimitiveFunction = (PrimitiveToPrimitiveFunction)$this$map$iv.get(0);
        $this$map$iv = list;
        $i$f$map = false;
        PrimitiveToPrimitiveFunction primitiveToPrimitiveFunction2 = (PrimitiveToPrimitiveFunction)$this$map$iv.get(1);
        $this$map$iv = list;
        $i$f$map = false;
        PrimitiveToPrimitiveFunction h = (PrimitiveToPrimitiveFunction)$this$map$iv.get(2);
        int currentOffset = Intrinsics.areEqual((Object)this.getDirection(), (Object)"forward") ? startOffset : outputArray.getLinearSize() - startOffset;
        int stepOffset = outputArray.getStrides().getStrides()[0];
        GatesData gatesData = GatesData.Companion.allocateGates(this.getHiddenSize(), type);
        State[] lastStates = State.Companion.create(lstmData.getInitialOutput(), lstmData.getInitialCellState(), batchSize, this.getHiddenSize(), type);
        int batchNum = Intrinsics.areEqual((Object)this.getDirection(), (Object)"forward") ? 0 : seqLength - 1;
        $i$f$mapTo = 0;
        int n3 = seqLength;
        while ($i$f$mapTo < n3) {
            void i;
            int temp = batchNum * batchSize;
            int it = 0;
            int n4 = batchSize;
            while (it < n4) {
                void inputNum;
                if (batchNum < sequenceLens[inputNum]) {
                    void g;
                    void f;
                    this.step(lstmData, inputs.get(temp + inputNum), outputArray, currentOffset + this.getHiddenSize() * inputNum, gatesData, lastStates[inputNum], (PrimitiveToPrimitiveFunction)f, (PrimitiveToPrimitiveFunction)g, h);
                }
                ++inputNum;
            }
            if (Intrinsics.areEqual((Object)this.getDirection(), (Object)"forward")) {
                currentOffset += stepOffset;
                ++batchNum;
            } else {
                currentOffset -= stepOffset;
                --batchNum;
            }
            ++i;
        }
        State lastState = this.toOutput(lastStates);
        return CollectionsKt.listOf((Object[])new Tensor[]{TensorExtensionsKt.asTensor$default((NDArray)outputArray, null, 1, null), TensorExtensionsKt.asTensor$default((NDArray)lastState.getOutput(), null, 1, null), TensorExtensionsKt.asTensor$default((NDArray)lastState.getCellState(), null, 1, null)});
    }

    private final void processGate(@NotNull NDArray $this$processGate, State lastState, MutableNDArray lstmWeight, MutableNDArray lstmGate, PrimitiveToPrimitiveFunction activation, NDArray recurrent, NDArray bias, NDArray peepholes) {
        NDArray nDArray = $this$processGate;
        if (nDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArray");
        }
        NumberNDArray cfr_ignored_0 = (NumberNDArray)nDArray;
        MutableNDArray mutableNDArray = lstmWeight;
        if (mutableNDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableNumberNDArray");
        }
        MutableNumberNDArray cfr_ignored_1 = (MutableNumberNDArray)mutableNDArray;
        MutableNDArray mutableNDArray2 = lstmGate;
        if (mutableNDArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableNumberNDArray");
        }
        MutableNumberNDArray cfr_ignored_2 = (MutableNumberNDArray)mutableNDArray2;
        ((NumberNDArray)$this$processGate).dot((NumberNDArray)lstmWeight, (MutableNumberNDArray)lstmGate);
        if (!lastState.isOutputZero()) {
            MutableNDArray mutableNDArray3 = lastState.getOutput();
            if (mutableNDArray3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArray");
            }
            NDArray nDArray2 = recurrent;
            if (nDArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArray");
            }
            ((NumberNDArray)mutableNDArray3).dot((NumberNDArray)nDArray2, (MutableNumberNDArray)lstmGate);
        }
        if (!lastState.isCellStateZero() && peepholes != null) {
            MutableNDArray mutableNDArray4 = lastState.getCellState();
            if (mutableNDArray4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArray");
            }
            ((MutableNumberNDArray)lstmGate).plusAssign((NDArray)((NumberNDArray)peepholes).times((NumberNDArray)mutableNDArray4));
        }
        if (bias != null) {
            ((MutableNumberNDArray)lstmGate).plusAssign(bias);
        }
        ((MutableNumberNDArray)lstmGate).mapMutable(activation);
    }

    static /* synthetic */ void processGate$default(LSTMLayer lSTMLayer, NDArray nDArray, State state, MutableNDArray mutableNDArray, MutableNDArray mutableNDArray2, PrimitiveToPrimitiveFunction primitiveToPrimitiveFunction, NDArray nDArray2, NDArray nDArray3, NDArray nDArray4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processGate");
        }
        if ((n & 0x40) != 0) {
            nDArray4 = null;
        }
        lSTMLayer.processGate(nDArray, state, mutableNDArray, mutableNDArray2, primitiveToPrimitiveFunction, nDArray2, nDArray3, nDArray4);
    }

    private final void step(LSTMData lstmData, NDArray input, MutableNDArray output, int outputOffset, GatesData gatesData, State lastState, PrimitiveToPrimitiveFunction f, PrimitiveToPrimitiveFunction g, PrimitiveToPrimitiveFunction h) {
        gatesData.cleanup();
        GatesData gatesData2 = lstmData.getBias();
        GatesData gatesData3 = lstmData.getPeepholes();
        this.processGate(input, lastState, lstmData.getWeights().getInput(), gatesData.getInput(), f, (NDArray)lstmData.getRecurrentWeights().getInput(), (NDArray)(gatesData2 != null ? gatesData2.getInput() : null), (NDArray)(gatesData3 != null ? gatesData3.getInput() : null));
        GatesData gatesData4 = lstmData.getBias();
        GatesData gatesData5 = lstmData.getPeepholes();
        this.processGate(input, lastState, lstmData.getWeights().getForget(), gatesData.getForget(), f, (NDArray)lstmData.getRecurrentWeights().getForget(), (NDArray)(gatesData4 != null ? gatesData4.getForget() : null), (NDArray)(gatesData5 != null ? gatesData5.getForget() : null));
        GatesData gatesData6 = lstmData.getBias();
        LSTMLayer.processGate$default(this, input, lastState, lstmData.getWeights().getCellGate(), gatesData.getCellGate(), g, (NDArray)lstmData.getRecurrentWeights().getCellGate(), (NDArray)(gatesData6 != null ? gatesData6.getCellGate() : null), null, 64, null);
        if (!lastState.isCellStateZero()) {
            MutableNDArray mutableNDArray = lastState.getCellState();
            if (mutableNDArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableNumberNDArray");
            }
            ((MutableNumberNDArray)mutableNDArray).timesAssign((NDArray)gatesData.getForget());
        }
        MutableNDArray mutableNDArray = gatesData.getInput();
        if (mutableNDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableNumberNDArray");
        }
        ((MutableNumberNDArray)mutableNDArray).timesAssign((NDArray)gatesData.getCellGate());
        MutableNDArray mutableNDArray2 = lastState.getCellState();
        if (mutableNDArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableNumberNDArray");
        }
        ((MutableNumberNDArray)mutableNDArray2).plusAssign((NDArray)gatesData.getInput());
        GatesData gatesData7 = lstmData.getBias();
        GatesData gatesData8 = lstmData.getPeepholes();
        this.processGate(input, lastState, lstmData.getWeights().getOutput(), gatesData.getOutput(), f, (NDArray)lstmData.getRecurrentWeights().getOutput(), (NDArray)(gatesData7 != null ? gatesData7.getOutput() : null), (NDArray)(gatesData8 != null ? gatesData8.getOutput() : null));
        MutableNDArray mutableNDArray3 = ((MutableNumberNDArray)lastState.getCellState()).map(h);
        State state = lastState;
        boolean bl = false;
        boolean bl2 = false;
        MutableNumberNDArray $this$apply = (MutableNumberNDArray)mutableNDArray3;
        boolean bl3 = false;
        $this$apply.timesAssign((NDArray)gatesData.getOutput());
        MutableNDArray mutableNDArray4 = mutableNDArray3;
        state.setOutput(mutableNDArray4);
        MutableNDArray.DefaultImpls.copyFrom$default((MutableNDArray)output, (int)outputOffset, (NDArray)((NDArray)lastState.getOutput()), (int)0, (int)0, (int)12, null);
        lastState.setOutputZero(false);
        lastState.setCellStateZero(false);
    }

    @Override
    protected void parseTempInputs(@NotNull Tensor weights, @NotNull Tensor recurrentWeights, @Nullable Tensor bias, @Nullable Tensor initialOutput, @Nullable Tensor initialCellState, @Nullable Tensor peepholes) {
        Intrinsics.checkParameterIsNotNull((Object)weights, (String)"weights");
        Intrinsics.checkParameterIsNotNull((Object)recurrentWeights, (String)"recurrentWeights");
        if (this.lstmData == null) {
            GatesData parsedWeights = GatesData.Companion.createWeights(NDArray.DefaultImpls.toMutable$default((NDArray)weights.getData(), null, (int)1, null));
            GatesData parsedRecurrentWeights = GatesData.Companion.createWeights(NDArray.DefaultImpls.toMutable$default((NDArray)recurrentWeights.getData(), null, (int)1, null));
            DataType dataType = this.getType();
            if (dataType == null) {
                Intrinsics.throwNpe();
            }
            this.lstmData = new LSTMData(dataType, parsedWeights, parsedRecurrentWeights, null, null, null, null, 120, null);
            this.setWeights(weights.getData());
            this.setRecurrentWeights(recurrentWeights.getData());
            this.setBias(null);
            this.setInitialOutput(null);
            this.setInitialCellState(null);
            this.setPeepholes(null);
        }
        if (weights.getData() != this.getWeights()) {
            LSTMData lSTMData = this.lstmData;
            if (lSTMData == null) {
                Intrinsics.throwNpe();
            }
            this.lstmData = lSTMData.updateWeights(GatesData.Companion.createWeights(NDArray.DefaultImpls.toMutable$default((NDArray)weights.getData(), null, (int)1, null)));
            this.setWeights(weights.getData());
        }
        if (recurrentWeights.getData() != this.getRecurrentWeights()) {
            LSTMData lSTMData = this.lstmData;
            if (lSTMData == null) {
                Intrinsics.throwNpe();
            }
            this.lstmData = lSTMData.updateRecurrentWeights(GatesData.Companion.createWeights(NDArray.DefaultImpls.toMutable$default((NDArray)recurrentWeights.getData(), null, (int)1, null)));
            this.setRecurrentWeights(recurrentWeights.getData());
        }
        if (bias != null && bias.getData() != this.getBias()) {
            LSTMData lSTMData = this.lstmData;
            if (lSTMData == null) {
                Intrinsics.throwNpe();
            }
            this.lstmData = lSTMData.updateBias(GatesData.Companion.createBias(NDArray.DefaultImpls.toMutable$default((NDArray)bias.getData(), null, (int)1, null)));
            this.setBias(bias.getData());
        }
        if (initialOutput != null && initialOutput.getData() != this.getInitialOutput()) {
            LSTMData lSTMData = this.lstmData;
            if (lSTMData == null) {
                Intrinsics.throwNpe();
            }
            NDArray nDArray = (NDArray)NDArrayExtensionsKt.squeeze((MutableNDArray)NDArray.DefaultImpls.toMutable$default((NDArray)initialOutput.getData(), null, (int)1, null), (int[])new int[]{0});
            Integer n = this.getBatchSize();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            this.lstmData = lSTMData.updateInitialOutput(SplitKt.splitWithAxis$default((NDArray)nDArray, (int)n, (int)0, (boolean)false, (int)6, null));
            this.setInitialOutput(initialOutput.getData());
        }
        if (initialCellState != null && initialCellState.getData() != this.getInitialCellState()) {
            LSTMData lSTMData = this.lstmData;
            if (lSTMData == null) {
                Intrinsics.throwNpe();
            }
            NDArray nDArray = (NDArray)NDArrayExtensionsKt.squeeze((MutableNDArray)NDArray.DefaultImpls.toMutable$default((NDArray)initialCellState.getData(), null, (int)1, null), (int[])new int[]{0});
            Integer n = this.getBatchSize();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            this.lstmData = lSTMData.updateInitialCellGate(SplitKt.splitWithAxis$default((NDArray)nDArray, (int)n, (int)0, (boolean)false, (int)6, null));
            this.setInitialCellState(initialCellState.getData());
        }
        if (peepholes != null && peepholes.getData() != this.getPeepholes()) {
            LSTMData lSTMData = this.lstmData;
            if (lSTMData == null) {
                Intrinsics.throwNpe();
            }
            this.lstmData = lSTMData.updatePeepholes(GatesData.Companion.createPeepholes(NDArray.DefaultImpls.toMutable$default((NDArray)peepholes.getData(), null, (int)1, null)));
            this.setPeepholes(peepholes.getData());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final State toOutput(@NotNull State[] $this$toOutput) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toOutput, (String)"$this$toOutput");
        int[] nArray = new int[3];
        nArray[0] = 1;
        Integer n = this.getBatchSize();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        nArray[1] = n;
        nArray[2] = this.getHiddenSize();
        Strides strides = new Strides(nArray);
        DataType dataType = this.getType();
        if (dataType == null) {
            Intrinsics.throwNpe();
        }
        MutableNDArray outputArray = ArrayFactoriesKt.allocateNDArray((DataType)dataType, (Strides)strides);
        DataType dataType2 = this.getType();
        if (dataType2 == null) {
            Intrinsics.throwNpe();
        }
        MutableNDArray cellStateArray = ArrayFactoriesKt.allocateNDArray((DataType)dataType2, (Strides)strides);
        int n2 = 0;
        int n3 = $this$toOutput.length;
        while (n2 < n3) {
            void i;
            void offset = i * this.getHiddenSize();
            MutableNDArray.DefaultImpls.copyFrom$default((MutableNDArray)outputArray, (int)offset, (NDArray)((NDArray)$this$toOutput[i].getOutput()), (int)0, (int)0, (int)12, null);
            MutableNDArray.DefaultImpls.copyFrom$default((MutableNDArray)cellStateArray, (int)offset, (NDArray)((NDArray)$this$toOutput[i].getCellState()), (int)0, (int)0, (int)12, null);
            ++i;
        }
        return new State(outputArray, cellStateArray, false, false);
    }

    public LSTMLayer(int hiddenSize, @NotNull List<String> activations, @NotNull String direction) {
        Intrinsics.checkParameterIsNotNull(activations, (String)"activations");
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        super(hiddenSize, activations, direction);
        boolean bl = Intrinsics.areEqual((Object)direction, (Object)"forward") || Intrinsics.areEqual((Object)direction, (Object)"reverse");
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = activations.size() >= 3;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ LSTMData access$getLstmData$p(LSTMLayer $this) {
        return $this.lstmData;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lio/kinference/operators/layer/recurrent/lstm/LSTMLayer$Companion;", "", "()V", "create", "Lio/kinference/operators/layer/recurrent/lstm/LSTMLayer;", "hiddenSize", "", "activations", "", "", "direction", "lstmData", "Lio/kinference/operators/layer/recurrent/lstm/LSTMData;", "seqLength", "batchSize", "type", "Lio/kinference/onnx/TensorProto$DataType;", "inference"})
    public static final class Companion {
        @NotNull
        public final LSTMLayer create(int hiddenSize, @NotNull List<String> activations, @NotNull String direction, @NotNull LSTMData lstmData, int seqLength, int batchSize, @NotNull TensorProto.DataType type) {
            Intrinsics.checkParameterIsNotNull(activations, (String)"activations");
            Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
            Intrinsics.checkParameterIsNotNull((Object)lstmData, (String)"lstmData");
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            LSTMLayer lstm = new LSTMLayer(hiddenSize, activations, direction);
            lstm.lstmData = lstmData;
            lstm.setSeqLength(seqLength);
            lstm.setBatchSize(batchSize);
            lstm.setType(TensorExtensionsKt.resolveLocalDataType(type));
            return lstm;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

