/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.operators.layer.normalization;

import io.kinference.attributes.Attribute;
import io.kinference.data.tensors.Tensor;
import io.kinference.data.tensors.TensorExtensionsKt;
import io.kinference.graph.Context;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableIntNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.onnx.AttributeProto;
import io.kinference.onnx.TensorProto;
import io.kinference.operators.AttributeInfo;
import io.kinference.operators.IOInfo;
import io.kinference.operators.Operator;
import io.kinference.operators.OperatorInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B;\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\tH\u0016R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lio/kinference/operators/layer/normalization/EmbedLayerNormalization;", "Lio/kinference/operators/Operator;", "Lio/kinference/data/tensors/Tensor;", "attributes", "", "", "Lio/kinference/attributes/Attribute;", "", "inputs", "", "outputs", "(Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "epsilon", "", "getEpsilon", "()F", "epsilon$delegate", "Lio/kinference/operators/Operator$AttributeValueDelegate;", "apply", "context", "Lio/kinference/graph/Context;", "Companion", "inference"})
public final class EmbedLayerNormalization
extends Operator<Tensor, Tensor> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Operator.AttributeValueDelegate epsilon$delegate;
    private static final Set<TensorProto.DataType> TYPE_CONSTRAINTS;
    private static final List<AttributeInfo> ATTRIBUTES_INFO;
    private static final List<IOInfo> INPUTS_INFO;
    private static final List<IOInfo> OUTPUTS_INFO;
    private static final OperatorInfo INFO;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EmbedLayerNormalization.class), "epsilon", "getEpsilon()F"))};
        Companion = new Companion(null);
        TYPE_CONSTRAINTS = SetsKt.setOf((Object[])new TensorProto.DataType[]{TensorProto.DataType.FLOAT, TensorProto.DataType.FLOAT16});
        ATTRIBUTES_INFO = CollectionsKt.listOf((Object)new AttributeInfo("epsilon", SetsKt.setOf((Object)((Object)AttributeProto.AttributeType.FLOAT)), false, Float.valueOf(1.0E-5f)));
        INPUTS_INFO = CollectionsKt.listOf((Object[])new IOInfo[]{new IOInfo(0, SetsKt.setOf((Object)((Object)TensorProto.DataType.INT32)), "input_ids", false, null, false, null, 0, 240, null), new IOInfo(1, SetsKt.setOf((Object)((Object)TensorProto.DataType.INT32)), "segment_ids", true, null, false, null, 0, 240, null), new IOInfo(2, TYPE_CONSTRAINTS, "word_embedding", false, null, false, null, 0, 240, null), new IOInfo(3, TYPE_CONSTRAINTS, "position_embedding", false, null, false, null, 0, 240, null), new IOInfo(4, TYPE_CONSTRAINTS, "segment_embedding", true, null, false, null, 0, 240, null), new IOInfo(5, TYPE_CONSTRAINTS, "gamma", false, null, false, null, 0, 240, null), new IOInfo(6, TYPE_CONSTRAINTS, "beta", false, null, false, null, 0, 240, null), new IOInfo(7, SetsKt.setOf((Object)((Object)TensorProto.DataType.INT32)), "mask", true, null, false, null, 0, 240, null)});
        OUTPUTS_INFO = CollectionsKt.listOf((Object[])new IOInfo[]{new IOInfo(0, TYPE_CONSTRAINTS, "output", false, null, false, null, 0, 240, null), new IOInfo(1, SetsKt.setOf((Object)((Object)TensorProto.DataType.INT32)), "mask_index", false, null, false, null, 0, 240, null)});
        INFO = new OperatorInfo("EmbedLayerNormalization", (Collection<AttributeInfo>)ATTRIBUTES_INFO, INPUTS_INFO, OUTPUTS_INFO);
    }

    private final float getEpsilon() {
        return ((Number)this.epsilon$delegate.getValue(this, $$delegatedProperties[0])).floatValue();
    }

    @Override
    @NotNull
    public List<Tensor> apply(@NotNull Context context, @NotNull List<Tensor> inputs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Tensor tensor = inputs.get(0);
        if (tensor == null) {
            Intrinsics.throwNpe();
        }
        NDArray nDArray = tensor.getData();
        if (nDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.IntNDArray");
        }
        IntNDArray inputIds = (IntNDArray)nDArray;
        Tensor tensor2 = inputs.get(1);
        IntNDArray segmentIds = (IntNDArray)(tensor2 != null ? tensor2.getData() : null);
        Tensor tensor3 = inputs.get(2);
        if (tensor3 == null) {
            Intrinsics.throwNpe();
        }
        NDArray nDArray2 = tensor3.getData();
        if (nDArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        }
        FloatNDArray wordEmbed = (FloatNDArray)nDArray2;
        Tensor tensor4 = inputs.get(3);
        if (tensor4 == null) {
            Intrinsics.throwNpe();
        }
        NDArray nDArray3 = tensor4.getData();
        if (nDArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        }
        FloatNDArray posEmbed = (FloatNDArray)nDArray3;
        Tensor tensor5 = inputs.get(4);
        FloatNDArray segmentEmbed = (FloatNDArray)(tensor5 != null ? tensor5.getData() : null);
        Tensor tensor6 = inputs.get(5);
        if (tensor6 == null) {
            Intrinsics.throwNpe();
        }
        NDArray nDArray4 = tensor6.getData();
        if (nDArray4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        }
        FloatNDArray gamma = (FloatNDArray)nDArray4;
        Tensor tensor7 = inputs.get(6);
        if (tensor7 == null) {
            Intrinsics.throwNpe();
        }
        NDArray nDArray5 = tensor7.getData();
        if (nDArray5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        }
        FloatNDArray beta2 = (FloatNDArray)nDArray5;
        Tensor tensor8 = (Tensor)CollectionsKt.getOrNull(inputs, (int)7);
        IntNDArray mask = (IntNDArray)(tensor8 != null ? tensor8.getData() : null);
        Tensor normalized = TensorExtensionsKt.asTensor((NDArray)Companion.normalize(this.getEpsilon(), inputIds, segmentIds, wordEmbed, posEmbed, segmentEmbed, gamma, beta2), "output");
        Tensor maskIndices = TensorExtensionsKt.asTensor((NDArray)Companion.createMaskIndices(mask, inputIds.getShape()[0], inputIds.getShape()[1]), "mask_index");
        return CollectionsKt.listOf((Object[])new Tensor[]{normalized, maskIndices});
    }

    public EmbedLayerNormalization(@NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
        super(INFO, attributes, inputs, outputs);
        this.epsilon$delegate = Operator.attribute$default(this, null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013JJ\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/kinference/operators/layer/normalization/EmbedLayerNormalization$Companion;", "", "()V", "ATTRIBUTES_INFO", "", "Lio/kinference/operators/AttributeInfo;", "INFO", "Lio/kinference/operators/OperatorInfo;", "INPUTS_INFO", "Lio/kinference/operators/IOInfo;", "OUTPUTS_INFO", "TYPE_CONSTRAINTS", "", "Lio/kinference/onnx/TensorProto$DataType;", "createMaskIndices", "Lio/kinference/ndarray/arrays/NumberNDArray;", "mask", "Lio/kinference/ndarray/arrays/IntNDArray;", "batchSize", "", "seqLen", "normalize", "Lio/kinference/ndarray/arrays/MutableFloatNDArray;", "epsilon", "", "inputIds", "segmentIds", "wordEmbed", "Lio/kinference/ndarray/arrays/FloatNDArray;", "posEmbed", "segmentEmbed", "gamma", "beta", "inference"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NumberNDArray createMaskIndices(@Nullable IntNDArray mask, int batchSize, int seqLen) {
            MutableIntNDArray maskIndices = new MutableIntNDArray(new int[]{batchSize}, 0, 2, null);
            if (mask == null) {
                return (NumberNDArray)maskIndices;
            }
            IntPointer pointer = IntTiledArray.pointer$default((IntTiledArray)mask.getArray(), (int)0, (int)1, null);
            IntPointer maskIndicesPointer = IntTiledArray.pointer$default((IntTiledArray)maskIndices.getArray(), (int)0, (int)1, null);
            int n = 0;
            int n2 = batchSize;
            while (n < n2) {
                int offset$iv;
                int[] block$iv;
                void i;
                int count = 0;
                pointer.setLinearIndex((int)(i * seqLen));
                IntPointer $this$forEach$iv = pointer;
                boolean $i$f$forEach = false;
                for (int end$iv = seqLen; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                    int n3;
                    block$iv = $this$forEach$iv.getCurrentBlock();
                    offset$iv = $this$forEach$iv.getIndexInBlock();
                    IntPointer this_$iv$iv22 = $this$forEach$iv;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                        IntPointer intPointer = this_$iv$iv22;
                        n3 = intPointer.getBlockNum();
                        intPointer.setBlockNum(n3 + 1);
                        this_$iv$iv22.setIndexInBlock(0);
                        this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                    } else {
                        this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                    }
                    int this_$iv$iv22 = offset$iv;
                    n3 = block$iv.length;
                    int n4 = offset$iv + end$iv;
                    boolean bl = false;
                    int n5 = Math.min(n3, n4);
                    while (this_$iv$iv22 < n5) {
                        void index$iv;
                        int it = block$iv[index$iv];
                        boolean bl2 = false;
                        if (it == 1) {
                            ++count;
                        }
                        ++index$iv;
                    }
                }
                $this$forEach$iv = maskIndicesPointer;
                int value$iv = count;
                int $i$f$set = 0;
                this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()] = value$iv;
                IntPointer this_$iv = maskIndicesPointer;
                boolean $i$f$increment = false;
                if (this_$iv.getIndexInBlock() < this_$iv.getArray().getBlockSize() - 1) {
                    IntPointer intPointer = this_$iv;
                    $i$f$set = intPointer.getIndexInBlock();
                    intPointer.setIndexInBlock($i$f$set + 1);
                } else {
                    IntPointer this_$iv$iv = this_$iv;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                        IntPointer intPointer = this_$iv$iv;
                        int n6 = intPointer.getBlockNum();
                        intPointer.setBlockNum(n6 + 1);
                        this_$iv$iv.setIndexInBlock(0);
                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                    }
                }
                ++i;
            }
            return (NumberNDArray)maskIndices;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public final MutableFloatNDArray normalize(float epsilon, @NotNull IntNDArray inputIds, @Nullable IntNDArray segmentIds, @NotNull FloatNDArray wordEmbed, @NotNull FloatNDArray posEmbed, @Nullable FloatNDArray segmentEmbed, @NotNull FloatNDArray gamma, @NotNull FloatNDArray beta) {
            Intrinsics.checkParameterIsNotNull((Object)inputIds, (String)"inputIds");
            Intrinsics.checkParameterIsNotNull((Object)wordEmbed, (String)"wordEmbed");
            Intrinsics.checkParameterIsNotNull((Object)posEmbed, (String)"posEmbed");
            Intrinsics.checkParameterIsNotNull((Object)gamma, (String)"gamma");
            Intrinsics.checkParameterIsNotNull((Object)beta, (String)"beta");
            var12_11 = var11_9 = inputIds.getShape();
            var13_12 = false;
            var9_14 = var12_11[0];
            var12_11 = var11_9;
            var13_12 = false;
            seqLen = var12_11[1];
            var13_13 = var12_11 = wordEmbed.getShape();
            var14_16 = false;
            hiddenSize = var13_13[1];
            output = new MutableFloatNDArray(new int[]{batchSize, seqLen, hiddenSize}, 0, 2, null);
            inputIdsPointer = IntTiledArray.pointer$default((IntTiledArray)inputIds.getArray(), (int)0, (int)1, null);
            v0 = segmentIds;
            segmentIdsPointer = v0 != null && (v0 = v0.getArray()) != null ? IntTiledArray.pointer$default((IntTiledArray)v0, (int)0, (int)1, null) : null;
            var15_18 = false;
            var16_19 = batchSize;
            while (var15_18 < var16_19) {
                var17_20 = 0;
                var18_21 = seqLen;
                while (var17_20 < var18_21) {
                    block107: {
                        block106: {
                            this_$iv = inputIdsPointer;
                            $i$f$getAndIncrement = false;
                            value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                            this_$iv$iv = this_$iv;
                            $i$f$increment = false;
                            if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                v1 = this_$iv$iv;
                                var25_36 = v1.getIndexInBlock();
                                v1.setIndexInBlock(var25_36 + 1);
                            } else {
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$blockIncrement = 0;
                                if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    v2 = this_$iv$iv$iv;
                                    var27_41 = v2.getBlockNum();
                                    v2.setBlockNum(var27_41 + 1);
                                    this_$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            wordIdx = value$iv;
                            if (segmentIdsPointer != null) {
                                $i$f$getAndIncrement = false;
                                value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                                this_$iv$iv = this_$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                    v3 = this_$iv$iv;
                                    $i$f$blockIncrement = v3.getIndexInBlock();
                                    v3.setIndexInBlock($i$f$blockIncrement + 1);
                                } else {
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v4 = this_$iv$iv$iv;
                                        var28_43 = v4.getBlockNum();
                                        v4.setBlockNum(var28_43 + 1);
                                        this_$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                v5 = value$iv;
                            } else {
                                v5 = 0;
                            }
                            segmentIdx = v5;
                            wordEmbedOffset = wordIdx * hiddenSize;
                            segmentEmbedOffset = segmentIdx * hiddenSize;
                            outputOffset = (posIdx + batch * seqLen) * hiddenSize;
                            posEmbedOffset = posIdx * hiddenSize;
                            wordEmbedPointer = wordEmbed.getArray().pointer(wordEmbedOffset);
                            v6 = segmentEmbed;
                            segmentEmbedPointer = v6 != null && (v6 = v6.getArray()) != null ? v6.pointer(segmentEmbedOffset) : null;
                            outputPointer = output.getArray().pointer((int)outputOffset);
                            posEmbedPointer = posEmbed.getArray().pointer((int)posEmbedOffset);
                            if (segmentEmbedPointer != null) break block106;
                            $this$acceptDouble$iv = outputPointer;
                            $i$f$acceptDouble = false;
                            $this$isCompatibleBySize$iv$iv = $this$acceptDouble$iv;
                            $i$f$isCompatibleBySize = false;
                            $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= hiddenSize && wordEmbedPointer.getArray().getSize() - wordEmbedPointer.getLinearIndex() >= hiddenSize;
                            $i$f$isCompatibleBySize = false;
                            var33_67 = false;
                            if (!$this$isCompatibleBySize$iv$iv) {
                                $i$a$-require-FloatPointerKt$acceptDouble$1$iv = false;
                                var33_68 = "Pointers not compatible by available elements";
                                throw (Throwable)new IllegalArgumentException(var33_68.toString());
                            }
                            $this$isCompatibleBySize$iv$iv = $this$acceptDouble$iv;
                            $i$f$isCompatibleBySize = false;
                            $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= hiddenSize && posEmbedPointer.getArray().getSize() - posEmbedPointer.getLinearIndex() >= hiddenSize;
                            $i$f$isCompatibleBySize = false;
                            var33_67 = false;
                            if (!$this$isCompatibleBySize$iv$iv) {
                                $i$a$-require-FloatPointerKt$acceptDouble$2$iv = false;
                                var33_69 = "Pointers not compatible by available elements";
                                throw (Throwable)new IllegalArgumentException(var33_69.toString());
                            }
                            $this$isCompatibleWith$iv$iv = $this$acceptDouble$iv;
                            $i$f$isCompatibleWith = false;
                            if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == wordEmbedPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == wordEmbedPointer.getArray().getBlockSize())) ** GOTO lbl-1000
                            $this$isCompatibleWith$iv$iv = $this$acceptDouble$iv;
                            $i$f$isCompatibleWith = false;
                            if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == posEmbedPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == posEmbedPointer.getArray().getBlockSize()) {
                                for (end$iv = hiddenSize; end$iv > 0; end$iv -= ((FloatPointer)dstBlock$iv /* !! */ ).length - dstOffset$iv) {
                                    dstBlock$iv /* !! */  = (FloatPointer)$this$acceptDouble$iv.getCurrentBlock();
                                    dstOffset$iv = $this$acceptDouble$iv.getIndexInBlock();
                                    this_$iv$iv = $this$acceptDouble$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                        v7 = this_$iv$iv;
                                        var36_105 = v7.getBlockNum();
                                        v7.setBlockNum(var36_105 + 1);
                                        this_$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                    }
                                    fstBlock$iv = wordEmbedPointer.getCurrentBlock();
                                    this_$iv$iv = wordEmbedPointer;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                        v8 = this_$iv$iv;
                                        var37_124 = v8.getBlockNum();
                                        v8.setBlockNum(var37_124 + 1);
                                        this_$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                    }
                                    sndBlock$iv = posEmbedPointer.getCurrentBlock();
                                    this_$iv$iv = posEmbedPointer;
                                    $i$f$blockIncrement = 0;
                                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                        v9 = this_$iv$iv;
                                        var38_131 = v9.getBlockNum();
                                        v9.setBlockNum(var38_131 + 1);
                                        this_$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                    }
                                    this_$iv$iv = dstOffset$iv;
                                    var38_131 = ((FloatPointer)dstBlock$iv /* !! */ ).length;
                                    var39_150 = dstOffset$iv + end$iv;
                                    var40_157 = false;
                                    $i$f$blockIncrement = Math.min(var38_131, var39_150);
                                    while (this_$iv$iv < $i$f$blockIncrement) {
                                        var41_168 = sndBlock$iv[index$iv];
                                        var42_180 = fstBlock$iv[index$iv];
                                        var43_188 = dstBlock$iv /* !! */ [index$iv];
                                        var55_220 = index$iv++;
                                        var54_219 /* !! */  = (float[])dstBlock$iv /* !! */ ;
                                        $i$a$-acceptDouble-EmbedLayerNormalization$Companion$normalize$1 = false;
                                        var56_221 = fst + snd;
                                        var54_219 /* !! */ [var55_220] = var56_221;
                                    }
                                }
                            } else lbl-1000:
                            // 3 sources

                            {
                                while (end$iv > 0) {
                                    dstBlock$iv /* !! */  = $this$acceptDouble$iv;
                                    this_$iv$iv = $this$acceptDouble$iv;
                                    $i$f$get = false;
                                    fst = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                    this_$iv$iv = wordEmbedPointer;
                                    $i$f$getAndIncrement = false;
                                    value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$increment = false;
                                    if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                        v10 = this_$iv$iv$iv;
                                        var38_133 = v10.getIndexInBlock();
                                        v10.setIndexInBlock(var38_133 + 1);
                                    } else {
                                        this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                            v11 = this_$iv$iv$iv$iv;
                                            var40_158 = v11.getBlockNum();
                                            v11.setBlockNum(var40_158 + 1);
                                            this_$iv$iv$iv$iv.setIndexInBlock(0);
                                            this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                        }
                                    }
                                    snd = value$iv$iv;
                                    this_$iv$iv = posEmbedPointer;
                                    $i$f$getAndIncrement = false;
                                    value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$increment = false;
                                    if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                        v12 = this_$iv$iv$iv;
                                        this_$iv$iv$iv$iv = v12.getIndexInBlock();
                                        v12.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                                    } else {
                                        this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                            v13 = this_$iv$iv$iv$iv;
                                            var40_158 = v13.getBlockNum();
                                            v13.setBlockNum(var40_158 + 1);
                                            this_$iv$iv$iv$iv.setIndexInBlock(0);
                                            this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                        }
                                    }
                                    var45_202 = $i$a$-acceptDouble-EmbedLayerNormalization$Companion$normalize$1 = value$iv$iv;
                                    var46_206 = snd;
                                    $noName_0 = fst;
                                    $i$a$-acceptDouble-EmbedLayerNormalization$Companion$normalize$1 = false;
                                    value$iv$iv = fst + snd;
                                    $i$f$set = 0;
                                    this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv;
                                    this_$iv$iv = $this$acceptDouble$iv;
                                    $i$f$increment = false;
                                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                        v14 = this_$iv$iv;
                                        $i$f$set = v14.getIndexInBlock();
                                        v14.setIndexInBlock($i$f$set + 1);
                                    } else {
                                        this_$iv$iv$iv = this_$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                            v15 = this_$iv$iv$iv;
                                            this_$iv$iv$iv = v15.getBlockNum();
                                            v15.setBlockNum(this_$iv$iv$iv + 1);
                                            this_$iv$iv$iv.setIndexInBlock(0);
                                            this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                        }
                                    }
                                    --end$iv;
                                }
                            }
                            break block107;
                        }
                        $this$acceptTriple$iv = outputPointer;
                        $i$f$acceptTriple = false;
                        $this$isCompatibleBySize$iv$iv = $this$acceptTriple$iv;
                        $i$f$isCompatibleBySize = false;
                        $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= hiddenSize && wordEmbedPointer.getArray().getSize() - wordEmbedPointer.getLinearIndex() >= hiddenSize;
                        $i$f$isCompatibleBySize = false;
                        $i$f$increment = false;
                        if (!$this$isCompatibleBySize$iv$iv) {
                            $i$a$-require-FloatPointerKt$acceptTriple$1$iv = false;
                            $i$f$increment = "Pointers not compatible by available elements";
                            throw (Throwable)new IllegalArgumentException($i$f$increment.toString());
                        }
                        $this$isCompatibleBySize$iv$iv = $this$acceptTriple$iv;
                        $i$f$isCompatibleBySize = false;
                        $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= hiddenSize && posEmbedPointer.getArray().getSize() - posEmbedPointer.getLinearIndex() >= hiddenSize;
                        $i$f$isCompatibleBySize = false;
                        $i$f$increment = false;
                        if (!$this$isCompatibleBySize$iv$iv) {
                            $i$a$-require-FloatPointerKt$acceptTriple$2$iv = false;
                            $i$f$increment = "Pointers not compatible by available elements";
                            throw (Throwable)new IllegalArgumentException($i$f$increment.toString());
                        }
                        $this$isCompatibleBySize$iv$iv = $this$acceptTriple$iv;
                        $i$f$isCompatibleBySize = false;
                        $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= hiddenSize && segmentEmbedPointer.getArray().getSize() - segmentEmbedPointer.getLinearIndex() >= hiddenSize;
                        $i$f$isCompatibleBySize = false;
                        $i$f$increment = false;
                        if (!$this$isCompatibleBySize$iv$iv) {
                            $i$a$-require-FloatPointerKt$acceptTriple$3$iv = false;
                            $i$f$increment = "Pointers not compatible by available elements";
                            throw (Throwable)new IllegalArgumentException($i$f$increment.toString());
                        }
                        $this$isCompatibleWith$iv$iv = $this$acceptTriple$iv;
                        $i$f$isCompatibleWith = false;
                        if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == wordEmbedPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == wordEmbedPointer.getArray().getBlockSize())) ** GOTO lbl-1000
                        $this$isCompatibleWith$iv$iv = $this$acceptTriple$iv;
                        $i$f$isCompatibleWith = false;
                        if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == posEmbedPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == posEmbedPointer.getArray().getBlockSize())) ** GOTO lbl-1000
                        $this$isCompatibleWith$iv$iv = $this$acceptTriple$iv;
                        $i$f$isCompatibleWith = false;
                        if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == segmentEmbedPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == segmentEmbedPointer.getArray().getBlockSize()) {
                            for (end$iv = hiddenSize; end$iv > 0; end$iv -= ((FloatPointer)dstBlock$iv /* !! */ ).length - dstOffset$iv) {
                                dstBlock$iv /* !! */  = (FloatPointer)$this$acceptTriple$iv.getCurrentBlock();
                                dstOffset$iv = $this$acceptTriple$iv.getIndexInBlock();
                                this_$iv$iv = $this$acceptTriple$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    v16 = this_$iv$iv;
                                    this_$iv$iv$iv = v16.getBlockNum();
                                    v16.setBlockNum(this_$iv$iv$iv + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                fstBlock$iv = wordEmbedPointer.getCurrentBlock();
                                this_$iv$iv = wordEmbedPointer;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    v17 = this_$iv$iv;
                                    $i$f$increment = v17.getBlockNum();
                                    v17.setBlockNum($i$f$increment + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                sndBlock$iv = posEmbedPointer.getCurrentBlock();
                                this_$iv$iv = posEmbedPointer;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    v18 = this_$iv$iv;
                                    this_$iv$iv$iv$iv = v18.getBlockNum();
                                    v18.setBlockNum(this_$iv$iv$iv$iv + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                trdBlock$iv = segmentEmbedPointer.getCurrentBlock();
                                this_$iv$iv = segmentEmbedPointer;
                                $i$f$blockIncrement = 0;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    v19 = this_$iv$iv;
                                    $i$f$blockIncrement = v19.getBlockNum();
                                    v19.setBlockNum($i$f$blockIncrement + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                this_$iv$iv = dstOffset$iv;
                                $i$f$blockIncrement = ((FloatPointer)dstBlock$iv /* !! */ ).length;
                                var40_159 = dstOffset$iv + end$iv;
                                snd = false;
                                $i$f$blockIncrement = Math.min($i$f$blockIncrement, var40_159);
                                while (this_$iv$iv < $i$f$blockIncrement) {
                                    fst = trdBlock$iv[index$iv];
                                    $noName_0 = sndBlock$iv[index$iv];
                                    $i$a$-acceptDouble-EmbedLayerNormalization$Companion$normalize$1 = fstBlock$iv[index$iv];
                                    snd = dstBlock$iv /* !! */ [index$iv];
                                    var55_220 = index$iv++;
                                    var54_219 /* !! */  = (float[])dstBlock$iv /* !! */ ;
                                    $i$a$-acceptTriple-EmbedLayerNormalization$Companion$normalize$2 = false;
                                    var56_221 = fst + snd + trd;
                                    var54_219 /* !! */ [var55_220] = var56_221;
                                }
                            }
                        } else lbl-1000:
                        // 4 sources

                        {
                            while (end$iv > 0) {
                                dstBlock$iv /* !! */  = $this$acceptTriple$iv;
                                this_$iv$iv = $this$acceptTriple$iv;
                                $i$f$get = false;
                                fst = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                this_$iv$iv = wordEmbedPointer;
                                $i$f$getAndIncrement = false;
                                value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                    v20 = this_$iv$iv$iv;
                                    $i$f$blockIncrement = v20.getIndexInBlock();
                                    v20.setIndexInBlock($i$f$blockIncrement + 1);
                                } else {
                                    this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v21 = this_$iv$iv$iv$iv;
                                        var40_160 = v21.getBlockNum();
                                        v21.setBlockNum(var40_160 + 1);
                                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                snd = value$iv$iv;
                                this_$iv$iv = posEmbedPointer;
                                $i$f$getAndIncrement = false;
                                value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                    v22 = this_$iv$iv$iv;
                                    this_$iv$iv$iv$iv = v22.getIndexInBlock();
                                    v22.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                                } else {
                                    this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v23 = this_$iv$iv$iv$iv;
                                        var40_160 = v23.getBlockNum();
                                        v23.setBlockNum(var40_160 + 1);
                                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                trd = value$iv$iv;
                                this_$iv$iv = segmentEmbedPointer;
                                $i$f$getAndIncrement = false;
                                value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                    v24 = this_$iv$iv$iv;
                                    this_$iv$iv$iv$iv = v24.getIndexInBlock();
                                    v24.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                                } else {
                                    this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v25 = this_$iv$iv$iv$iv;
                                        var40_160 = v25.getBlockNum();
                                        v25.setBlockNum(var40_160 + 1);
                                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                $noName_0 = $i$a$-acceptTriple-EmbedLayerNormalization$Companion$normalize$2 = value$iv$iv;
                                $i$a$-acceptDouble-EmbedLayerNormalization$Companion$normalize$1 = trd;
                                var49_212 = snd;
                                $noName_0 = fst;
                                $i$a$-acceptTriple-EmbedLayerNormalization$Companion$normalize$2 = false;
                                value$iv$iv = fst + snd + trd;
                                $i$f$set = 0;
                                this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv;
                                this_$iv$iv = $this$acceptTriple$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                    v26 = this_$iv$iv;
                                    $i$f$set = v26.getIndexInBlock();
                                    v26.setIndexInBlock($i$f$set + 1);
                                } else {
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v27 = this_$iv$iv$iv;
                                        this_$iv$iv$iv = v27.getBlockNum();
                                        v27.setBlockNum(this_$iv$iv$iv + 1);
                                        this_$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                --end$iv;
                            }
                        }
                    }
                    acc = 0.0f;
                    outputPointer.setLinearIndex((int)outputOffset);
                    $this$forEach$iv = outputPointer;
                    $i$f$forEach = false;
                    for (end$iv = hiddenSize; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = $this$forEach$iv.getCurrentBlock();
                        offset$iv = $this$forEach$iv.getIndexInBlock();
                        this_$iv$iv = $this$forEach$iv;
                        $i$f$blockIncrement = 0;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            v28 = this_$iv$iv;
                            $i$f$increment = v28.getBlockNum();
                            v28.setBlockNum($i$f$increment + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        this_$iv$iv = offset$iv;
                        $i$f$increment = block$iv.length;
                        this_$iv$iv$iv$iv = offset$iv + end$iv;
                        $i$f$blockIncrement = 0;
                        $i$f$blockIncrement = Math.min($i$f$increment, this_$iv$iv$iv$iv);
                        while (this_$iv$iv < $i$f$blockIncrement) {
                            it = block$iv[index$iv];
                            $i$a$-forEach-EmbedLayerNormalization$Companion$normalize$3 = false;
                            acc += it;
                            ++index$iv;
                        }
                    }
                    mean = acc / (float)hiddenSize;
                    acc = 0.0f;
                    outputPointer.setLinearIndex((int)outputOffset);
                    $this$map$iv = outputPointer;
                    $i$f$map = false;
                    for (end$iv = hiddenSize; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = $this$map$iv.getCurrentBlock();
                        offset$iv = $this$map$iv.getIndexInBlock();
                        this_$iv$iv = $this$map$iv;
                        $i$f$blockIncrement = 0;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            v29 = this_$iv$iv;
                            this_$iv$iv$iv$iv = v29.getBlockNum();
                            v29.setBlockNum(this_$iv$iv$iv$iv + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        this_$iv$iv = offset$iv;
                        this_$iv$iv$iv$iv = block$iv.length;
                        $i$f$blockIncrement = offset$iv + end$iv;
                        it = false;
                        $i$f$blockIncrement = Math.min(this_$iv$iv$iv$iv, $i$f$blockIncrement);
                        while (this_$iv$iv < $i$f$blockIncrement) {
                            $i$a$-forEach-EmbedLayerNormalization$Companion$normalize$3 = block$iv[index$iv];
                            var55_220 = index$iv++;
                            var54_219 /* !! */  = block$iv;
                            $i$a$-map-EmbedLayerNormalization$Companion$normalize$4 = false;
                            var56_221 = it - mean;
                            var54_219 /* !! */ [var55_220] = var56_221;
                        }
                    }
                    outputPointer.setLinearIndex((int)outputOffset);
                    $this$forEach$iv = outputPointer;
                    $i$f$forEach = false;
                    for (end$iv = hiddenSize; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = $this$forEach$iv.getCurrentBlock();
                        offset$iv = $this$forEach$iv.getIndexInBlock();
                        this_$iv$iv = $this$forEach$iv;
                        $i$f$blockIncrement = 0;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            v30 = this_$iv$iv;
                            this_$iv$iv$iv$iv = v30.getBlockNum();
                            v30.setBlockNum(this_$iv$iv$iv$iv + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        this_$iv$iv = offset$iv;
                        this_$iv$iv$iv$iv = block$iv.length;
                        $i$f$blockIncrement = offset$iv + end$iv;
                        it = false;
                        $i$f$blockIncrement = Math.min(this_$iv$iv$iv$iv, $i$f$blockIncrement);
                        while (this_$iv$iv < $i$f$blockIncrement) {
                            it = block$iv[index$iv];
                            $i$a$-forEach-EmbedLayerNormalization$Companion$normalize$5 = false;
                            acc += it * it;
                            ++index$iv;
                        }
                    }
                    $i$f$forEach = acc / (float)hiddenSize + epsilon;
                    end$iv = 0;
                    eps = (float)Math.sqrt($i$f$forEach);
                    outputPointer.setLinearIndex((int)outputOffset);
                    gammaPointer = FloatTiledArray.pointer$default((FloatTiledArray)gamma.getArray(), (int)0, (int)1, null);
                    betaPointer = FloatTiledArray.pointer$default((FloatTiledArray)beta.getArray(), (int)0, (int)1, null);
                    $this$acceptDouble$iv = outputPointer;
                    $i$f$acceptDouble = false;
                    $this$isCompatibleBySize$iv$iv = $this$acceptDouble$iv;
                    $i$f$isCompatibleBySize = false;
                    $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= hiddenSize && gammaPointer.getArray().getSize() - gammaPointer.getLinearIndex() >= hiddenSize;
                    $i$f$isCompatibleBySize = false;
                    this_$iv$iv$iv$iv = 0;
                    if (!$this$isCompatibleBySize$iv$iv) {
                        $i$a$-require-FloatPointerKt$acceptDouble$1$iv = false;
                        this_$iv$iv$iv$iv = "Pointers not compatible by available elements";
                        throw (Throwable)new IllegalArgumentException(this_$iv$iv$iv$iv.toString());
                    }
                    $this$isCompatibleBySize$iv$iv = $this$acceptDouble$iv;
                    $i$f$isCompatibleBySize = false;
                    $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= hiddenSize && betaPointer.getArray().getSize() - betaPointer.getLinearIndex() >= hiddenSize;
                    $i$f$isCompatibleBySize = false;
                    this_$iv$iv$iv$iv = 0;
                    if (!$this$isCompatibleBySize$iv$iv) {
                        $i$a$-require-FloatPointerKt$acceptDouble$2$iv = false;
                        this_$iv$iv$iv$iv = "Pointers not compatible by available elements";
                        throw (Throwable)new IllegalArgumentException(this_$iv$iv$iv$iv.toString());
                    }
                    $this$isCompatibleWith$iv$iv = $this$acceptDouble$iv;
                    $i$f$isCompatibleWith = false;
                    if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == gammaPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == gammaPointer.getArray().getBlockSize())) ** GOTO lbl-1000
                    $this$isCompatibleWith$iv$iv = $this$acceptDouble$iv;
                    $i$f$isCompatibleWith = false;
                    if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == betaPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == betaPointer.getArray().getBlockSize()) {
                        for (end$iv = hiddenSize; end$iv > 0; end$iv -= ((FloatPointer)dstBlock$iv /* !! */ ).length - dstOffset$iv) {
                            dstBlock$iv /* !! */  = (FloatPointer)$this$acceptDouble$iv.getCurrentBlock();
                            dstOffset$iv = $this$acceptDouble$iv.getIndexInBlock();
                            this_$iv$iv = $this$acceptDouble$iv;
                            $i$f$blockIncrement = false;
                            if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                v31 = this_$iv$iv;
                                it = v31.getBlockNum();
                                v31.setBlockNum(it + 1);
                                this_$iv$iv.setIndexInBlock(0);
                                this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                            }
                            fstBlock$iv = gammaPointer.getCurrentBlock();
                            this_$iv$iv = gammaPointer;
                            $i$f$blockIncrement = false;
                            if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                v32 = this_$iv$iv;
                                $i$a$-forEach-EmbedLayerNormalization$Companion$normalize$5 = v32.getBlockNum();
                                v32.setBlockNum($i$a$-forEach-EmbedLayerNormalization$Companion$normalize$5 + 1);
                                this_$iv$iv.setIndexInBlock(0);
                                this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                            }
                            sndBlock$iv = betaPointer.getCurrentBlock();
                            this_$iv$iv = betaPointer;
                            $i$f$blockIncrement = 0;
                            if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                v33 = this_$iv$iv;
                                snd = v33.getBlockNum();
                                v33.setBlockNum(snd + 1);
                                this_$iv$iv.setIndexInBlock(0);
                                this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                            }
                            this_$iv$iv = dstOffset$iv;
                            snd = ((FloatPointer)dstBlock$iv /* !! */ ).length;
                            fst = dstOffset$iv + end$iv;
                            var45_204 = false;
                            $i$f$blockIncrement = Math.min(snd, fst);
                            while (this_$iv$iv < $i$f$blockIncrement) {
                                $i$a$-acceptTriple-EmbedLayerNormalization$Companion$normalize$2 = sndBlock$iv[index$iv];
                                trd = fstBlock$iv[index$iv];
                                snd = dstBlock$iv /* !! */ [index$iv];
                                var55_220 = index$iv++;
                                var54_219 /* !! */  = (float[])dstBlock$iv /* !! */ ;
                                $i$a$-acceptDouble-EmbedLayerNormalization$Companion$normalize$6 = false;
                                var56_221 = out / eps * g + b;
                                var54_219 /* !! */ [var55_220] = var56_221;
                            }
                        }
                    } else lbl-1000:
                    // 3 sources

                    {
                        while (end$iv > 0) {
                            dstBlock$iv /* !! */  = $this$acceptDouble$iv;
                            this_$iv$iv = $this$acceptDouble$iv;
                            $i$f$get = false;
                            var47_208 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            this_$iv$iv = gammaPointer;
                            $i$f$getAndIncrement = false;
                            value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                v34 = this_$iv$iv$iv;
                                snd = v34.getIndexInBlock();
                                v34.setIndexInBlock(snd + 1);
                            } else {
                                this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    v35 = this_$iv$iv$iv$iv;
                                    var45_205 = v35.getBlockNum();
                                    v35.setBlockNum(var45_205 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            var46_206 = value$iv$iv;
                            this_$iv$iv = betaPointer;
                            $i$f$getAndIncrement = false;
                            value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                v36 = this_$iv$iv$iv;
                                this_$iv$iv$iv$iv = v36.getIndexInBlock();
                                v36.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                            } else {
                                this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    v37 = this_$iv$iv$iv$iv;
                                    var45_205 = v37.getBlockNum();
                                    v37.setBlockNum(var45_205 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            $noName_0 = var49_212 = value$iv$iv;
                            $i$a$-acceptTriple-EmbedLayerNormalization$Companion$normalize$2 = var46_206;
                            out = var47_208;
                            $i$a$-acceptDouble-EmbedLayerNormalization$Companion$normalize$6 = false;
                            value$iv$iv = out / eps * g + b;
                            $i$f$set = 0;
                            this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv;
                            this_$iv$iv = $this$acceptDouble$iv;
                            $i$f$increment = false;
                            if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                v38 = this_$iv$iv;
                                $i$f$set = v38.getIndexInBlock();
                                v38.setIndexInBlock($i$f$set + 1);
                            } else {
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    v39 = this_$iv$iv$iv;
                                    var41_179 = v39.getBlockNum();
                                    v39.setBlockNum(var41_179 + 1);
                                    this_$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            --end$iv;
                        }
                    }
                    ++posIdx;
                }
                ++batch;
            }
            return output;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

