/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.operators.activations;

import io.kinference.attributes.Attribute;
import io.kinference.ndarray.arrays.DoubleMap;
import io.kinference.ndarray.arrays.FloatMap;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.PrimitiveToPrimitiveFunction;
import io.kinference.onnx.TensorProto;
import io.kinference.operators.IOInfo;
import io.kinference.operators.Operator;
import io.kinference.operators.OperatorInfo;
import io.kinference.operators.activations.Activation;
import io.kinference.operators.activations.Tanh$WhenMappings;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB=\u0012\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lio/kinference/operators/activations/Tanh;", "Lio/kinference/operators/activations/Activation;", "attributes", "", "", "Lio/kinference/attributes/Attribute;", "", "inputs", "", "outputs", "(Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "activate", "Lio/kinference/ndarray/arrays/NDArray;", "input", "Companion", "inference"})
public final class Tanh
extends Activation {
    private static final Set<TensorProto.DataType> TYPE_CONSTRAINTS;
    private static final OperatorInfo INFO;
    @NotNull
    private static final FloatMap activateFloat;
    @NotNull
    private static final DoubleMap activateDouble;
    public static final Companion Companion;

    @Override
    @NotNull
    public NDArray activate(@NotNull NDArray input) {
        NDArray nDArray;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        switch (Tanh$WhenMappings.$EnumSwitchMapping$0[input.getType().ordinal()]) {
            case 1: {
                nDArray = (NDArray)input.map((PrimitiveToPrimitiveFunction)activateFloat);
                break;
            }
            case 2: {
                nDArray = (NDArray)input.map((PrimitiveToPrimitiveFunction)activateDouble);
                break;
            }
            default: {
                String string = "Unsupported operation";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return nDArray;
    }

    public Tanh(@NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
        super(INFO, attributes, inputs, outputs);
    }

    public /* synthetic */ Tanh(Map map, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map, list, list2);
    }

    static {
        Companion = new Companion(null);
        TYPE_CONSTRAINTS = Operator.Companion.getFLOAT_DATA_TYPES();
        INFO = new OperatorInfo("Tanh", MapsKt.emptyMap(), (List<? extends IOInfo>)CollectionsKt.listOf((Object)new IOInfo(0, TYPE_CONSTRAINTS, "input", false, null, false, null, 0, 240, null)), (List<? extends IOInfo>)CollectionsKt.listOf((Object)new IOInfo(0, TYPE_CONSTRAINTS, "output", false, null, false, null, 0, 240, null)));
        activateFloat = new FloatMap(){

            public float apply(float value) {
                float temp$iv;
                boolean $i$f$tanh = false;
                float f = 2.0f * value;
                boolean bl = false;
                f = temp$iv = (float)Math.exp(f);
                bl = false;
                if (Float.isInfinite(f)) {
                    temp$iv = FloatCompanionObject.INSTANCE.getMAX_VALUE();
                }
                return (temp$iv - 1.0f) / (temp$iv + 1.0f);
            }
        };
        activateDouble = new DoubleMap(){

            public double apply(double value) {
                boolean $i$f$tanh = false;
                double d = 2.0 * value;
                boolean bl = false;
                double d2 = Math.exp(d) - 1.0;
                d = 2.0 * value;
                double d3 = d2;
                bl = false;
                double d4 = Math.exp(d);
                return d3 / (d4 + 1.0);
            }
        };
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/kinference/operators/activations/Tanh$Companion;", "", "()V", "INFO", "Lio/kinference/operators/OperatorInfo;", "TYPE_CONSTRAINTS", "", "Lio/kinference/onnx/TensorProto$DataType;", "activateDouble", "Lio/kinference/ndarray/arrays/DoubleMap;", "getActivateDouble", "()Lio/kinference/ndarray/arrays/DoubleMap;", "activateFloat", "Lio/kinference/ndarray/arrays/FloatMap;", "getActivateFloat", "()Lio/kinference/ndarray/arrays/FloatMap;", "inference"})
    public static final class Companion {
        @NotNull
        public final FloatMap getActivateFloat() {
            return activateFloat;
        }

        @NotNull
        public final DoubleMap getActivateDouble() {
            return activateDouble;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

