/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.operators;

import io.kinference.attributes.Attribute;
import io.kinference.data.ONNXData;
import io.kinference.onnx.AttributeProto;
import io.kinference.onnx.NodeProto;
import io.kinference.operators.Operator;
import io.kinference.operators.activations.Erf;
import io.kinference.operators.activations.Identity;
import io.kinference.operators.activations.Relu;
import io.kinference.operators.activations.Sigmoid;
import io.kinference.operators.activations.Softmax;
import io.kinference.operators.activations.Tanh;
import io.kinference.operators.flow.Loop;
import io.kinference.operators.layer.attention.Attention;
import io.kinference.operators.layer.attention.QAttention;
import io.kinference.operators.layer.normalization.EmbedLayerNormalization;
import io.kinference.operators.layer.normalization.LayerNormalization;
import io.kinference.operators.layer.normalization.SkipLayerNormalization;
import io.kinference.operators.layer.recurrent.lstm.LSTM;
import io.kinference.operators.logical.Equal;
import io.kinference.operators.logical.Not;
import io.kinference.operators.math.Add;
import io.kinference.operators.math.BiasGelu;
import io.kinference.operators.math.CumSum;
import io.kinference.operators.math.FastGelu;
import io.kinference.operators.math.Gelu;
import io.kinference.operators.math.Gemm;
import io.kinference.operators.math.MatMul;
import io.kinference.operators.math.MatMulInteger;
import io.kinference.operators.math.Mul;
import io.kinference.operators.math.Sub;
import io.kinference.operators.quantization.DequantizeLinear;
import io.kinference.operators.quantization.DynamicQuantizeLinear;
import io.kinference.operators.seq.ConcatFromSequence;
import io.kinference.operators.seq.SplitToSequence;
import io.kinference.operators.tensor.Cast;
import io.kinference.operators.tensor.Concat;
import io.kinference.operators.tensor.Constant;
import io.kinference.operators.tensor.ConstantOfShape;
import io.kinference.operators.tensor.Gather;
import io.kinference.operators.tensor.Reshape;
import io.kinference.operators.tensor.Shape;
import io.kinference.operators.tensor.Slice;
import io.kinference.operators.tensor.Split;
import io.kinference.operators.tensor.Squeeze;
import io.kinference.operators.tensor.Transpose;
import io.kinference.operators.tensor.Unsqueeze;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007JR\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000e\u00a8\u0006\u0010"}, d2={"Lio/kinference/operators/OperatorFactory;", "", "()V", "create", "Lio/kinference/operators/Operator;", "Lio/kinference/data/ONNXData;", "proto", "Lio/kinference/onnx/NodeProto;", "name", "", "attributes", "", "Lio/kinference/attributes/Attribute;", "inputs", "", "outputs", "inference"})
public final class OperatorFactory {
    public static final OperatorFactory INSTANCE;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Operator<ONNXData, ONNXData> create(@Nullable String name, @NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull(outputs, (String)"outputs");
        String string = name;
        if (string != null) {
            switch (string) {
                case "Add": {
                    Operator operator = new Add(attributes, inputs, outputs);
                    return operator;
                }
                case "Sub": {
                    Operator operator = new Sub(attributes, inputs, outputs);
                    return operator;
                }
                case "Attention": {
                    Operator operator = new Attention(attributes, inputs, outputs);
                    return operator;
                }
                case "BiasGelu": {
                    Operator operator = new BiasGelu(attributes, inputs, outputs);
                    return operator;
                }
                case "Cast": {
                    Operator operator = new Cast(attributes, inputs, outputs);
                    return operator;
                }
                case "Concat": {
                    Operator operator = new Concat(attributes, inputs, outputs);
                    return operator;
                }
                case "ConcatFromSequence": {
                    Operator operator = new ConcatFromSequence(attributes, inputs, outputs);
                    return operator;
                }
                case "Constant": {
                    Operator operator = new Constant(attributes, inputs, outputs);
                    return operator;
                }
                case "ConstantOfShape": {
                    Operator operator = new ConstantOfShape(attributes, inputs, outputs);
                    return operator;
                }
                case "CumSum": {
                    Operator operator = new CumSum(attributes, inputs, outputs);
                    return operator;
                }
                case "DequantizeLinear": {
                    Operator operator = new DequantizeLinear(attributes, inputs, outputs);
                    return operator;
                }
                case "DynamicQuantizeLinear": {
                    Operator operator = new DynamicQuantizeLinear(attributes, inputs, outputs);
                    return operator;
                }
                case "EmbedLayerNormalization": {
                    Operator operator = new EmbedLayerNormalization(attributes, inputs, outputs);
                    return operator;
                }
                case "Equal": {
                    Operator operator = new Equal(attributes, inputs, outputs);
                    return operator;
                }
                case "Erf": {
                    Operator operator = new Erf(attributes, inputs, outputs);
                    return operator;
                }
                case "FastGelu": {
                    Operator operator = new FastGelu(attributes, inputs, outputs);
                    return operator;
                }
                case "Gather": {
                    Operator operator = new Gather(attributes, inputs, outputs);
                    return operator;
                }
                case "Gelu": {
                    Operator operator = new Gelu(attributes, inputs, outputs);
                    return operator;
                }
                case "Gemm": {
                    Operator operator = new Gemm(attributes, inputs, outputs);
                    return operator;
                }
                case "Identity": {
                    Operator operator = new Identity(attributes, inputs, outputs);
                    return operator;
                }
                case "LSTM": {
                    Operator operator = new LSTM(attributes, inputs, outputs);
                    return operator;
                }
                case "Loop": {
                    Operator operator = new Loop(attributes, inputs, outputs);
                    return operator;
                }
                case "LayerNormalization": {
                    Operator operator = new LayerNormalization(attributes, inputs, outputs);
                    return operator;
                }
                case "MatMul": {
                    Operator operator = new MatMul(attributes, inputs, outputs);
                    return operator;
                }
                case "MatMulInteger": {
                    Operator operator = new MatMulInteger(attributes, inputs, outputs);
                    return operator;
                }
                case "Mul": {
                    Operator operator = new Mul(attributes, inputs, outputs);
                    return operator;
                }
                case "Not": {
                    Operator operator = new Not(attributes, inputs, outputs);
                    return operator;
                }
                case "QAttention": {
                    Operator operator = new QAttention(attributes, inputs, outputs);
                    return operator;
                }
                case "Relu": {
                    Operator operator = new Relu(attributes, inputs, outputs);
                    return operator;
                }
                case "Reshape": {
                    Operator operator = new Reshape(attributes, inputs, outputs);
                    return operator;
                }
                case "Shape": {
                    Operator operator = new Shape(attributes, inputs, outputs);
                    return operator;
                }
                case "Sigmoid": {
                    Operator operator = new Sigmoid(attributes, inputs, outputs);
                    return operator;
                }
                case "SkipLayerNormalization": {
                    Operator operator = new SkipLayerNormalization(attributes, inputs, outputs);
                    return operator;
                }
                case "Slice": {
                    Operator operator = new Slice(attributes, inputs, outputs);
                    return operator;
                }
                case "Softmax": {
                    Operator operator = new Softmax(attributes, inputs, outputs);
                    return operator;
                }
                case "Split": {
                    Operator operator = new Split(attributes, inputs, outputs);
                    return operator;
                }
                case "SplitToSequence": {
                    Operator operator = new SplitToSequence(attributes, inputs, outputs);
                    return operator;
                }
                case "Squeeze": {
                    Operator operator = new Squeeze(attributes, inputs, outputs);
                    return operator;
                }
                case "Tanh": {
                    Operator operator = new Tanh(attributes, inputs, outputs);
                    return operator;
                }
                case "Transpose": {
                    Operator operator = new Transpose(attributes, inputs, outputs);
                    return operator;
                }
                case "Unsqueeze": {
                    Operator operator = new Unsqueeze(attributes, inputs, outputs);
                    return operator;
                }
            }
        }
        String string2 = "Unsupported operator: " + name;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Operator<ONNXData, ONNXData> create(@NotNull NodeProto proto) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
        Iterable iterable = proto.getAttribute();
        String string = proto.getOp_type();
        OperatorFactory operatorFactory = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AttributeProto attributeProto = (AttributeProto)((Object)item$iv$iv);
            object2 = destination$iv$iv;
            boolean bl = false;
            object = Attribute.Companion.create((AttributeProto)it);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object element$iv$iv;
            Object bl = element$iv$iv = iterator.next();
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            object = ((Attribute)receiver).getName();
            object2.put(object, element$iv$iv);
        }
        object2 = destination$iv$iv2;
        return operatorFactory.create(string, (Map<String, Attribute<Object>>)object2, proto.getInput(), proto.getOutput());
    }

    private OperatorFactory() {
    }

    static {
        OperatorFactory operatorFactory;
        INSTANCE = operatorFactory = new OperatorFactory();
    }
}

