/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.model;

import io.kinference.data.ONNXData;
import io.kinference.graph.Graph;
import io.kinference.onnx.GraphProto;
import io.kinference.onnx.ModelProto;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/kinference/model/Model;", "", "proto", "Lio/kinference/onnx/ModelProto;", "(Lio/kinference/onnx/ModelProto;)V", "graph", "Lio/kinference/graph/Graph;", "getGraph", "()Lio/kinference/graph/Graph;", "predict", "", "Lio/kinference/data/ONNXData;", "input", "", "Companion", "inference"})
public final class Model {
    @NotNull
    private final Graph graph;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Graph getGraph() {
        return this.graph;
    }

    @NotNull
    public final List<ONNXData> predict(@NotNull Collection<? extends ONNXData> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        return Graph.execute$default(this.graph, CollectionsKt.toList((Iterable)input), null, 2, null);
    }

    public Model(@NotNull ModelProto proto) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
        GraphProto graphProto = proto.getGraph();
        if (graphProto == null) {
            Intrinsics.throwNpe();
        }
        this.graph = new Graph(graphProto);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/kinference/model/Model$Companion;", "", "()V", "load", "Lio/kinference/model/Model;", "bytes", "", "file", "", "inference"})
    public static final class Companion {
        @NotNull
        public final Model load(@NotNull String file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return this.load(FilesKt.readBytes((File)new File(file)));
        }

        @NotNull
        public final Model load(@NotNull byte[] bytes) {
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            ModelProto modelScheme = (ModelProto)((Object)ModelProto.ADAPTER.decode(bytes));
            return new Model(modelScheme);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

