/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.graph;

import io.kinference.attributes.Attribute;
import io.kinference.data.ONNXData;
import io.kinference.data.tensors.Tensor;
import io.kinference.graph.Context;
import io.kinference.graph.GraphValueOrderInfo;
import io.kinference.onnx.AttributeProto;
import io.kinference.onnx.GraphProto;
import io.kinference.onnx.NodeProto;
import io.kinference.onnx.TensorProto;
import io.kinference.onnx.ValueInfoProto;
import io.kinference.operators.IOInfo;
import io.kinference.operators.Operator;
import io.kinference.operators.OperatorFactory;
import io.kinference.types.ValueInfo;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0002+,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 J\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\"J\u001c\u0010!\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006J\u0014\u0010!\u001a\u00020\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006J\u0014\u0010%\u001a\u00020&*\u00020 2\u0006\u0010'\u001a\u00020\fH\u0002J\"\u0010(\u001a\u00020&*\u00020\u001d2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*2\u0006\u0010'\u001a\u00020\fH\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR#\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00170\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/kinference/graph/Graph;", "", "proto", "Lio/kinference/onnx/GraphProto;", "(Lio/kinference/onnx/GraphProto;)V", "availableInputs", "", "", "getAvailableInputs", "()Ljava/util/List;", "dividerByName", "", "", "info", "Lio/kinference/types/ValueInfo;", "getInfo", "initNames", "initializers", "Lio/kinference/data/tensors/Tensor;", "getInitializers", "inputs", "getInputs", "operators", "Lio/kinference/operators/Operator;", "Lio/kinference/data/ONNXData;", "getOperators", "outputs", "getOutputs", "valueOrderInfo", "Lio/kinference/graph/GraphValueOrderInfo;", "execute", "root", "Lio/kinference/graph/Context;", "prepareInput", "Lio/kinference/onnx/TensorProto;", "name", "value", "cleanupUntilOrder", "", "order", "putOrderFor", "names", "", "Companion", "Node", "inference"})
public final class Graph {
    @NotNull
    private final List<Operator<ONNXData, ONNXData>> operators;
    @NotNull
    private final List<ValueInfo> inputs;
    @NotNull
    private final List<ValueInfo> outputs;
    @NotNull
    private final List<ValueInfo> info;
    private final GraphValueOrderInfo valueOrderInfo;
    @NotNull
    private final List<Tensor> initializers;
    private final List<String> initNames;
    private final Map<String, Integer> dividerByName;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final List<Operator<ONNXData, ONNXData>> getOperators() {
        return this.operators;
    }

    @NotNull
    public final List<ValueInfo> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final List<ValueInfo> getOutputs() {
        return this.outputs;
    }

    @NotNull
    public final List<ValueInfo> getInfo() {
        return this.info;
    }

    @NotNull
    public final List<Tensor> getInitializers() {
        return this.initializers;
    }

    private final void putOrderFor(@NotNull GraphValueOrderInfo $this$putOrderFor, Set<String> names, int order) {
        Iterable $this$partition$iv = names;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl;
            block5: {
                String name = (String)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = this.initNames;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)name)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List otherNames = (List)pair.component2();
        $this$putOrderFor.putOrder(otherNames, order);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAvailableInputs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.inputs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueInfo valueInfo = (ValueInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Tensor prepareInput(@NotNull String name, @NotNull List<? extends Object> value) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            Iterable iterable = this.inputs;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ValueInfo it = (ValueInfo)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ValueInfo valueInfo = v0;
        TensorProto.DataType dataType = valueInfo != null ? valueInfo.getType() : null;
        if (dataType == null) {
            Intrinsics.throwNpe();
        }
        TensorProto.DataType type = dataType;
        return Tensor.Companion.invoke$inference(value, type);
    }

    @NotNull
    public final Tensor prepareInput(@NotNull TensorProto proto) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
        Map<String, Integer> map = this.dividerByName;
        String string = proto.getName();
        boolean bl = false;
        Integer n = map.get(string);
        int divider = n != null ? n : 1;
        return Tensor.Companion.create(proto, divider);
    }

    @NotNull
    public final Tensor prepareInput(@NotNull List<? extends Object> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        boolean bl = this.inputs.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Multiple input nodes found. Specify input name explicitly";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String name = ((ValueInfo)CollectionsKt.single(this.inputs)).getName();
        return this.prepareInput(name, value);
    }

    private final void cleanupUntilOrder(@NotNull Context $this$cleanupUntilOrder, int order) {
        $this$cleanupUntilOrder.removeValues((Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this, order){
            final /* synthetic */ Graph this$0;
            final /* synthetic */ int $order;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Graph.access$getValueOrderInfo$p(this.this$0).getOrder(it) <= this.$order;
            }
            {
                this.this$0 = graph;
                this.$order = n;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ONNXData> execute(@NotNull List<? extends ONNXData> inputs, @Nullable Context root) {
        void $this$mapTo$iv$iv;
        Object first$iv;
        ArrayList<Object> arrayList;
        Object object;
        Intrinsics.checkParameterIsNotNull(inputs, (String)"inputs");
        Context context = new Context(root);
        for (Tensor tensor : this.initializers) {
            context.putValue(tensor.getInfo().getName(), tensor);
        }
        for (ONNXData oNNXData : inputs) {
            if (!this.getAvailableInputs().contains(oNNXData.getInfo().getName())) {
                logger.warn("Input node '" + oNNXData.getInfo().getName() + "' not found in Graph and probably is excessive");
                continue;
            }
            context.putValue(oNNXData.getInfo().getName(), oNNXData);
        }
        boolean bl = false;
        for (Operator operator : (Iterable)this.operators) {
            int n;
            void $this$zip$iv;
            void var4_10;
            Collection<ONNXData> collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Iterable iterable = operator.getInputs();
            object = context;
            arrayList = operator;
            boolean $i$f$map = false;
            void var10_19 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void input2;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                CharSequence charSequence = (CharSequence)input2;
                boolean bl3 = false;
                ONNXData oNNXData = charSequence.length() == 0 ? null : context.getValue((String)input2);
                collection.add(oNNXData);
            }
            collection = (List)destination$iv$iv;
            List outputs = ((Operator)((Object)arrayList)).applyWithCheck((Context)object, collection);
            this.cleanupUntilOrder(context, (int)var4_10);
            $this$map$iv = outputs;
            Iterable other$iv = operator.getOutputs();
            boolean $i$f$zip = false;
            first$iv = $this$zip$iv.iterator();
            Iterator second$iv = other$iv.iterator();
            int n2 = CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10);
            int n3 = CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10);
            boolean bl4 = false;
            int n4 = n = Math.min(n2, n3);
            ArrayList<Object> list$iv = new ArrayList<Object>(n4);
            while (first$iv.hasNext() && second$iv.hasNext()) {
                boolean bl5;
                CharSequence charSequence;
                void variable;
                void output;
                String string = (String)second$iv.next();
                ONNXData oNNXData = (ONNXData)first$iv.next();
                arrayList = list$iv;
                boolean bl42 = false;
                if (output == null) {
                    charSequence = (CharSequence)variable;
                    bl5 = false;
                    boolean bl6 = charSequence.length() == 0;
                    bl5 = false;
                    boolean bl7 = false;
                    if (!bl6) {
                        boolean bl72 = false;
                        String string2 = "Required output '" + (String)variable + "' not provided by '" + operator.getInfo().getName() + "' operator";
                        throw (Throwable)new IllegalArgumentException(string2.toString());
                    }
                }
                charSequence = (CharSequence)variable;
                bl5 = false;
                if (charSequence.length() > 0) {
                    void v0 = output;
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    context.putValue((String)variable, v0.rename((String)variable));
                }
                object = Unit.INSTANCE;
                arrayList.add(object);
            }
            ++var4_10;
        }
        Iterable iterable = this.outputs;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            first$iv = (ValueInfo)item$iv$iv;
            arrayList = destination$iv$iv;
            boolean bl8 = false;
            object = context.getValue(it.getName());
            arrayList.add(object);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List execute$default(Graph graph, List list, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        return graph.execute(list, context);
    }

    /*
     * WARNING - void declaration
     */
    public Graph(@NotNull GraphProto proto) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean ready;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv32322;
        Iterable $this$mapTo$iv$iv3;
        Object object;
        boolean bl;
        Object object2;
        Iterable $this$mapTo$iv$iv32;
        Iterable $this$map$iv2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
        Iterable iterable = proto.getInput();
        Object object3 = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv32) {
            ValueInfoProto valueInfoProto = (ValueInfoProto)((Object)item$iv$iv);
            object2 = destination$iv$iv;
            bl = false;
            object = ValueInfo.Companion.create(valueInfoProto);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        ((Graph)object3).inputs = object2;
        $this$map$iv2 = proto.getOutput();
        object3 = this;
        $i$f$map = false;
        $this$mapTo$iv$iv32 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            ValueInfoProto valueInfoProto = (ValueInfoProto)((Object)item$iv$iv);
            object2 = destination$iv$iv;
            bl = false;
            object = ValueInfo.Companion.create(valueInfoProto);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        ((Graph)object3).outputs = object2;
        $this$map$iv2 = proto.getValue_info();
        object3 = this;
        $i$f$map = false;
        $this$mapTo$iv$iv3 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            ValueInfoProto valueInfoProto = (ValueInfoProto)((Object)item$iv$iv);
            object2 = destination$iv$iv;
            bl = false;
            object = ValueInfo.Companion.create(valueInfoProto);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        ((Graph)object3).info = object2;
        this.valueOrderInfo = new GraphValueOrderInfo();
        $this$map$iv2 = proto.getInitializer();
        object3 = this;
        boolean $i$f$map42 = false;
        $this$mapTo$iv$iv3 = $this$map$iv2;
        Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv32322) {
            TensorProto tensorProto = (TensorProto)((Object)item$iv$iv);
            object2 = destination$iv$iv32;
            bl = false;
            object = tensorProto.getName();
            object2.add(object);
        }
        object2 = (List)destination$iv$iv32;
        ((Graph)object3).initNames = object2;
        this.operators = new ArrayList(proto.getNode().size());
        HashMap<String, Node> $i$f$map42 = new HashMap<String, Node>();
        boolean $this$mapTo$iv$iv32322 = false;
        boolean destination$iv$iv32 = false;
        HashMap<String, Node> $this$apply232 = $i$f$map42;
        boolean bl2 = false;
        for (NodeProto nodeProto : proto.getNode()) {
            Node node = new Node(nodeProto, false, 2, null);
            for (String string : nodeProto.getOutput()) {
                $this$apply232.put(string, node);
            }
        }
        HashMap<String, Node> nodes = $i$f$map42;
        Stack<Node> $this$mapTo$iv$iv32322 = new Stack<Node>();
        destination$iv$iv32 = false;
        boolean $this$apply232 = false;
        Stack<Node> $this$apply = $this$mapTo$iv$iv32322;
        boolean $i$a$-apply-Graph$stack$232 = false;
        for (ValueInfoProto output : proto.getOutput()) {
            Node node;
            String name;
            if (output.getName() == null) {
                Intrinsics.throwNpe();
            }
            CharSequence charSequence = name;
            boolean bl3 = false;
            if (!(charSequence.length() > 0) || (node = (Node)nodes.get(name)) == null) continue;
            $this$apply.push(node);
        }
        Stack<Node> stack = $this$mapTo$iv$iv32322;
        int order = 0;
        Iterable $this$map$iv22 = this.outputs;
        boolean $i$f$map3 = false;
        Iterable $i$a$-apply-Graph$stack$232 = $this$map$iv22;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo2 = false;
        for (String string : $this$mapTo$iv$iv2) {
            void it2;
            ValueInfo valueInfo = (ValueInfo)((Object)string);
            object3 = collection;
            boolean bl3 = false;
            object2 = it2.getName();
            object3.add(object2);
        }
        List outputNames = (List)collection;
        while (true) {
            $this$map$iv22 = stack;
            $i$f$map3 = false;
            if (!(!$this$map$iv22.isEmpty())) break;
            Node node232 = (Node)stack.peek();
            if (!node232.getVisited()) {
                ready = true;
                for (String input232 : node232.getDependencies()) {
                    Node next = (Node)nodes.get(input232);
                    if (next == null || next.getVisited()) continue;
                    ready = false;
                    stack.push(next);
                }
                if (!ready) continue;
                node232.setVisited(true);
                stack.pop();
                ((ArrayList)this.operators).add(OperatorFactory.INSTANCE.create(node232.getProto()));
                this.putOrderFor(this.valueOrderInfo, SetsKt.minus(node232.getDependencies(), (Iterable)outputNames), order);
                ++order;
                continue;
            }
            stack.pop();
        }
        boolean node232 = this.operators.size() == proto.getNode().size();
        ready = false;
        boolean input232 = false;
        input232 = false;
        boolean bl4 = false;
        if (!node232) {
            boolean next = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object node232 = new HashMap<String, Integer>();
        object3 = this;
        ready = false;
        input232 = false;
        HashMap<String, Integer> hashMap = node232;
        boolean bl42 = false;
        for (Operator operator : (ArrayList)this.operators) {
            if (Intrinsics.areEqual((Object)operator.getInfo().getName(), (Object)"Attention") || Intrinsics.areEqual((Object)operator.getInfo().getName(), (Object)"QAttention")) {
                Attribute<Object> attribute2 = operator.getAttributes().get("num_heads");
                if (attribute2 == null) {
                    Intrinsics.throwNpe();
                }
                Object object4 = attribute2.getValue();
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                }
                int numHeads2 = (int)((Long)object4).longValue();
                for (IOInfo input : operator.getInfo().getInputs()) {
                    int n = input.getIndex();
                    if (0 > n || ((Collection)operator.getInputs()).size() <= n) continue;
                    String name = operator.getInputs().get(input.getIndex());
                    if (Intrinsics.areEqual((Object)input.getName(), (Object)"weight") || Intrinsics.areEqual((Object)input.getName(), (Object)"bias")) {
                        hashMap.put(name, input.getDivider() * numHeads2);
                        continue;
                    }
                    hashMap.put(name, input.getDivider());
                }
                continue;
            }
            for (IOInfo input : operator.getInfo().getInputs()) {
                int bl3 = input.getIndex();
                if (0 > bl3 || ((Collection)operator.getInputs()).size() <= bl3) continue;
                String name = operator.getInputs().get(input.getIndex());
                hashMap.put(name, input.getDivider());
            }
        }
        object2 = node232;
        ((Graph)object3).dividerByName = (Map)object2;
        node232 = proto.getInitializer();
        object3 = this;
        boolean $i$f$map2 = false;
        void input232 = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (String string : $this$mapTo$iv$iv) {
            void it3;
            TensorProto input = (TensorProto)((Object)string);
            object2 = collection2;
            boolean bl5 = false;
            Map<String, Integer> map = this.dividerByName;
            String string2 = it3.getName();
            boolean bl6 = false;
            Integer n = (Integer)map.get(string2);
            int divider = n != null ? n : 1;
            object = Tensor.Companion.create((TensorProto)it3, divider);
            object2.add(object);
        }
        ((Graph)object3).initializers = object2 = (List)collection2;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(Graph.class);
    }

    public static final /* synthetic */ GraphValueOrderInfo access$getValueOrderInfo$p(Graph $this) {
        return $this.valueOrderInfo;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0003H\u0002R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lio/kinference/graph/Graph$Node;", "", "proto", "Lio/kinference/onnx/NodeProto;", "visited", "", "(Lio/kinference/onnx/NodeProto;Z)V", "dependencies", "", "", "getDependencies", "()Ljava/util/Set;", "dependencies$delegate", "Lkotlin/Lazy;", "getProto", "()Lio/kinference/onnx/NodeProto;", "getVisited", "()Z", "setVisited", "(Z)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "collectRequiredInputs", "inference"})
    private static final class Node {
        @NotNull
        private final Lazy dependencies$delegate;
        @NotNull
        private final NodeProto proto;
        private boolean visited;

        /*
         * WARNING - void declaration
         */
        private final Set<String> collectRequiredInputs(@NotNull NodeProto $this$collectRequiredInputs) {
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = false;
            boolean bl2 = false;
            HashSet<String> $this$apply = hashSet;
            boolean bl3 = false;
            for (String variable : $this$collectRequiredInputs.getInput()) {
                CharSequence charSequence = variable;
                boolean bl4 = false;
                if (!(charSequence.length() > 0)) continue;
                $this$apply.add(variable);
            }
            for (AttributeProto attr : $this$collectRequiredInputs.getAttribute()) {
                void $this$flatMapTo$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable $this$flatMapTo$iv2;
                Object object;
                Collection collection;
                Object item$iv2;
                void $this$mapTo$iv;
                if (attr.getType() != AttributeProto.AttributeType.GRAPH) continue;
                GraphProto graphProto = attr.getG();
                if (graphProto == null) {
                    Intrinsics.throwNpe();
                }
                Iterable iterable = graphProto.getInput();
                Iterable destination$iv = new HashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv2 : $this$mapTo$iv) {
                    void it;
                    ValueInfoProto valueInfoProto = (ValueInfoProto)((Object)item$iv2);
                    collection = destination$iv;
                    boolean bl5 = false;
                    if (it.getName() == null) {
                        Intrinsics.throwNpe();
                    }
                    collection.add(object);
                }
                HashSet subGraphInputs = (HashSet)destination$iv;
                destination$iv = attr.getG().getNode();
                Collection destination$iv2 = new HashSet();
                boolean $i$f$flatMapTo22 = false;
                item$iv2 = $this$flatMapTo$iv2.iterator();
                while (item$iv2.hasNext()) {
                    Object element$iv = item$iv2.next();
                    NodeProto it = (NodeProto)((Object)element$iv);
                    boolean bl6 = false;
                    Iterable list$iv = this.collectRequiredInputs(it);
                    CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
                }
                HashSet subGraphLocalInputs = (HashSet)destination$iv2;
                $this$flatMapTo$iv2 = attr.getG().getOutput();
                collection = subGraphInputs;
                boolean $i$f$map22 = false;
                void $i$f$flatMapTo22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string;
                    void it;
                    ValueInfoProto valueInfoProto = (ValueInfoProto)((Object)item$iv$iv);
                    object = destination$iv$iv;
                    boolean bl7 = false;
                    if (it.getName() == null) {
                        Intrinsics.throwNpe();
                    }
                    object.add(string);
                }
                object = (List)destination$iv$iv;
                ((AbstractCollection)collection).addAll((Collection)object);
                Iterable $i$f$map22 = attr.getG().getNode();
                Collection destination$iv3 = new HashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    NodeProto it = (NodeProto)((Object)element$iv);
                    boolean bl8 = false;
                    Iterable list$iv = it.getOutput();
                    CollectionsKt.addAll((Collection)destination$iv3, (Iterable)list$iv);
                }
                HashSet subGraphLocalOutputs = (HashSet)destination$iv3;
                $this$apply.addAll(SetsKt.minus((Set)SetsKt.minus((Set)subGraphLocalInputs, (Iterable)subGraphLocalOutputs), (Iterable)subGraphInputs));
            }
            return hashSet;
        }

        @NotNull
        public final Set<String> getDependencies() {
            Lazy lazy = this.dependencies$delegate;
            Node node = this;
            Object var3_3 = null;
            boolean bl = false;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final NodeProto getProto() {
            return this.proto;
        }

        public final boolean getVisited() {
            return this.visited;
        }

        public final void setVisited(boolean bl) {
            this.visited = bl;
        }

        public Node(@NotNull NodeProto proto, boolean visited) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
            this.proto = proto;
            this.visited = visited;
            this.dependencies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
                final /* synthetic */ Node this$0;

                @NotNull
                public final Set<String> invoke() {
                    return Node.access$collectRequiredInputs(this.this$0, this.this$0.getProto());
                }
                {
                    this.this$0 = node;
                    super(0);
                }
            }));
        }

        public /* synthetic */ Node(NodeProto nodeProto, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(nodeProto, bl);
        }

        public static final /* synthetic */ Set access$collectRequiredInputs(Node $this, NodeProto $this$access_u24collectRequiredInputs) {
            return $this.collectRequiredInputs($this$access_u24collectRequiredInputs);
        }

        @NotNull
        public final NodeProto component1() {
            return this.proto;
        }

        public final boolean component2() {
            return this.visited;
        }

        @NotNull
        public final Node copy(@NotNull NodeProto proto, boolean visited) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
            return new Node(proto, visited);
        }

        public static /* synthetic */ Node copy$default(Node node, NodeProto nodeProto, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                nodeProto = node.proto;
            }
            if ((n & 2) != 0) {
                bl = node.visited;
            }
            return node.copy(nodeProto, bl);
        }

        @NotNull
        public String toString() {
            return "Node(proto=" + (Object)((Object)this.proto) + ", visited=" + this.visited + ")";
        }

        public int hashCode() {
            NodeProto nodeProto = this.proto;
            int n = (nodeProto != null ? ((Object)((Object)nodeProto)).hashCode() : 0) * 31;
            int n2 = this.visited ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Node)) break block3;
                    Node node = (Node)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.proto), (Object)((Object)node.proto)) || this.visited != node.visited) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/kinference/graph/Graph$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "inference"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

