/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.attributes;

import io.kinference.attributes.Attribute$Companion$WhenMappings;
import io.kinference.data.tensors.Tensor;
import io.kinference.graph.Graph;
import io.kinference.onnx.AttributeProto;
import io.kinference.onnx.GraphProto;
import io.kinference.onnx.TensorProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u0014*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/kinference/attributes/Attribute;", "T", "", "proto", "Lio/kinference/onnx/AttributeProto;", "value", "(Lio/kinference/onnx/AttributeProto;Ljava/lang/Object;)V", "name", "", "getName", "()Ljava/lang/String;", "refAttrName", "getRefAttrName", "type", "Lio/kinference/onnx/AttributeProto$AttributeType;", "getType", "()Lio/kinference/onnx/AttributeProto$AttributeType;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "Companion", "inference"})
public final class Attribute<T> {
    @NotNull
    private final String name;
    @NotNull
    private final AttributeProto.AttributeType type;
    @Nullable
    private final String refAttrName;
    private final T value;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final AttributeProto.AttributeType getType() {
        return this.type;
    }

    @Nullable
    public final String getRefAttrName() {
        return this.refAttrName;
    }

    public final T getValue() {
        return this.value;
    }

    public Attribute(@NotNull AttributeProto proto, T value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
        this.value = value;
        String string = proto.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.name = string;
        AttributeProto.AttributeType attributeType = proto.getType();
        if (attributeType == null) {
            Intrinsics.throwNpe();
        }
        this.type = attributeType;
        this.refAttrName = proto.getRef_attr_name();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/kinference/attributes/Attribute$Companion;", "", "()V", "create", "Lio/kinference/attributes/Attribute;", "proto", "Lio/kinference/onnx/AttributeProto;", "inference"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Attribute<Object> create(@NotNull AttributeProto proto) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)proto), (String)"proto");
            AttributeProto.AttributeType attributeType = proto.getType();
            if (attributeType != null) {
                switch (Attribute$Companion$WhenMappings.$EnumSwitchMapping$0[attributeType.ordinal()]) {
                    case 1: {
                        Float f = proto.getF();
                        if (f == null) {
                            Intrinsics.throwNpe();
                        }
                        Attribute<List> attribute2 = new Attribute<List>(proto, (List)((Object)f));
                        return attribute2;
                    }
                    case 2: {
                        Long l = proto.getI();
                        if (l == null) {
                            Intrinsics.throwNpe();
                        }
                        Attribute<List> attribute2 = new Attribute<Long>(proto, l);
                        return attribute2;
                    }
                    case 3: {
                        ByteString byteString = proto.getS();
                        if (byteString == null) {
                            Intrinsics.throwNpe();
                        }
                        Attribute<List> attribute2 = new Attribute<String>(proto, byteString.utf8());
                        return attribute2;
                    }
                    case 4: {
                        TensorProto tensorProto = proto.getT();
                        if (tensorProto == null) {
                            Intrinsics.throwNpe();
                        }
                        Attribute<List> attribute2 = new Attribute<Tensor>(proto, Tensor.Companion.create$default(Tensor.Companion, tensorProto, 0, 2, null));
                        return attribute2;
                    }
                    case 5: {
                        GraphProto graphProto = proto.getG();
                        if (graphProto == null) {
                            Intrinsics.throwNpe();
                        }
                        Attribute<List> attribute2 = new Attribute<Graph>(proto, new Graph(graphProto));
                        return attribute2;
                    }
                    case 6: {
                        String string = "Not supported in current version of MPP Inference";
                        boolean bl = false;
                        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                    }
                    case 7: {
                        Attribute<List> attribute2 = new Attribute<List<Float>>(proto, proto.getFloats());
                        return attribute2;
                    }
                    case 8: {
                        Attribute<List> attribute2 = new Attribute<List<Long>>(proto, proto.getInts());
                        return attribute2;
                    }
                    case 9: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Attribute<List> attribute2;
                        Iterable iterable = proto.getStrings();
                        AttributeProto attributeProto = proto;
                        boolean $i$f$map = false;
                        void var4_17 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (true) {
                            void it;
                            Collection<String> collection;
                            if (!iterator.hasNext()) {
                                collection = (List)destination$iv$iv;
                                List list = collection;
                                AttributeProto attributeProto2 = attributeProto;
                                attribute2 = new Attribute<List>(attributeProto2, list);
                                return attribute2;
                            }
                            Object item$iv$iv = iterator.next();
                            ByteString byteString = (ByteString)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it.utf8();
                            collection.add(string);
                        }
                    }
                    case 10: {
                        Attribute<List> attribute2;
                        Iterable $this$map$iv = proto.getTensors();
                        AttributeProto attributeProto = proto;
                        boolean $i$f$map = false;
                        Iterable $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (true) {
                            Collection<Tensor> collection;
                            if (!iterator.hasNext()) {
                                collection = (List)destination$iv$iv;
                                List list = collection;
                                AttributeProto attributeProto3 = attributeProto;
                                attribute2 = new Attribute<List>(attributeProto3, list);
                                return attribute2;
                            }
                            Object item$iv$iv = iterator.next();
                            TensorProto it = (TensorProto)((Object)item$iv$iv);
                            collection = destination$iv$iv;
                            boolean bl = false;
                            Tensor tensor = Tensor.Companion.create$default(Tensor.Companion, it, 0, 2, null);
                            collection.add(tensor);
                        }
                    }
                    case 11: {
                        Attribute<List> attribute2;
                        Iterable $this$map$iv = proto.getGraphs();
                        AttributeProto attributeProto = proto;
                        boolean $i$f$map = false;
                        Iterable $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (true) {
                            Collection<Graph> collection;
                            if (!iterator.hasNext()) {
                                collection = (List)destination$iv$iv;
                                List list = collection;
                                AttributeProto attributeProto4 = attributeProto;
                                attribute2 = new Attribute<List>(attributeProto4, list);
                                return attribute2;
                            }
                            Object item$iv$iv = iterator.next();
                            GraphProto it = (GraphProto)((Object)item$iv$iv);
                            collection = destination$iv$iv;
                            boolean bl = false;
                            Graph graph = new Graph(it);
                            collection.add(graph);
                        }
                    }
                    case 12: {
                        String string = "Not supported in current version of MPP Inference";
                        boolean bl = false;
                        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                    }
                }
            }
            String string = "Unsupported attribute type";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

