/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.junit4.JUnitTestTreeNodeManager;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import org.junit.runner.Description;

public class CucumberTestTreeNodeManager
implements JUnitTestTreeNodeManager {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_COLON_PREFIX = "file:";
    private static final String FILE_URL_PREFIX = "file://";

    public JUnitTestTreeNodeManager.TestNodePresentation getRootNodePresentation(String fullName) {
        return new JUnitTestTreeNodeManager.TestNodePresentation(fullName, null);
    }

    public String getNodeName(String fqName, boolean splitBySlash) {
        return fqName;
    }

    public String getTestLocation(Description description, String className, String methodName) {
        try {
            String elementUrl;
            Field descriptionField = Description.class.getDeclaredField("fUniqueId");
            descriptionField.setAccessible(true);
            String elementSMUrl = elementUrl = descriptionField.get(description).toString();
            if (elementUrl.startsWith(CLASSPATH_PREFIX)) {
                int colonIndex = (elementUrl = elementUrl.substring(CLASSPATH_PREFIX.length())).lastIndexOf(":");
                if (colonIndex < 0) {
                    return "";
                }
                int lineNumber = Integer.parseInt(elementUrl.substring(colonIndex + 1));
                elementUrl = elementUrl.substring(0, colonIndex);
                URL url = this.getClass().getResource("/" + elementUrl);
                if (url == null) {
                    return "";
                }
                elementSMUrl = FILE_URL_PREFIX + url.getFile() + ":" + lineNumber;
            } else if (elementUrl.startsWith(FILE_COLON_PREFIX)) {
                elementUrl = elementUrl.substring(FILE_COLON_PREFIX.length());
                elementUrl = System.getProperty("user.dir") + File.separator + elementUrl;
                elementSMUrl = FILE_URL_PREFIX + elementUrl;
            }
            return "locationHint='" + MapSerializerUtil.escapeStr((String)elementSMUrl, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER) + "'";
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return "";
    }
}

