/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class CucumberJvmSMFormatterUtil {
    public static final String TEAMCITY_PREFIX = "##teamcity";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    public static final String FILE_RESOURCE_PREFIX = "file://";
    public static final String TEMPLATE_TEST_STARTED = "##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']";
    public static final String TEMPLATE_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' name = '%s' %s]";
    public static final String TEMPLATE_COMPARISON_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' expected='%s' actual='%s' name = '%s' %s]";
    public static final String TEMPLATE_SCENARIO_FAILED = "##teamcity[customProgressStatus timestamp='%s' type='testFailed']";
    public static final String TEMPLATE_TEST_PENDING = "##teamcity[testIgnored name = '%s' message = 'Skipped step' timestamp = '%s']";
    public static final String TEMPLATE_TEST_FINISHED = "##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']";
    public static final String TEMPLATE_ENTER_THE_MATRIX = "##teamcity[enteredTheMatrix timestamp = '%s']";
    public static final String TEMPLATE_TEST_SUITE_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']";
    public static final String TEMPLATE_TEST_SUITE_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = '%s']";
    public static final String TEMPLATE_SCENARIO_COUNTING_STARTED = "##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '%s' timestamp = '%s']";
    public static final String TEMPLATE_SCENARIO_COUNTING_FINISHED = "##teamcity[customProgressStatus testsCategory = '' count = '0' timestamp = '%s']";
    public static final String TEMPLATE_SCENARIO_STARTED = "##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']";
    public static final String TEMPLATE_SCENARIO_FINISHED = "##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']";

    public static String getCurrentTime() {
        return DATE_FORMAT.format(new Date());
    }

    private static String escape(String source) {
        if (source == null) {
            return "";
        }
        return source.replace("|", "||").replace("\n", "|n").replace("\r", "|r").replace("'", "|'").replace("]", "|]");
    }

    public static String escapeCommand(String command, String ... parameters) {
        String[] escapedParameters = new String[parameters.length];
        for (int i = 0; i < escapedParameters.length; ++i) {
            escapedParameters[i] = CucumberJvmSMFormatterUtil.escape(parameters[i]);
        }
        return String.format(command, escapedParameters);
    }

    public static String getFeatureName(String featureHeader) {
        String[] lines;
        for (String line : lines = featureHeader.split("\n")) {
            int i;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || line.charAt(0) == '@' || (i = featureHeader.indexOf(":")) < 0) continue;
            return line;
        }
        return featureHeader;
    }

    public static String getStepKeyword(String filePath, int lineNumber) throws IOException {
        String line = CucumberJvmSMFormatterUtil.readLineWithNumber(filePath, lineNumber);
        if (line != null) {
            return line.trim().split(" ", 2)[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLineWithNumber(String filePath, int lineNumber) throws IOException {
        int currentLineNumber = 0;
        FileReader fileStream = null;
        try {
            String line;
            fileStream = new FileReader(filePath);
            BufferedReader bufferedReader = new BufferedReader(fileStream);
            while ((line = bufferedReader.readLine()) != null) {
                if (++currentLineNumber != lineNumber) continue;
                String string = line;
                return string;
            }
        }
        finally {
            if (fileStream != null) {
                fileStream.close();
            }
        }
        return null;
    }
}

