/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.api.formatter.Formatter;
import java.io.PrintStream;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvm2Adapter;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMConverter;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestSourceReadEvent;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmWriteEvent;

public class CucumberJvm2SMFormatter
extends CucumberJvmSMConverter
implements Formatter {
    private final EventHandler<TestCaseStarted> testCaseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            CucumberJvm2SMFormatter.this.handleTestCaseStarted(new CucumberJvm2Adapter.CucumberJvmTestCase(event.testCase));
        }
    };
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            CucumberJvm2SMFormatter.this.handleTestCaseFinished(new CucumberJvm2Adapter.CucumberJvmTestCase(event.testCase));
        }
    };
    private final EventHandler<TestRunFinished> testRunFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            CucumberJvm2SMFormatter.this.handleTestRunFinished();
        }
    };
    private final EventHandler<WriteEvent> writeEventHandler = new EventHandler<WriteEvent>(){

        public void receive(WriteEvent event) {
            CucumberJvm2SMFormatter.this.handleWriteEvent(new CucumberJvmWriteEvent(event.text));
        }
    };
    private final EventHandler<TestStepStarted> testStepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            CucumberJvm2SMFormatter.this.handleTestStepStarted(new CucumberJvm2Adapter.CucumberJvmTestStep(event.testStep));
        }
    };
    private final EventHandler<TestStepFinished> testStepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            CucumberJvm2SMFormatter.this.handleTestStepFinished(new CucumberJvm2Adapter.CucumberJvmTestStepFinishedEvent(event));
        }
    };
    private final EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            CucumberJvm2SMFormatter.this.handleTestSourceRead(new CucumberJvmTestSourceReadEvent(event.uri, event.source));
        }
    };

    public CucumberJvm2SMFormatter() {
        this(System.out, null);
    }

    public CucumberJvm2SMFormatter(PrintStream out, String currentTimeValue) {
        super(out, currentTimeValue);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.testRunFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
    }
}

