/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.providers;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ws.rest.model.jam.RSHttpMappingInfo;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RsUrlPathSpecification;
import com.intellij.ws.rest.providers.RSHttpUrlResolver;
import com.intellij.ws.rest.providers.RSUrlTargetInfo;
import com.intellij.ws.rest.utils.RSUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="JEE RESTful WS Server", icon="JavaUltimateIcons.Web.RequestMapping")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ws/rest/providers/RSHttpUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.javaee.jax.rs"})
public final class RSHttpUrlResolver
extends HttpUrlResolver {
    private final Project myProject;

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(myProject).modules");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<Module, Sequence<? extends RSUrlTargetInfo>>(this, request){
            final /* synthetic */ RSHttpUrlResolver this$0;
            final /* synthetic */ UrlResolveRequest $request;

            @NotNull
            public final Sequence<RSUrlTargetInfo> invoke(Module module) {
                return SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(this.$request.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends RSUrlTargetInfo>>(this, module){
                    final /* synthetic */ resolve.1 this$0;
                    final /* synthetic */ Module $module;

                    @NotNull
                    public final Sequence<RSUrlTargetInfo> invoke(@NotNull UrlPath path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        Module module = this.$module;
                        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
                        return SequencesKt.map(RSJamModel.resolvePaths(module, path), (Function1)((Function1)new Function1<RSHttpMappingInfo, RSUrlTargetInfo>(this){
                            final /* synthetic */ resolve.1 this$0;

                            @NotNull
                            public final RSUrlTargetInfo invoke(@NotNull RSHttpMappingInfo resolved) {
                                Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
                                return new RSUrlTargetInfo(this.this$0.this$0.this$0.getSupportedSchemes(), RsUrlPathSpecification.INSTANCE.parsePath(RSUtils.getResourcePath(resolved.getMapping())), resolved, null, 8, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$module = module;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = rSHttpUrlResolver;
                this.$request = urlResolveRequest;
                super(1);
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(myProject).modules");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<Module, Sequence<? extends RSUrlTargetInfo>>(this){
            final /* synthetic */ RSHttpUrlResolver this$0;

            @NotNull
            public final Sequence<RSUrlTargetInfo> invoke(Module module) {
                Module module2 = module;
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                Project project = module2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(true);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"module.getModuleWithDepe\u2026esAndLibrariesScope(true)");
                return SequencesKt.map(RSJamModel.getServerPsiMethodPaths(project, globalSearchScope), (Function1)((Function1)new Function1<RSHttpMappingInfo, RSUrlTargetInfo>(this){
                    final /* synthetic */ getVariants.1 this$0;

                    @NotNull
                    public final RSUrlTargetInfo invoke(@NotNull RSHttpMappingInfo rsHttpMethod) {
                        Intrinsics.checkNotNullParameter((Object)rsHttpMethod, (String)"rsHttpMethod");
                        UrlPath urlPath = RsUrlPathSpecification.INSTANCE.parsePath(RSUtils.getResourcePath(rsHttpMethod));
                        return new RSUrlTargetInfo(this.this$0.this$0.getSupportedSchemes(), urlPath, rsHttpMethod, null, 8, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = rSHttpUrlResolver;
                super(1);
            }
        })));
    }

    public RSHttpUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ws/rest/providers/RSHttpUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jax.rs"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return RSUtils.hasRestLibrary(project) ? (UrlResolver)new RSHttpUrlResolver(project) : null;
        }
    }
}

