/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.ws.rest.RSBundle;
import org.jetbrains.annotations.NotNull;

public class CreateMethodParamWithPathParamFix
implements LocalQuickFix {
    private final String myName;
    private final PsiMethod myMethod;

    public CreateMethodParamWithPathParamFix(String name, PsiMethod method) {
        this.myName = name;
        this.myMethod = method;
    }

    @NotNull
    public String getFamilyName() {
        String string = RSBundle.message("create.method.parameter", new Object[0]);
        if (string == null) {
            CreateMethodParamWithPathParamFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CreateMethodParamWithPathParamFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            CreateMethodParamWithPathParamFix.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiParameterList parameterList = this.myMethod.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiElement lastChild = parameterList.getLastChild();
            if (lastChild == null) {
                return;
            }
            int offset = lastChild.getTextOffset();
            String start = parameters.length == 0 ? "" : ", ";
            String template = start + "@PathParam(\"" + this.myName + "\") $type$ $name$";
            PsiFile psiFile = this.myMethod.getContainingFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            OpenFileDescriptor descriptor1 = new OpenFileDescriptor(project, virtualFile, offset);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor1, true);
            if (editor == null) {
                return;
            }
            Template temp = TemplateManager.getInstance((Project)project).createTemplate("", "", template);
            temp.addVariable("type", "\"String\"", "String", true);
            temp.addVariable("name", "\"" + this.myName + "\"", this.myName, true);
            TemplateManager.getInstance((Project)project).startTemplate(editor, "", temp);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/fixes/CreateMethodParamWithPathParamFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/fixes/CreateMethodParamWithPathParamFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

