/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.constants.RSClassConstants;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestParamTypeInspection
extends AbstractRestJavaInspection {
    private static final String[] PARAM_ANNOTATIONS = new String[]{RSAnnotations.PATH_PARAM.javax(), RSAnnotations.QUERY_PARAM.javax(), RSAnnotations.MATRIX_PARAM.javax(), RSAnnotations.HEADER_PARAM.javax(), RSAnnotations.FORM_PARAM.javax(), RSAnnotations.COOKIE_PARAM.javax(), RSAnnotations.PATH_PARAM.jakarta(), RSAnnotations.QUERY_PARAM.jakarta(), RSAnnotations.MATRIX_PARAM.jakarta(), RSAnnotations.HEADER_PARAM.jakarta(), RSAnnotations.FORM_PARAM.jakarta(), RSAnnotations.COOKIE_PARAM.jakarta()};
    private static final JavaeeClass PARAM_CONVERTER_CLASSNAME = JavaeeClass.create((String)"javax.ws.rs.ext.ParamConverter");

    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            RestParamTypeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RestParamTypeInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RestParamTypeInspection.$$$reportNull$$$0(2);
        }
        for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            PsiIdentifier nameIdentifier;
            PsiType parameterType;
            PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (String[])PARAM_ANNOTATIONS);
            if (psiAnnotation == null || RestParamTypeInspection.acceptSimpleType(parameterType = parameter.getType(), module) || RestParamTypeInspection.acceptCollectionType(parameterType, module) || RestParamTypeInspection.acceptOptionalType(parameterType, module)) continue;
            JavaeeType javaeeType = JavaeeType.discover((Module)module, (JavaeeClass)RSAnnotations.PATH);
            if (RSAnnotations.PATH_PARAM.isFqn(psiAnnotation.getQualifiedName()) && RestParamTypeInspection.acceptPathSegmentType(parameterType, javaeeType) || RSAnnotations.COOKIE_PARAM.isFqn(psiAnnotation.getQualifiedName()) && RestParamTypeInspection.acceptCookieType(parameterType, javaeeType) || (nameIdentifier = parameter.getNameIdentifier()) == null) continue;
            holder.registerProblem((PsiElement)nameIdentifier, RSBundle.message("RestParamTypeInspection.incorrect.parameter.type", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static boolean acceptPathSegmentType(PsiType parameterType, @NotNull JavaeeType javaeeType) {
        PsiClass psiClass;
        if (javaeeType == null) {
            RestParamTypeInspection.$$$reportNull$$$0(3);
        }
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)RSClassConstants.PATH_SEGMENT.fqn(javaeeType))) {
                return true;
            }
            PsiType itType = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.util.Collection", (int)0, (boolean)false);
            return itType != null && RestParamTypeInspection.acceptPathSegmentType(itType, javaeeType);
        }
        return false;
    }

    private static boolean acceptCookieType(PsiType parameterType, @NotNull JavaeeType javaeeType) {
        PsiClass psiClass;
        if (javaeeType == null) {
            RestParamTypeInspection.$$$reportNull$$$0(4);
        }
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)RSClassConstants.COOKIE.fqn(javaeeType));
        }
        return false;
    }

    private static boolean acceptCollectionType(@NotNull PsiType parameterType, @NotNull Module module) {
        if (parameterType == null) {
            RestParamTypeInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            RestParamTypeInspection.$$$reportNull$$$0(6);
        }
        if (parameterType instanceof PsiClassType) {
            PsiType itType = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.util.Collection", (int)0, (boolean)false);
            return itType != null && RestParamTypeInspection.acceptSimpleType(itType, module);
        }
        return false;
    }

    private static boolean acceptOptionalType(@NotNull PsiType parameterType, @NotNull Module module) {
        if (parameterType == null) {
            RestParamTypeInspection.$$$reportNull$$$0(7);
        }
        if (module == null) {
            RestParamTypeInspection.$$$reportNull$$$0(8);
        }
        if (parameterType instanceof PsiClassType) {
            PsiType optionalType = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.util.Optional", (int)0, (boolean)false);
            return optionalType != null && RestParamTypeInspection.acceptSimpleType(optionalType, module);
        }
        return false;
    }

    private static boolean acceptSimpleType(@NotNull PsiType parameterType, @NotNull Module module) {
        PsiClass psiClass;
        if (parameterType == null) {
            RestParamTypeInspection.$$$reportNull$$$0(9);
        }
        if (module == null) {
            RestParamTypeInspection.$$$reportNull$$$0(10);
        }
        if (PsiType.CHAR.equals((Object)parameterType) || "java.lang.Character".equals(parameterType.getCanonicalText())) {
            return false;
        }
        if (parameterType instanceof PsiPrimitiveType) {
            return true;
        }
        if (PsiPrimitiveType.getUnboxedType((PsiType)parameterType) != null) {
            return true;
        }
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            if (psiClass.isEnum()) {
                return true;
            }
            if (RestParamTypeInspection.hasSingleStringConstructor(psiClass)) {
                return true;
            }
            if (RestParamTypeInspection.hasStaticMethod(psiClass, "valueOf")) {
                return true;
            }
            if (RestParamTypeInspection.hasStaticMethod(psiClass, "fromString")) {
                return true;
            }
            if (RestParamTypeInspection.hasParamConverter(psiClass, module)) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasParamConverter(@NotNull PsiClass aClass, @NotNull Module module) {
        if (aClass == null) {
            RestParamTypeInspection.$$$reportNull$$$0(11);
        }
        if (module == null) {
            RestParamTypeInspection.$$$reportNull$$$0(12);
        }
        for (PsiClass convertedClass : RestParamTypeInspection.getConvertedClasses(module)) {
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)convertedClass, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<PsiClass> getConvertedClasses(@NotNull Module module) {
        if (module == null) {
            RestParamTypeInspection.$$$reportNull$$$0(13);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(RestParamTypeInspection.getAllConvertedClasses(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.MODIFICATION_COUNT}));
        if (set == null) {
            RestParamTypeInspection.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public static Set<PsiClass> getAllConvertedClasses(@NotNull Module module) {
        if (module == null) {
            RestParamTypeInspection.$$$reportNull$$$0(15);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
        JavaeeType javaeeType = JavaeeType.discover((Module)module, (JavaeeClass)RSAnnotations.PATH);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(PARAM_CONVERTER_CLASSNAME.fqn(javaeeType), searchScope);
        if (psiClass == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                RestParamTypeInspection.$$$reportNull$$$0(16);
            }
            return set;
        }
        HashSet<PsiClass> convertedClasses = new HashSet<PsiClass>();
        ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), (boolean)true).forEach(inheritor -> {
            PsiType optionalType = PsiUtil.substituteTypeParameter((PsiType)PsiTypesUtil.getClassType((PsiClass)inheritor), (String)PARAM_CONVERTER_CLASSNAME.fqn(javaeeType), (int)0, (boolean)false);
            if (optionalType instanceof PsiClassType) {
                ContainerUtil.addIfNotNull((Collection)convertedClasses, (Object)((PsiClassType)optionalType).resolve());
            }
            return true;
        });
        HashSet<PsiClass> hashSet = convertedClasses;
        if (hashSet == null) {
            RestParamTypeInspection.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    private static boolean hasStaticMethod(@NotNull PsiClass psiClass, String methodName) {
        PsiMethod valueOf;
        if (psiClass == null) {
            RestParamTypeInspection.$$$reportNull$$$0(18);
        }
        return (valueOf = RestParamTypeInspection.getSingleStringParameterMethod(psiClass.findMethodsByName(methodName, true))) != null && valueOf.getModifierList().hasModifierProperty("static");
    }

    private static boolean hasSingleStringConstructor(PsiClass psiClass) {
        return RestParamTypeInspection.getSingleStringParameterMethod(psiClass.getConstructors()) != null;
    }

    @Nullable
    private static PsiMethod getSingleStringParameterMethod(PsiMethod[] methods) {
        for (PsiMethod method : methods) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1 || !"java.lang.String".equals(parameters[0].getType().getCanonicalText())) continue;
            return method;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/RestParamTypeInspection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/RestParamTypeInspection";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConvertedClasses";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConvertedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptPathSegmentType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptCookieType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptCollectionType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptOptionalType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptSimpleType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasParamConverter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedClasses";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllConvertedClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasStaticMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

