/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.ExternalProcessHandler;
import com.intellij.ws.common.InvokeExternalCodeUtil;
import com.intellij.ws.rest.RSBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class GenerateJavaFromWadlDialog
extends DialogWrapper {
    private ComboboxWithBrowseButton wadlUrl;
    private EditorComboBox packagePrefix;
    private ComboBox outputPathes;
    private final Project myProject;
    private final Module myModule;
    private final VirtualFile myWadl;

    GenerateJavaFromWadlDialog(Project project, Module module, VirtualFile wadl) {
        super(project);
        this.myProject = project;
        this.myModule = module;
        this.myWadl = wadl;
        this.setTitle(RSBundle.message("generate.java.from.wadl.action", new Object[0]));
        this.init();
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected JComponent createCenterPanel() {
        VirtualFile[] roots;
        String currentUrl;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2), 0, 0);
        panel.add((Component)new JLabel(RSBundle.message("generate.java.from.wadl.url", new Object[0])), gc);
        this.wadlUrl = new ComboboxWithBrowseButton();
        this.wadlUrl.getComboBox().setEditable(true);
        FileChooserDescriptor wadlDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return "wadl".equals(file.getExtension());
            }
        };
        this.wadlUrl.addBrowseFolderListener(RSBundle.message("generate.java.from.wadl.file.path", new Object[0]), null, this.myProject, wadlDescriptor, (TextComponentAccessor)new ComboboxTextAccessor());
        ArrayList<String> lastUrls = new ArrayList<String>();
        String string = currentUrl = this.myWadl != null ? this.myWadl.getUrl() : null;
        if (currentUrl != null && !lastUrls.contains(currentUrl)) {
            lastUrls.add(0, currentUrl);
        }
        GenerateJavaFromWadlDialog.configureComboBox(this.wadlUrl.getComboBox(), lastUrls);
        if (currentUrl != null) {
            this.wadlUrl.getComboBox().setSelectedItem(currentUrl);
        }
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.gridx = 1;
        panel.add((Component)this.wadlUrl, gc);
        this.outputPathes = new ComboBox();
        LinkedList<String> outputPathesList = new LinkedList<String>();
        for (VirtualFile root : roots = OrderEnumerator.orderEntries((Module)this.myModule).getAllSourceRoots()) {
            if (root.getExtension() != null || !root.isWritable()) continue;
            String presentableUrl = root.getPresentableUrl();
            outputPathesList.add(presentableUrl);
        }
        Collections.sort(outputPathesList);
        this.outputPathes.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(outputPathesList)));
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.gridy = 1;
        panel.add((Component)new JLabel(RSBundle.message("generate.java.from.wadl.output.path", new Object[0])), gc);
        gc.gridx = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        panel.add((Component)this.outputPathes, gc);
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.gridy = 2;
        panel.add((Component)new JLabel(RSBundle.message("generate.java.from.wadl.package.prefix", new Object[0])), gc);
        gc.gridx = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage("");
        PsiJavaCodeReferenceCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)this.myProject).createReferenceCodeFragment("example", (PsiElement)defaultPackage, true, false);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        this.packagePrefix = new EditorComboBox(PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)fragment), this.myProject, (FileType)JavaFileType.INSTANCE);
        panel.add((Component)this.packagePrefix, gc);
        return panel;
    }

    protected ValidationInfo doValidate() {
        if (StringUtil.isEmptyOrSpaces((String)this.packagePrefix.getText())) {
            return new ValidationInfo(RSBundle.message("generate.java.from.wadl.validation.empty.prefix", new Object[0]), (JComponent)this.packagePrefix);
        }
        if (!PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(this.packagePrefix.getText().trim())) {
            return new ValidationInfo(RSBundle.message("generate.java.from.wadl.validation.invalid.identifier", new Object[0]), (JComponent)this.packagePrefix);
        }
        if (this.wadlUrl.getComboBox().getSelectedItem() == null) {
            return new ValidationInfo(RSBundle.message("generate.java.from.wadl.validation.no.wadl", new Object[0]), (JComponent)this.wadlUrl);
        }
        return null;
    }

    protected void doOKAction() {
        super.doOKAction();
        String usedWadlUrl = ((String)this.wadlUrl.getComboBox().getSelectedItem()).replace(" ", "%20");
        ArrayList<String> parameters = new ArrayList<String>(5);
        parameters.add("-o");
        parameters.add((String)this.outputPathes.getSelectedItem());
        parameters.add("-p");
        parameters.add(this.packagePrefix.getText().trim());
        parameters.add(usedWadlUrl);
        PsiClass class2Run = JavaPsiFacade.getInstance((Project)this.myProject).findClass("org.jvnet.ws.wadl2java.Main", GlobalSearchScope.moduleWithLibrariesScope((Module)this.myModule));
        if (class2Run != null) {
            PsiFile containingFile = class2Run.getContainingFile();
            VirtualFile virtualFile = containingFile.getVirtualFile();
            VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile);
            if (jar != null) {
                InvokeExternalCodeUtil.JavaExternalProcessHandler wadl2Java = new InvokeExternalCodeUtil.JavaExternalProcessHandler("Generate Java to Wadl", "org.jvnet.ws.wadl2java.Main", new String[]{jar.getPath()}, ArrayUtilRt.toStringArray(parameters), this.myModule, true);
                this.startGeneration(wadl2Java);
            }
        }
    }

    private void startGeneration(ExternalProcessHandler wadl2Java) {
        InvokeExternalCodeUtil.invokeExternalProcess2(wadl2Java, this.myProject, () -> this.refreshGeneratedSources(), (Consumer<? super Exception>)((Consumer)e -> {
            String message = e.getMessage();
            if (message != null && StringUtil.startsWithIgnoreCase((String)message, (String)"Info:")) {
                return;
            }
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
        }), (Computable<Boolean>)((Computable)() -> Boolean.TRUE), () -> {});
    }

    private void refreshGeneratedSources() {
        ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
            CommonWsUtils.doFileSystemRefresh();
            InvokeExternalCodeUtil.navigateToPackage(this.myModule, this.packagePrefix.getText().trim(), (String)this.outputPathes.getSelectedItem());
        }), this.myModule.getDisposed());
    }

    public static void configureComboBox(JComboBox combo, List<String> lastValues) {
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(lastValues)));
        if (combo.getItemCount() != 0) {
            combo.setSelectedIndex(0);
            combo.getEditor().selectAll();
        }
    }

    private static class ComboboxTextAccessor
    implements TextComponentAccessor<JComboBox> {
        private ComboboxTextAccessor() {
        }

        public String getText(JComboBox comboBox) {
            Object item = comboBox.getEditor().getItem();
            return item.toString();
        }

        public void setText(JComboBox comboBox, @NotNull String text) {
            if (text == null) {
                ComboboxTextAccessor.$$$reportNull$$$0(0);
            }
            @NlsSafe String newWadlUrl = VfsUtilCore.pathToUrl((String)text);
            ((DefaultComboBoxModel)comboBox.getModel()).addElement(newWadlUrl);
            comboBox.setSelectedItem(newWadlUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ws/rest/actions/GenerateJavaFromWadlDialog$ComboboxTextAccessor", "setText"));
        }
    }
}

